set(FLB_ALL                         OFF CACHE BOOL "Enable all features")
set(FLB_DEBUG                       OFF CACHE BOOL "Build with debug mode (-g)")
set(FLB_RELEASE                     OFF CACHE BOOL "Build with release mode (-O2 -g -DNDEBUG)")
# set(FLB_IPO "ReleaseOnly" CACHE STRING "Build with interprocedural optimization")
# set_property(CACHE FLB_IPO PROPERTY STRINGS "On;Off;ReleaseOnly")
set(FLB_SMALL                       OFF CACHE BOOL "Optimise for small size")
set(FLB_COVERAGE                    OFF CACHE BOOL "Build with code-coverage")
set(FLB_JEMALLOC                    OFF CACHE BOOL "Build with Jemalloc support")
set(FLB_REGEX                       ON  CACHE BOOL "Build with Regex support")
set(FLB_UTF8_ENCODER                ON  CACHE BOOL "Build with UTF8 encoding support")
set(FLB_PARSER                      ON  CACHE BOOL "Build with Parser support")
set(FLB_TLS                         ON  CACHE BOOL "Build with SSL/TLS support")
set(FLB_BINARY                      OFF CACHE BOOL "Build executable binary")
set(FLB_EXAMPLES                    OFF CACHE BOOL "Build examples")
set(FLB_SHARED_LIB                  ON  CACHE BOOL "Build shared library")
set(FLB_VALGRIND                    OFF CACHE BOOL "Enable Valgrind support")
set(FLB_TRACE                       OFF CACHE BOOL "Enable trace mode")
set(FLB_CHUNK_TRACE                 OFF CACHE BOOL "Enable chunk traces")
set(FLB_TESTS_RUNTIME               OFF CACHE BOOL "Enable runtime tests")
set(FLB_TESTS_INTERNAL              OFF CACHE BOOL "Enable internal tests")
set(FLB_TESTS_INTERNAL_FUZZ         OFF CACHE BOOL "Enable internal fuzz tests")
set(FLB_TESTS_OSSFUZZ               OFF CACHE BOOL "Enable OSS-Fuzz build")
set(FLB_MTRACE                      OFF CACHE BOOL "Enable mtrace support")
set(FLB_POSIX_TLS                   OFF CACHE BOOL "Force POSIX thread storage")
set(FLB_INOTIFY                     ON  CACHE BOOL "Enable inotify support")
set(FLB_SQLDB                       ON  CACHE BOOL "Enable SQL embedded DB")
set(FLB_HTTP_SERVER                 ON  CACHE BOOL "Enable HTTP Server")
set(FLB_BACKTRACE                   OFF CACHE BOOL "Enable stacktrace support")
set(FLB_LUAJIT                      OFF CACHE BOOL "Enable Lua Scripting support")
set(FLB_RECORD_ACCESSOR             ON  CACHE BOOL "Enable record accessor")
set(FLB_SIGNV4                      ON  CACHE BOOL "Enable AWS Signv4 support")
set(FLB_AWS                         ON  CACHE BOOL "Enable AWS support")
# set(FLB_STATIC_CONF               "Build binary using static configuration")
set(FLB_STREAM_PROCESSOR            OFF CACHE BOOL "Enable Stream Processor")
set(FLB_CORO_STACK_SIZE             24576 CACHE STRING "Set coroutine stack size")
set(FLB_AVRO_ENCODER                OFF CACHE BOOL "Build with Avro encoding support")
set(FLB_AWS_ERROR_REPORTER          ON  CACHE BOOL "Build with aws error reporting support")
set(FLB_ARROW                       OFF CACHE BOOL "Build with Apache Arrow support")
set(FLB_WINDOWS_DEFAULTS            OFF CACHE BOOL "Build with predefined Windows settings")
set(FLB_WASM                        OFF CACHE BOOL "Build with WASM runtime support")
set(FLB_WAMRC                       OFF CACHE BOOL "Build with WASM AOT compiler executable")
set(FLB_WASM_STACK_PROTECT          OFF CACHE BOOL "Build with WASM runtime with strong stack protector flags")

# Native Metrics Support (cmetrics)
set(FLB_METRICS                     OFF CACHE BOOL "Enable metrics support")

# Proxy Plugins
set(FLB_PROXY_GO                    OFF CACHE BOOL "Enable Go plugins support")

# Built-in Custom Plugins
set(FLB_CUSTOM_CALYPTIA             OFF CACHE BOOL "Enable Calyptia Support")

# Config formats
set(FLB_CONFIG_YAML                 OFF CACHE BOOL "Enable YAML config format")

# Built-in Plugins
set(FLB_IN_CPU                      OFF CACHE BOOL "Enable CPU input plugin")
set(FLB_IN_THERMAL                  OFF CACHE BOOL "Enable Thermal plugin")
set(FLB_IN_DISK                     OFF CACHE BOOL "Enable Disk input plugin")
set(FLB_IN_DOCKER                   OFF CACHE BOOL "Enable Docker input plugin")
set(FLB_IN_DOCKER_EVENTS            ON  CACHE BOOL "Enable Docker events input plugin")
set(FLB_IN_EXEC                     OFF CACHE BOOL "Enable Exec input plugin")
set(FLB_IN_EXEC_WASI                OFF CACHE BOOL "Enable Exec WASI input plugin")
set(FLB_IN_EVENT_TEST               OFF CACHE BOOL "Enable Events test plugin")
set(FLB_IN_EVENT_TYPE               OFF CACHE BOOL "Enable event type plugin")
set(FLB_IN_FLUENTBIT_METRICS        OFF CACHE BOOL "Enable Fluent Bit metrics  plugin")
set(FLB_IN_FORWARD                  ON  CACHE BOOL "Enable Forward input plugin")
set(FLB_IN_HEALTH                   OFF CACHE BOOL "Enable Health input plugin")
set(FLB_IN_HTTP                     OFF CACHE BOOL "Enable HTTP input plugin")
set(FLB_IN_MEM                      OFF CACHE BOOL "Enable Memory input plugin")
set(FLB_IN_KUBERNETES_EVENTS        OFF CACHE BOOL "Enable Kubernetes Events plugin")
set(FLB_IN_KAFKA                    OFF CACHE BOOL "Enable Kafka input plugin")
set(FLB_IN_KMSG                     ON  CACHE BOOL "Enable Kernel log input plugin")
set(FLB_IN_LIB                      ON  CACHE BOOL "Enable library mode input plugin")
set(FLB_IN_RANDOM                   OFF CACHE BOOL "Enable random input plugin")
set(FLB_IN_SERIAL                   ON  CACHE BOOL "Enable Serial input plugin")
set(FLB_IN_STDIN                    OFF CACHE BOOL "Enable Standard input plugin")
set(FLB_IN_SYSLOG                   ON  CACHE BOOL "Enable Syslog input plugin")
set(FLB_IN_TAIL                     ON  CACHE BOOL "Enable Tail input plugin")
set(FLB_IN_UDP                      OFF CACHE BOOL "Enable UDP input plugin")
set(FLB_IN_TCP                      OFF CACHE BOOL "Enable TCP input plugin")
set(FLB_IN_UNIX_SOCKET              OFF CACHE BOOL "Enable Unix socket input plugin")
set(FLB_IN_MQTT                     ON  CACHE BOOL "Enable MQTT Broker input plugin")
set(FLB_IN_HEAD                     OFF CACHE BOOL "Enable Head input plugin")
set(FLB_IN_PROC                     OFF CACHE BOOL "Enable Process input plugin")
set(FLB_IN_SYSTEMD                  ON  CACHE BOOL "Enable Systemd input plugin")
set(FLB_IN_DUMMY                    OFF CACHE BOOL "Enable Dummy input plugin")
set(FLB_IN_NGINX_EXPORTER_METRICS   OFF CACHE BOOL "Enable Nginx Metrics input plugin")
set(FLB_IN_NETIF                    OFF CACHE BOOL "Enable NetworkIF input plugin")
set(FLB_IN_WINLOG                   OFF CACHE BOOL "Enable Windows Log input plugin")
set(FLB_IN_WINSTAT                  OFF CACHE BOOL "Enable Windows Stat input plugin")
set(FLB_IN_WINEVTLOG                OFF CACHE BOOL "Enable Windows EvtLog input plugin")
set(FLB_IN_COLLECTD                 OFF CACHE BOOL "Enable Collectd input plugin")
set(FLB_IN_PROMETHEUS_SCRAPE        OFF CACHE BOOL "Enable Promeheus Scrape input plugin")
set(FLB_IN_STATSD                   OFF CACHE BOOL "Enable StatsD input plugin")
set(FLB_IN_EVENT_TEST               OFF CACHE BOOL "Enable event test plugin")
set(FLB_IN_STORAGE_BACKLOG          OFF CACHE BOOL "Enable storage backlog input plugin")
set(FLB_IN_EMITTER                  OFF CACHE BOOL "Enable emitter input plugin")
set(FLB_IN_NODE_EXPORTER_METRICS    OFF CACHE BOOL "Enable node exporter metrics input plugin")
set(FLB_IN_WINDOWS_EXPORTER_METRICS OFF CACHE BOOL "Enable windows exporter metrics input plugin")
set(FLB_IN_PODMAN_METRICS           OFF CACHE BOOL "Enable Podman Metrics input plugin")
set(FLB_IN_OPENTELEMETRY            OFF CACHE BOOL "Enable OpenTelemetry input plugin")
set(FLB_IN_ELASTICSEARCH            OFF CACHE BOOL "Enable Elasticsearch (Bulk API) input plugin")
set(FLB_IN_CALYPTIA_FLEET           OFF CACHE BOOL "Enable Calyptia Fleet input plugin")
set(FLB_IN_SPLUNK                   OFF CACHE BOOL "Enable Splunk HTTP HEC input plugin")
set(FLB_OUT_AZURE                   ON  CACHE BOOL "Enable Azure output plugin")
set(FLB_OUT_AZURE_BLOB              ON  CACHE BOOL "Enable Azure output plugin")
set(FLB_OUT_AZURE_LOGS_INGESTION    ON  CACHE BOOL "Enable Azure Logs Ingestion output plugin")
set(FLB_OUT_AZURE_KUSTO             ON  CACHE BOOL "Enable Azure Kusto output plugin")
set(FLB_OUT_BIGQUERY                ON  CACHE BOOL "Enable BigQuery output plugin")
set(FLB_OUT_CALYPTIA                OFF CACHE BOOL "Enable Calyptia monitoring plugin")
set(FLB_OUT_COUNTER                 OFF CACHE BOOL "Enable Counter output plugin")
set(FLB_OUT_DATADOG                 ON  CACHE BOOL "Enable DataDog output plugin")
set(FLB_OUT_ES                      ON  CACHE BOOL "Enable Elasticsearch output plugin")
set(FLB_OUT_EXIT                    OFF CACHE BOOL "Enable Exit output plugin")
set(FLB_OUT_FORWARD                 ON  CACHE BOOL "Enable Forward output plugin")
set(FLB_OUT_GELF                    ON  CACHE BOOL "Enable GELF output plugin")
set(FLB_OUT_HTTP                    ON  CACHE BOOL "Enable HTTP output plugin")
set(FLB_OUT_INFLUXDB                ON  CACHE BOOL "Enable InfluxDB output plugin")
set(FLB_OUT_NATS                    ON  CACHE BOOL "Enable NATS output plugin")
set(FLB_OUT_NRLOGS                  ON  CACHE BOOL "Enable New Relic output plugin")
set(FLB_OUT_OPENSEARCH              ON  CACHE BOOL "Enable OpenSearch output plugin")
set(FLB_OUT_TCP                     ON  CACHE BOOL "Enable TCP output plugin")
set(FLB_OUT_UDP                     ON  CACHE BOOL "Enable UDP output plugin")
set(FLB_OUT_PLOT                    ON  CACHE BOOL "Enable Plot output plugin")
set(FLB_OUT_FILE                    ON  CACHE BOOL "Enable file output plugin")
set(FLB_OUT_TD                      ON  CACHE BOOL "Enable Treasure Data output plugin")
set(FLB_OUT_RETRY                   OFF CACHE BOOL "Enable Retry test output plugin")
set(FLB_OUT_PGSQL                   ON  CACHE BOOL "Enable PostgreSQL output plugin")
set(FLB_OUT_SKYWALKING              ON  CACHE BOOL "Enable Apache SkyWalking output plugin")
set(FLB_OUT_SLACK                   ON  CACHE BOOL "Enable Slack output plugin")
set(FLB_OUT_SPLUNK                  ON  CACHE BOOL "Enable Splunk output plugin")
set(FLB_OUT_STACKDRIVER             ON  CACHE BOOL "Enable Stackdriver output plugin")
set(FLB_OUT_STDOUT                  OFF CACHE BOOL "Enable STDOUT output plugin")
set(FLB_OUT_SYSLOG                  ON  CACHE BOOL "Enable Syslog output plugin")
set(FLB_OUT_LIB                     ON  CACHE BOOL "Enable library mode output plugin")
set(FLB_OUT_NULL                    OFF CACHE BOOL "Enable dev null output plugin")
set(FLB_OUT_FLOWCOUNTER             ON  CACHE BOOL "Enable flowcount output plugin")
set(FLB_OUT_LOGDNA                  ON  CACHE BOOL "Enable LogDNA output plugin")
set(FLB_OUT_LOKI                    ON  CACHE BOOL "Enable Loki output plugin")
set(FLB_OUT_KAFKA                   ON  CACHE BOOL "Enable Kafka output plugin")
set(FLB_OUT_KAFKA_REST              ON  CACHE BOOL "Enable Kafka Rest output plugin")
set(FLB_OUT_CLOUDWATCH_LOGS         ON  CACHE BOOL "Enable AWS CloudWatch output plugin")
set(FLB_OUT_KINESIS_FIREHOSE        ON  CACHE BOOL "Enable AWS Firehose output plugin")
set(FLB_OUT_KINESIS_STREAMS         ON  CACHE BOOL "Enable AWS Kinesis output plugin")
set(FLB_OUT_OPENTELEMETRY           ON  CACHE BOOL "Enable OpenTelemetry plugin")
set(FLB_OUT_PROMETHEUS_EXPORTER     ON  CACHE BOOL "Enable Prometheus exporter plugin")
set(FLB_OUT_PROMETHEUS_REMOTE_WRITE ON  CACHE BOOL "Enable Prometheus remote write plugin")
set(FLB_OUT_S3                      ON  CACHE BOOL "Enable AWS S3 output plugin")
set(FLB_OUT_VIVO_EXPORTER           ON  CACHE BOOL "Enabel Vivo exporter output plugin")
set(FLB_OUT_WEBSOCKET               ON  CACHE BOOL "Enable Websocket output plugin")
set(FLB_OUT_CHRONICLE               ON  CACHE BOOL "Enable Google Chronicle output plugin")
set(FLB_FILTER_ALTER_SIZE           OFF CACHE BOOL "Enable alter_size filter")
set(FLB_FILTER_AWS                  OFF CACHE BOOL "Enable aws filter")
set(FLB_FILTER_ECS                  OFF CACHE BOOL "Enable AWS ECS filter")
set(FLB_FILTER_CHECKLIST            OFF CACHE BOOL "Enable checklist filter")
set(FLB_FILTER_EXPECT               OFF CACHE BOOL "Enable expect filter")
set(FLB_FILTER_GREP                 OFF CACHE BOOL "Enable grep filter")
set(FLB_FILTER_MODIFY               OFF CACHE BOOL "Enable modify filter")
set(FLB_FILTER_STDOUT               OFF CACHE BOOL "Enable stdout filter")
set(FLB_FILTER_PARSER               ON  CACHE BOOL "Enable parser filter")
set(FLB_FILTER_KUBERNETES           OFF CACHE BOOL "Enable kubernetes filter")
set(FLB_FILTER_REWRITE_TAG          OFF CACHE BOOL "Enable tag rewrite filter")
set(FLB_FILTER_THROTTLE             OFF CACHE BOOL "Enable throttle filter")
set(FLB_FILTER_THROTTLE_SIZE        OFF CACHE BOOL "Enable throttle size filter")
set(FLB_FILTER_TYPE_CONVERTER       OFF CACHE BOOL "Enable type converter filter")
set(FLB_FILTER_MULTILINE            OFF CACHE BOOL "Enable multiline filter")
set(FLB_FILTER_NEST                 OFF CACHE BOOL "Enable nest filter")
set(FLB_FILTER_LOG_TO_METRICS       OFF CACHE BOOL "Enable log-derived metrics filter")
set(FLB_FILTER_LUA                  OFF CACHE BOOL "Enable Lua scripting filter")
set(FLB_FILTER_LUA_USE_MPACK        OFF CACHE BOOL "Enable mpack on the lua filter")
set(FLB_FILTER_RECORD_MODIFIER      ON  CACHE BOOL "Enable record_modifier filter")
set(FLB_FILTER_TENSORFLOW           OFF CACHE BOOL "Enable tensorflow filter")
set(FLB_FILTER_GEOIP2               OFF CACHE BOOL "Enable geoip2 filter")
set(FLB_FILTER_NIGHTFALL            OFF CACHE BOOL "Enable Nightfall filter")
set(FLB_FILTER_WASM                 OFF CACHE BOOL "Enable WASM filter")
set(FLB_PROCESSOR_LABELS            OFF CACHE BOOL "Enable metrics label manipulation processor")
set(FLB_PROCESSOR_ATTRIBUTES        OFF CACHE BOOL "Enable atributes manipulation processor")
