<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [ExecutionContext](./puppeteer.executioncontext.md) &gt; [queryObjects](./puppeteer.executioncontext.queryobjects.md)

## ExecutionContext.queryObjects() method

This method iterates the JavaScript heap and finds all the objects with the given prototype.

<b>Signature:</b>

```typescript
queryObjects(prototypeHandle: JSHandle): Promise<JSHandle>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  prototypeHandle | [JSHandle](./puppeteer.jshandle.md) | a handle to the object prototype |

<b>Returns:</b>

Promise&lt;[JSHandle](./puppeteer.jshandle.md)&gt;

A handle to an array of objects with the given prototype.

## Remarks


## Example


```js
// Create a Map object
await page.evaluate(() => window.map = new Map());
// Get a handle to the Map object prototype
const mapPrototype = await page.evaluateHandle(() => Map.prototype);
// Query all map instances into an array
const mapInstances = await page.queryObjects(mapPrototype);
// Count amount of map objects in heap
const count = await page.evaluate(maps => maps.length, mapInstances);
await mapInstances.dispose();
await mapPrototype.dispose();

```

