<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# LOG2E

> Base 2 logarithm of the mathematical constant [_e_][eulers-number].

<section class="usage">

## Usage

```javascript
var LOG2E = require( '@stdlib/constants/float64/log2-e' );
```

#### LOG2E

Base 2 logarithm of the mathematical constant [_e_][eulers-number].

```javascript
var bool = ( LOG2E === 1.4426950408889634 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var LOG2E = require( '@stdlib/constants/float64/log2-e' );

console.log( LOG2E );
// => 1.4426950408889634
```

</section>

<!-- /.examples -->

<section class="links">

[eulers-number]: https://en.wikipedia.org/wiki/E_%28mathematical_constant%29

</section>

<!-- /.links -->
