/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Evaluate the common logarithm (base ten).
*
* @module @stdlib/math/base/special/log10
*
* @example
* var log10 = require( '@stdlib/math/base/special/log10' );
*
* var v = log10( 100.0 );
* // returns ~0.602
*
* v = log10( 8.0 );
* // returns ~0.903
*
* v = log10( 0.0 );
* // returns -Infinity
*
* v = log10( Infinity );
* // returns Infinity
*
* v = log10( NaN );
* // returns NaN
*
* v = log10( -4.0 );
* // returns NaN
*/

// MODULES //

var log10 = require( './log10.js' );


// EXPORTS //

module.exports = log10;
