package jnormaliz;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import org.jdesktop.application.Action;

/**
 * Dialog describing documentation for Normaliz's algorithms, with possibility
 * of opening the documentation of an specific algorithm by clicking on its
 * hyperlink
 */
public class HelpAlgorithmsDialog extends javax.swing.JDialog {

    private final Desktop desktop;

    /**
     * Creates dialog and initializes it, reading documentation from
     * resources
     * @param parent
     */
    public HelpAlgorithmsDialog(java.awt.Frame parent) {
        super(parent, false);
        initComponents();

        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            try {
                algorithmsTextPane.read(getClass().getResourceAsStream("/jnormaliz/resources/documentation.html"), null);
            } catch (IOException ex) {
                Logger.getLogger(HelpAlgorithmsDialog.class.getName()).log(Level.SEVERE, "Error reading documentation", ex);
            }
        } else {
            Logger.getLogger(HelpAlgorithmsDialog.class.getName()).log(Level.WARNING, null, "Desktop.getDesktop() == null");
            desktop = null;
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        algorithmsTextPane = new javax.swing.JTextPane();
        jButton2 = new javax.swing.JButton();

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(jnormaliz.JNormalizApplication.class).getContext().getResourceMap(HelpAlgorithmsDialog.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setIconImage(null);
        setName("Form"); // NOI18N

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jScrollPane1.setEnabled(false);
        jScrollPane1.setFont(resourceMap.getFont("jScrollPane1.font")); // NOI18N
        jScrollPane1.setName("jScrollPane1"); // NOI18N

        algorithmsTextPane.setContentType(resourceMap.getString("algorithmsTextPane.contentType")); // NOI18N
        algorithmsTextPane.setEditable(false);
        algorithmsTextPane.setText(resourceMap.getString("algorithmsTextPane.text")); // NOI18N
        algorithmsTextPane.setName("algorithmsTextPane"); // NOI18N
        algorithmsTextPane.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                algorithmsTextPaneHyperlinkUpdate(evt);
            }
        });
        jScrollPane1.setViewportView(algorithmsTextPane);

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(jnormaliz.JNormalizApplication.class).getContext().getActionMap(HelpAlgorithmsDialog.class, this);
        jButton2.setAction(actionMap.get("closeAction")); // NOI18N
        jButton2.setName("jButton2"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 446, Short.MAX_VALUE)
                    .addComponent(jLabel1)
                    .addComponent(jButton2))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton2)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void algorithmsTextPaneHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_algorithmsTextPaneHyperlinkUpdate
        if (desktop != null) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                File docFile = new File("doc", evt.getDescription());
                if (!docFile.exists()) {
                    JOptionPane.showMessageDialog(this,
                            "File not found:\n" + docFile.getAbsolutePath(), "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                try {
                    desktop.open(docFile);
                } catch (IOException ex) {
                    Logger.getLogger(MainView.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        }
    }//GEN-LAST:event_algorithmsTextPaneHyperlinkUpdate

    /**
     * Hides the dialog box.
     */
    @Action
    public void closeAction() {
        this.setVisible(false);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextPane algorithmsTextPane;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
}
