package jnormaliz;

import java.io.File;

/**
 * Class to hold parameters to be used in a Normaliz execution
 */
public class NormalizConfig {

    /**
     * Holds the input file to be used in computations
     */
    public File inFile = null;

    /**
     * Returns the full path for the input file without the .in extension
     */
    public String getInFileWithoutExt() {
        return FileUtils.stripInExtension(inFile.getAbsolutePath());
    }

    /**
     * Options of integer precision that can be used when running Normaliz
     */
    public enum Precision {

        PRECISION64, PRECISIONBIG
    };

    /**
     * Specifies integer precision to be used
     */
    public Precision precision;

    /**
     * Computation types that can be used when running Normaliz
     */
    public enum ComputationType {
        
        DEFAULT,
        SUPPORT_HYPERPLANES, TRIANGULATION,
        VOLUME, VOLUME_DEGREE_1_ELEMENTS,
        HILBERT_BASIS_VOLUME, HILBERT_BASIS,
        DEGREE_1_ELEMENTS, HILBERT_SERIES,
        HILBERT_SERIES_DEGREE_1_ELEMENTS,
        HILBERT_BASIS_SERIES
    };

    /**
     * Specifies computation type to be used
     */
    public ComputationType computationType;
    
    
     /**
     * Algorithms that can be used when running Normaliz
     */
    public enum Algorithm {

        PRIMAL, DUAL, APPROXIMATION
    };

    /**
     * Specifies algorithm to be used
     */
    public Algorithm algorithm;

    /**
     * Amount of output that can be produced by Normaliz
     */
    public enum OutputFiles {

        ONLY_OUT, SOME, ALL
    };
     
    /**
     * Specifies output files to be generated
     */
    public OutputFiles outputFiles;
    
     /**
     * Options for NmzIntegrate
     */
    public enum NmzIntegrateOptions
    {
        NONE, EHRHART, LEADING, LEBESQUE
    };
    
    /**
     * Specifies how NmzIntegrate will be used
     */
    public NmzIntegrateOptions nmzIntegrateOptions;

    /**
     * Specifies whether or not to save memory while running Normaliz
     */
   // public boolean saveMemory; // option for Normliz version 2.1, 2.2

    /**
     * Specifies whether or not to check for arithmetic overflow while
     * running Normaliz
     */
    public boolean testArithmeticOverflow;

     /**
     * Specifies whether or not to write the triangulation file generated 
     * by Normaliz
     */
    public boolean writeTriangulationFile;

      /**
     * Specifies whether or not to write the Stanley decomposition file 
     */
    public boolean writeStanleyDecompositionFile;
    
    
     /**
     * Specifies whether or not to control the maximal number of paralell
     * threads generated by Normaliz
     */
    public boolean controlParalellization;

     /**
     * Specifies the maximum number of parallel threads generated by Normaliz
     */
    public Integer numberParallelThreads;
}
