/*
 * (C) Copyright 1996-2012 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#include "eckit/testing/Test.h"
#include "eckit/config/Resource.h"
#include "eckit/log/Log.h"

#include "odb_api/Partitioner.h"

#include "TemporaryFiles.h"

#include <stdint.h>

using namespace eckit::testing;


// ------------------------------------------------------------------------------------------------------

eckit::Resource<eckit::PathName> testDataPath("$TEST_DATA_DIRECTORY", "..");

CASE("Test partitioning ODBs into chunks") {

    std::vector<eckit::PathName> files;

    files.push_back(testDataPath / "2000010106.odb");

    std::vector<eckit::PathName> indices(odb::Indexer::createIndex(files));

    odb::Partitions partitions(odb::Partitioner::createPartitions(files, 5));

    eckit::Log::info() << partitions << std::endl;

    partitions.write(testDataPath / "output.partitions.odb");
}

// ------------------------------------------------------------------------------------------------------

int main(int argc, char* argv[]) {
    return run_tests(argc, argv);
}

