#!/bin/sh

set -e

export VERBOSE=1

# Ubuntu autopkgtest infra provides internet access via a proxy, and
# buildds could conceivably do the same, but libostree doesn't need
# that. However, libostree also doesn't support no_proxy, so it will try
# to use Ubuntu's proxy for localhost, and fail to reach itself.
unset ftp_proxy
unset http_proxy
unset https_proxy
unset no_proxy

try_tests=5

failed=0
make check || failed=1

if [ "$failed" -gt 0 ]; then
    [ "$failed" -eq 0 ] || echo "Test failed! Checking how reproducible it is..."
    for i in $(seq 1 "$(( $try_tests - 1 ))"); do
        if ! make check; then
            failed=$(( $failed + 1 ))
        fi
    done
fi

pkill --full "gpg-agent --homedir /var/tmp/tap-test\\.[^/]+/.*" || :

if pgrep lt-ostree || pgrep --full "gpg-agent --homedir /var/tmp/tap-test."; then \
    echo "WARNING: daemon processes were leaked"
    pgrep gpg-agent | xargs --no-run-if-empty ps ww
    pgrep lt-ostree | xargs --no-run-if-empty ps ww
fi

# There are several race conditions that cause intermittent failures.
# They are not actually a regression - we've just been luckier in the
# past - so let newer versions build reliably.
if [ "$failed" -gt 1 ]; then
    echo "Failed $failed out of $try_tests test runs; that seems bad"
    exit 1
elif [ "$failed" -gt 0 ]; then
    echo "Failed $failed out of $try_tests test runs; continuing anyway"
else
    echo "All tests passed"
fi

exit 0

# vim:set et sw=4 sts=4:
