# pkg-perl/module-name -- lintian check script for checking that module name is present in the long description
#
# Copyright © 2013 Niels Thykier <niels@thykier.net>
# Copyright © 2013 gregor herrmann <gregoa@debian.org>
# Copyright © 2013, 2014 Axel Beckert <abe@debian.org>
# Copyright © 2014 Damyan Ivanov <dmn@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, you can find it on the World Wide
# Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301, USA.

package Lintian::pkg_perl::module_name;

use strict;
use warnings;

use Lintian::Tags qw(tag);
use File::Find qw(find);

sub run {
    my ( $pkg, $type, $info, $proc, $group ) = @_;

    # Only for pkg-perl packages
    return
        unless $info->field('maintainer')
        =~ /pkg-perl-maintainers\@lists\.alioth\.debian\.org/sm;

    my @binaries = $info->binaries;
    for my $b (@binaries) {
        next unless $b =~ /lib(.+)-perl/;
        my $mod = $1;
        my @mod_path_elements = split( /-/, $mod );
        $mod = join( '::', map {ucfirst} @mod_path_elements );
        my $mod_lc = lc($mod);
        my $d = $info->binary_field( $b, 'description' );
        $d =~ s/[^\n]+\n//; # strip long description

        my $pm_found = 0;
        my $pmpath = join( '/', @mod_path_elements ).'.pm';
        my $pm     = $mod_path_elements[-1].'.pm';
        find(
            sub {
                $pm_found = 1 if $File::Find::name =~ m(\Q$pmpath\E\z)i;
                $pm_found = 1 if $File::Find::name =~ m(^\Q./$pm\E\z)i;
            },
            '.');

        tag( 'no-module-name-in-description', $b, $mod )
            if (lc($d) !~ /\Q$mod_lc\E/ and $pm_found);
    }
}

1;
