        PROGRAM MIK01A
C
C       =============================================================
C       Purpose: This program computes the modified Bessel functions 
C                I0(x), I1(x), K0(x), K1(x), and their derivatives 
C                using subroutine IK01A
C       Input :  x   --- Argument ( x  0 )
C       Output:  BI0 --- I0(x)
C                DI0 --- I0'(x)
C                BI1 --- I1(x)
C                DI1 --- I1'(x)
C                BK0 --- K0(x)
C                DK0 --- K0'(x)
C                BK1 --- K1(x)
C                DK1 --- K1'(x)
C       Example:
C
C         x      I0(x)         I0'(x)        I1(x)         I1'(x)
C       -------------------------------------------------------------
C        1.0  .1266066D+01  .5651591D+00  .5651591D+00  .7009068D+00
C       10.0  .2815717D+04  .2670988D+04  .2670988D+04  .2548618D+04
C       20.0  .4355828D+08  .4245497D+08  .4245497D+08  .4143553D+08
C       30.0  .7816723D+12  .7685320D+12  .7685320D+12  .7560546D+12
C       40.0  .1489477D+17  .1470740D+17  .1470740D+17  .1452709D+17
C       50.0  .2932554D+21  .2903079D+21  .2903079D+21  .2874492D+21
C
C         x      K0(x)         K0'(x)        K1(x)         K1'(x)
C       -------------------------------------------------------------
C        1.0  .4210244D+00 -.6019072D+00  .6019072D+00 -.1022932D+01
C       10.0  .1778006D-04 -.1864877D-04  .1864877D-04 -.1964494D-04
C       20.0  .5741238D-09 -.5883058D-09  .5883058D-09 -.6035391D-09
C       30.0  .2132477D-13 -.2167732D-13  .2167732D-13 -.2204735D-13
C       40.0  .8392861D-18 -.8497132D-18  .8497132D-18 -.8605289D-18
C       50.0  .3410168D-22 -.3444102D-22  .3444102D-22 -.3479050D-22
C       =============================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        WRITE(*,*)'Please enter x '
        READ(*,*)X
        WRITE(*,10)X
        WRITE(*,*)'  x       I0(x)          I0''(x)         I1(x)',
     &            '          I1''(x)'
        WRITE(*,*)'-------------------------------------------',
     &            '----------------------'
        CALL IK01A(X,BI0,DI0,BI1,DI1,BK0,DK0,BK1,DK1)
        WRITE(*,20)X,BI0,DI0,BI1,DI1
        WRITE(*,*)
        WRITE(*,*)'  x       K0(x)          K0''(x)         K1(x)',
     &            '          K1''(x)'
        WRITE(*,*)'-------------------------------------------',
     &            '----------------------'
        WRITE(*,20)X,BK0,DK0,BK1,DK1
10      FORMAT(3x 'x =',F5.1)
20      FORMAT(1X,F4.1,4D15.7)
        END


        SUBROUTINE IK01A(X,BI0,DI0,BI1,DI1,BK0,DK0,BK1,DK1)
C
C       =========================================================
C       Purpose: Compute modified Bessel functions I0(x), I1(1),
C                K0(x) and K1(x), and their derivatives
C       Input :  x   --- Argument ( x  0 )
C       Output:  BI0 --- I0(x)
C                DI0 --- I0'(x)
C                BI1 --- I1(x)
C                DI1 --- I1'(x)
C                BK0 --- K0(x)
C                DK0 --- K0'(x)
C                BK1 --- K1(x)
C                DK1 --- K1'(x)
C       =========================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        DIMENSION A(12),B(12),A1(8)
        PI=3.141592653589793D0
        EL=0.5772156649015329D0
        X2=X*X
        IF (X.EQ.0.0D0) THEN
           BI0=1.0D0
           BI1=0.0D0
           BK0=1.0D+300
           BK1=1.0D+300
           DI0=0.0D0
           DI1=0.5D0
           DK0=-1.0D+300
           DK1=-1.0D+300
           RETURN
        ELSE IF (X.LE.18.0D0) THEN
           BI0=1.0D0
           R=1.0D0
           DO 15 K=1,50
              R=0.25D0*R*X2/(K*K)
              BI0=BI0+R
              IF (DABS(R/BI0).LT.1.0D-15) GO TO 20
15         CONTINUE
20         BI1=1.0D0
           R=1.0D0
           DO 25 K=1,50
              R=0.25D0*R*X2/(K*(K+1))
              BI1=BI1+R
              IF (DABS(R/BI1).LT.1.0D-15) GO TO 30
25         CONTINUE
30         BI1=0.5D0*X*BI1
        ELSE
           DATA A/0.125D0,7.03125D-2,
     &            7.32421875D-2,1.1215209960938D-1,
     &            2.2710800170898D-1,5.7250142097473D-1,
     &            1.7277275025845D0,6.0740420012735D0,
     &            2.4380529699556D01,1.1001714026925D02,
     &            5.5133589612202D02,3.0380905109224D03/
           DATA B/-0.375D0,-1.171875D-1,
     &            -1.025390625D-1,-1.4419555664063D-1,
     &            -2.7757644653320D-1,-6.7659258842468D-1,
     &            -1.9935317337513D0,-6.8839142681099D0,
     &            -2.7248827311269D01,-1.2159789187654D02,
     &            -6.0384407670507D02,-3.3022722944809D03/
           K0=12
           IF (X.GE.35.0) K0=9
           IF (X.GE.50.0) K0=7
           CA=DEXP(X)/DSQRT(2.0D0*PI*X)
           BI0=1.0D0
           XR=1.0D0/X
           DO 35 K=1,K0
35            BI0=BI0+A(K)*XR**K
           BI0=CA*BI0
           BI1=1.0D0
           DO 40 K=1,K0
40            BI1=BI1+B(K)*XR**K
           BI1=CA*BI1
        ENDIF
        IF (X.LE.9.0D0) THEN
           CT=-(DLOG(X/2.0D0)+EL)
           BK0=0.0D0
           W0=0.0D0
           R=1.0D0
           DO 65 K=1,50
              W0=W0+1.0D0/K
              R=0.25D0*R/(K*K)*X2
              BK0=BK0+R*(W0+CT)
              IF (DABS((BK0-WW)/BK0).LT.1.0D-15) GO TO 70
65            WW=BK0
70         BK0=BK0+CT
        ELSE
           DATA A1/0.125D0,0.2109375D0,
     &             1.0986328125D0,1.1775970458984D01,
     &             2.1461706161499D02,5.9511522710323D03,
     &             2.3347645606175D05,1.2312234987631D07/
           CB=0.5D0/X
           XR2=1.0D0/X2
           BK0=1.0D0
           DO 75 K=1,8
75            BK0=BK0+A1(K)*XR2**K
           BK0=CB*BK0/BI0
        ENDIF
        BK1=(1.0D0/X-BI1*BK0)/BI0
        DI0=BI1
        DI1=BI0-BI1/X
        DK0=-BK1
        DK1=-BK0-BK1/X
        RETURN
        END
