#!/usr/bin/env bash

#    Copyright
#    (c) 2019-2020 Claudio Ortega <claudio.alberto.ortega@gmail.com>
#    (c) 2019-2020 Paolo Lucente <paolo@pmacct.net>
#
#    Permission to use, copy, modify, and distribute this software for any
#    purpose with or without fee is hereby granted, provided that the above
#    copyright notice and this permission notice appear in all copies.
#
#    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
#    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
#    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
#    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
#    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
#    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
#    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

LINUX_IMAGE_DISTRO=${1}
VARIANT_SPEC=${2}

if [[ ( ${LINUX_IMAGE_DISTRO} == "centos" ) ]]; then
  bash -ex docker/build_outside.sh \
    docker/Dockerfile-centos-8.1-for-pmacct \
    centos8.1-for-pmacct \
    ${VARIANT_SPEC} \
    master
elif [[ ( ${LINUX_IMAGE_DISTRO} == "ubuntu" ) ]]; then
  bash -ex docker/build_outside.sh \
    docker/Dockerfile-ubuntu-bionic-for-pmacct \
    ubuntu-bionic-for-pmacct \
    ${VARIANT_SPEC} \
    master
else
  echo "unsupported linux distribution: ["${LINUX_IMAGE_DISTRO}"]"
  exit 1
fi
