require 'gem2deb/rake/testtask'

Gem2Deb::Rake::TestTask.new do |t|
  t.libs = ['test']
  ENV['CI'] = '300'
  if ENV['AUTOPKGTEST_TEST_PUMA_SERVER_SSL']
    ENV['OPENSSL_CONF'] = '' # https://github.com/puma/puma/issues/2147
    t.test_files = FileList['test/test_puma_server_ssl.rb']
  else
    files = FileList['test/**/*_test.rb'] + FileList['test/**/test_*.rb'] - FileList['test/test_puma_server_ssl.rb']
    if RUBY_PLATFORM == "aarch64-linux-gnu"
      # The test/test_cli.rb file contains multiple test cases failing on
      # arm64 only. There is some investigation going on with upstream
      # maintainers. See https://github.com/puma/puma/issues/2148 and
      # https://github.com/puma/puma/issues/2562.
      files -= FileList['test/test_cli.rb']
    end
    t.test_files = files
  end
  t.verbose = true
end
