/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.ContourControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.PlotText;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.util.RangeSlider;
import visad.util.Util;

public class ContourWidget
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener,
ControlListener,
ScalarMapListener {
    private ContourControl control;
    private float cInterval;
    private float cBase;
    private float cSurface;
    private float cLo;
    private float cHi;
    private String name;
    private JTextField Interval;
    private JTextField Base;
    private JLabel SurfaceLabel;
    private JSlider Surface;
    private JCheckBox Labels;
    private JCheckBox Contours;
    private JCheckBox Dashed;
    private ContourRangeSlider ContourRange;
    private JCheckBox Fill;
    private double sliderScale;
    private Dimension prefSize = null;

    public ContourWidget(ScalarMap smap) throws VisADException, RemoteException {
        this(smap, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, true);
    }

    public ContourWidget(ScalarMap smap, float surf) throws VisADException, RemoteException {
        this(smap, Float.NaN, Float.NaN, Float.NaN, Float.NaN, surf, true);
    }

    public ContourWidget(ScalarMap smap, float interv, float min, float max, float ba) throws VisADException, RemoteException {
        this(smap, interv, min, max, ba, Float.NaN, true);
    }

    public ContourWidget(ScalarMap smap, float interv, float min, float max, float ba, float surf, boolean update) throws VisADException, RemoteException {
        if (!Display.IsoContour.equals(smap.getDisplayScalar())) {
            throw new DisplayException("ContourWidget: ScalarMap must be to Display.IsoContour");
        }
        this.name = smap.getScalarName();
        this.control = (ContourControl)smap.getControl();
        boolean[] flags = new boolean[2];
        float[] values = new float[5];
        this.control.getMainContours(flags, values);
        boolean contourFlag = flags[0];
        boolean labelFlag = flags[1];
        boolean dashFlag = values[1] < 0.0f;
        boolean fillFlag = this.control.contourFilled();
        boolean setSurface = false;
        boolean setInterval = false;
        if (surf == surf) {
            this.cSurface = surf;
            setSurface = true;
        } else {
            this.cSurface = values[0];
        }
        if (interv == interv) {
            this.cInterval = interv;
            setInterval = true;
        } else {
            this.cInterval = values[1];
        }
        if (min == min) {
            this.cLo = min;
            setInterval = true;
        } else {
            this.cLo = values[2];
        }
        if (max == max) {
            this.cHi = max;
            setInterval = true;
        } else {
            this.cHi = values[3];
        }
        if (ba == ba) {
            this.cBase = ba;
            setInterval = true;
        } else {
            this.cBase = values[4];
        }
        JPanel top = new JPanel();
        JPanel mid = new JPanel();
        JPanel low = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        top.setLayout(new BoxLayout(top, 0));
        mid.setLayout(new BoxLayout(mid, 0));
        low.setLayout(new BoxLayout(low, 0));
        this.Contours = new JCheckBox("contours", contourFlag);
        this.Labels = new JCheckBox("labels", labelFlag);
        this.Dashed = new JCheckBox("dashed lines below base", dashFlag);
        JLabel intLabel = new JLabel("interval:");
        this.Interval = new JTextField("---");
        this.Fill = new JCheckBox("fill", fillFlag);
        Dimension msize = this.Interval.getMaximumSize();
        Dimension psize = this.Interval.getPreferredSize();
        msize.height = psize.height;
        this.Interval.setMaximumSize(msize);
        JLabel baseLabel = new JLabel("base:");
        this.Base = new JTextField("---");
        msize = this.Base.getMaximumSize();
        psize = this.Base.getPreferredSize();
        msize.height = psize.height;
        this.Base.setMaximumSize(msize);
        this.SurfaceLabel = new JLabel(this.name + " = ---");
        this.Surface = new JSlider();
        this.ContourRange = new ContourRangeSlider(smap, this.cLo, this.cHi, this, update);
        if (!update) {
            if (setSurface) {
                this.control.setSurfaceValue(this.cSurface);
            }
            if (setInterval) {
                this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
            }
            this.updateWidgetSurface();
            this.updateWidgetRange();
        }
        intLabel.setForeground(Color.black);
        baseLabel.setForeground(Color.black);
        this.SurfaceLabel.setForeground(Color.black);
        this.Dashed.setAlignmentX(0.5f);
        this.SurfaceLabel.setAlignmentX(0.5f);
        this.Interval.addActionListener(this);
        this.Interval.setActionCommand("interval");
        this.Base.addActionListener(this);
        this.Base.setActionCommand("base");
        Dimension d = new Dimension(Integer.MAX_VALUE, this.SurfaceLabel.getMaximumSize().height);
        this.SurfaceLabel.setMaximumSize(d);
        this.SurfaceLabel.setPreferredSize(d);
        this.Surface.addChangeListener(this);
        this.Labels.addItemListener(this);
        this.Contours.addItemListener(this);
        this.Fill.addItemListener(this);
        this.Dashed.addItemListener(this);
        this.control.addControlListener(this);
        smap.addScalarMapListener(this);
        this.Contours.setToolTipText("Toggle contours");
        this.Labels.setToolTipText("Toggle iso-contour labels (2-D only)");
        this.Fill.setToolTipText("Solid filled contours (2-D only)");
        this.Dashed.setToolTipText("Toggle dashed lines below base value (2-D only)");
        String s = "Specify the iso-contouring interval (2-D only)";
        intLabel.setToolTipText(s);
        this.Interval.setToolTipText(s);
        String t = "Specify the iso-contouring base value (2-D only)";
        baseLabel.setToolTipText(t);
        this.Base.setToolTipText(t);
        String u = "Specify the iso-level value (3-D only)";
        this.SurfaceLabel.setToolTipText(u);
        this.Surface.setToolTipText(u);
        top.add(this.Contours);
        top.add(this.Labels);
        top.add(this.Fill);
        mid.add(intLabel);
        mid.add(this.Interval);
        mid.add(Box.createRigidArea(new Dimension(10, 0)));
        mid.add(baseLabel);
        mid.add(this.Base);
        low.add(Box.createRigidArea(new Dimension(10, 0)));
        low.add(this.SurfaceLabel);
        this.add(top);
        this.add(this.Dashed);
        this.add(mid);
        this.add(low);
        this.add(this.Surface);
        this.add(this.ContourRange);
    }

    void setSliderBounds(float min, float max) {
        this.sliderScale = 1000.0f / (max - min);
        this.Surface.setMinimum((int)(this.sliderScale * (double)min));
        this.Surface.setMaximum((int)(this.sliderScale * (double)max));
    }

    void setMinMax(float min, float max) throws VisADException, RemoteException {
        if (!Util.isApproximatelyEqual(this.cLo, min) || !Util.isApproximatelyEqual(this.cHi, max)) {
            this.cLo = min;
            this.cHi = max;
            this.control.setContourLimits(this.cLo, this.cHi);
        }
    }

    private void detectValues(double[] range) throws VisADException, RemoteException {
        boolean[] bval = new boolean[2];
        float[] fval = new float[5];
        this.control.getMainContours(bval, fval);
        boolean setSurface = false;
        if (fval[0] == fval[0] && !Util.isApproximatelyEqual(this.cSurface, fval[0])) {
            this.cSurface = fval[0];
            setSurface = true;
        } else if (!Util.isApproximatelyEqual(this.cSurface, (float)range[0])) {
            this.cSurface = (float)range[0];
            setSurface = true;
        }
        if (setSurface) {
            this.control.setSurfaceValue(this.cSurface);
        }
        if (!(Util.isApproximatelyEqual(this.cInterval, fval[1]) && Util.isApproximatelyEqual(this.cLo, fval[2]) && Util.isApproximatelyEqual(this.cHi, fval[3]) && Util.isApproximatelyEqual(this.cBase, fval[4]))) {
            this.cInterval = fval[1];
            this.cLo = fval[2];
            this.cHi = fval[3];
            this.cBase = fval[4];
            this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
        }
        this.updateWidgetSurface();
        this.updateWidgetRange();
    }

    private synchronized void updateWidgetSurface() throws VisADException, RemoteException {
        if (this.cSurface == this.cSurface) {
            this.Surface.setEnabled(true);
            double tmp = this.sliderScale * (double)this.cSurface;
            int val = tmp < 0.0 ? (int)(tmp - 0.5) : (int)(tmp + 0.5);
            this.Surface.setValue(val);
            this.SurfaceLabel.setText(this.name + " = " + PlotText.shortString(this.cSurface));
        } else {
            this.Surface.setEnabled(false);
            this.SurfaceLabel.setText(this.name + " = ---");
        }
    }

    private synchronized void updateWidgetRange() throws VisADException, RemoteException {
        if (this.cInterval == this.cInterval && this.cBase == this.cBase) {
            this.Interval.setEnabled(true);
            this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            this.Base.setEnabled(true);
            this.Base.setText("" + PlotText.shortString(this.cBase));
        } else {
            this.Interval.setEnabled(false);
            this.Interval.setText("---");
            this.Base.setEnabled(false);
            this.Base.setText("---");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("interval")) {
            float interv = Float.NaN;
            try {
                interv = Float.valueOf(this.Interval.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            }
            if (interv == interv && interv >= 0.0f) {
                if (this.cInterval < 0.0f) {
                    interv = -interv;
                }
                try {
                    this.control.setContourInterval(interv, this.cLo, this.cHi, this.cBase);
                    this.cInterval = interv;
                }
                catch (VisADException exc) {
                    this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
                }
                catch (RemoteException exc) {
                    this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
                }
            } else {
                this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            }
        }
        if (cmd.equals("base")) {
            float ba = Float.NaN;
            try {
                ba = Float.valueOf(this.Base.getText()).floatValue();
            }
            catch (NumberFormatException exc) {
                this.Base.setText(PlotText.shortString(this.cBase));
            }
            if (ba == ba) {
                try {
                    this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, ba);
                    this.cBase = ba;
                }
                catch (VisADException exc) {
                    this.Base.setText(PlotText.shortString(this.cBase));
                }
                catch (RemoteException exc) {
                    this.Base.setText(PlotText.shortString(this.cBase));
                }
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        float newVal = (float)((double)this.Surface.getValue() / this.sliderScale);
        if (!Util.isApproximatelyEqual(this.cSurface, newVal)) {
            this.cSurface = newVal;
            this.SurfaceLabel.setText(this.name + " = " + PlotText.shortString(this.cSurface));
            try {
                this.control.setSurfaceValue(this.cSurface);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        boolean on;
        ItemSelectable o = e.getItemSelectable();
        boolean bl = on = e.getStateChange() == 1;
        if (o == this.Labels) {
            try {
                this.control.enableLabels(on);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }
        if (o == this.Contours) {
            try {
                this.control.enableContours(on);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }
        if (o == this.Dashed) {
            this.cInterval = -this.cInterval;
            try {
                this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }
        if (o == this.Fill) {
            try {
                this.control.setContourFill(on);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }
    }

    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        float cInt;
        float interval;
        boolean dashedState;
        boolean[] bvals = new boolean[2];
        float[] fvals = new float[5];
        this.control.getMainContours(bvals, fvals);
        if (this.Contours.isSelected() != bvals[0]) {
            this.Contours.setSelected(bvals[0]);
        }
        if (this.Labels.isSelected() != bvals[1]) {
            this.Labels.setSelected(bvals[1]);
        }
        boolean bl = dashedState = (interval = fvals[1]) < 0.0f;
        if (this.Dashed.isSelected() != dashedState) {
            this.Dashed.setSelected(dashedState);
        }
        if (!Util.isApproximatelyEqual(interval, cInt = dashedState != this.cInterval < 0.0f ? -this.cInterval : this.cInterval)) {
            if (interval < 0.0f) {
                interval = -interval;
            }
            this.Interval.setText(PlotText.shortString(interval));
            this.cInterval = fvals[1];
        }
        if (!Util.isApproximatelyEqual(fvals[4], this.cBase)) {
            this.Base.setText(PlotText.shortString(fvals[4]));
            this.cBase = fvals[4];
        }
        if (!Util.isApproximatelyEqual(fvals[0], this.cSurface)) {
            this.cSurface = fvals[0];
            this.updateWidgetSurface();
        }
        if (!Util.isApproximatelyEqual(fvals[2], this.cLo) || !Util.isApproximatelyEqual(fvals[3], this.cHi)) {
            this.cLo = fvals[2];
            this.cHi = fvals[3];
            this.updateWidgetRange();
            this.ContourRange.setValues(this.cLo, this.cHi);
        }
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, super.getPreferredSize().height);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    public void mapChanged(ScalarMapEvent e) {
    }

    public void controlChanged(ScalarMapControlEvent evt) throws RemoteException, VisADException {
        int id = evt.getId();
        if (this.control != null && (id == 4 || id == 5)) {
            evt.getControl().removeControlListener(this);
        }
        if (id == 5 || id == 3) {
            this.control = (ContourControl)evt.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(this.control));
            this.control.addControlListener(this);
        }
    }

    class ContourRangeSlider
    extends RangeSlider
    implements ScalarMapListener {
        ContourWidget pappy;

        ContourRangeSlider(ScalarMap smap, float min, float max, ContourWidget dad, boolean update) throws VisADException, RemoteException {
            super(RangeSlider.nameOf(smap), min, max);
            this.pappy = dad;
            if (update) {
                smap.addScalarMapListener(this);
            }
        }

        public void mapChanged(ScalarMapEvent e) {
            ScalarMap s = e.getScalarMap();
            ContourControl cc = (ContourControl)s.getControl();
            double[] range = s.getRange();
            try {
                this.minLimit = (float)range[0];
                this.maxLimit = (float)range[1];
                if (!Util.isApproximatelyEqual(ContourWidget.this.cLo, this.minLimit) || !Util.isApproximatelyEqual(ContourWidget.this.cHi, this.maxLimit)) {
                    ContourWidget.this.cLo = this.minLimit;
                    ContourWidget.this.cHi = this.maxLimit;
                }
                this.pappy.setSliderBounds(this.minLimit, this.maxLimit);
                this.pappy.detectValues(range);
                float[] lhb = new float[3];
                boolean[] dashes = new boolean[1];
                float[] lvls = cc.getLevels(lhb, dashes);
                this.setValues(lhb[0], lhb[1]);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException exc) {
                // empty catch block
            }
        }

        public void controlChanged(ScalarMapControlEvent evt) {
        }

        public void valuesUpdated() {
            try {
                this.pappy.setMinMax(this.minValue, this.maxValue);
            }
            catch (VisADException exc) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

