/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.Server;

import gnu.regexp.RE;
import gnu.regexp.REException;
import opendap.dap.BaseType;
import opendap.dap.DByte;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DString;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import opendap.dap.DURL;
import opendap.dap.Server.InvalidOperatorException;
import opendap.dap.Server.RegExpException;
import opendap.dap.Server.SBHException;
import opendap.dap.parser.ExprParserConstants;

public class Operator
implements ExprParserConstants {
    private static boolean _Debug = false;

    public static boolean op(int oprtr, BaseType lop, BaseType rop) throws InvalidOperatorException, RegExpException, SBHException {
        if (lop instanceof DByte) {
            return Operator.op(oprtr, (DByte)lop, rop);
        }
        if (lop instanceof DFloat32) {
            return Operator.op(oprtr, (DFloat32)lop, rop);
        }
        if (lop instanceof DFloat64) {
            return Operator.op(oprtr, (DFloat64)lop, rop);
        }
        if (lop instanceof DInt16) {
            return Operator.op(oprtr, (DInt16)lop, rop);
        }
        if (lop instanceof DInt32) {
            return Operator.op(oprtr, (DInt32)lop, rop);
        }
        if (lop instanceof DString) {
            return Operator.op(oprtr, (DString)lop, rop);
        }
        if (lop instanceof DUInt16) {
            return Operator.op(oprtr, (DUInt16)lop, rop);
        }
        if (lop instanceof DUInt32) {
            return Operator.op(oprtr, (DUInt32)lop, rop);
        }
        if (lop instanceof DURL) {
            return Operator.op(oprtr, (DURL)lop, rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DByte lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DFloat32 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DFloat64 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DInt16 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DInt32 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DString lop, BaseType rop) throws InvalidOperatorException, RegExpException, SBHException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DUInt16 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DUInt32 lop, BaseType rop) throws InvalidOperatorException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static boolean op(int oprtr, DURL lop, BaseType rop) throws InvalidOperatorException, RegExpException, SBHException {
        if (rop instanceof DByte) {
            return Operator.op(oprtr, lop, (DByte)rop);
        }
        if (rop instanceof DFloat32) {
            return Operator.op(oprtr, lop, (DFloat32)rop);
        }
        if (rop instanceof DFloat64) {
            return Operator.op(oprtr, lop, (DFloat64)rop);
        }
        if (rop instanceof DInt16) {
            return Operator.op(oprtr, lop, (DInt16)rop);
        }
        if (rop instanceof DInt32) {
            return Operator.op(oprtr, lop, (DInt32)rop);
        }
        if (rop instanceof DString) {
            return Operator.op(oprtr, lop, (DString)rop);
        }
        if (rop instanceof DUInt16) {
            return Operator.op(oprtr, lop, (DUInt16)rop);
        }
        if (rop instanceof DUInt32) {
            return Operator.op(oprtr, lop, (DUInt32)rop);
        }
        if (rop instanceof DURL) {
            return Operator.op(oprtr, lop, (DURL)rop);
        }
        throw new InvalidOperatorException("Binary operations not supported for the type:" + lop.getClass());
    }

    private static String opErrorMsg(int oprtr, String lop, String rop) {
        switch (oprtr) {
            case 9: {
                return "Less Than (<) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 10: {
                return "Less Than Equal To (<=) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 7: {
                return "Greater Than (>) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 8: {
                return "Greater Than Equal To (>=) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 5: {
                return "Equal To (==) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 6: {
                return "Not Equal To (!=) Operator not valid between types" + lop + "and" + rop + ".";
            }
            case 11: {
                return "Regular Expression cannot beevaluated between types" + lop + "and" + rop + ".";
            }
        }
        return "Unknown Operator Requested! RTFM!";
    }

    private static boolean op(int oprtr, DByte lop, DByte rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        int rval = rop.getValue() & 0xFF;
        switch (oprtr) {
            case 9: {
                return lval < rval;
            }
            case 10: {
                return lval <= rval;
            }
            case 7: {
                return lval > rval;
            }
            case 8: {
                return lval >= rval;
            }
            case 5: {
                return lval == rval;
            }
            case 6: {
                return lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DFloat32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        switch (oprtr) {
            case 9: {
                return (float)lval < rop.getValue();
            }
            case 10: {
                return (float)lval <= rop.getValue();
            }
            case 7: {
                return (float)lval > rop.getValue();
            }
            case 8: {
                return (float)lval >= rop.getValue();
            }
            case 5: {
                return (float)lval == rop.getValue();
            }
            case 6: {
                return (float)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DFloat64 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        switch (oprtr) {
            case 9: {
                return (double)lval < rop.getValue();
            }
            case 10: {
                return (double)lval <= rop.getValue();
            }
            case 7: {
                return (double)lval > rop.getValue();
            }
            case 8: {
                return (double)lval >= rop.getValue();
            }
            case 5: {
                return (double)lval == rop.getValue();
            }
            case 6: {
                return (double)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DInt16 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        switch (oprtr) {
            case 9: {
                return lval < rop.getValue();
            }
            case 10: {
                return lval <= rop.getValue();
            }
            case 7: {
                return lval > rop.getValue();
            }
            case 8: {
                return lval >= rop.getValue();
            }
            case 5: {
                return lval == rop.getValue();
            }
            case 6: {
                return lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DInt32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        switch (oprtr) {
            case 9: {
                return lval < rop.getValue();
            }
            case 10: {
                return lval <= rop.getValue();
            }
            case 7: {
                return lval > rop.getValue();
            }
            case 8: {
                return lval >= rop.getValue();
            }
            case 5: {
                return lval == rop.getValue();
            }
            case 6: {
                return lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DUInt16 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < rval;
            }
            case 10: {
                return lval <= rval;
            }
            case 7: {
                return lval > rval;
            }
            case 8: {
                return lval >= rval;
            }
            case 5: {
                return lval == rval;
            }
            case 6: {
                return lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DUInt32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFF;
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (long)lval < rval;
            }
            case 10: {
                return (long)lval <= rval;
            }
            case 7: {
                return (long)lval > rval;
            }
            case 8: {
                return (long)lval >= rval;
            }
            case 5: {
                return (long)lval == rval;
            }
            case 6: {
                return (long)lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DByte lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (float)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (float)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (float)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (float)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (float)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (float)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return (double)lop.getValue() < rop.getValue();
            }
            case 10: {
                return (double)lop.getValue() <= rop.getValue();
            }
            case 7: {
                return (double)lop.getValue() > rop.getValue();
            }
            case 8: {
                return (double)lop.getValue() >= rop.getValue();
            }
            case 5: {
                return (double)lop.getValue() == rop.getValue();
            }
            case 6: {
                return (double)lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (float)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (float)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (float)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (float)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (float)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (float)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (float)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (float)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (float)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (float)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (float)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (float)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DUInt16 rop) throws InvalidOperatorException {
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (float)rval;
            }
            case 10: {
                return lop.getValue() <= (float)rval;
            }
            case 7: {
                return lop.getValue() > (float)rval;
            }
            case 8: {
                return lop.getValue() >= (float)rval;
            }
            case 5: {
                return lop.getValue() == (float)rval;
            }
            case 6: {
                return lop.getValue() != (float)rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DUInt32 rop) throws InvalidOperatorException {
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (float)rval;
            }
            case 10: {
                return lop.getValue() <= (float)rval;
            }
            case 7: {
                return lop.getValue() > (float)rval;
            }
            case 8: {
                return lop.getValue() >= (float)rval;
            }
            case 5: {
                return lop.getValue() == (float)rval;
            }
            case 6: {
                return lop.getValue() != (float)rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat32 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (double)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (double)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (double)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (double)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (double)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (double)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (double)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (double)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (double)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (double)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (double)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (double)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (double)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (double)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (double)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rop.getValue();
            }
            case 10: {
                return lop.getValue() <= (double)rop.getValue();
            }
            case 7: {
                return lop.getValue() > (double)rop.getValue();
            }
            case 8: {
                return lop.getValue() >= (double)rop.getValue();
            }
            case 5: {
                return lop.getValue() == (double)rop.getValue();
            }
            case 6: {
                return lop.getValue() != (double)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DUInt16 rop) throws InvalidOperatorException {
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rval;
            }
            case 10: {
                return lop.getValue() <= (double)rval;
            }
            case 7: {
                return lop.getValue() > (double)rval;
            }
            case 8: {
                return lop.getValue() >= (double)rval;
            }
            case 5: {
                return lop.getValue() == (double)rval;
            }
            case 6: {
                return lop.getValue() != (double)rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DUInt32 rop) throws InvalidOperatorException {
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < (double)rval;
            }
            case 10: {
                return lop.getValue() <= (double)rval;
            }
            case 7: {
                return lop.getValue() > (double)rval;
            }
            case 8: {
                return lop.getValue() >= (double)rval;
            }
            case 5: {
                return lop.getValue() == (double)rval;
            }
            case 6: {
                return lop.getValue() != (double)rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DFloat64 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return (float)lop.getValue() < rop.getValue();
            }
            case 10: {
                return (float)lop.getValue() <= rop.getValue();
            }
            case 7: {
                return (float)lop.getValue() > rop.getValue();
            }
            case 8: {
                return (float)lop.getValue() >= rop.getValue();
            }
            case 5: {
                return (float)lop.getValue() == rop.getValue();
            }
            case 6: {
                return (float)lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return (double)lop.getValue() < rop.getValue();
            }
            case 10: {
                return (double)lop.getValue() <= rop.getValue();
            }
            case 7: {
                return (double)lop.getValue() > rop.getValue();
            }
            case 8: {
                return (double)lop.getValue() >= rop.getValue();
            }
            case 5: {
                return (double)lop.getValue() == rop.getValue();
            }
            case 6: {
                return (double)lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DUInt16 rop) throws InvalidOperatorException {
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rval;
            }
            case 10: {
                return lop.getValue() <= rval;
            }
            case 7: {
                return lop.getValue() > rval;
            }
            case 8: {
                return lop.getValue() >= rval;
            }
            case 5: {
                return lop.getValue() == rval;
            }
            case 6: {
                return lop.getValue() != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DUInt32 rop) throws InvalidOperatorException {
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (long)lop.getValue() < rval;
            }
            case 10: {
                return (long)lop.getValue() <= rval;
            }
            case 7: {
                return (long)lop.getValue() > rval;
            }
            case 8: {
                return (long)lop.getValue() >= rval;
            }
            case 5: {
                return (long)lop.getValue() == rval;
            }
            case 6: {
                return (long)lop.getValue() != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt16 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return (float)lop.getValue() < rop.getValue();
            }
            case 10: {
                return (float)lop.getValue() <= rop.getValue();
            }
            case 7: {
                return (float)lop.getValue() > rop.getValue();
            }
            case 8: {
                return (float)lop.getValue() >= rop.getValue();
            }
            case 5: {
                return (float)lop.getValue() == rop.getValue();
            }
            case 6: {
                return (float)lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return (double)lop.getValue() < rop.getValue();
            }
            case 10: {
                return (double)lop.getValue() <= rop.getValue();
            }
            case 7: {
                return (double)lop.getValue() > rop.getValue();
            }
            case 8: {
                return (double)lop.getValue() >= rop.getValue();
            }
            case 5: {
                return (double)lop.getValue() == rop.getValue();
            }
            case 6: {
                return (double)lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rop.getValue();
            }
            case 10: {
                return lop.getValue() <= rop.getValue();
            }
            case 7: {
                return lop.getValue() > rop.getValue();
            }
            case 8: {
                return lop.getValue() >= rop.getValue();
            }
            case 5: {
                return lop.getValue() == rop.getValue();
            }
            case 6: {
                return lop.getValue() != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DUInt16 rop) throws InvalidOperatorException {
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lop.getValue() < rval;
            }
            case 10: {
                return lop.getValue() <= rval;
            }
            case 7: {
                return lop.getValue() > rval;
            }
            case 8: {
                return lop.getValue() >= rval;
            }
            case 5: {
                return lop.getValue() == rval;
            }
            case 6: {
                return lop.getValue() != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DUInt32 rop) throws InvalidOperatorException {
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (long)lop.getValue() < rval;
            }
            case 10: {
                return (long)lop.getValue() <= rval;
            }
            case 7: {
                return (long)lop.getValue() > rval;
            }
            case 8: {
                return (long)lop.getValue() >= rval;
            }
            case 5: {
                return (long)lop.getValue() == rval;
            }
            case 6: {
                return (long)lop.getValue() != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DInt32 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DString rop) throws InvalidOperatorException, RegExpException, SBHException {
        switch (oprtr) {
            case 9: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp < 0;
            }
            case 10: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp <= 0;
            }
            case 7: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp > 0;
            }
            case 8: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp >= 0;
            }
            case 5: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp == 0;
            }
            case 6: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp != 0;
            }
            case 11: {
                if (_Debug) {
                    System.out.println("Left Operand: '" + lop.getValue() + "'  Right Operand: '" + rop.getValue() + "'");
                }
                try {
                    RE regexp = new RE(lop.getValue());
                    return regexp.isMatch(rop.getValue());
                }
                catch (REException e1) {
                    throw new RegExpException(e1.getMessage());
                }
                catch (Exception e2) {
                    throw new SBHException(e2.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DUInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DUInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DString lop, DURL rop) throws InvalidOperatorException, RegExpException, SBHException {
        switch (oprtr) {
            case 9: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp < 0;
            }
            case 10: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp <= 0;
            }
            case 7: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp > 0;
            }
            case 8: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp >= 0;
            }
            case 5: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp == 0;
            }
            case 6: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp != 0;
            }
            case 11: {
                if (_Debug) {
                    System.out.println("Left Operand: '" + lop.getValue() + "'  Right Operand: '" + rop.getValue() + "'");
                }
                try {
                    RE regexp = new RE(lop.getValue());
                    return regexp.isMatch(rop.getValue());
                }
                catch (REException e1) {
                    throw new RegExpException(e1.getMessage());
                }
                catch (Exception e2) {
                    throw new SBHException(e2.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DByte rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < rop.getValue();
            }
            case 10: {
                return lval <= rop.getValue();
            }
            case 7: {
                return lval > rop.getValue();
            }
            case 8: {
                return lval >= rop.getValue();
            }
            case 5: {
                return lval == rop.getValue();
            }
            case 6: {
                return lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DFloat32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return (float)lval < rop.getValue();
            }
            case 10: {
                return (float)lval <= rop.getValue();
            }
            case 7: {
                return (float)lval > rop.getValue();
            }
            case 8: {
                return (float)lval >= rop.getValue();
            }
            case 5: {
                return (float)lval == rop.getValue();
            }
            case 6: {
                return (float)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DFloat64 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return (double)lval < rop.getValue();
            }
            case 10: {
                return (double)lval <= rop.getValue();
            }
            case 7: {
                return (double)lval > rop.getValue();
            }
            case 8: {
                return (double)lval >= rop.getValue();
            }
            case 5: {
                return (double)lval == rop.getValue();
            }
            case 6: {
                return (double)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DInt16 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < rop.getValue();
            }
            case 10: {
                return lval <= rop.getValue();
            }
            case 7: {
                return lval > rop.getValue();
            }
            case 8: {
                return lval >= rop.getValue();
            }
            case 5: {
                return lval == rop.getValue();
            }
            case 6: {
                return lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DInt32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < rop.getValue();
            }
            case 10: {
                return lval <= rop.getValue();
            }
            case 7: {
                return lval > rop.getValue();
            }
            case 8: {
                return lval >= rop.getValue();
            }
            case 5: {
                return lval == rop.getValue();
            }
            case 6: {
                return lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DUInt16 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < rval;
            }
            case 10: {
                return lval <= rval;
            }
            case 7: {
                return lval > rval;
            }
            case 8: {
                return lval >= rval;
            }
            case 5: {
                return lval == rval;
            }
            case 6: {
                return lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DUInt32 rop) throws InvalidOperatorException {
        int lval = lop.getValue() & 0xFFFF;
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (long)lval < rval;
            }
            case 10: {
                return (long)lval <= rval;
            }
            case 7: {
                return (long)lval > rval;
            }
            case 8: {
                return (long)lval >= rval;
            }
            case 5: {
                return (long)lval == rval;
            }
            case 6: {
                return (long)lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt16 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DByte rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lval < (long)rop.getValue();
            }
            case 10: {
                return lval <= (long)rop.getValue();
            }
            case 7: {
                return lval > (long)rop.getValue();
            }
            case 8: {
                return lval >= (long)rop.getValue();
            }
            case 5: {
                return lval == (long)rop.getValue();
            }
            case 6: {
                return lval != (long)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DFloat32 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (float)lval < rop.getValue();
            }
            case 10: {
                return (float)lval <= rop.getValue();
            }
            case 7: {
                return (float)lval > rop.getValue();
            }
            case 8: {
                return (float)lval >= rop.getValue();
            }
            case 5: {
                return (float)lval == rop.getValue();
            }
            case 6: {
                return (float)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DFloat64 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return (double)lval < rop.getValue();
            }
            case 10: {
                return (double)lval <= rop.getValue();
            }
            case 7: {
                return (double)lval > rop.getValue();
            }
            case 8: {
                return (double)lval >= rop.getValue();
            }
            case 5: {
                return (double)lval == rop.getValue();
            }
            case 6: {
                return (double)lval != rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DInt16 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lval < (long)rop.getValue();
            }
            case 10: {
                return lval <= (long)rop.getValue();
            }
            case 7: {
                return lval > (long)rop.getValue();
            }
            case 8: {
                return lval >= (long)rop.getValue();
            }
            case 5: {
                return lval == (long)rop.getValue();
            }
            case 6: {
                return lval != (long)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DInt32 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lval < (long)rop.getValue();
            }
            case 10: {
                return lval <= (long)rop.getValue();
            }
            case 7: {
                return lval > (long)rop.getValue();
            }
            case 8: {
                return lval >= (long)rop.getValue();
            }
            case 5: {
                return lval == (long)rop.getValue();
            }
            case 6: {
                return lval != (long)rop.getValue();
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DString rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DUInt16 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        int rval = rop.getValue() & 0xFFFF;
        switch (oprtr) {
            case 9: {
                return lval < (long)rval;
            }
            case 10: {
                return lval <= (long)rval;
            }
            case 7: {
                return lval > (long)rval;
            }
            case 8: {
                return lval >= (long)rval;
            }
            case 5: {
                return lval == (long)rval;
            }
            case 6: {
                return lval != (long)rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DUInt32 rop) throws InvalidOperatorException {
        long lval = (long)lop.getValue() & 0xFFFFFFFFL;
        long rval = (long)rop.getValue() & 0xFFFFFFFFL;
        switch (oprtr) {
            case 9: {
                return lval < rval;
            }
            case 10: {
                return lval <= rval;
            }
            case 7: {
                return lval > rval;
            }
            case 8: {
                return lval >= rval;
            }
            case 5: {
                return lval == rval;
            }
            case 6: {
                return lval != rval;
            }
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DUInt32 lop, DURL rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DByte rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DFloat32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DFloat64 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DString rop) throws InvalidOperatorException, RegExpException, SBHException {
        switch (oprtr) {
            case 9: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp < 0;
            }
            case 10: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp <= 0;
            }
            case 7: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp > 0;
            }
            case 8: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp >= 0;
            }
            case 5: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp == 0;
            }
            case 6: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp != 0;
            }
            case 11: {
                if (_Debug) {
                    System.out.println("Left Operand: '" + lop.getValue() + "'  Right Operand: '" + rop.getValue() + "'");
                }
                try {
                    RE regexp = new RE(lop.getValue());
                    return regexp.isMatch(rop.getValue());
                }
                catch (REException e1) {
                    throw new RegExpException(e1.getMessage());
                }
                catch (Exception e2) {
                    throw new SBHException(e2.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DUInt16 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DUInt32 rop) throws InvalidOperatorException {
        switch (oprtr) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new InvalidOperatorException(Operator.opErrorMsg(oprtr, lop.getTypeName(), rop.getTypeName()));
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }

    private static boolean op(int oprtr, DURL lop, DURL rop) throws InvalidOperatorException, RegExpException, SBHException {
        switch (oprtr) {
            case 9: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp < 0;
            }
            case 10: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp <= 0;
            }
            case 7: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp > 0;
            }
            case 8: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp >= 0;
            }
            case 5: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp == 0;
            }
            case 6: {
                int cmp = lop.getValue().compareTo(rop.getValue());
                return cmp != 0;
            }
            case 11: {
                if (_Debug) {
                    System.out.println("Left Operand: '" + lop.getValue() + "'  Right Operand: '" + rop.getValue() + "'");
                }
                try {
                    RE regexp = new RE(lop.getValue());
                    return regexp.isMatch(rop.getValue());
                }
                catch (REException e1) {
                    throw new RegExpException(e1.getMessage());
                }
                catch (Exception e2) {
                    throw new SBHException(e2.getMessage());
                }
            }
        }
        throw new InvalidOperatorException("Unknown Operator Requested! RTFM!");
    }
}

