/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.util.Arrays;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class ImageFlatField
extends FlatField {
    public static final boolean DEBUG = false;
    protected BufferedImage image;
    protected int num;
    protected int width;
    protected int height;

    public static BufferedImage make3ByteRGB(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int dataType = 0;
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 3, dataType);
        int w = image.getWidth();
        int h = image.getHeight();
        byte[][] data = new byte[3][w * h];
        BandedSampleModel model = new BandedSampleModel(dataType, w, h, data.length);
        DataBufferByte buffer = new DataBufferByte(data, data[0].length);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage result = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = result.createGraphics();
        g.drawRenderedImage(image, null);
        g.dispose();
        g = null;
        return result;
    }

    public static FunctionType makeFunctionType(BufferedImage img) throws VisADException {
        if (img == null) {
            throw new VisADException("image cannot be null");
        }
        RealType x = RealType.getRealType("ImageElement");
        RealType y = RealType.getRealType("ImageLine");
        RealTupleType xy = new RealTupleType(x, y);
        int num = img.getRaster().getNumBands();
        MathType range = null;
        if (num == 4) {
            RealType r = RealType.getRealType("Red");
            RealType g = RealType.getRealType("Green");
            RealType b = RealType.getRealType("Blue");
            RealType a = RealType.getRealType("Alpha");
            range = new RealTupleType(r, g, b, a);
        } else if (num == 3) {
            RealType r = RealType.getRealType("Red");
            RealType g = RealType.getRealType("Green");
            RealType b = RealType.getRealType("Blue");
            range = new RealTupleType(r, g, b);
        } else if (num == 1) {
            range = RealType.getRealType("Intensity");
        } else {
            throw new VisADException("Unsupported # of bands (" + num + ")");
        }
        return new FunctionType(xy, range);
    }

    public static Set makeDomainSet(BufferedImage img) throws VisADException {
        RealType x = RealType.getRealType("ImageElement");
        RealType y = RealType.getRealType("ImageLine");
        RealTupleType xy = new RealTupleType(x, y);
        int w = img.getWidth();
        int h = img.getHeight();
        return new Linear2DSet((MathType)xy, 0.0, (double)(w - 1), w, h - 1, 0.0, h);
    }

    public ImageFlatField(BufferedImage img) throws VisADException, RemoteException {
        this(ImageFlatField.makeFunctionType(img), ImageFlatField.makeDomainSet(img));
        this.setImage(img);
    }

    public ImageFlatField(FunctionType type) throws VisADException {
        this(type, type.getDomain().getDefaultSet(), null, null, null, null);
    }

    public ImageFlatField(FunctionType type, Set domain_set) throws VisADException {
        this(type, domain_set, null, null, null, null);
    }

    public ImageFlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, range_coord_sys, null, range_sets, units);
    }

    public ImageFlatField(FunctionType type, Set domain_set, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        this(type, domain_set, null, range_coord_syses, range_sets, units);
    }

    public ImageFlatField(FunctionType type, Set domain_set, CoordinateSystem range_coord_sys, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException {
        super(type, domain_set, range_coord_sys, range_coord_syses, range_sets, units);
        RealTupleType domain = type.getDomain();
        if (domain.getNumberOfRealComponents() != 2) {
            throw new VisADException("FunctionType domain must be flat with 2 components");
        }
        MathType range = type.getRange();
        if (range instanceof RealType) {
            this.num = 1;
        } else if (range instanceof RealTupleType) {
            this.num = ((RealTupleType)range).getNumberOfRealComponents();
        }
        if (this.num != 1 && this.num != 3 && this.num != 4) {
            throw new VisADException("FunctionType range must be flat with 1, 3 or 4 components");
        }
        if (!(domain_set instanceof Gridded2DSet)) {
            throw new VisADException("Domain set must be Gridded2DSet");
        }
        int[] len = ((Gridded2DSet)domain_set).getLengths();
        this.width = len[0];
        this.height = len[1];
    }

    public BufferedImage getImage() {
        this.pr("getImage");
        return this.image;
    }

    public void setImage(BufferedImage image) throws VisADException, RemoteException {
        if (image == null) {
            throw new VisADException("image cannot be null");
        }
        if (image.getWidth() != this.width || image.getHeight() != this.height) {
            throw new VisADException("Image dimensions do not match domain set");
        }
        if (image.getRaster().getNumBands() != this.num) {
            throw new VisADException("Image component count does not match FunctionType range");
        }
        this.image = image;
        this.clearMissing();
        this.notifyReferences();
    }

    public RealType[] getDomainTypes() {
        RealTupleType domain = ((FunctionType)this.getType()).getDomain();
        return domain.getRealComponents();
    }

    public RealType[] getRangeTypes() {
        MathType range = ((FunctionType)this.getType()).getRange();
        RealType[] v = null;
        v = range instanceof RealType ? new RealType[]{(RealType)range} : (range instanceof TupleType ? ((TupleType)range).getRealComponents() : new RealType[]{});
        return v;
    }

    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        boolean anyRangeRef;
        if (this.isMissing()) {
            return shadow;
        }
        ShadowRealTupleType domainType = ((ShadowFunctionType)type).getDomain();
        int n = domainType.getDimension();
        double[][] ranges = new double[2][n];
        shadow = this.getDomainSet().computeRanges(domainType, shadow, ranges, true);
        int[] indices = ((ShadowFunctionType)type).getRangeDisplayIndices();
        boolean anyMapped = false;
        for (int i = 0; i < this.TupleDimension; ++i) {
            if (indices[i] < 0) continue;
            anyMapped = true;
        }
        if (!anyMapped) {
            return shadow;
        }
        boolean bl = anyRangeRef = this.RangeCoordinateSystem != null;
        if (this.RangeCoordinateSystems != null) {
            for (int i = 0; i < this.RangeCoordinateSystems.length; ++i) {
                anyRangeRef |= this.RangeCoordinateSystems[i] != null;
            }
        }
        ranges = anyRangeRef ? new double[2][this.TupleDimension] : (double[][])null;
        WritableRaster raster = this.image.getRaster();
        double[] min = new double[this.TupleDimension];
        Arrays.fill(min, Double.MAX_VALUE);
        double[] max = new double[this.TupleDimension];
        Arrays.fill(max, -1.7976931348623157E308);
        double[] vals = new double[this.TupleDimension];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                raster.getPixel(x, y, vals);
                for (int i = 0; i < this.TupleDimension; ++i) {
                    min[i] = Math.min(min[i], vals[i]);
                    max[i] = Math.max(max[i], vals[i]);
                }
            }
        }
        for (int i = 0; i < this.TupleDimension; ++i) {
            int k = indices[i];
            if (k < 0 && !anyRangeRef) continue;
            Unit dunit = ((RealType)((FunctionType)this.Type).getFlatRange().getComponent(i)).getDefaultUnit();
            if (dunit != null && !dunit.equals(this.RangeUnits[i])) {
                min[i] = dunit.toThis(min[i], this.RangeUnits[i]);
                max[i] = dunit.toThis(max[i], this.RangeUnits[i]);
            }
            if (anyRangeRef) {
                ranges[0][i] = Math.min(ranges[0][i], min[i]);
                ranges[1][i] = Math.max(ranges[1][i], max[i]);
            }
            if (k < 0 || k >= shadow.ranges[0].length) continue;
            shadow.ranges[0][k] = Math.min(shadow.ranges[0][k], min[i]);
            shadow.ranges[1][k] = Math.max(shadow.ranges[1][k], max[i]);
        }
        if (this.RangeCoordinateSystem != null) {
            ShadowRealTupleType rangeType = (ShadowRealTupleType)((ShadowFunctionType)type).getRange();
            ShadowRealTupleType shadRef = rangeType.getReference();
            shadow = this.computeReferenceRanges(rangeType, this.RangeCoordinateSystem, this.RangeUnits, shadow, shadRef, ranges);
        } else if (this.RangeCoordinateSystems != null) {
            TupleType rangeTupleType = (TupleType)((FunctionType)this.Type).getRange();
            int j = 0;
            for (int i = 0; i < this.RangeCoordinateSystems.length; ++i) {
                MathType component = rangeTupleType.getComponent(i);
                if (component instanceof RealType) {
                    ++j;
                    continue;
                }
                int m = ((RealTupleType)component).getDimension();
                if (this.RangeCoordinateSystems[i] != null) {
                    double[][] subRanges = new double[2][m];
                    Unit[] subUnits = new Unit[m];
                    for (int k = 0; k < m; ++k) {
                        subRanges[0][k] = ranges[0][j];
                        subRanges[1][k] = ranges[1][j];
                        subUnits[k] = this.RangeUnits[j];
                        ++j;
                    }
                    ShadowRealTupleType rangeType = (ShadowRealTupleType)((ShadowTupleType)((ShadowFunctionType)type).getRange()).getComponent(i);
                    ShadowRealTupleType shadRef = rangeType.getReference();
                    shadow = this.computeReferenceRanges(rangeType, this.RangeCoordinateSystems[i], subUnits, shadow, shadRef, subRanges);
                    continue;
                }
                j += m;
            }
        }
        return shadow;
    }

    protected double[][] unpackValues(boolean copy) throws VisADException {
        this.pr("unpackValues(" + copy + ")");
        WritableRaster r = this.image.getRaster();
        double[][] samps = new double[this.num][this.width * this.height];
        for (int c = 0; c < this.num; ++c) {
            r.getSamples(0, 0, this.width, this.height, c, samps[c]);
        }
        return samps;
    }

    protected float[][] unpackFloats(boolean copy) throws VisADException {
        this.pr("unpackFloats(" + copy + ")");
        WritableRaster r = this.image.getRaster();
        float[][] samps = new float[this.num][this.width * this.height];
        for (int c = 0; c < this.num; ++c) {
            r.getSamples(0, 0, this.width, this.height, c, samps[c]);
        }
        return samps;
    }

    protected double[] unpackValues(int s_index) throws VisADException {
        this.pr("unpackValues(" + s_index + ")");
        WritableRaster r = this.image.getRaster();
        double[] samps = new double[this.num];
        r.getPixel(s_index % this.width, s_index / this.width, samps);
        return samps;
    }

    protected float[] unpackFloats(int s_index) throws VisADException {
        this.pr("unpackFloats(" + s_index + ")");
        WritableRaster r = this.image.getRaster();
        float[] samps = new float[this.num];
        r.getPixel(s_index % this.width, s_index / this.width, samps);
        return samps;
    }

    protected double[] unpackOneRangeComp(int comp) throws VisADException {
        this.pr("unpackOneRangeComp(" + comp + ")");
        WritableRaster r = this.image.getRaster();
        double[] samps = new double[this.width * this.height];
        r.getSamples(0, 0, this.width, this.height, comp, samps);
        return samps;
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        double[] v = this.unpackValues(index);
        RealTupleType range = (RealTupleType)((FunctionType)this.getType()).getRange();
        return new RealTuple(range, v);
    }

    protected void pr(String message) {
    }

    public void setSamples(double[][] range, boolean copy) throws RemoteException, VisADException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public void setSamples(float[][] range, boolean copy) throws RemoteException, VisADException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public void setSamples(double[][] range, ErrorEstimate[] errors, boolean copy) throws RemoteException, VisADException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public void setSamples(int start, double[][] range) throws RemoteException, VisADException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public void setSamples(float[][] range, ErrorEstimate[] errors, boolean copy) throws RemoteException, VisADException {
        throw new VisADException("Use setImage(Image) for ImageFlatField");
    }

    public byte[][] grabBytes() {
        this.pr("grabBytes");
        Object data = ImageFlatField.grabBytes(this.image);
        if (data == null) {
            return null;
        }
        if (((byte[][])data).length > this.num) {
            byte[][] bytes = new byte[this.num][];
            System.arraycopy(data, 0, bytes, 0, this.num);
            data = bytes;
        }
        return data;
    }

    public static byte[][] grabBytes(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (raster.getTransferType() != 0) {
            return null;
        }
        DataBuffer buffer = raster.getDataBuffer();
        if (buffer instanceof DataBufferByte) {
            SampleModel model = raster.getSampleModel();
            if (model instanceof BandedSampleModel) {
                byte[][] data = ((DataBufferByte)buffer).getBankData();
                return data;
            }
            if (model instanceof ComponentSampleModel) {
                byte[][] data = ((DataBufferByte)buffer).getBankData();
                ComponentSampleModel csm = (ComponentSampleModel)model;
                int[] bandOffsets = csm.getBandOffsets();
                int[] bankIndices = csm.getBankIndices();
                int pixelStride = csm.getPixelStride();
                int scanlineStride = csm.getScanlineStride();
                int numBands = bandOffsets.length;
                int width = image.getWidth();
                int height = image.getHeight();
                int numPixels = width * height;
                byte[][] bytes = new byte[numBands][numPixels];
                for (int c = 0; c < numBands; ++c) {
                    for (int h = 0; h < height; ++h) {
                        for (int w = 0; w < width; ++w) {
                            int ndx = width * h + w;
                            int q = bandOffsets[c] + h * scanlineStride + w * pixelStride;
                            bytes[c][ndx] = data[bankIndices[c]][q];
                        }
                    }
                }
                return bytes;
            }
        }
        return ImageFlatField.grabBytes(ImageFlatField.make3ByteRGB(image));
    }
}

