/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class MultipleValueVetter
extends ValueVetter {
    private double[] doubleValues;
    private float[] floatValues;
    private static final WeakHashMap map = new WeakHashMap();

    private MultipleValueVetter(double[] values) {
        this.doubleValues = values;
        this.floatValues = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.floatValues[i] = (float)values[i];
        }
    }

    static synchronized MultipleValueVetter multipleValueVetter(double[] values) {
        MultipleValueVetter vetter = new MultipleValueVetter(values);
        WeakReference ref = (WeakReference)map.get(vetter);
        if (ref == null) {
            map.put(vetter, new WeakReference<MultipleValueVetter>(vetter));
        } else {
            MultipleValueVetter oldVetter = (MultipleValueVetter)ref.get();
            if (oldVetter == null) {
                map.put(vetter, new WeakReference<MultipleValueVetter>(vetter));
            } else {
                vetter = oldVetter;
            }
        }
        return vetter;
    }

    public float process(float value) {
        for (int i = 0; i < this.floatValues.length; ++i) {
            if (value != this.floatValues[i]) continue;
            return Float.NaN;
        }
        return value;
    }

    public double process(double value) {
        for (int i = 0; i < this.doubleValues.length; ++i) {
            if (value != this.doubleValues[i]) continue;
            return Double.NaN;
        }
        return value;
    }

    public float[] process(float[] values) {
        block0: for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < this.floatValues.length; ++j) {
                if (values[i] != this.floatValues[j]) continue;
                values[i] = Float.NaN;
                continue block0;
            }
        }
        return values;
    }

    public double[] process(double[] values) {
        block0: for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < this.doubleValues.length; ++j) {
                if (values[i] != this.doubleValues[j]) continue;
                values[i] = Double.NaN;
                continue block0;
            }
        }
        return values;
    }

    public boolean equals(Object obj) {
        MultipleValueVetter that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (MultipleValueVetter)obj) || Arrays.equals(this.doubleValues, that.doubleValues);
        return equals;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.doubleValues.length; ++i) {
            code ^= new Double(this.doubleValues[i]).hashCode();
        }
        return code;
    }
}

