# Introduction

This documentation provides a guide for `pymatgen` administrators. The
following assumes you are using `miniconda` or Anaconda.

## Releases

The general procedure for releasing `pymatgen` comprises the following
steps:

1. Make sure all CI checks are green. We don't want to release known bugs.
2. Update and edit changelog.
3. Release PyPI versions + doc.
4. Release `conda` versions.
5. Release Dash documentation.

## Initial setup

Pymatgen uses [`invoke`](http://pyinvoke.org) to automate releases.
You will also need `sphinx` and `doc2dash`.

```sh
pip install --upgrade invoke sphinx doc2dash
```

Add your PyPI username and password and GITHUB_RELEASE_TOKEN into your
environment:

```sh
export TWINE_USERNAME=PYPIUSERNAME
export TWINE_PASSWORD=PYPIPASSWORD
export GITHUB_RELEASES_TOKEN=TOKEN_YOU_GET_FROM_GITHUB
```

You may want to add these to your .bash_profile to avoid having to type
these each time.

### Machine-specific issues

The above instructions are general, but some known issues are machine-specific:

- Installing lxml via pip required <span
  class="title-ref">STATIC_DEPS=true pip install lxml</span> on macOS
  10.13.
- It can be useful to <span class="title-ref">pip install --upgrade pip
  twine setuptools</span> (this may be necessary if there are
  authentication errors when connecting to PyPI).
- You may have to <span class="title-ref">brew install hdf5
  netcdf</span> or similar to be able to pip install the optional
  requirement <span class="title-ref">netCDF4</span>.

## Doing the release

Ensure appropriate environment variables are set including <span
class="title-ref">DISCOURSE_API_USERNAME</span>, <span
class="title-ref">DISCOURSE_API_KEY</span> and <span
class="title-ref">GITHUB_RELEASES_TOKEN</span>.

First update the change log. The autogenerated change log is simply a
list of commit messages since the last version. Make sure to edit the
log for brevity and to attribute significant features to appropriate
developers:

```sh
invoke update-changelog
```

Then, do the release with the following sequence of commands (you can
put them in a bash script in your PATH somewhere):

```sh
invoke release --notest --nodoc
invoke update-doc
python setup.py develop
```

Double check that the releases are properly done on Pypi. If you are
releasing on a Mac, you should see a pymatgen.version.tar.gz and two
wheels (Py37 and P). There will be a py37 wheel for Windows that is
generated by Appveyor.

## Materials.sh

Fork and clone the
[materials.sh](https://github.com/materialsvirtuallab/materials.sh).
This repo contains the `conda` skeletons to build the `conda` versions for
various matsci codes on the Anaconda [matsci
channel](https://anaconda.org/matsci).

The first time this is run, you may need to <span class="title-ref">pip
install beautifulsoup4</span>.

If you doing this for the first time, make sure conda-build and
anaconda-client are installed:

```sh
conda install --yes conda-build anaconda-client
```

Update the pymatgen meta.yaml:

```sh
invoke update-pypi pymatgen
```

Build the mac versions manually:

```sh
invoke build-conda pymatgen
```

Commit and push to repo, which will build the Linux and Windows
versions.

Check that the [matsci channel](https://anaconda.org/matsci) versions
are properly updated.

## Dash docs

Fork and clone the [Dash User Contributions
repo](https://github.com/Kapeli/Dash-User-Contributions).

Generate the offline Dash doc using:

```sh
invoke contribute-dash
```

Create a pull request and submit.
