# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AccessPolicyEntry(Model):
    """An identity that have access to the key vault. All identities in the array
    must use the same tenant ID as the key vault's tenant ID.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: Required. The Azure Active Directory tenant ID that
     should be used for authenticating requests to the key vault.
    :type tenant_id: str
    :param object_id: Required. The object ID of a user, service principal or
     security group in the Azure Active Directory tenant for the vault. The
     object ID must be unique for the list of access policies.
    :type object_id: str
    :param application_id:  Application ID of the client making request on
     behalf of a principal
    :type application_id: str
    :param permissions: Required. Permissions the identity has for keys,
     secrets and certificates.
    :type permissions: ~azure.mgmt.keyvault.v2018_02_14.models.Permissions
    """

    _validation = {
        'tenant_id': {'required': True},
        'object_id': {'required': True},
        'permissions': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'Permissions'},
    }

    def __init__(self, *, tenant_id: str, object_id: str, permissions, application_id: str=None, **kwargs) -> None:
        super(AccessPolicyEntry, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions


class CheckNameAvailabilityResult(Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: A boolean value that indicates whether the name is
     available for you to use. If true, the name is available. If false, the
     name has already been taken or is invalid and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason
     element is only returned if NameAvailable is false. Possible values
     include: 'AccountNameInvalid', 'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.keyvault.v2018_02_14.models.Reason
    :ivar message: An error message explaining the Reason value in more
     detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'Reason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudError(Model):
    """An error response from Key Vault resource provider.

    :param error:
    :type error: ~azure.mgmt.keyvault.v2018_02_14.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from Key Vault resource provider.

    :param code: Error code. This is a mnemonic that can be consumed
     programmatically.
    :type code: str
    :param message: User friendly error message. The message is typically
     localized and may vary with service version.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class DeletedVault(Model):
    """Deleted vault information with extended details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID for the deleted key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :param properties: Properties of the vault
    :type properties:
     ~azure.mgmt.keyvault.v2018_02_14.models.DeletedVaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeletedVaultProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(DeletedVault, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedVaultProperties(Model):
    """Properties of the deleted vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: datetime
    :ivar tags: Tags of the original vault.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'vault_id': {'readonly': True},
        'location': {'readonly': True},
        'deletion_date': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'deletion_date': {'key': 'deletionDate', 'type': 'iso-8601'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'iso-8601'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(DeletedVaultProperties, self).__init__(**kwargs)
        self.vault_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None


class IPRule(Model):
    """A rule governing the accessibility of a vault from a specific ip address or
    ip range.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. An IPv4 address range in CIDR notation, such as
     '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that
     start with 124.56.78).
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, value: str, **kwargs) -> None:
        super(IPRule, self).__init__(**kwargs)
        self.value = value


class LogSpecification(Model):
    """Log specification of operation.

    :param name: Name of log specification.
    :type name: str
    :param display_name: Display name of log specification.
    :type display_name: str
    :param blob_duration: Blob duration of specification.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, blob_duration: str=None, **kwargs) -> None:
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class NetworkRuleSet(Model):
    """A set of rules governing the network accessibility of a vault.

    :param bypass: Tells what traffic can bypass network rules. This can be
     'AzureServices' or 'None'.  If not specified the default is
     'AzureServices'. Possible values include: 'AzureServices', 'None'
    :type bypass: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleBypassOptions
    :param default_action: The default action when no rule from ipRules and
     from virtualNetworkRules match. This is only used after the bypass
     property has been evaluated. Possible values include: 'Allow', 'Deny'
    :type default_action: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleAction
    :param ip_rules: The list of IP address rules.
    :type ip_rules: list[~azure.mgmt.keyvault.v2018_02_14.models.IPRule]
    :param virtual_network_rules: The list of virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.keyvault.v2018_02_14.models.VirtualNetworkRule]
    """

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
    }

    def __init__(self, *, bypass=None, default_action=None, ip_rules=None, virtual_network_rules=None, **kwargs) -> None:
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class Operation(Model):
    """Key Vault REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.keyvault.v2018_02_14.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param service_specification: One property of operation, include metric
     specifications.
    :type service_specification:
     ~azure.mgmt.keyvault.v2018_02_14.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, service_specification=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Key Vault.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Permissions(Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :param keys: Permissions to keys
    :type keys: list[str or
     ~azure.mgmt.keyvault.v2018_02_14.models.KeyPermissions]
    :param secrets: Permissions to secrets
    :type secrets: list[str or
     ~azure.mgmt.keyvault.v2018_02_14.models.SecretPermissions]
    :param certificates: Permissions to certificates
    :type certificates: list[str or
     ~azure.mgmt.keyvault.v2018_02_14.models.CertificatePermissions]
    :param storage: Permissions to storage accounts
    :type storage: list[str or
     ~azure.mgmt.keyvault.v2018_02_14.models.StoragePermissions]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[str]'},
        'secrets': {'key': 'secrets', 'type': '[str]'},
        'certificates': {'key': 'certificates', 'type': '[str]'},
        'storage': {'key': 'storage', 'type': '[str]'},
    }

    def __init__(self, *, keys=None, secrets=None, certificates=None, storage=None, **kwargs) -> None:
        super(Permissions, self).__init__(**kwargs)
        self.keys = keys
        self.secrets = secrets
        self.certificates = certificates
        self.storage = storage


class PrivateEndpoint(Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class Resource(Model):
    """Key Vault resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class PrivateEndpointConnection(Resource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
    :param private_link_service_connection_state: Approval state of the
     private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint
     connection. Possible values include: 'Succeeded', 'Creating', 'Updating',
     'Deleting', 'Failed', 'Disconnected'
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionItem(Model):
    """Private endpoint connection item.

    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpoint
    :param private_link_service_connection_state: Approval state of the
     private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint
     connection. Possible values include: 'Succeeded', 'Creating', 'Updating',
     'Deleting', 'Failed', 'Disconnected'
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionProvisioningState
    """

    _attribute_map = {
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnectionItem, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :param required_zone_names: Required DNS zone names of the the private
     link resource.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, *, required_zone_names=None, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(Model):
    """A list of private link resources.

    :param value: Array of private link resources
    :type value:
     list[~azure.mgmt.keyvault.v2018_02_14.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(Model):
    """An object that represents the approval state of the private link
    connection.

    :param status: Indicates whether the connection has been approved,
     rejected or removed by the key vault owner. Possible values include:
     'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval or rejection.
    :type description: str
    :param action_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type action_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, action_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ServiceSpecification(Model):
    """One property of operation, include log specifications.

    :param log_specifications: Log specifications of operation.
    :type log_specifications:
     list[~azure.mgmt.keyvault.v2018_02_14.models.LogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(self, *, log_specifications=None, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class Sku(Model):
    """SKU details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar family: Required. SKU family name. Default value: "A" .
    :vartype family: str
    :param name: Required. SKU name to specify whether the key vault is a
     standard vault or a premium vault. Possible values include: 'standard',
     'premium'
    :type name: str or ~azure.mgmt.keyvault.v2018_02_14.models.SkuName
    """

    _validation = {
        'family': {'required': True, 'constant': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'SkuName'},
    }

    family = "A"

    def __init__(self, *, name, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name


class Vault(Model):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :param location: Azure location of the key vault resource.
    :type location: str
    :param tags: Tags assigned to the key vault resource.
    :type tags: dict[str, str]
    :param properties: Required. Properties of the vault
    :type properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
    }

    def __init__(self, *, properties, location: str=None, tags=None, **kwargs) -> None:
        super(Vault, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultAccessPolicyParameters(Model):
    """Parameters for updating the access policy in a vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :param properties: Required. Properties of the access policy
    :type properties:
     ~azure.mgmt.keyvault.v2018_02_14.models.VaultAccessPolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VaultAccessPolicyProperties'},
    }

    def __init__(self, *, properties, **kwargs) -> None:
        super(VaultAccessPolicyParameters, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class VaultAccessPolicyProperties(Model):
    """Properties of the vault access policy.

    All required parameters must be populated in order to send to Azure.

    :param access_policies: Required. An array of 0 to 16 identities that have
     access to the key vault. All identities in the array must use the same
     tenant ID as the key vault's tenant ID.
    :type access_policies:
     list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    """

    _validation = {
        'access_policies': {'required': True},
    }

    _attribute_map = {
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
    }

    def __init__(self, *, access_policies, **kwargs) -> None:
        super(VaultAccessPolicyProperties, self).__init__(**kwargs)
        self.access_policies = access_policies


class VaultCheckNameAvailabilityParameters(Model):
    """The parameters used to check the availability of the vault name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The vault name.
    :type name: str
    :ivar type: Required. The type of resource, Microsoft.KeyVault/vaults.
     Default value: "Microsoft.KeyVault/vaults" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.KeyVault/vaults"

    def __init__(self, *, name: str, **kwargs) -> None:
        super(VaultCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class VaultCreateOrUpdateParameters(Model):
    """Parameters for creating or updating a vault.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The supported Azure location where the key
     vault should be created.
    :type location: str
    :param tags: The tags that will be assigned to the key vault.
    :type tags: dict[str, str]
    :param properties: Required. Properties of the vault
    :type properties: ~azure.mgmt.keyvault.v2018_02_14.models.VaultProperties
    """

    _validation = {
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
    }

    def __init__(self, *, location: str, properties, tags=None, **kwargs) -> None:
        super(VaultCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultPatchParameters(Model):
    """Parameters for creating or updating a vault.

    :param tags: The tags that will be assigned to the key vault.
    :type tags: dict[str, str]
    :param properties: Properties of the vault
    :type properties:
     ~azure.mgmt.keyvault.v2018_02_14.models.VaultPatchProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultPatchProperties'},
    }

    def __init__(self, *, tags=None, properties=None, **kwargs) -> None:
        super(VaultPatchParameters, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class VaultPatchProperties(Model):
    """Properties of the vault.

    :param tenant_id: The Azure Active Directory tenant ID that should be used
     for authenticating requests to the key vault.
    :type tenant_id: str
    :param sku: SKU details
    :type sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
    :param access_policies: An array of 0 to 16 identities that have access to
     the key vault. All identities in the array must use the same tenant ID as
     the key vault's tenant ID.
    :type access_policies:
     list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    :param enabled_for_deployment: Property to specify whether Azure Virtual
     Machines are permitted to retrieve certificates stored as secrets from the
     key vault.
    :type enabled_for_deployment: bool
    :param enabled_for_disk_encryption: Property to specify whether Azure Disk
     Encryption is permitted to retrieve secrets from the vault and unwrap
     keys.
    :type enabled_for_disk_encryption: bool
    :param enabled_for_template_deployment: Property to specify whether Azure
     Resource Manager is permitted to retrieve secrets from the key vault.
    :type enabled_for_template_deployment: bool
    :param enable_soft_delete: Property to specify whether the 'soft delete'
     functionality is enabled for this key vault. It does not accept false
     value.
    :type enable_soft_delete: bool
    :param create_mode: The vault's create mode to indicate whether the vault
     need to be recovered or not. Possible values include: 'recover', 'default'
    :type create_mode: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
    :param enable_purge_protection: Property specifying whether protection
     against purge is enabled for this vault. Setting this property to true
     activates protection against purge for this vault and its content - only
     the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this
     functionality is irreversible - that is, the property does not accept
     false as its value.
    :type enable_purge_protection: bool
    :param network_acls: A collection of rules governing the accessibility of
     the vault from specific network locations.
    :type network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
        'enabled_for_deployment': {'key': 'enabledForDeployment', 'type': 'bool'},
        'enabled_for_disk_encryption': {'key': 'enabledForDiskEncryption', 'type': 'bool'},
        'enabled_for_template_deployment': {'key': 'enabledForTemplateDeployment', 'type': 'bool'},
        'enable_soft_delete': {'key': 'enableSoftDelete', 'type': 'bool'},
        'create_mode': {'key': 'createMode', 'type': 'CreateMode'},
        'enable_purge_protection': {'key': 'enablePurgeProtection', 'type': 'bool'},
        'network_acls': {'key': 'networkAcls', 'type': 'NetworkRuleSet'},
    }

    def __init__(self, *, tenant_id: str=None, sku=None, access_policies=None, enabled_for_deployment: bool=None, enabled_for_disk_encryption: bool=None, enabled_for_template_deployment: bool=None, enable_soft_delete: bool=None, create_mode=None, enable_purge_protection: bool=None, network_acls=None, **kwargs) -> None:
        super(VaultPatchProperties, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls


class VaultProperties(Model):
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: Required. The Azure Active Directory tenant ID that
     should be used for authenticating requests to the key vault.
    :type tenant_id: str
    :param sku: Required. SKU details
    :type sku: ~azure.mgmt.keyvault.v2018_02_14.models.Sku
    :param access_policies: An array of 0 to 16 identities that have access to
     the key vault. All identities in the array must use the same tenant ID as
     the key vault's tenant ID. When `createMode` is set to `recover`, access
     policies are not required. Otherwise, access policies are required.
    :type access_policies:
     list[~azure.mgmt.keyvault.v2018_02_14.models.AccessPolicyEntry]
    :param vault_uri: The URI of the vault for performing operations on keys
     and secrets.
    :type vault_uri: str
    :param enabled_for_deployment: Property to specify whether Azure Virtual
     Machines are permitted to retrieve certificates stored as secrets from the
     key vault.
    :type enabled_for_deployment: bool
    :param enabled_for_disk_encryption: Property to specify whether Azure Disk
     Encryption is permitted to retrieve secrets from the vault and unwrap
     keys.
    :type enabled_for_disk_encryption: bool
    :param enabled_for_template_deployment: Property to specify whether Azure
     Resource Manager is permitted to retrieve secrets from the key vault.
    :type enabled_for_template_deployment: bool
    :param enable_soft_delete: Property to specify whether the 'soft delete'
     functionality is enabled for this key vault. It does not accept false
     value.
    :type enable_soft_delete: bool
    :param create_mode: The vault's create mode to indicate whether the vault
     need to be recovered or not. Possible values include: 'recover', 'default'
    :type create_mode: str or
     ~azure.mgmt.keyvault.v2018_02_14.models.CreateMode
    :param enable_purge_protection: Property specifying whether protection
     against purge is enabled for this vault. Setting this property to true
     activates protection against purge for this vault and its content - only
     the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this
     functionality is irreversible - that is, the property does not accept
     false as its value.
    :type enable_purge_protection: bool
    :param network_acls: Rules governing the accessibility of the key vault
     from specific network locations.
    :type network_acls: ~azure.mgmt.keyvault.v2018_02_14.models.NetworkRuleSet
    :ivar private_endpoint_connections: List of private endpoint connections
     associated with the key vault.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2018_02_14.models.PrivateEndpointConnectionItem]
    """

    _validation = {
        'tenant_id': {'required': True},
        'sku': {'required': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'enabled_for_deployment': {'key': 'enabledForDeployment', 'type': 'bool'},
        'enabled_for_disk_encryption': {'key': 'enabledForDiskEncryption', 'type': 'bool'},
        'enabled_for_template_deployment': {'key': 'enabledForTemplateDeployment', 'type': 'bool'},
        'enable_soft_delete': {'key': 'enableSoftDelete', 'type': 'bool'},
        'create_mode': {'key': 'createMode', 'type': 'CreateMode'},
        'enable_purge_protection': {'key': 'enablePurgeProtection', 'type': 'bool'},
        'network_acls': {'key': 'networkAcls', 'type': 'NetworkRuleSet'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnectionItem]'},
    }

    def __init__(self, *, tenant_id: str, sku, access_policies=None, vault_uri: str=None, enabled_for_deployment: bool=None, enabled_for_disk_encryption: bool=None, enabled_for_template_deployment: bool=None, enable_soft_delete: bool=None, create_mode=None, enable_purge_protection: bool=None, network_acls=None, **kwargs) -> None:
        super(VaultProperties, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.vault_uri = vault_uri
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls
        self.private_endpoint_connections = None


class VirtualNetworkRule(Model):
    """A rule governing the accessibility of a vault from a specific virtual
    network.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.id = id
