// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_GPU_VP9_REFERENCE_FRAME_VECTOR_H_
#define MEDIA_GPU_VP9_REFERENCE_FRAME_VECTOR_H_

#include <array>

#include "base/memory/scoped_refptr.h"
#include "base/sequence_checker.h"
#include "media/filters/vp9_parser.h"

namespace media {

class VP9Picture;

// class to share reference frame management code
// between encoder and decoder classes.
// TODO(crbug.com/924804): Add the support in Decoder class.
class Vp9ReferenceFrameVector {
 public:
  Vp9ReferenceFrameVector();
  ~Vp9ReferenceFrameVector();

  void Refresh(scoped_refptr<VP9Picture> pic);
  void Clear();

  scoped_refptr<VP9Picture> GetFrame(size_t index) const;

 private:
  std::array<scoped_refptr<VP9Picture>, kVp9NumRefFrames> reference_frames_;

  SEQUENCE_CHECKER(sequence_checker_);
  DISALLOW_COPY_AND_ASSIGN(Vp9ReferenceFrameVector);
};

}  // namespace media

#endif  // MEDIA_GPU_VP9_REFERENCE_FRAME_VECTOR_H_
