// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_TREES_COMPOSITOR_MODE_H_
#define CC_TREES_COMPOSITOR_MODE_H_

namespace cc {

// The LayerTreeHost uses the CompositorMode to determine the current mode of
// operation, which is needed to:
// 1) Safely cast Proxy to SingleThreadProxy to allow operations only supported
// in SingleThreaded mode.
// 2) Make decisions restricted to either browser(SingleThreaded) or renderer
// compositors(Threaded).
enum CompositorMode {
  SingleThreaded,
  Threaded,
};

}  // namespace cc

#endif  // CC_TREES_COMPOSITOR_MODE_H_
