% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveGRanges.R
\name{saveObject,GRanges-method}
\alias{saveObject,GRanges-method}
\alias{stageObject,GRanges-method}
\title{Save a GRanges object to disk}
\usage{
\S4method{saveObject}{GRanges}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{GRanges} object or one of its subclasses.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
\code{x} is saved to \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{GRanges} object to its on-disk representation .
}
\examples{
gr <- GRanges(c("chrA", "chrB"), IRanges(c(1, 5), c(100, 200)))
seqlengths(gr) <- c(chrA=1000, chrB=2000)

tmp <- tempfile()
saveObject(gr, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\code{\link{readGRanges}}, to read a \linkS4class{GRanges} from disk.
}
\author{
Aaron Lun
}
