% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-get-methods.R
\docType{methods}
\name{geneIDs}
\alias{geneIDs}
\alias{geneIDs}
\alias{geneIDs,ballgown-method}
\title{get gene IDs from a ballgown object}
\usage{
geneIDs(x)

\S4method{geneIDs}{ballgown}(x)
}
\arguments{
\item{x}{a ballgown object}
}
\value{
named vector of gene IDs included in the ballgown object. If object 
was created using Tablemaker, these gene IDs will be of the form "XLOC_*".
Vector is named and ordered by corresponding numeric transcript ID.
}
\description{
get gene IDs from a ballgown object
}
\details{
This vector differs from that produced by geneNames in that geneIDs produces
names of loci created during the assembly process, not necessarily
annotated genes.
}
\examples{
data(bg)
geneIDs(bg)
}
\seealso{
\code{\link{geneNames}}
}
