% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tGene.R
\name{tGene}
\alias{tGene}
\title{Connect a transcript to its gene}
\usage{
tGene(bg, transcript, tid = TRUE, gid = TRUE, warnme = TRUE)
}
\arguments{
\item{bg}{ballgown object}

\item{transcript}{transcript identifier}

\item{tid}{set to \code{TRUE} if \code{transcript} is a numeric transcript
identifier (i.e., \code{t_id} in expression tables), or \code{FALSE} if 
\code{transcript} is a named identifie (e.g., \code{TCONS_000001} or 
similar.}

\item{gid}{if \code{FALSE}, return the gene *name* associated with 
\code{transcript} in \code{bg} instead of the gene *id*, which is returned
by default. Take care to remember that not all ballgown objects include 
gene *name* information. (They do all include gene IDs).}

\item{warnme}{if \code{TRUE}, and if \code{gid} is \code{FALSE}, print a 
warning if no gene name is available for the transcript. This could either
mean the transcript didn't overlap an annotated gene, or that no gene names
were included when \code{bg} was created.}
}
\description{
find the gene to which a transcript belongs
}
\examples{
  data(bg)
  tGene(bg, 10)
  tGene(bg, 'TCONS_00000010', tid=FALSE)
  tGene(bg, 10, gid=FALSE) #empty: no gene names included in bg.

}
