% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colIQRDiffs.R, R/colMadDiffs.R, R/colSdDiffs.R,
%   R/colVarDiffs.R, R/rowIQRDiffs.R, R/rowMadDiffs.R, R/rowSdDiffs.R,
%   R/rowVarDiffs.R
\name{colIQRDiffs,DelayedMatrix-method}
\alias{colIQRDiffs,DelayedMatrix-method}
\alias{colMadDiffs,DelayedMatrix-method}
\alias{colSdDiffs,DelayedMatrix-method}
\alias{colVarDiffs,DelayedMatrix-method}
\alias{rowIQRDiffs,DelayedMatrix-method}
\alias{rowMadDiffs,DelayedMatrix-method}
\alias{rowSdDiffs,DelayedMatrix-method}
\alias{rowVarDiffs,DelayedMatrix-method}
\title{Calculates the interquartile range of the difference between each element of
a row (column) of a matrix-like object}
\usage{
\S4method{colIQRDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{colMadDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{colSdDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{colVarDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowIQRDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowMadDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowSdDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)

\S4method{rowVarDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  diff = 1L,
  trim = 0,
  force_block_processing = FALSE,
  ...,
  useNames = NA
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{diff}{An integer specifying the order of difference.}

\item{trim}{A double in [0,1/2] specifying the fraction of observations to
be trimmed from each end of (sorted) x before estimation.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the interquartile range of the difference between each element of
a row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowIQRDiffs}} /
\code{matrixStats::\link[matrixStats]{colIQRDiffs}}.
}
\examples{
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))
# A DelayedMatrix with a 'SolidRleArraySeed' seed
dm_Rle <- RleArray(Rle(c(rep(1L, 5),
                         as.integer((0:4) ^ 2),
                         seq(-5L, -1L, 1L))),
                   dim = c(5, 3))

colIQRDiffs(dm_Matrix)

colMadDiffs(dm_Matrix)

colSdDiffs(dm_Matrix)

colVarDiffs(dm_Matrix)

# Only using rows 2-4
rowIQRDiffs(dm_Rle, rows = 2:4)

# Only using rows 2-4
rowMadDiffs(dm_Rle, rows = 2:4)

# Only using rows 2-4
rowSdDiffs(dm_Rle, rows = 2:4)

# Only using rows 2-4
rowVarDiffs(dm_Rle, rows = 2:4)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:varDiff]{rowIQRDiffs}()} and
\code{matrixStats::\link[matrixStats:varDiff]{colIQRDiffs}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item For the direct interquartile range see also \link[MatrixGenerics]{rowIQRs}.
}
}
\author{
Peter Hickey
}
