% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCounts}
\alias{plotCounts}
\title{Plot of normalized counts for a single gene}
\usage{
plotCounts(dds, gene, intgroup = "condition", normalized = TRUE,
  transform = TRUE, main, xlab = "group", returnData = FALSE,
  replaced = FALSE, pc, ...)
}
\arguments{
\item{dds}{a \code{DESeqDataSet}}

\item{gene}{a character, specifying the name of the gene to plot}

\item{intgroup}{interesting groups: a character vector of names in \code{colData(x)} to use for grouping.
Must be factor variables. If you want to plot counts over numeric, choose \code{returnData=TRUE}}

\item{normalized}{whether the counts should be normalized by size factor
(default is TRUE)}

\item{transform}{whether to have log scale y-axis or not.
defaults to TRUE}

\item{main}{as in 'plot'}

\item{xlab}{as in 'plot'}

\item{returnData}{should the function only return the data.frame of counts and
covariates for custom plotting (default is FALSE)}

\item{replaced}{use the outlier-replaced counts if they exist}

\item{pc}{pseudocount for log transform}

\item{...}{arguments passed to plot}
}
\description{
Normalized counts plus a pseudocount of 0.5 are shown by default.
}
\examples{

dds <- makeExampleDESeqDataSet()
plotCounts(dds, "gene1")

}
