% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-Filter.R
\docType{methods}
\name{convertFilter,AnnotationFilter,EnsDb-method}
\alias{convertFilter,AnnotationFilter,EnsDb-method}
\alias{convertFilter,AnnotationFilterList,EnsDb-method}
\alias{convertFilter,AnnotationFilterList,EnsDb-method}
\title{Convert an AnnotationFilter to a SQL WHERE condition for EnsDb}
\usage{
\S4method{convertFilter}{AnnotationFilter,EnsDb}(object, db,
  with.tables = character())

\S4method{convertFilter}{AnnotationFilterList,EnsDb}(object, db,
  with.tables = character())
}
\arguments{
\item{object}{\code{AnnotationFilter} or \code{AnnotationFilterList} objects (or
objects extending these classes).}

\item{db}{\code{EnsDb} object.}

\item{with.tables}{optional \code{character} vector specifying the names of the
database tables that are being queried.}
}
\value{
A \code{character(1)} with the SQL where condition.
}
\description{
\code{convertFilter} converts an \code{AnnotationFilter::AnnotationFilter}
or \code{AnnotationFilter::AnnotationFilterList} to an SQL where condition
for an \code{EnsDb} database.
}
\note{
This function \emph{might} be used in direct SQL queries on the SQLite
database underlying an \code{EnsDb} but is more thought to illustrate the
use of \code{AnnotationFilter} objects in combination with SQL databases.
This method is used internally to create the SQL calls to the database.
}
\examples{

library(EnsDb.Hsapiens.v86)
edb <- EnsDb.Hsapiens.v86

## Define a filter
flt <- AnnotationFilter(~ genename == "BCL2")

## Use the method from the AnnotationFilter package:
convertFilter(flt)

## Create a combination of filters
flt_list <- AnnotationFilter(~ genename \%in\% c("BCL2", "BCL2L11") &
    tx_biotype == "protein_coding")
flt_list

convertFilter(flt_list)

## Use the filters in the context of an EnsDb database:
convertFilter(flt, edb)

convertFilter(flt_list, edb)
}
\author{
Johannes Rainer
}
