% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomeAxisTrack-class.R
\docType{class}
\name{GenomeAxisTrack-class}
\alias{GenomeAxisTrack-class}
\alias{initialize,GenomeAxisTrack-method}
\alias{GenomeAxisTrack}
\alias{ranges,GenomeAxisTrack-method}
\alias{range,GenomeAxisTrack-method}
\alias{start,GenomeAxisTrack-method}
\alias{start<-,GenomeAxisTrack-method}
\alias{end,GenomeAxisTrack-method}
\alias{end<-,GenomeAxisTrack-method}
\alias{width,GenomeAxisTrack-method}
\alias{length,GenomeAxisTrack-method}
\alias{values,GenomeAxisTrack-method}
\alias{strand,GenomeAxisTrack-method}
\alias{collapseTrack,GenomeAxisTrack-method}
\alias{[,GenomeAxisTrack,ANY,ANY,ANY-method}
\alias{subset,GenomeAxisTrack-method}
\alias{drawGD,GenomeAxisTrack-method}
\alias{show,GenomeAxisTrack-method}
\title{GenomeAxisTrack class and methods}
\usage{
\S4method{initialize}{GenomeAxisTrack}(.Object, range, ids, ...)

GenomeAxisTrack(range = NULL, name = "Axis", id, ...)

\S4method{ranges}{GenomeAxisTrack}(x)

\S4method{range}{GenomeAxisTrack}(x)

\S4method{start}{GenomeAxisTrack}(x)

\S4method{start}{GenomeAxisTrack}(x) <- value

\S4method{end}{GenomeAxisTrack}(x)

\S4method{end}{GenomeAxisTrack}(x) <- value

\S4method{width}{GenomeAxisTrack}(x)

\S4method{length}{GenomeAxisTrack}(x)

\S4method{values}{GenomeAxisTrack}(x)

\S4method{strand}{GenomeAxisTrack}(x)

\S4method{collapseTrack}{GenomeAxisTrack}(
  GdObject,
  min.width = 1,
  min.distance = 0,
  collapse = TRUE,
  diff = .pxResolution(coord = "x"),
  xrange
)

\S4method{[}{GenomeAxisTrack,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{subset}{GenomeAxisTrack}(x, from = NULL, to = NULL, sort = FALSE, ...)

\S4method{drawGD}{GenomeAxisTrack}(GdObject, minBase, maxBase, prepare = FALSE, subset = TRUE, ...)

\S4method{show}{GenomeAxisTrack}(object)
}
\arguments{
\item{range}{Optional object of class \code{GRanges} or \code{IRanges} containing
regions to be highlighted on the axis by coloured boxes.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters. See \code{settings} and the "Display Parameters"
section below for details.}

\item{name}{Character scalar of the track's name used in the title panel
when plotting.}

\item{id}{A character vector of the same length as \code{range} containing
identifiers for the ranges. If missing, the constructor will try to extract
the ids from \code{names(range)}.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}
}
\value{
The return value of the constructor function is a new object of class
\code{GenomeAxisTrack}.

Objects can be created using the constructor function \code{GenomeAxisTrack}.
}
\description{
A class representing a customizable genomic axis.
}
\details{
A \code{GenomeAxisTrack} can be customized using the familiar display
parameters. By providing a \code{GRanges} or \code{IRanges} object to the
constructor, ranges on the axis can be further highlighted.

With the \code{scale} display parameter, a small scale indicator can be
shown instead of the entire genomic axis. The scale can either be provided
as a fraction of the plotting region (it will be rounded to the nearest
human readable absolute value) or as an absolute value and is always
displayed in bp, kb, mb or gb units. Note that most display parameters for
the \code{GenomeAxisTrack} are ignored when a scale is used instead of the
full axis. In particular, only the parameters \code{exponent}, \code{alpha},
\code{lwd}, \code{col}, \code{cex}, \code{distFromAxis} and \code{labelPos}
are used.
}
\section{Functions}{
\itemize{
\item \code{initialize,GenomeAxisTrack-method}: Intialize.

\item \code{GenomeAxisTrack}: Constructor

\item \code{ranges,GenomeAxisTrack-method}: return the genomic coordinates for the
track along with all additional annotation information as an object of
class \code{GRanges}.

\item \code{range,GenomeAxisTrack-method}: return the genomic coordinates for the
track as an object of class \code{IRanges}.
@export

\item \code{start,GenomeAxisTrack-method}: return the start coordinates of the track
items.

\item \code{start<-,GenomeAxisTrack-method}: replace the start coordinates of the track
items.

\item \code{end,GenomeAxisTrack-method}: return the end coordinates of the track
items.

\item \code{end<-,GenomeAxisTrack-method}: replace the end coordinates of the track
items.

\item \code{width,GenomeAxisTrack-method}: return the with of the track items in
genomic coordinates.

\item \code{length,GenomeAxisTrack-method}: return the number of items stored in the ranges slot.

\item \code{values,GenomeAxisTrack-method}: return all additional annotation information
except for the genomic coordinates for the track items.

\item \code{strand,GenomeAxisTrack-method}: return a vector of strand specifiers for
all track items, in the form '+' for the Watson strand, '-' for the Crick
strand or '*' for either of the two.

\item \code{collapseTrack,GenomeAxisTrack-method}: preprocess the track before plotting.
This will collapse overlapping track items based on the available resolution
and increase the width and height of all track objects to a minimum value
to avoid rendering issues. See collapsing for details.

\item \code{[,GenomeAxisTrack,ANY,ANY,ANY-method}: subset the items in the \code{GenomeAxisTrack} object.
This is essentially similar to subsetting of the \code{GRanges} object in the
\code{range} slot. For most applications, the subset method may be more appropriate.

\item \code{subset,GenomeAxisTrack-method}: plot subset all the contained tracks in an
\code{GenomeAxisTrack} by coordinates and sort if necessary.

\item \code{drawGD,GenomeAxisTrack-method}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show,GenomeAxisTrack-method}: Show method.
}}

\examples{
## Construct object
axTrack <- GenomeAxisTrack(
    name = "Axis",
    range <- IRanges(start = c(100, 300, 800), end = c(150, 400, 1000))
)
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(axTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}


## Plotting
plotTracks(axTrack, from = 0, to = 1100)

## Track names
names(axTrack)
names(axTrack) <- "foo"

## Subsetting and splitting
subTrack <- subset(axTrack, from = 0, to = 500)
length(subTrack)
subTrack[1]
split(axTrack, c(1, 1, 2))

## Accessors
start(axTrack)
end(axTrack)
width(axTrack)

strand(axTrack)

range(axTrack)
ranges(axTrack)

## Annotation
values(axTrack)

## Grouping
group(axTrack)

## HTML image map
coords(axTrack)
tags(axTrack)
axTrack <- plotTracks(axTrack)$foo
coords(axTrack)
tags(axTrack)

## adding an axis to another track
data(cyp2b10)
grTrack <- GeneRegionTrack(
    start = 26682683, end = 26711643,
    rstart = cyp2b10$start, rends = cyp2b10$end, chromosome = 7, genome = "mm9",
    transcript = cyp2b10$transcript, gene = cyp2b10$gene, symbol = cyp2b10$symbol,
    name = "Cyp2b10", strand = cyp2b10$strand
)

plotTracks(list(grTrack, GenomeAxisTrack()))
plotTracks(list(grTrack, GenomeAxisTrack(scale = 0.1)))
plotTracks(list(grTrack, GenomeAxisTrack(scale = 5000)))
plotTracks(list(grTrack, GenomeAxisTrack(scale = 0.5, labelPos = "below")))
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
\keyword{internal}
