% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{import_pyrotagger_tab}
\alias{import_pyrotagger_tab}
\title{Imports a tab-delimited version of the pyrotagger output file.}
\usage{
import_pyrotagger_tab(pyrotagger_tab_file, 
strict_taxonomy=FALSE, keep_potential_chimeras=FALSE)
}
\arguments{
\item{pyrotagger_tab_file}{(Required). A character string. The name of the tab-delimited
pyrotagger output table.}

\item{strict_taxonomy}{(Optional). Logical. Default \code{FALSE}. Should the taxonomyTable
component be limited to just taxonomic data? Default includes all fields from 
the pyrotagger file.}

\item{keep_potential_chimeras}{(Optional). Logical. Default \code{FALSE}. The 
pyrotagger output also includes OTUs that are tagged by pyrotagger as likely
chimeras. These putative chimeric OTUs can be retained if set to \code{TRUE}.
The putative chimeras are excluded by default.}
}
\value{
An \code{otuTax} object containing both the otu_table and TaxonomyTable data
 components, parsed from the pyrotagger output.
}
\description{
PyroTagger is a web-server that takes raw, barcoded 16S rRNA amplicon sequences
and returns an excel spreadsheet (\code{".xls"}) with both abundance and 
taxonomy data. It also includes some confidence information related to the 
taxonomic assignment.
}
\details{
PyroTagger is created and maintained by the Joint Genome Institute 
at \code{"http://pyrotagger.jgi-psf.org/"}

The typical output form PyroTagger is a spreadsheet format \code{".xls"}, which poses 
additional import challenges. However, virtually all spreadsheet applications 
support the \code{".xls"} format, and can further export this file in a 
tab-delimited format. It is recommended that you convert the xls-file without
any modification (as tempting as it might be once you have loaded it) into a
tab-delimited text file. Deselect any options to encapsulate fields in quotes,
as extra quotes around each cell's contents might cause problems during 
file processing. These quotes will also inflate the file-size, so leave them out
as much as possible, while also resisting any temptation to modify the xls-file
``by hand''.

A highly-functional and free spreadsheet application can be obtained as part
of the cross-platform \code{OpenOffice} suite. It works for the above 
required conversion. Go to \code{"http://www.openoffice.org/"}.

It is regrettable that this importer does not take the xls-file directly
as input. However, because of the moving-target nature of spreadsheet
file formats, there is limited support for direct import of these formats into
\code{R}. Rather than add to the dependency requirements of emph{phyloseq}
and the relative support of these xls-support packages, it seems more efficient
to choose an arbitrary delimited text format, and focus on the data 
structure in the PyroTagger output. This will be easier to support in the
long-run.
}
\examples{
## New_otuTaxObject <- import_pyrotagger_tab(pyrotagger_tab_file)
}
\references{
\url{http://pyrotagger.jgi-psf.org/}
}
