% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScoreHeatmap.R
\name{plotScoreHeatmap}
\alias{plotScoreHeatmap}
\title{Plot a score heatmap}
\usage{
plotScoreHeatmap(
  results,
  cells.use = NULL,
  labels.use = NULL,
  clusters = NULL,
  show.labels = TRUE,
  show.pruned = FALSE,
  max.labels = 40,
  normalize = TRUE,
  cells.order = NULL,
  order.by = c("labels", "clusters"),
  rows.order = NULL,
  scores.use = NULL,
  calls.use = 0,
  na.color = "gray30",
  cluster_cols = FALSE,
  annotation_col = NULL,
  show_colnames = FALSE,
  color = (grDevices::colorRampPalette(c("#D1147E", "white", "#00A44B")))(100),
  silent = FALSE,
  ...,
  grid.vars = list()
)
}
\arguments{
\item{results}{A \linkS4class{DataFrame} containing the output from \code{\link{SingleR}},
\code{\link{classifySingleR}}, \code{\link{combineCommonResults}}, or \code{\link{combineRecomputedResults}}.}

\item{cells.use}{Integer or string vector specifying the single cells (i.e., rows of \code{results}) to show.
If \code{NULL}, all cells are shown.}

\item{labels.use}{Character vector specifying the labels to show in the heatmap rows.
Defaults to all labels in \code{results}.}

\item{clusters}{String vector or factor containing cell cluster assignments, to be shown as an annotation bar in the heatmap.}

\item{show.labels}{Logical indicating whether the assigned labels should be shown as an annotation bar.}

\item{show.pruned}{Logical indicating whether the pruning status of the cell labels,
as defined by \code{\link{pruneScores}}, should be shown as an annotation bar.}

\item{max.labels}{Integer scalar specifying the maximum number of labels to show.}

\item{normalize}{Logical specifying whether correlations should be normalized to lie in [0, 1].}

\item{cells.order}{Integer or String vector specifying how to order the cells/columns of the heatmap.
Regardless of \code{cells.use}, this input should be the the same length as the total number of cells.
Ignored if \code{cluster_cols} is set.}

\item{order.by}{String providing the annotation to be used for cells/columns ordering.
Can be "labels" (default) or "clusters" (when provided).
Ignored if \code{cells.order} or \code{cluster_cols} are specified.}

\item{rows.order}{String vector specifying how to order rows of the heatmap.
Contents should be the reference-labels in the order you would like them to appear, from top-to-bottom.
For combined results, include labels for all plots in a single vector and labels relevant to each plot will be extracted.}

\item{scores.use}{Integer scalar or vector specifying the individual annotation result from which to take scores.
This is only relevant for combined results, see Details.}

\item{calls.use}{Integer scalar or vector specifying the individual annotation result from which to take labels,
for use in the annotation bar when \code{show.labels=TRUE}.
This is only relevant for combined results, see Details.}

\item{na.color}{String specifying the color for non-calculated scores of combined \code{results}.}

\item{annotation_col, cluster_cols, show_colnames, color, silent, ...}{Additional parameters for heatmap control passed to \code{\link[pheatmap]{pheatmap}}.}

\item{grid.vars}{A named list of extra variables to pass to \code{\link[gridExtra]{grid.arrange}},
used to arrange the multiple plots generated when \code{scores.use} is of length greater than 1.}
}
\value{
If \code{scores.use} specifies a single set of scores,
the output of \code{\link[pheatmap]{pheatmap}} is returned showing the heatmap on the current graphics device.

If \code{scores.use} specifies multiple scores for a combined result,
multiple heatmaps are generated in a grid on the current graphics device.

If \code{scores.use} specifies multiple scores and \code{grid.vars} is set to \code{NULL},
a list is returned containing the \code{\link[pheatmap]{pheatmap}} globs for manual display.
}
\description{
Create a heatmap of the \code{\link{SingleR}} assignment scores across all cell-label combinations.
}
\details{
This function creates a heatmap containing the \code{\link{SingleR}} initial assignment scores
for each cell (columns) to each reference label (rows).
Users can then easily identify the high-scoring labels associated with each cell and/or cluster of cells.

If \code{show.labels=TRUE}, an annotation bar will be added to the heatmap showing the label assigned to each cell.
This is also used to order the columns for a more organized visualization when \code{order.by="label"}.
Note that scores shown in the heatmap are initial scores prior to the fine-tuning step,
so the reported labels may not match up to the visual maximum for each cell in the heatmap.

If \code{max.labels} is less than the total number of unique labels, only the top labels are shown in the plot.
Labels that were called most frequently are prioritized.
The remaining labels are then selected based on:
\itemize{
\item Labels with max z-scores after per-cell centering and scaling of the scores matrix,
if \code{results} does not contain combined scores.
\item Labels which were suggested most frequently by individual references,
if \code{results} contains combined scores.
}
}
\section{Working with combined results}{

For combined results (see \code{?\link{combineRecomputedResults}}),
this function can show both the combined and individual scores or labels.
This is done using the \code{scores.use} and \code{calls.use} arguments,
entries of which refer to columns of \code{results$orig.results} if positive or to the combined results if zero.
For example:
\itemize{
\item If we set \code{scores.use=2} and \code{calls.use=1},
we will plot the scores from the second individual reference
with the annotation bar containing label assignments from the first reference.
\item If we set \code{scores.use=1:2} and \code{calls.use=1:2},
we will plot the scores from first and second references (in separate plots)
with the annotation bar in each plot containing the corresponding label assignments.
\item By default, the function will create a separate plot the combined scores and each individual reference.
In each plot, the annotation bar contains the combined labels;
this is equivalent to \code{scores.use=0:N} and \code{calls.use=0} for \code{N} individual references.
}
}

\section{Tweaking the output}{

Additional arguments can be passed to \code{\link[pheatmap]{pheatmap}} for further tweaking of the heatmap.
Particularly useful parameters are \code{show_colnames}, which can be used to display cell/cluster names;
\code{treeheight_row}, which sets the width of the clustering tree;
and \code{annotation_col}, which can be used to add extra annotation layers.
Clustering, pruning and label annotations are automatically generated and appended to \code{annotation_col} when available.
}

\section{Normalization of colors}{

If \code{normalize=TRUE}, scores will be linearly adjusted for each cell
so that the smallest score is 0 and the largest score is 1.
This is followed by cubing of the adjusted scores to improve dynamic range near 1.
Visually, the color scheme is changed to a blue-green-yellow scale.

The adjustment is intended to inflate differences between scores within a given cell for easier visualization.
This is because the scores are often systematically shifted between cells,
making the raw values difficult to directly compare.
However, it may be somewhat misleading;
fine-tuning may appear to assign a cell to a label with much lower score whereas the actual scores are much closer.
It is for this reason that the color bar values are not shown as the absolute values of the score have little meaning.

Note that this transformation is not dependent on the choice of the top \code{max.labels} labels.
Altering \code{max.labels} will not change the normalized values, only the labels that are shown.
However, the transformation will respond to \code{labels.use}.
}

\examples{
# Running the SingleR() example.
example(SingleR, echo=FALSE)

# Grab the original identities of the cells as mock clusters
clusts <- test$label

# Creating a heatmap with just the labels.
plotScoreHeatmap(pred)

# Creating a heatmap with clusters also displayed.
plotScoreHeatmap(pred,
    clusters=clusts)

# Creating a heatmap with whether cells were pruned displayed.
plotScoreHeatmap(pred,
    show.pruned = TRUE)

# We can also turn off the normalization with Normalize = FALSE
plotScoreHeatmap(pred, clusters=clusts,
    normalize = FALSE)

# To only show certain labels, you can use labels.use or max.labels
plotScoreHeatmap(pred, clusters=clusts,
    labels.use = c("A","B","D"))
plotScoreHeatmap(pred, clusters=clusts,
    max.labels = 4)

# We can pass extra tweaks the heatmap as well
plotScoreHeatmap(pred, clusters=clusts,
    fontsize_row = 20)
plotScoreHeatmap(pred, clusters=clusts,
    treeheight_row = 15)
plotScoreHeatmap(pred, clusters=clusts, cluster_col = TRUE,
    cutree_cols = 5)

### Multi-Reference Compatibility ###

example(combineRecomputedResults, echo = FALSE)
plotScoreHeatmap(combined)

# 'scores.use' sets which particular run's scores to show, and can be multiple
plotScoreHeatmap(combined,
    scores.use = 1)
plotScoreHeatmap(combined,
    scores.use = c(0,2))

# 'calls.use' adjusts which run's labels and pruning calls to display.
plotScoreHeatmap(combined,
    calls.use = 1)

# To have plots output in a grid rather than as separate pages, provide,
# a list of inputs for gridExtra::grid.arrange() to 'grids.vars'.
plotScoreHeatmap(combined,
    grid.vars = list(ncol = 1))

# An empty list will use grid.arrange defaluts
plotScoreHeatmap(combined,
    grid.vars = list())

}
\seealso{
\code{\link{SingleR}}, to generate \code{scores}.

\code{\link{pruneScores}}, to remove low-quality labels based on the scores.

\code{\link[pheatmap]{pheatmap}}, for additional tweaks to the heatmap.

\code{\link[gridExtra]{grid.arrange}}, for tweaks to the how heatmaps are arranged when multiple are output together.
}
\author{
Daniel Bunis, based on code by Dvir Aran.
}
