% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet-cv-glmnet-tidiers.R
\name{glance.cv.glmnet}
\alias{glance.cv.glmnet}
\title{Glance at a(n) cv.glmnet object}
\usage{
\method{glance}{cv.glmnet}(x, ...)
}
\arguments{
\item{x}{A \code{cv.glmnet} object returned from \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one-row with columns:
\item{lambda.min}{The value of the penalization parameter lambda that
achieved minimum loss as estimated by cross validation.}
\item{lambda.1se}{The value of the penalization parameter lambda that
results in the sparsest model while remaining within one standard
error of the minimum loss.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}

Other glmnet tidiers: \code{\link{glance.glmnet}},
  \code{\link{tidy.cv.glmnet}}, \code{\link{tidy.glmnet}}
}
\concept{glmnet tidiers}
