% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet-glmnet-tidiers.R
\name{tidy.glmnet}
\alias{tidy.glmnet}
\alias{glmnet_tidiers}
\title{Tidy a(n) glmnet object}
\usage{
\method{tidy}{glmnet}(x, return_zeros = FALSE, ...)
}
\arguments{
\item{x}{A \code{glmnet} object returned from \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.}

\item{return_zeros}{Logical indicating whether coefficients with value zero
zero should be included in the results. Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns:
\item{term}{coefficient name (V1...VN by default, along with
"(Intercept)")}
\item{step}{which step of lambda choices was used}
\item{estimate}{estimate of coefficient}
\item{lambda}{value of penalty parameter lambda}
\item{dev.ratio}{fraction of null deviance explained at each
value of lambda}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Note that while this representation of GLMs is much easier
to plot and combine than the default structure, it is also much
more memory-intensive. Do not use for large, sparse matrices.

No \code{augment} method is yet provided even though the model produces
predictions, because the input data is not tidy (it is a matrix that
may be very wide) and therefore combining predictions with it is not
logical. Furthermore, predictions make sense only with a specific
choice of lambda.
}
\examples{

if (requireNamespace("glmnet", quietly = TRUE)) {

    library(glmnet)
    
    set.seed(2014)
    x <- matrix(rnorm(100*20),100,20)
    y <- rnorm(100)
    fit1 <- glmnet(x,y)

    tidy(fit1)
    glance(fit1)

    library(dplyr)
    library(ggplot2)

    tidied <- tidy(fit1) \%>\% filter(term != "(Intercept)")

    ggplot(tidied, aes(step, estimate, group = term)) + geom_line()
    ggplot(tidied, aes(lambda, estimate, group = term)) +
        geom_line() + scale_x_log10()

    ggplot(tidied, aes(lambda, dev.ratio)) + geom_line()

    # works for other types of regressions as well, such as logistic
    g2 <- sample(1:2, 100, replace=TRUE)
    fit2 <- glmnet(x, g2, family="binomial")
    tidy(fit2)
}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[glmnet:glmnet]{glmnet::glmnet()}}

Other glmnet tidiers: \code{\link{glance.cv.glmnet}},
  \code{\link{glance.glmnet}}, \code{\link{tidy.cv.glmnet}}
}
\concept{glmnet tidiers}
