% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\docType{data}
\name{HttpResponse}
\alias{HttpResponse}
\title{Base response object}
\arguments{
\item{url}{(character) A url, required}

\item{opts}{(list) curl options}

\item{handle}{A handle}

\item{method}{(character) HTTP method}

\item{status_code}{(integer) status code}

\item{request_headers}{(list) request headers, named list}

\item{response_headers}{(list) response headers, named list}

\item{response_headers_all}{(list) all response headers, including
intermediate redirect headers, unnamed list of named lists}

\item{modified}{(character) modified date}

\item{times}{(vector) named vector}

\item{content}{(raw) raw binary content response}

\item{request}{request object, with all details}
}
\description{
Base response object
}
\details{
\strong{Methods}
\describe{
\item{\code{parse()}}{
Parse the raw response content to text
}
\item{\code{success()}}{
Was status code less than or equal to 201.
returns boolean
}
\item{\code{status_http()}}{
Get HTTP status code, message, and explanation
}
\item{\code{raise_for_status()}}{
Check HTTP status and stop with appropriate
HTTP error code and message if >= 300.
- If you have \code{fauxpas} installed we use that,
otherwise use \pkg{httpcode}
}
}
}
\examples{
\dontrun{
x <- HttpResponse$new(method = "get", url = "https://httpbin.org")
x$url
x$method

x <- HttpClient$new(url = 'https://httpbin.org')
(res <- x$get('get'))
res$request_headers
res$response_headers
res$parse()
res$status_code
res$status_http()
res$status_http()$status_code
res$status_http()$message
res$status_http()$explanation
res$success()

x <- HttpClient$new(url = 'https://httpbin.org/status/404')
(res <- x$get())
# res$raise_for_status()

x <- HttpClient$new(url = 'https://httpbin.org/status/414')
(res <- x$get())
# res$raise_for_status()
}
}
\keyword{datasets}
