% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_mean_median_sd_mad.R
\name{weighted_mean}
\alias{weighted_mean}
\alias{weighted_median}
\alias{weighted_sd}
\alias{weighted_mad}
\title{Weighted Mean, Median, SD, and MAD}
\usage{
weighted_mean(x, weights = NULL, verbose = TRUE, ...)

weighted_median(x, weights = NULL, verbose = TRUE, ...)

weighted_sd(x, weights = NULL, verbose = TRUE, ...)

weighted_mad(x, weights = NULL, constant = 1.4826, verbose = TRUE, ...)
}
\arguments{
\item{x}{an object containing the values whose weighted mean is to be
    computed.}

\item{weights}{A numerical vector of weights the same length as \code{x} giving
the weights to use for elements of \code{x}.}

\item{verbose}{Show warning when \code{weights} are negative?

If \code{weights = NULL}, \code{x} is passed to the non-weighted function.}

\item{...}{arguments to be passed to or from methods.}

\item{constant}{scale factor.}
}
\description{
Weighted Mean, Median, SD, and MAD
}
\examples{
## GPA from Siegel 1994
x <- c(3.7, 3.3, 3.5, 2.8)
wt <- c(5, 5, 4, 1) / 15

weighted_mean(x, wt)
weighted_median(x, wt)

weighted_sd(x, wt)
weighted_mad(x, wt)

}
