% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_extra.R
\name{effectsize_CIs}
\alias{effectsize_CIs}
\title{Confidence (Compatibility) Intervals}
\description{
More information regarding Confidence (Compatibiity) Intervals and how
they are computed in \emph{effectsize}.
}
\section{Confidence (Compatibility) Intervals (CIs)}{

Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{

"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{One-Sided CIs}{

Typically, CIs are constructed as two-tailed intervals, with an equal
proportion of the cumulative probability distribution above and below the
interval. CIs can also be constructed as \emph{one-sided} intervals,
giving only a lower bound or upper bound. This is analogous to computing a
1-tailed \emph{p} value or conducting a 1-tailed hypothesis test.
\cr\cr
Significance tests conducted using CIs (whether a value is inside the interval)
and using \emph{p} values (whether p < alpha for that value) are only guaranteed
to agree when both are constructed using the same number of sides/tails.
\cr\cr
Most effect sizes are not bounded by zero (e.g., \emph{r}, \emph{d}, \emph{g}), and as such
are generally tested using 2-tailed tests and 2-sided CIs.
\cr\cr
Some effect sizes are strictly positive--they do have a minimum value, of 0.
For example, \eqn{R^2}, \eqn{\eta^2}, and other variance-accounted-for effect
sizes, as well as Cramer's \emph{V} and multiple \emph{R}, range from 0 to 1. These
typically involve \emph{F}- or \eqn{\chi^2}-statistics and are generally tested
using \emph{1-tailed} tests which test whether the estimated effect size is
\emph{larger} than the hypothesized null value (e.g., 0). In order for a CI to
yield the same significance decision it must then by a \emph{1-sided} CI,
estimating only a lower bound. This is the default CI computed by
\emph{effectsize} for these effect sizes, where \code{alternative = "greater"} is set.
\cr\cr
This lower bound interval indicates the smallest effect size that is not
significantly different from the observed effect size. That is, it is the
minimum effect size compatible with the observed data, background model
assumptions, and \eqn{\alpha} level. This type of interval does not indicate
a maximum effect size value; anything up to the maximum possible value of the
effect size (e.g., 1) is in the interval.
\cr\cr
One-sided CIs can also be used to test against a maximum effect size value
(e.g., is \eqn{R^2} significantly smaller than a perfect correlation of 1.0?)
can by setting \code{alternative = "less"}. This estimates a CI with only an
\emph{upper} bound; anything from the minimum possible value of the effect size
(e.g., 0) up to this upper bound is in the interval.
\cr\cr
We can also obtain a 2-sided interval by setting \code{alternative = "two.sided"}.
These intervals can be interpreted in the same way as other 2-sided
intervals, such as those for \emph{r}, \emph{d}, or \emph{g}.
\cr\cr
An alternative approach to aligning significance tests using CIs and 1-tailed
\emph{p} values that can often be found in the literature is to construct a
2-sided CI at a lower confidence level (e.g., 100(1-2\eqn{\alpha})\% = 100 -
2*5\% = 90\%. This estimates the lower bound and upper bound for the above
1-sided intervals simultaneously. These intervals are commonly reported when
conducting \strong{equivalence tests}. For example, a 90\% 2-sided interval gives
the bounds for an equivalence test with \eqn{\alpha} = .05. However, be aware
that this interval does not give 95\% coverage for the underlying effect size
parameter value. For that, construct a 95\% 2-sided CI.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data("hardlyworking")
fit <- lm(salary ~ n_comps + age, data = hardlyworking)
eta_squared(fit) # default, ci = 0.95, alternative = "greater"
#> # Effect Size for ANOVA (Type I)
#> 
#> Parameter | Eta2 (partial) |       95\% CI
#> -----------------------------------------
#> n_comps   |           0.21 | [0.16, 1.00]
#> age       |           0.10 | [0.06, 1.00]
#> 
#> - One-sided CIs: upper bound fixed at [1.00].
eta_squared(fit, alternative = "less") # Test is eta is smaller than some value
#> # Effect Size for ANOVA (Type I)
#> 
#> Parameter | Eta2 (partial) |       95\% CI
#> -----------------------------------------
#> n_comps   |           0.21 | [0.00, 0.26]
#> age       |           0.10 | [0.00, 0.14]
#> 
#> - One-sided CIs: lower bound fixed at [0.00].
eta_squared(fit, alternative = "two.sided") # 2-sided bounds for alpha = .05
#> # Effect Size for ANOVA (Type I)
#> 
#> Parameter | Eta2 (partial) |       95\% CI
#> -----------------------------------------
#> n_comps   |           0.21 | [0.15, 0.27]
#> age       |           0.10 | [0.06, 0.15]
eta_squared(fit, ci = 0.9, alternative = "two.sided") # both 1-sided bounds for alpha = .05
#> # Effect Size for ANOVA (Type I)
#> 
#> Parameter | Eta2 (partial) |       90\% CI
#> -----------------------------------------
#> n_comps   |           0.21 | [0.16, 0.26]
#> age       |           0.10 | [0.06, 0.14]
}\if{html}{\out{</div>}}
}

\section{CI Does Not Contain the Estimate}{

For very large sample sizes or effect sizes, the width of the CI can be
smaller than the tolerance of the optimizer, resulting in CIs of width 0.
This can also result in the estimated CIs excluding the point estimate.

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{t_to_d(80, df_error = 4555555)
#> d    |       95\% CI
#> -------------------
#> 0.07 | [0.08, 0.08]
}\if{html}{\out{</div>}}

In these cases, consider an alternative optimizer, or an alternative method
for computing CIs, such as the bootstrap.
}

\references{
Bauer, P., & Kieser, M. (1996).
A unifying approach for confidence intervals and testing of equivalence and difference.
\emph{Biometrika, 83}(4), 934-–937.
\doi{10.1093/biomet/83.4.934}

Rafi, Z., & Greenland, S. (2020).
Semantic and cognitive tools to aid statistical science: Replace confidence and significance by compatibility and surprise.
\emph{BMC Medical Research Methodology, 20}(1), Article 244.
\doi{10.1186/s12874-020-01105-9}

Schweder, T., & Hjort, N. L. (2016).
\emph{Confidence, likelihood, probability: Statistical inference with confidence distributions.}
Cambridge University Press.
\doi{10.1017/CBO9781139046671}

Steiger, J. H. (2004).
Beyond the \emph{F} test: Effect size confidence intervals and tests of close fit in the analysis of variance and contrast analysis.
\emph{Psychological Methods, 9}(2), 164--182.
\doi{10.1037/1082-989x.9.2.164}

Xie, M., & Singh, K. (2013).
Confidence distribution, the frequentist distribution estimator of a parameter: A review.
\emph{International Statistical Review, 81}(1), 3–-39.
\doi{10.1111/insr.12000}
}
