% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{removeMatches}
\alias{removeMatches}
\title{Remove elements if they are in a target vector, possibly replacing with NA}
\usage{
removeMatches(x, y, padNA = FALSE)
}
\arguments{
\item{x}{vector from which elements are to be removed}

\item{y}{shorter vector of elements to be removed}

\item{padNA}{Default FALSE, Should removed items be replaced with NA values?}
}
\value{
a vector with elements in y removed
}
\description{
If a vector has c("A", "b", "c") and we want to remove "b" and
"c", this function can do the work. It can also replace "b" and
"c" with the NA symbol.
}
\details{
If elements in y are not members of x, they are silently ignored.

The code for this is not complicated, but it is
difficult to remember.  Here's the recipe to remove
elements y from x: \code{x <- x[!x \%in\% y[y \%in\% x]]}. It is
easy to get that wrong when in a hurry, so we use this function
instead.  The \code{padNA} was an afterthought, but it helps sometimes.
}
\examples{
x <- c("a", "b", "c", "d", "e", "f")
y <- c("e", "a")
removeMatches(x, y)
y <- c("q", "r", "s")
removeMatches(x, y)
}
\author{
Ben Kite <bakite@ku.edu> and Paul Johnson <pauljohn@ku.edu>
}
