% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-estimate2.R, R/sCorrect-sscResiduals.R
\name{estimate2}
\alias{estimate2}
\alias{estimate2.lvm}
\alias{estimate2.lvmfit}
\alias{estimate2.list}
\alias{estimate2.mmm}
\alias{.sscResiduals}
\title{Satterthwaite Correction and Small Sample Correction}
\usage{
estimate2(
  object,
  param,
  data,
  ssc,
  df,
  derivative,
  hessian,
  dVcov.robust,
  iter.max,
  tol.max,
  trace,
  ...
)

\method{estimate2}{lvm}(
  object,
  param = NULL,
  data = NULL,
  ssc = lava.options()$ssc,
  df = lava.options()$df,
  derivative = "analytic",
  hessian = FALSE,
  dVcov.robust = FALSE,
  iter.max = 100,
  tol.max = 1e-06,
  trace = 0,
  ...
)

\method{estimate2}{lvmfit}(
  object,
  param = NULL,
  data = NULL,
  ssc = lava.options()$ssc,
  df = lava.options()$df,
  derivative = "analytic",
  hessian = FALSE,
  dVcov.robust = FALSE,
  iter.max = 100,
  tol.max = 1e-06,
  trace = 0,
  ...
)

\method{estimate2}{list}(object, ...)

\method{estimate2}{mmm}(object, ...)

.sscResiduals(object, ssc, algorithm = "2")
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{param}{[numeric vector, optional] the values of the parameters at which to perform the correction.}

\item{data}{[data.frame, optional] the dataset relative to which the correction should be performed.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{df}{[character] method used to estimate the degree of freedoms of the Wald statistic: Satterthwaite \code{"satterthwaite"}. 
Otherwise (\code{"none"}/code{FALSE}/code{NA}) the degree of freedoms are set to \code{Inf}.
Only relevant when using a \code{lvmfit} object.}

\item{derivative}{[character] should the first derivative of the information matrix be computed using a formula (\code{"analytic"}) or numerical derivative (\code{"numeric"})?}

\item{hessian}{[logical] should the hessian be stored? Can be \code{NULL} to indicate only if computed during the small sample correction.}

\item{dVcov.robust}{[logical] should the first derivative of robust variance-covariance matrix be stored?}

\item{iter.max}{[integer >0] the maximum number of iterations used to estimate the bias correction.}

\item{tol.max}{[numeric >0] the largest acceptable absolute difference between two succesive estimates of the bias correction.}

\item{trace}{[logical] should the execution of the function be traced.}

\item{...}{arguments passed to \code{lava::estimate} when using a \code{lvm} object.}
}
\description{
Correct the bias of the ML estimate of the variance and compute the first derivative of the information matrix.

Compute bias corrected residuals variance covariance matrix
and information matrix.
Also provides the leverage values and corrected sample size when adjust.n is set to TRUE.
}
\details{
The argument \code{value} is equivalent to the argument \code{bias.correct} of the function \code{summary2}.
}
\examples{
#### simulate data ####
set.seed(10)
dW <- sampleRepeated(10, format = "wide")

#### latent variable model ####
m.lvm <- lvm(Y1~X1+X2+Z1)

e2.lvm <- estimate2(m.lvm, data = dW)
summary2(e2.lvm)

}
\concept{estimator}
\keyword{internal}
\keyword{smallSampleCorrection}
