% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_heatmap}
\alias{hot_heatmap}
\title{Handsontable widget}
\usage{
hot_heatmap(hot, cols, color_scale = c("#ED6D47", "#17F556"), renderer = NULL)
}
\arguments{
\item{hot}{rhandsontable object}

\item{cols}{numeric vector of columns to include in the heatmap. If missing
all columns are used.}

\item{color_scale}{character vector that includes the lower and upper
colors}

\item{renderer}{character defining a Javascript function to be used
to determine the cell colors. If missing,
\code{rhandsontable:::renderer_heatmap} is used.}
}
\description{
Add heatmap to table.
}
\examples{
MAT = matrix(rnorm(50), nrow = 10, dimnames = list(LETTERS[1:10],
             letters[1:5]))

rhandsontable(MAT) \%>\%
 hot_heatmap()
}
