% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-slider.R
\name{sliderInput}
\alias{sliderInput}
\alias{animationOptions}
\title{Slider Input Widget}
\usage{
sliderInput(inputId, label, min, max, value, step = NULL,
  round = FALSE, format = NULL, locale = NULL, ticks = TRUE,
  animate = FALSE, width = NULL, sep = ",", pre = NULL,
  post = NULL, timeFormat = NULL, timezone = NULL,
  dragRange = TRUE)

animationOptions(interval = 1000, loop = FALSE, playButton = NULL,
  pauseButton = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{min}{The minimum value (inclusive) that can be selected.}

\item{max}{The maximum value (inclusive) that can be selected.}

\item{value}{The initial value of the slider. A numeric vector of length one
will create a regular slider; a numeric vector of length two will create a
double-ended range slider. A warning will be issued if the value doesn't
fit between \code{min} and \code{max}.}

\item{step}{Specifies the interval between each selectable value on the
slider (if \code{NULL}, a heuristic is used to determine the step size). If
the values are dates, \code{step} is in days; if the values are times
(POSIXt), \code{step} is in seconds.}

\item{round}{\code{TRUE} to round all values to the nearest integer;
\code{FALSE} if no rounding is desired; or an integer to round to that
number of digits (for example, 1 will round to the nearest 10, and -2 will
round to the nearest .01). Any rounding will be applied after snapping to
the nearest step.}

\item{format}{Deprecated.}

\item{locale}{Deprecated.}

\item{ticks}{\code{FALSE} to hide tick marks, \code{TRUE} to show them
according to some simple heuristics.}

\item{animate}{\code{TRUE} to show simple animation controls with default
settings; \code{FALSE} not to; or a custom settings list, such as those
created using \code{\link[=animationOptions]{animationOptions()}}.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[=validateCssUnit]{validateCssUnit()}}.}

\item{sep}{Separator between thousands places in numbers.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{timeFormat}{Only used if the values are Date or POSIXt objects. A time
format string, to be passed to the Javascript strftime library. See
\url{https://github.com/samsonjs/strftime} for more details. The allowed
format specifications are very similar, but not identical, to those for R's
\code{\link[base:strftime]{base::strftime()}} function. For Dates, the default is \code{"\%F"}
(like \code{"2015-07-01"}), and for POSIXt, the default is \code{"\%F \%T"}
(like \code{"2015-07-01 15:32:10"}).}

\item{timezone}{Only used if the values are POSIXt objects. A string
specifying the time zone offset for the displayed times, in the format
\code{"+HHMM"} or \code{"-HHMM"}. If \code{NULL} (the default), times will
be displayed in the browser's time zone. The value \code{"+0000"} will
result in UTC time.}

\item{dragRange}{This option is used only if it is a range slider (with two
values). If \code{TRUE} (the default), the range can be dragged. In other
words, the min and max can be dragged together. If \code{FALSE}, the range
cannot be dragged.}

\item{interval}{The interval, in milliseconds, between each animation step.}

\item{loop}{\code{TRUE} to automatically restart the animation when it
reaches the end.}

\item{playButton}{Specifies the appearance of the play button. Valid values
are a one-element character vector (for a simple text label), an HTML tag
or list of tags (using \code{\link[=tag]{tag()}} and friends), or raw HTML (using
\code{\link[=HTML]{HTML()}}).}

\item{pauseButton}{Similar to \code{playButton}, but for the pause button.}
}
\description{
Constructs a slider widget to select a numeric value from a range.
}
\section{Server value}{

A number, or in the case of slider range, a vector of two numbers.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {
options(device.ask.default = FALSE)

ui <- fluidPage(
  sliderInput("obs", "Number of observations:",
    min = 0, max = 1000, value = 500
  ),
  plotOutput("distPlot")
)

# Server logic
server <- function(input, output) {
  output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
  })
}

# Complete app with UI and server components
shinyApp(ui, server)
}

}
\seealso{
\code{\link[=updateSliderInput]{updateSliderInput()}}

Other input elements: \code{\link{actionButton}},
  \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}}, \code{\link{dateInput}},
  \code{\link{dateRangeInput}}, \code{\link{fileInput}},
  \code{\link{numericInput}}, \code{\link{passwordInput}},
  \code{\link{radioButtons}}, \code{\link{selectInput}},
  \code{\link{submitButton}}, \code{\link{textAreaInput}},
  \code{\link{textInput}}, \code{\link{varSelectInput}}
}
\concept{input elements}
