% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downstream.R
\name{downstream}
\alias{downstream}
\alias{downstream.default}
\alias{downstream.tsn}
\alias{downstream.colid}
\alias{downstream.gbifid}
\alias{downstream.uid}
\alias{downstream.wormsid}
\alias{downstream.ids}
\title{Retrieve the downstream taxa for a given taxon name or ID.}
\usage{
downstream(...)

\method{downstream}{default}(x, db = NULL, downto = NULL,
  intermediate = FALSE, rows = NA, ...)

\method{downstream}{tsn}(x, db = NULL, downto = NULL,
  intermediate = FALSE, ...)

\method{downstream}{colid}(x, db = NULL, downto = NULL,
  intermediate = FALSE, ...)

\method{downstream}{gbifid}(x, db = NULL, downto = NULL,
  intermediate = FALSE, limit = 100, start = NULL, ...)

\method{downstream}{uid}(x, db = NULL, downto = NULL,
  intermediate = FALSE, ...)

\method{downstream}{wormsid}(x, db = NULL, downto = NULL,
  intermediate = FALSE, ...)

\method{downstream}{ids}(x, db = NULL, downto = NULL,
  intermediate = FALSE, ...)
}
\arguments{
\item{...}{Further args passed on to \code{itis_downstream},
\code{col_downstream}, \code{gbif_downstream}, \code{ncbi_downstream},
or \code{worms_downstream}}

\item{x}{Vector of taxa names (character) or IDs (character or numeric)
to query.}

\item{db}{character; database to query. One or more of \code{itis},
\code{col}, \code{gbif}, \code{ncbi} or \code{worms}. Note that each taxonomic 
data source has their own identifiers, so that if you provide the wrong 
\code{db} value for the identifier you could get a result, but it will 
likely be wrong (not what you were expecting).}

\item{downto}{What taxonomic rank to go down to. One of: 'superkingdom',
'kingdom', 'subkingdom','infrakingdom','phylum','division','subphylum',
'subdivision','infradivision', 'superclass','class','subclass','infraclass',
'superorder','order','suborder','infraorder','superfamily','family',
'subfamily','tribe','subtribe','genus','subgenus','section','subsection',
'species group','species','subspecies','variety','form','subvariety','race',
'stirp', 'morph','aberration','subform', 'unspecified', 'no rank'}

\item{intermediate}{(logical) If \code{TRUE}, return a list of length two
with target taxon rank names, with additional list of data.frame's of
intermediate taxonomic groups. Default: \code{FALSE}}

\item{rows}{(numeric) Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this parameter is ignored if you pass in a
taxonomic id of any of the acceptable classes: tsn, colid.}

\item{limit}{Number of records to return}

\item{start}{Record number to start at}
}
\value{
A named list of data.frames with the downstream names of every
supplied taxa. You get an NA if there was no match in the database.
}
\description{
This function uses a while loop to continually collect children taxa down
to the taxonomic rank that you specify in the \code{downto} parameter. You
can get data from ITIS (itis), Catalogue of Life (col), GBIF (gbif),
NCBI (ncbi) or WORMS (worms). There is no method exposed by these four 
services for getting taxa at a specific taxonomic rank, so we do it 
ourselves here.
}
\section{Authentication}{

See \code{\link{taxize-authentication}} for help on authentication
}

\examples{
\dontrun{
# Plug in taxon IDs
downstream("015be25f6b061ba517f495394b80f108", db = "col",
  downto = "species")
downstream(125732, db = 'worms', downto = 'species')

# Plug in taxon names
downstream("Insecta", db = 'col', downto = 'order')
downstream("Apis", db = 'col', downto = 'species')
downstream("Apis", db = 'ncbi', downto = 'species')
downstream("Apis", db = 'itis', downto = 'species')
downstream("Gadus", db = 'worms', downto = 'species')
downstream(c("Apis","Epeoloides"), db = 'itis', downto = 'species')
downstream(c("Apis","Epeoloides"), db = 'col', downto = 'species')
downstream("Ursus", db = 'gbif', downto = 'species')
downstream(get_gbifid("Ursus"), db = 'gbif', downto = 'species')

# Plug in IDs
id <- get_colid("Apis")
downstream(id, downto = 'species')

## Equivalently, plug in the call to get the id via e.g., get_colid
## into downstream
identical(downstream(id, downto = 'species'),
         downstream(get_colid("Apis"), downto = 'species'))

id <- get_colid("Apis")
downstream(id, downto = 'species')
downstream(get_colid("Apis"), downto = 'species')

# Many taxa
sp <- names_list("genus", 3)
downstream(sp, db = 'col', downto = 'species')
downstream(sp, db = 'itis', downto = 'species')
downstream(sp, db = 'gbif', downto = 'species')

# Both data sources
ids <- get_ids("Apis", db = c('col','itis'))
downstream(ids, downto = 'species')
## same result
downstream(get_ids("Apis", db = c('col','itis')), downto = 'species')

# Collect intermediate names
## itis
downstream('Bangiophyceae', db="itis", downto="genus")
downstream('Bangiophyceae', db="itis", downto="genus", intermediate=TRUE)
downstream(get_tsn('Bangiophyceae'), downto="genus")
downstream(get_tsn('Bangiophyceae'), downto="genus", intermediate=TRUE)
## col
downstream(get_colid("Animalia"), downto="class")
downstream(get_colid("Animalia"), downto="class", intermediate=TRUE)

# Use the rows parameter
## note how in the second function call you don't get the prompt
downstream("Poa", db = 'col', downto="species")
downstream("Poa", db = 'col', downto="species", rows=1)

# use curl options
res <- downstream("Apis", db = 'col', downto = 'species', verbose = TRUE)
}
}
