% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cassette_names.R
\name{check_cassette_names}
\alias{check_cassette_names}
\title{Check cassette names}
\usage{
check_cassette_names(pattern = "test-", behavior = "stop")
}
\arguments{
\item{pattern}{(character) regex pattern for file paths to check.
this is done inside of \verb{tests/testthat/}. default: "test-"}

\item{behavior}{(character) "stop" (default) or "warning". if "warning",
we use \code{immediate.=TRUE} so the warning happens at the top of your
tests rather than you seeing it after tests have run (as would happen
by default)}
}
\description{
Check cassette names
}
\details{
This function is meant to be run during your tests, from a
\code{helper-pkgname.R} file inside the \code{tests/testthat} directory. It only
checks that cassette names are not duplicated. A helper function
\code{check_cassette_name()} runs inside \code{\link[=insert_cassette]{insert_cassette()}} that checks
that cassettes do not have: spaces, file extensions, unaccepted
characters (slashes)
}
\section{Cassette names}{

\itemize{
\item Should be meaningful so that it's obvious to you what test/function
they relate to. Meaningful names are important so that you can quickly
determine to what test file or test block a cassette belongs. Note that
vcr cannot check that your cassette names are meaningful.
\item Should not be duplicated. Duplicated cassette names would lead to
a test using the wrong cassette.
\item Should not have spaces. Spaces can lead to problems in using file paths.
\item Should not include a file extension. vcr handles file extensions for
the user.
\item Should not have illegal characters that can lead to problems in using
file paths: '/', '?', '<', '>', '\\', ':', '*', '|', and '\"'
\item Should not have control characters, e.g., \verb{\\n}
\item Should not have just dots, e.g,. \code{.} or \code{..}
\item Should not have Windows reserved words, e.g, \code{com1}
\item Should not have trailing dots
\item Should not be longer than 255 characters
}
}

