/* file-stream-log.c generated by valac 0.35.5, the Vala compiler
 * generated from file-stream-log.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define RETRO_TYPE_LOG (retro_log_get_type ())
#define RETRO_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_LOG, RetroLog))
#define RETRO_IS_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_LOG))
#define RETRO_LOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_LOG, RetroLogIface))

typedef struct _RetroLog RetroLog;
typedef struct _RetroLogIface RetroLogIface;

#define RETRO_TYPE_LOG_LEVEL (retro_log_level_get_type ())

#define RETRO_TYPE_FILE_STREAM_LOG (retro_file_stream_log_get_type ())
#define RETRO_FILE_STREAM_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLog))
#define RETRO_FILE_STREAM_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLogClass))
#define RETRO_IS_FILE_STREAM_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_FILE_STREAM_LOG))
#define RETRO_IS_FILE_STREAM_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_FILE_STREAM_LOG))
#define RETRO_FILE_STREAM_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLogClass))

typedef struct _RetroFileStreamLog RetroFileStreamLog;
typedef struct _RetroFileStreamLogClass RetroFileStreamLogClass;
typedef struct _RetroFileStreamLogPrivate RetroFileStreamLogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RETRO_LOG_LEVEL_DEBUG = 0,
	RETRO_LOG_LEVEL_INFO,
	RETRO_LOG_LEVEL_WARN,
	RETRO_LOG_LEVEL_ERROR
} RetroLogLevel;

struct _RetroLogIface {
	GTypeInterface parent_iface;
	gboolean (*log) (RetroLog* self, RetroLogLevel level, const gchar* message);
};

struct _RetroFileStreamLog {
	GObject parent_instance;
	RetroFileStreamLogPrivate * priv;
};

struct _RetroFileStreamLogClass {
	GObjectClass parent_class;
};

struct _RetroFileStreamLogPrivate {
	FILE* _stream;
};


static gpointer retro_file_stream_log_parent_class = NULL;
static RetroLogIface * retro_file_stream_log_retro_log_parent_iface = NULL;

GType retro_log_level_get_type (void) G_GNUC_CONST;
GType retro_log_get_type (void) G_GNUC_CONST;
GType retro_file_stream_log_get_type (void) G_GNUC_CONST;
#define RETRO_FILE_STREAM_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLogPrivate))
enum  {
	RETRO_FILE_STREAM_LOG_DUMMY_PROPERTY,
	RETRO_FILE_STREAM_LOG_STREAM
};
#define RETRO_FILE_STREAM_LOG_default_color "\033[39m"
RetroFileStreamLog* retro_file_stream_log_new (FILE* stream);
RetroFileStreamLog* retro_file_stream_log_construct (GType object_type, FILE* stream);
static gboolean retro_file_stream_log_real_log (RetroLog* base, RetroLogLevel level, const gchar* message);
FILE* retro_file_stream_log_get_stream (RetroFileStreamLog* self);
static gchar* retro_file_stream_log_get_color (RetroFileStreamLog* self, RetroLogLevel level);
void retro_file_stream_log_set_stream (RetroFileStreamLog* self, FILE* value);
static void retro_file_stream_log_finalize (GObject * obj);
static void _vala_retro_file_stream_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_file_stream_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Creates a FileStreamLog.
 *
 * @param stream the FileStream to log messages to
 */
RetroFileStreamLog* retro_file_stream_log_construct (GType object_type, FILE* stream) {
	RetroFileStreamLog * self = NULL;
	FILE* _tmp0_;
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = stream;
	self = (RetroFileStreamLog*) g_object_new (object_type, "stream", _tmp0_, NULL);
	return self;
}


RetroFileStreamLog* retro_file_stream_log_new (FILE* stream) {
	return retro_file_stream_log_construct (RETRO_TYPE_FILE_STREAM_LOG, stream);
}


/**
 * Logs a message to the {@link stream}.
 *
 * @param level the importance of the message
 * @param message the message to log
 * @return true if the message have been logged, false otherwise
 */
static gboolean retro_file_stream_log_real_log (RetroLog* base, RetroLogLevel level, const gchar* message) {
	RetroFileStreamLog * self;
	gboolean result = FALSE;
	FILE* _tmp0_;
	RetroLogLevel _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (RetroFileStreamLog*) base;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->priv->_stream;
	_tmp1_ = level;
	_tmp2_ = retro_file_stream_log_get_color (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = message;
	fprintf (_tmp0_, "%s%s%s", _tmp3_, _tmp4_, RETRO_FILE_STREAM_LOG_default_color);
	_g_free0 (_tmp3_);
	result = TRUE;
	return result;
}


static gchar* retro_file_stream_log_get_color (RetroFileStreamLog* self, RetroLogLevel level) {
	gchar* result = NULL;
	RetroLogLevel _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = level;
	switch (_tmp0_) {
		case RETRO_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("\033[32m");
			result = _tmp1_;
			return result;
		}
		case RETRO_LOG_LEVEL_WARN:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("\033[33m");
			result = _tmp2_;
			return result;
		}
		case RETRO_LOG_LEVEL_ERROR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("\033[31m");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (RETRO_FILE_STREAM_LOG_default_color);
			result = _tmp4_;
			return result;
		}
	}
}


FILE* retro_file_stream_log_get_stream (RetroFileStreamLog* self) {
	FILE* result;
	FILE* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stream;
	result = _tmp0_;
	return result;
}


void retro_file_stream_log_set_stream (RetroFileStreamLog* self, FILE* value) {
	g_return_if_fail (self != NULL);
	if (retro_file_stream_log_get_stream (self) != value) {
		FILE* _tmp0_;
		_tmp0_ = value;
		self->priv->_stream = _tmp0_;
		g_object_notify ((GObject *) self, "stream");
	}
}


static void retro_file_stream_log_class_init (RetroFileStreamLogClass * klass) {
	retro_file_stream_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroFileStreamLogPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_file_stream_log_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_file_stream_log_set_property;
	G_OBJECT_CLASS (klass)->finalize = retro_file_stream_log_finalize;
	/**
	 * The FileStream to log the core's messages to.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_FILE_STREAM_LOG_STREAM, g_param_spec_pointer ("stream", "stream", "stream", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void retro_file_stream_log_retro_log_interface_init (RetroLogIface * iface) {
	retro_file_stream_log_retro_log_parent_iface = g_type_interface_peek_parent (iface);
	iface->log = (gboolean (*) (RetroLog *, RetroLogLevel, const gchar*)) retro_file_stream_log_real_log;
}


static void retro_file_stream_log_instance_init (RetroFileStreamLog * self) {
	self->priv = RETRO_FILE_STREAM_LOG_GET_PRIVATE (self);
}


static void retro_file_stream_log_finalize (GObject * obj) {
	RetroFileStreamLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLog);
	G_OBJECT_CLASS (retro_file_stream_log_parent_class)->finalize (obj);
}


/**
 * Sends log messages from a {@link Core} to a FileStream.
 */
GType retro_file_stream_log_get_type (void) {
	static volatile gsize retro_file_stream_log_type_id__volatile = 0;
	if (g_once_init_enter (&retro_file_stream_log_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroFileStreamLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_file_stream_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroFileStreamLog), 0, (GInstanceInitFunc) retro_file_stream_log_instance_init, NULL };
		static const GInterfaceInfo retro_log_info = { (GInterfaceInitFunc) retro_file_stream_log_retro_log_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType retro_file_stream_log_type_id;
		retro_file_stream_log_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroFileStreamLog", &g_define_type_info, 0);
		g_type_add_interface_static (retro_file_stream_log_type_id, RETRO_TYPE_LOG, &retro_log_info);
		g_once_init_leave (&retro_file_stream_log_type_id__volatile, retro_file_stream_log_type_id);
	}
	return retro_file_stream_log_type_id__volatile;
}


static void _vala_retro_file_stream_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroFileStreamLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLog);
	switch (property_id) {
		case RETRO_FILE_STREAM_LOG_STREAM:
		g_value_set_pointer (value, retro_file_stream_log_get_stream (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_file_stream_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroFileStreamLog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_FILE_STREAM_LOG, RetroFileStreamLog);
	switch (property_id) {
		case RETRO_FILE_STREAM_LOG_STREAM:
		retro_file_stream_log_set_stream (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



