# TinyMCE

TinyMCE is the world's most advanced open source core rich text editor.

Trusted by millions of developers, and used by some of the world's largest companies and fastest-growing start-ups, TinyMCE is the WYSIWYG editor that is built to scale, designed to innovate, and is built to thrive with edge-cases.

You can access a [full featured demo of TinyMCE](https://www.tiny.cloud/docs/demo/full-featured/) in the docs on the Tiny website.

<p align="center">
  <img alt="Screenshot of the TinyMCE Editor" src="https://www.tiny.cloud/storage/github-readme-images/tinymce-editor.png"\>
</p>

## Get started with TinyMCE

[TinyMCE Cloud Deployment Quick Start Guide](https://www.tiny.cloud/docs/quick-start/)

[TinyMCE Self-hosted Deployment Guide](https://www.tiny.cloud/docs/general-configuration-guide/advanced-install/)

TinyMCE provides a range of configuration options that allow you to integrate it into your application. Start customizing with a [basic setup](https://www.tiny.cloud/docs/general-configuration-guide/basic-setup/).

Configure it for one of three modes of editing:

- [TinyMCE classic editing mode](https://www.tiny.cloud/docs/general-configuration-guide/use-tinymce-classic/).
- [TinyMCE inline editing mode](https://www.tiny.cloud/docs/general-configuration-guide/use-tinymce-inline/).
- [TinyMCE distraction-free editing mode](https://www.tiny.cloud/docs/general-configuration-guide/use-tinymce-distraction-free/).

## Features

### Integration

TinyMCE is easily integrated into your projects with the help of components such as:

- [tinymce-react](https://github.com/tinymce/tinymce-react)
- [tinymce-vue](https://github.com/tinymce/tinymce-vue)
- [tinymce-angular](https://github.com/tinymce/tinymce-angular)

See the Tiny docs for a full list of [integration components](https://www.tiny.cloud/docs/integrations/).

### Customization

It is easy to [configure the UI](https://www.tiny.cloud/docs/general-configuration-guide/customize-ui/) to match the design of your site, product or application. Due to its flexibility, you can [configure the editor](https://www.tiny.cloud/docs/general-configuration-guide/basic-setup/) with as much or as little functionality as you like, depending on your requirements.

With [50+ powerful plugins available](https://www.tiny.cloud/apps/), adding additional functionality is as simple as including a single line of code. Realizing the full power of most plugins requires only a few lines more.

### Extensibility

Sometimes your business requirements can be quite unique, and you need the freedom and flexibility to innovate. View the source code and develop your own extensions for custom functionality to meet your own requirements. The [API](https://www.tiny.cloud/docs/api/) is exposed to make it easier for you to write custom functionality that fits within the existing framework of TinyMCE [UI components](https://www.tiny.cloud/docs/ui-components/).

### Extended Features and Support

For the professional software teams that require more in-depth efficiency, compliance or collaborative features built to enterprise-grade standards, please [get in touch with our team](https://www.tiny.cloud/contact/).

Tiny also offers dedicated SLAs and support for professional development teams.

## Compiling and contributing

In 2019 the decision was made to transition our codebase to a monorepo. For information on compiling and contributing, see: [contribution guidelines](https://github.com/tinymce/tinymce/blob/master/CONTRIBUTING.md).

As an open source product, we encourage and support the active development of our software.

## Want more information?

Visit the [TinyMCE website](https://tiny.cloud/) and check out the [TinyMCE documentation](https://www.tiny.cloud/docs/).
