# Rspamd options settings

## Introduction

Options section defines the basic rspamd behaviour and are global for all types of workers.
The default options are depicted in the following example configuration snippet:

~~~nginx
filters = "chartable,dkim,spf,surbl,regexp,fuzzy_check";
one_shot = false;
cache_file = "$DBDIR/symbols.cache";
map_watch_interval = 1min;
dynamic_conf = "$DBDIR/rspamd_dynamic";
history_file = "$DBDIR/rspamd.history";
check_all_filters = false;
dns {
    timeout = 1s;
    sockets = 16;
    retransmits = 5;
}
tempdir = "/tmp";
url_tld = "${PLUGINSDIR}/effective_tld_names.dat";
~~~

## Global options

* `filters`: commas separated string that defines **internal** rspamd filters enabled; for list
of the internal modules please consult with the [following page](../modules/).
* `one_shot`: if this flag is set to `true` then multiple rules triggers do not increase the total
score of messages (however, this option can be also individually configured in the `metric` section for each
symbol).
* `cache_file`: this file is used to store information about rules and their statistics; this file is automatically generated if rspamd detects that a symbols' list has been changed since last time.
* `map_watch_interval`: defines time when all maps are rescanned; the actual check interval is jittered to avoid simultaneous checking (hence, the real interval is from this value up to the this interval doubled).
* `check_all_filters`: turns off optimizations when a message gains the overall score more than the `reject` score for the default metric; this optimization can also be turned off for each request individually.
* `history_file`: path to the rolling history of operations displayed by webui; this file is automatically created and refreshed by rspamd on each scan operation.
* `temp_dir`: a directory for temporary files (also could be set via environment variable `TMPDIR`).
* `url_tld`: path to file with top level domain suffixes used by rspamd to find URL's in messages; by default this file is shipped with rspamd and should not be touched manually.
* `pid_file`: file used to store pid of the rspamd main process (not used with sytemd).
* `min_word_len`: minimum size in letters (valid for utf8 texts as well) for a sequence of characters to be treated as a word; normally rspamd skips sequences if they are shorter or equal to three symbols.

## DNS options

These options live in a separate subsection named `dns` and specify the behaviour of rspamd name resolution. Here is a list of available tunables:

* `nameserver`: list (or array) of DNS servers to be used (if this option is missed, then `/etc/resolv.conf` is parsed instead). It is also possible to specify weights of DNS servers to balance the payload, e.g.

~~~nginx
options {
	dns {
		# 9/10 on 127.0.0.1 and 1/10 to 8.8.8.8
		nameserver = ["127.0.0.1:10", "8.8.8.8:1"];
		# or
		# nameserver = "127.0.0.1:10";
		# nameserver = "8.8.8.8:1";
	}
}
~~~

* `timeout`: timeout for each DNS request
* `retransmits`: how many times each request is retransmitted to be treated as bad (the overall timeout for each request is thus `timeout * retransmits`)
* `sockets`: how many sockets are opened to a remote DNS resolver, can be tuned if you have tens thousands of requests per second).

## Upstream options

**TODO**