# The Rust Reference

[Introduction](introduction.md)

- [Notation](notation.md)
    - [Unicode productions](unicode-productions.md)
    - [String table productions](string-table-productions.md)

- [Lexical structure](lexical-structure.md)
    - [Input format](input-format.md)
    - [Identifiers](identifiers.md)
    - [Comments](comments.md)
    - [Whitespace](whitespace.md)
    - [Tokens](tokens.md)
    - [Paths](paths.md)

- [Macros](macros.md)
    - [Macros By Example](macros-by-example.md)
    - [Procedrual Macros](procedural-macros.md)

- [Crates and source files](crates-and-source-files.md)

- [Items and attributes](items-and-attributes.md)
    - [Items](items.md)
    - [Visibility and Privacy](visibility-and-privacy.md)
    - [Attributes](attributes.md)

- [Statements and expressions](statements-and-expressions.md)
    - [Statements](statements.md)
    - [Expressions](expressions.md)

- [Type system](type-system.md)
    - [Types](types.md)
    - [Subtyping](subtyping.md)
    - [Type coercions](type-coercions.md)

- [Special traits](special-traits.md)
    - [The Copy trait](the-copy-trait.md)
    - [The Sized trait](the-sized-trait.md)
    - [The Drop trait](the-drop-trait.md)
    - [The Deref trait](the-deref-trait.md)
    - [The Send trait](the-send-trait.md)
    - [The Sync trait](the-sync-trait.md)

- [Memory model](memory-model.md)
    - [Memory allocation and lifetime](memory-allocation-and-lifetime.md)
    - [Memory ownership](memory-ownership.md)
    - [Variables](variables.md)

- [Linkage](linkage.md)

- [Unsafety](unsafety.md)
    - [Unsafe functions](unsafe-functions.md)
    - [Unsafe blocks](unsafe-blocks.md)
    - [Behavior considered undefined](behavior-considered-undefined.md)
    - [Behavior not considered unsafe](behavior-not-considered-unsafe.md)

[Appendix: Influences](influences.md)
