// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
//! Constant definitions for the NTSTATUS values.
pub const STATUS_WAIT_0: ::NTSTATUS = 0x00000000;
pub const FACILITY_VSM: ::NTSTATUS = 0x45;
pub const FACILITY_VOLSNAP: ::NTSTATUS = 0x50;
pub const FACILITY_VOLMGR: ::NTSTATUS = 0x38;
pub const FACILITY_VIRTUALIZATION: ::NTSTATUS = 0x37;
pub const FACILITY_VIDEO: ::NTSTATUS = 0x1B;
pub const FACILITY_USB_ERROR_CODE: ::NTSTATUS = 0x10;
pub const FACILITY_TRANSACTION: ::NTSTATUS = 0x19;
pub const FACILITY_TPM: ::NTSTATUS = 0x29;
pub const FACILITY_TERMINAL_SERVER: ::NTSTATUS = 0xA;
pub const FACILITY_SXS_ERROR_CODE: ::NTSTATUS = 0x15;
pub const FACILITY_NTSSPI: ::NTSTATUS = 0x9;
pub const FACILITY_SPACES: ::NTSTATUS = 0xE7;
pub const FACILITY_SMB: ::NTSTATUS = 0x5D;
pub const FACILITY_SYSTEM_INTEGRITY: ::NTSTATUS = 0xE9;
pub const FACILITY_SHARED_VHDX: ::NTSTATUS = 0x5C;
pub const FACILITY_SECUREBOOT: ::NTSTATUS = 0x43;
pub const FACILITY_SECURITY_CORE: ::NTSTATUS = 0xE8;
pub const FACILITY_SDBUS: ::NTSTATUS = 0x51;
pub const FACILITY_RTPM: ::NTSTATUS = 0x2A;
pub const FACILITY_RPC_STUBS: ::NTSTATUS = 0x3;
pub const FACILITY_RPC_RUNTIME: ::NTSTATUS = 0x2;
pub const FACILITY_RESUME_KEY_FILTER: ::NTSTATUS = 0x40;
pub const FACILITY_RDBSS: ::NTSTATUS = 0x41;
pub const FACILITY_NTWIN32: ::NTSTATUS = 0x7;
pub const FACILITY_WIN32K_NTUSER: ::NTSTATUS = 0x3E;
pub const FACILITY_WIN32K_NTGDI: ::NTSTATUS = 0x3F;
pub const FACILITY_NDIS_ERROR_CODE: ::NTSTATUS = 0x23;
pub const FACILTIY_MUI_ERROR_CODE: ::NTSTATUS = 0xB;
pub const FACILITY_MONITOR: ::NTSTATUS = 0x1D;
pub const FACILITY_MAXIMUM_VALUE: ::NTSTATUS = 0xEB;
pub const FACILITY_LICENSING: ::NTSTATUS = 0xEA;
pub const FACILITY_IPSEC: ::NTSTATUS = 0x36;
pub const FACILITY_IO_ERROR_CODE: ::NTSTATUS = 0x4;
pub const FACILITY_INTERIX: ::NTSTATUS = 0x99;
pub const FACILITY_HYPERVISOR: ::NTSTATUS = 0x35;
pub const FACILITY_HID_ERROR_CODE: ::NTSTATUS = 0x11;
pub const FACILITY_GRAPHICS_KERNEL: ::NTSTATUS = 0x1E;
pub const FACILITY_FWP_ERROR_CODE: ::NTSTATUS = 0x22;
pub const FACILITY_FVE_ERROR_CODE: ::NTSTATUS = 0x21;
pub const FACILITY_FIREWIRE_ERROR_CODE: ::NTSTATUS = 0x12;
pub const FACILITY_FILTER_MANAGER: ::NTSTATUS = 0x1C;
pub const FACILITY_DRIVER_FRAMEWORK: ::NTSTATUS = 0x20;
pub const FACILITY_DEBUGGER: ::NTSTATUS = 0x1;
pub const FACILITY_COMMONLOG: ::NTSTATUS = 0x1A;
pub const FACILITY_CODCLASS_ERROR_CODE: ::NTSTATUS = 0x6;
pub const FACILITY_CLUSTER_ERROR_CODE: ::NTSTATUS = 0x13;
pub const FACILITY_NTCERT: ::NTSTATUS = 0x8;
pub const FACILITY_BTH_ATT: ::NTSTATUS = 0x42;
pub const FACILITY_BCD_ERROR_CODE: ::NTSTATUS = 0x39;
pub const FACILITY_AUDIO_KERNEL: ::NTSTATUS = 0x44;
pub const FACILITY_ACPI_ERROR_CODE: ::NTSTATUS = 0x14;
pub const STATUS_SEVERITY_WARNING: ::NTSTATUS = 0x2;
pub const STATUS_SEVERITY_SUCCESS: ::NTSTATUS = 0x0;
pub const STATUS_SEVERITY_INFORMATIONAL: ::NTSTATUS = 0x1;
pub const STATUS_SEVERITY_ERROR: ::NTSTATUS = 0x3;
pub const STATUS_SUCCESS: ::NTSTATUS = 0x00000000;
pub const STATUS_WAIT_1: ::NTSTATUS = 0x00000001;
pub const STATUS_WAIT_2: ::NTSTATUS = 0x00000002;
pub const STATUS_WAIT_3: ::NTSTATUS = 0x00000003;
pub const STATUS_WAIT_63: ::NTSTATUS = 0x0000003F;
pub const STATUS_ABANDONED: ::NTSTATUS = 0x00000080;
pub const STATUS_ABANDONED_WAIT_0: ::NTSTATUS = 0x00000080;
pub const STATUS_ABANDONED_WAIT_63: ::NTSTATUS = 0x000000BF;
pub const STATUS_USER_APC: ::NTSTATUS = 0x000000C0;
pub const STATUS_KERNEL_APC: ::NTSTATUS = 0x00000100;
pub const STATUS_ALERTED: ::NTSTATUS = 0x00000101;
pub const STATUS_TIMEOUT: ::NTSTATUS = 0x00000102;
pub const STATUS_PENDING: ::NTSTATUS = 0x00000103;
pub const STATUS_REPARSE: ::NTSTATUS = 0x00000104;
pub const STATUS_MORE_ENTRIES: ::NTSTATUS = 0x00000105;
pub const STATUS_NOT_ALL_ASSIGNED: ::NTSTATUS = 0x00000106;
pub const STATUS_SOME_NOT_MAPPED: ::NTSTATUS = 0x00000107;
pub const STATUS_OPLOCK_BREAK_IN_PROGRESS: ::NTSTATUS = 0x00000108;
pub const STATUS_VOLUME_MOUNTED: ::NTSTATUS = 0x00000109;
pub const STATUS_RXACT_COMMITTED: ::NTSTATUS = 0x0000010A;
pub const STATUS_NOTIFY_CLEANUP: ::NTSTATUS = 0x0000010B;
pub const STATUS_NOTIFY_ENUM_DIR: ::NTSTATUS = 0x0000010C;
pub const STATUS_NO_QUOTAS_FOR_ACCOUNT: ::NTSTATUS = 0x0000010D;
pub const STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED: ::NTSTATUS = 0x0000010E;
pub const STATUS_PAGE_FAULT_TRANSITION: ::NTSTATUS = 0x00000110;
pub const STATUS_PAGE_FAULT_DEMAND_ZERO: ::NTSTATUS = 0x00000111;
pub const STATUS_PAGE_FAULT_COPY_ON_WRITE: ::NTSTATUS = 0x00000112;
pub const STATUS_PAGE_FAULT_GUARD_PAGE: ::NTSTATUS = 0x00000113;
pub const STATUS_PAGE_FAULT_PAGING_FILE: ::NTSTATUS = 0x00000114;
pub const STATUS_CACHE_PAGE_LOCKED: ::NTSTATUS = 0x00000115;
pub const STATUS_CRASH_DUMP: ::NTSTATUS = 0x00000116;
pub const STATUS_BUFFER_ALL_ZEROS: ::NTSTATUS = 0x00000117;
pub const STATUS_REPARSE_OBJECT: ::NTSTATUS = 0x00000118;
pub const STATUS_RESOURCE_REQUIREMENTS_CHANGED: ::NTSTATUS = 0x00000119;
pub const STATUS_TRANSLATION_COMPLETE: ::NTSTATUS = 0x00000120;
pub const STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY: ::NTSTATUS = 0x00000121;
pub const STATUS_NOTHING_TO_TERMINATE: ::NTSTATUS = 0x00000122;
pub const STATUS_PROCESS_NOT_IN_JOB: ::NTSTATUS = 0x00000123;
pub const STATUS_PROCESS_IN_JOB: ::NTSTATUS = 0x00000124;
pub const STATUS_VOLSNAP_HIBERNATE_READY: ::NTSTATUS = 0x00000125;
pub const STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY: ::NTSTATUS = 0x00000126;
pub const STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED: ::NTSTATUS = 0x00000127;
pub const STATUS_INTERRUPT_STILL_CONNECTED: ::NTSTATUS = 0x00000128;
pub const STATUS_PROCESS_CLONED: ::NTSTATUS = 0x00000129;
pub const STATUS_FILE_LOCKED_WITH_ONLY_READERS: ::NTSTATUS = 0x0000012A;
pub const STATUS_FILE_LOCKED_WITH_WRITERS: ::NTSTATUS = 0x0000012B;
pub const STATUS_VALID_IMAGE_HASH: ::NTSTATUS = 0x0000012C;
pub const STATUS_VALID_CATALOG_HASH: ::NTSTATUS = 0x0000012D;
pub const STATUS_VALID_STRONG_CODE_HASH: ::NTSTATUS = 0x0000012E;
pub const STATUS_RESOURCEMANAGER_READ_ONLY: ::NTSTATUS = 0x00000202;
pub const STATUS_RING_PREVIOUSLY_EMPTY: ::NTSTATUS = 0x00000210;
pub const STATUS_RING_PREVIOUSLY_FULL: ::NTSTATUS = 0x00000211;
pub const STATUS_RING_PREVIOUSLY_ABOVE_QUOTA: ::NTSTATUS = 0x00000212;
pub const STATUS_RING_NEWLY_EMPTY: ::NTSTATUS = 0x00000213;
pub const STATUS_RING_SIGNAL_OPPOSITE_ENDPOINT: ::NTSTATUS = 0x00000214;
pub const STATUS_OPLOCK_SWITCHED_TO_NEW_HANDLE: ::NTSTATUS = 0x00000215;
pub const STATUS_OPLOCK_HANDLE_CLOSED: ::NTSTATUS = 0x00000216;
pub const STATUS_WAIT_FOR_OPLOCK: ::NTSTATUS = 0x00000367;
pub const DBG_EXCEPTION_HANDLED: ::NTSTATUS = 0x00010001;
pub const DBG_CONTINUE: ::NTSTATUS = 0x00010002;
pub const STATUS_FLT_IO_COMPLETE: ::NTSTATUS = 0x001C0001;
pub const STATUS_OBJECT_NAME_EXISTS: ::NTSTATUS = 0x40000000;
pub const STATUS_THREAD_WAS_SUSPENDED: ::NTSTATUS = 0x40000001;
pub const STATUS_WORKING_SET_LIMIT_RANGE: ::NTSTATUS = 0x40000002;
pub const STATUS_IMAGE_NOT_AT_BASE: ::NTSTATUS = 0x40000003;
pub const STATUS_RXACT_STATE_CREATED: ::NTSTATUS = 0x40000004;
pub const STATUS_SEGMENT_NOTIFICATION: ::NTSTATUS = 0x40000005;
pub const STATUS_LOCAL_USER_SESSION_KEY: ::NTSTATUS = 0x40000006;
pub const STATUS_BAD_CURRENT_DIRECTORY: ::NTSTATUS = 0x40000007;
pub const STATUS_SERIAL_MORE_WRITES: ::NTSTATUS = 0x40000008;
pub const STATUS_REGISTRY_RECOVERED: ::NTSTATUS = 0x40000009;
pub const STATUS_FT_READ_RECOVERY_FROM_BACKUP: ::NTSTATUS = 0x4000000A;
pub const STATUS_FT_WRITE_RECOVERY: ::NTSTATUS = 0x4000000B;
pub const STATUS_SERIAL_COUNTER_TIMEOUT: ::NTSTATUS = 0x4000000C;
pub const STATUS_NULL_LM_PASSWORD: ::NTSTATUS = 0x4000000D;
pub const STATUS_IMAGE_MACHINE_TYPE_MISMATCH: ::NTSTATUS = 0x4000000E;
pub const STATUS_RECEIVE_PARTIAL: ::NTSTATUS = 0x4000000F;
pub const STATUS_RECEIVE_EXPEDITED: ::NTSTATUS = 0x40000010;
pub const STATUS_RECEIVE_PARTIAL_EXPEDITED: ::NTSTATUS = 0x40000011;
pub const STATUS_EVENT_DONE: ::NTSTATUS = 0x40000012;
pub const STATUS_EVENT_PENDING: ::NTSTATUS = 0x40000013;
pub const STATUS_CHECKING_FILE_SYSTEM: ::NTSTATUS = 0x40000014;
pub const STATUS_FATAL_APP_EXIT: ::NTSTATUS = 0x40000015;
pub const STATUS_PREDEFINED_HANDLE: ::NTSTATUS = 0x40000016;
pub const STATUS_WAS_UNLOCKED: ::NTSTATUS = 0x40000017;
pub const STATUS_SERVICE_NOTIFICATION: ::NTSTATUS = 0x40000018;
pub const STATUS_WAS_LOCKED: ::NTSTATUS = 0x40000019;
pub const STATUS_LOG_HARD_ERROR: ::NTSTATUS = 0x4000001A;
pub const STATUS_ALREADY_WIN32: ::NTSTATUS = 0x4000001B;
pub const STATUS_WX86_UNSIMULATE: ::NTSTATUS = 0x4000001C;
pub const STATUS_WX86_CONTINUE: ::NTSTATUS = 0x4000001D;
pub const STATUS_WX86_SINGLE_STEP: ::NTSTATUS = 0x4000001E;
pub const STATUS_WX86_BREAKPOINT: ::NTSTATUS = 0x4000001F;
pub const STATUS_WX86_EXCEPTION_CONTINUE: ::NTSTATUS = 0x40000020;
pub const STATUS_WX86_EXCEPTION_LASTCHANCE: ::NTSTATUS = 0x40000021;
pub const STATUS_WX86_EXCEPTION_CHAIN: ::NTSTATUS = 0x40000022;
pub const STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE: ::NTSTATUS = 0x40000023;
pub const STATUS_NO_YIELD_PERFORMED: ::NTSTATUS = 0x40000024;
pub const STATUS_TIMER_RESUME_IGNORED: ::NTSTATUS = 0x40000025;
pub const STATUS_ARBITRATION_UNHANDLED: ::NTSTATUS = 0x40000026;
pub const STATUS_CARDBUS_NOT_SUPPORTED: ::NTSTATUS = 0x40000027;
pub const STATUS_WX86_CREATEWX86TIB: ::NTSTATUS = 0x40000028;
pub const STATUS_MP_PROCESSOR_MISMATCH: ::NTSTATUS = 0x40000029;
pub const STATUS_HIBERNATED: ::NTSTATUS = 0x4000002A;
pub const STATUS_RESUME_HIBERNATION: ::NTSTATUS = 0x4000002B;
pub const STATUS_FIRMWARE_UPDATED: ::NTSTATUS = 0x4000002C;
pub const STATUS_DRIVERS_LEAKING_LOCKED_PAGES: ::NTSTATUS = 0x4000002D;
pub const STATUS_MESSAGE_RETRIEVED: ::NTSTATUS = 0x4000002E;
pub const STATUS_SYSTEM_POWERSTATE_TRANSITION: ::NTSTATUS = 0x4000002F;
pub const STATUS_ALPC_CHECK_COMPLETION_LIST: ::NTSTATUS = 0x40000030;
pub const STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION: ::NTSTATUS = 0x40000031;
pub const STATUS_ACCESS_AUDIT_BY_POLICY: ::NTSTATUS = 0x40000032;
pub const STATUS_ABANDON_HIBERFILE: ::NTSTATUS = 0x40000033;
pub const STATUS_BIZRULES_NOT_ENABLED: ::NTSTATUS = 0x40000034;
pub const STATUS_FT_READ_FROM_COPY: ::NTSTATUS = 0x40000035;
pub const STATUS_IMAGE_AT_DIFFERENT_BASE: ::NTSTATUS = 0x40000036;
pub const DBG_REPLY_LATER: ::NTSTATUS = 0x40010001;
pub const DBG_UNABLE_TO_PROVIDE_HANDLE: ::NTSTATUS = 0x40010002;
pub const DBG_TERMINATE_THREAD: ::NTSTATUS = 0x40010003;
pub const DBG_TERMINATE_PROCESS: ::NTSTATUS = 0x40010004;
pub const DBG_CONTROL_C: ::NTSTATUS = 0x40010005;
pub const DBG_PRINTEXCEPTION_C: ::NTSTATUS = 0x40010006;
pub const DBG_RIPEXCEPTION: ::NTSTATUS = 0x40010007;
pub const DBG_CONTROL_BREAK: ::NTSTATUS = 0x40010008;
pub const DBG_COMMAND_EXCEPTION: ::NTSTATUS = 0x40010009;
pub const DBG_PRINTEXCEPTION_WIDE_C: ::NTSTATUS = 0x4001000A;
pub const STATUS_HEURISTIC_DAMAGE_POSSIBLE: ::NTSTATUS = 0x40190001;
pub const STATUS_GUARD_PAGE_VIOLATION: ::NTSTATUS = 0x80000001u32 as i32;
pub const STATUS_DATATYPE_MISALIGNMENT: ::NTSTATUS = 0x80000002u32 as i32;
pub const STATUS_BREAKPOINT: ::NTSTATUS = 0x80000003u32 as i32;
pub const STATUS_SINGLE_STEP: ::NTSTATUS = 0x80000004u32 as i32;
pub const STATUS_BUFFER_OVERFLOW: ::NTSTATUS = 0x80000005u32 as i32;
pub const STATUS_NO_MORE_FILES: ::NTSTATUS = 0x80000006u32 as i32;
pub const STATUS_WAKE_SYSTEM_DEBUGGER: ::NTSTATUS = 0x80000007u32 as i32;
pub const STATUS_HANDLES_CLOSED: ::NTSTATUS = 0x8000000Au32 as i32;
pub const STATUS_NO_INHERITANCE: ::NTSTATUS = 0x8000000Bu32 as i32;
pub const STATUS_GUID_SUBSTITUTION_MADE: ::NTSTATUS = 0x8000000Cu32 as i32;
pub const STATUS_PARTIAL_COPY: ::NTSTATUS = 0x8000000Du32 as i32;
pub const STATUS_DEVICE_PAPER_EMPTY: ::NTSTATUS = 0x8000000Eu32 as i32;
pub const STATUS_DEVICE_POWERED_OFF: ::NTSTATUS = 0x8000000Fu32 as i32;
pub const STATUS_DEVICE_OFF_LINE: ::NTSTATUS = 0x80000010u32 as i32;
pub const STATUS_DEVICE_BUSY: ::NTSTATUS = 0x80000011u32 as i32;
pub const STATUS_NO_MORE_EAS: ::NTSTATUS = 0x80000012u32 as i32;
pub const STATUS_INVALID_EA_NAME: ::NTSTATUS = 0x80000013u32 as i32;
pub const STATUS_EA_LIST_INCONSISTENT: ::NTSTATUS = 0x80000014u32 as i32;
pub const STATUS_INVALID_EA_FLAG: ::NTSTATUS = 0x80000015u32 as i32;
pub const STATUS_VERIFY_REQUIRED: ::NTSTATUS = 0x80000016u32 as i32;
pub const STATUS_EXTRANEOUS_INFORMATION: ::NTSTATUS = 0x80000017u32 as i32;
pub const STATUS_RXACT_COMMIT_NECESSARY: ::NTSTATUS = 0x80000018u32 as i32;
pub const STATUS_NO_MORE_ENTRIES: ::NTSTATUS = 0x8000001Au32 as i32;
pub const STATUS_FILEMARK_DETECTED: ::NTSTATUS = 0x8000001Bu32 as i32;
pub const STATUS_MEDIA_CHANGED: ::NTSTATUS = 0x8000001Cu32 as i32;
pub const STATUS_BUS_RESET: ::NTSTATUS = 0x8000001Du32 as i32;
pub const STATUS_END_OF_MEDIA: ::NTSTATUS = 0x8000001Eu32 as i32;
pub const STATUS_BEGINNING_OF_MEDIA: ::NTSTATUS = 0x8000001Fu32 as i32;
pub const STATUS_MEDIA_CHECK: ::NTSTATUS = 0x80000020u32 as i32;
pub const STATUS_SETMARK_DETECTED: ::NTSTATUS = 0x80000021u32 as i32;
pub const STATUS_NO_DATA_DETECTED: ::NTSTATUS = 0x80000022u32 as i32;
pub const STATUS_REDIRECTOR_HAS_OPEN_HANDLES: ::NTSTATUS = 0x80000023u32 as i32;
pub const STATUS_SERVER_HAS_OPEN_HANDLES: ::NTSTATUS = 0x80000024u32 as i32;
pub const STATUS_ALREADY_DISCONNECTED: ::NTSTATUS = 0x80000025u32 as i32;
pub const STATUS_LONGJUMP: ::NTSTATUS = 0x80000026u32 as i32;
pub const STATUS_CLEANER_CARTRIDGE_INSTALLED: ::NTSTATUS = 0x80000027u32 as i32;
pub const STATUS_PLUGPLAY_QUERY_VETOED: ::NTSTATUS = 0x80000028u32 as i32;
pub const STATUS_UNWIND_CONSOLIDATE: ::NTSTATUS = 0x80000029u32 as i32;
pub const STATUS_REGISTRY_HIVE_RECOVERED: ::NTSTATUS = 0x8000002Au32 as i32;
pub const STATUS_DLL_MIGHT_BE_INSECURE: ::NTSTATUS = 0x8000002Bu32 as i32;
pub const STATUS_DLL_MIGHT_BE_INCOMPATIBLE: ::NTSTATUS = 0x8000002Cu32 as i32;
pub const STATUS_STOPPED_ON_SYMLINK: ::NTSTATUS = 0x8000002Du32 as i32;
pub const STATUS_CANNOT_GRANT_REQUESTED_OPLOCK: ::NTSTATUS = 0x8000002Eu32 as i32;
pub const STATUS_NO_ACE_CONDITION: ::NTSTATUS = 0x8000002Fu32 as i32;
pub const STATUS_DEVICE_SUPPORT_IN_PROGRESS: ::NTSTATUS = 0x80000030u32 as i32;
pub const STATUS_DEVICE_POWER_CYCLE_REQUIRED: ::NTSTATUS = 0x80000031u32 as i32;
pub const DBG_EXCEPTION_NOT_HANDLED: ::NTSTATUS = 0x80010001u32 as i32;
pub const STATUS_CLUSTER_NODE_ALREADY_UP: ::NTSTATUS = 0x80130001u32 as i32;
pub const STATUS_CLUSTER_NODE_ALREADY_DOWN: ::NTSTATUS = 0x80130002u32 as i32;
pub const STATUS_CLUSTER_NETWORK_ALREADY_ONLINE: ::NTSTATUS = 0x80130003u32 as i32;
pub const STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE: ::NTSTATUS = 0x80130004u32 as i32;
pub const STATUS_CLUSTER_NODE_ALREADY_MEMBER: ::NTSTATUS = 0x80130005u32 as i32;
pub const STATUS_FLT_BUFFER_TOO_SMALL: ::NTSTATUS = 0x801C0001u32 as i32;
pub const STATUS_FVE_PARTIAL_METADATA: ::NTSTATUS = 0x80210001u32 as i32;
pub const STATUS_FVE_TRANSIENT_STATE: ::NTSTATUS = 0x80210002u32 as i32;
pub const STATUS_UNSUCCESSFUL: ::NTSTATUS = 0xC0000001u32 as i32;
pub const STATUS_NOT_IMPLEMENTED: ::NTSTATUS = 0xC0000002u32 as i32;
pub const STATUS_INVALID_INFO_CLASS: ::NTSTATUS = 0xC0000003u32 as i32;
pub const STATUS_INFO_LENGTH_MISMATCH: ::NTSTATUS = 0xC0000004u32 as i32;
pub const STATUS_ACCESS_VIOLATION: ::NTSTATUS = 0xC0000005u32 as i32;
pub const STATUS_IN_PAGE_ERROR: ::NTSTATUS = 0xC0000006u32 as i32;
pub const STATUS_PAGEFILE_QUOTA: ::NTSTATUS = 0xC0000007u32 as i32;
pub const STATUS_INVALID_HANDLE: ::NTSTATUS = 0xC0000008u32 as i32;
pub const STATUS_BAD_INITIAL_STACK: ::NTSTATUS = 0xC0000009u32 as i32;
pub const STATUS_BAD_INITIAL_PC: ::NTSTATUS = 0xC000000Au32 as i32;
pub const STATUS_INVALID_CID: ::NTSTATUS = 0xC000000Bu32 as i32;
pub const STATUS_TIMER_NOT_CANCELED: ::NTSTATUS = 0xC000000Cu32 as i32;
pub const STATUS_INVALID_PARAMETER: ::NTSTATUS = 0xC000000Du32 as i32;
pub const STATUS_NO_SUCH_DEVICE: ::NTSTATUS = 0xC000000Eu32 as i32;
pub const STATUS_NO_SUCH_FILE: ::NTSTATUS = 0xC000000Fu32 as i32;
pub const STATUS_INVALID_DEVICE_REQUEST: ::NTSTATUS = 0xC0000010u32 as i32;
pub const STATUS_END_OF_FILE: ::NTSTATUS = 0xC0000011u32 as i32;
pub const STATUS_WRONG_VOLUME: ::NTSTATUS = 0xC0000012u32 as i32;
pub const STATUS_NO_MEDIA_IN_DEVICE: ::NTSTATUS = 0xC0000013u32 as i32;
pub const STATUS_UNRECOGNIZED_MEDIA: ::NTSTATUS = 0xC0000014u32 as i32;
pub const STATUS_NONEXISTENT_SECTOR: ::NTSTATUS = 0xC0000015u32 as i32;
pub const STATUS_MORE_PROCESSING_REQUIRED: ::NTSTATUS = 0xC0000016u32 as i32;
pub const STATUS_NO_MEMORY: ::NTSTATUS = 0xC0000017u32 as i32;
pub const STATUS_CONFLICTING_ADDRESSES: ::NTSTATUS = 0xC0000018u32 as i32;
pub const STATUS_NOT_MAPPED_VIEW: ::NTSTATUS = 0xC0000019u32 as i32;
pub const STATUS_UNABLE_TO_FREE_VM: ::NTSTATUS = 0xC000001Au32 as i32;
pub const STATUS_UNABLE_TO_DELETE_SECTION: ::NTSTATUS = 0xC000001Bu32 as i32;
pub const STATUS_INVALID_SYSTEM_SERVICE: ::NTSTATUS = 0xC000001Cu32 as i32;
pub const STATUS_ILLEGAL_INSTRUCTION: ::NTSTATUS = 0xC000001Du32 as i32;
pub const STATUS_INVALID_LOCK_SEQUENCE: ::NTSTATUS = 0xC000001Eu32 as i32;
pub const STATUS_INVALID_VIEW_SIZE: ::NTSTATUS = 0xC000001Fu32 as i32;
pub const STATUS_INVALID_FILE_FOR_SECTION: ::NTSTATUS = 0xC0000020u32 as i32;
pub const STATUS_ALREADY_COMMITTED: ::NTSTATUS = 0xC0000021u32 as i32;
pub const STATUS_ACCESS_DENIED: ::NTSTATUS = 0xC0000022u32 as i32;
pub const STATUS_BUFFER_TOO_SMALL: ::NTSTATUS = 0xC0000023u32 as i32;
pub const STATUS_OBJECT_TYPE_MISMATCH: ::NTSTATUS = 0xC0000024u32 as i32;
pub const STATUS_NONCONTINUABLE_EXCEPTION: ::NTSTATUS = 0xC0000025u32 as i32;
pub const STATUS_INVALID_DISPOSITION: ::NTSTATUS = 0xC0000026u32 as i32;
pub const STATUS_UNWIND: ::NTSTATUS = 0xC0000027u32 as i32;
pub const STATUS_BAD_STACK: ::NTSTATUS = 0xC0000028u32 as i32;
pub const STATUS_INVALID_UNWIND_TARGET: ::NTSTATUS = 0xC0000029u32 as i32;
pub const STATUS_NOT_LOCKED: ::NTSTATUS = 0xC000002Au32 as i32;
pub const STATUS_PARITY_ERROR: ::NTSTATUS = 0xC000002Bu32 as i32;
pub const STATUS_UNABLE_TO_DECOMMIT_VM: ::NTSTATUS = 0xC000002Cu32 as i32;
pub const STATUS_NOT_COMMITTED: ::NTSTATUS = 0xC000002Du32 as i32;
pub const STATUS_INVALID_PORT_ATTRIBUTES: ::NTSTATUS = 0xC000002Eu32 as i32;
pub const STATUS_PORT_MESSAGE_TOO_LONG: ::NTSTATUS = 0xC000002Fu32 as i32;
pub const STATUS_INVALID_PARAMETER_MIX: ::NTSTATUS = 0xC0000030u32 as i32;
pub const STATUS_INVALID_QUOTA_LOWER: ::NTSTATUS = 0xC0000031u32 as i32;
pub const STATUS_DISK_CORRUPT_ERROR: ::NTSTATUS = 0xC0000032u32 as i32;
pub const STATUS_OBJECT_NAME_INVALID: ::NTSTATUS = 0xC0000033u32 as i32;
pub const STATUS_OBJECT_NAME_NOT_FOUND: ::NTSTATUS = 0xC0000034u32 as i32;
pub const STATUS_OBJECT_NAME_COLLISION: ::NTSTATUS = 0xC0000035u32 as i32;
pub const STATUS_PORT_DO_NOT_DISTURB: ::NTSTATUS = 0xC0000036u32 as i32;
pub const STATUS_PORT_DISCONNECTED: ::NTSTATUS = 0xC0000037u32 as i32;
pub const STATUS_DEVICE_ALREADY_ATTACHED: ::NTSTATUS = 0xC0000038u32 as i32;
pub const STATUS_OBJECT_PATH_INVALID: ::NTSTATUS = 0xC0000039u32 as i32;
pub const STATUS_OBJECT_PATH_NOT_FOUND: ::NTSTATUS = 0xC000003Au32 as i32;
pub const STATUS_OBJECT_PATH_SYNTAX_BAD: ::NTSTATUS = 0xC000003Bu32 as i32;
pub const STATUS_DATA_OVERRUN: ::NTSTATUS = 0xC000003Cu32 as i32;
pub const STATUS_DATA_LATE_ERROR: ::NTSTATUS = 0xC000003Du32 as i32;
pub const STATUS_DATA_ERROR: ::NTSTATUS = 0xC000003Eu32 as i32;
pub const STATUS_CRC_ERROR: ::NTSTATUS = 0xC000003Fu32 as i32;
pub const STATUS_SECTION_TOO_BIG: ::NTSTATUS = 0xC0000040u32 as i32;
pub const STATUS_PORT_CONNECTION_REFUSED: ::NTSTATUS = 0xC0000041u32 as i32;
pub const STATUS_INVALID_PORT_HANDLE: ::NTSTATUS = 0xC0000042u32 as i32;
pub const STATUS_SHARING_VIOLATION: ::NTSTATUS = 0xC0000043u32 as i32;
pub const STATUS_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000044u32 as i32;
pub const STATUS_INVALID_PAGE_PROTECTION: ::NTSTATUS = 0xC0000045u32 as i32;
pub const STATUS_MUTANT_NOT_OWNED: ::NTSTATUS = 0xC0000046u32 as i32;
pub const STATUS_SEMAPHORE_LIMIT_EXCEEDED: ::NTSTATUS = 0xC0000047u32 as i32;
pub const STATUS_PORT_ALREADY_SET: ::NTSTATUS = 0xC0000048u32 as i32;
pub const STATUS_SECTION_NOT_IMAGE: ::NTSTATUS = 0xC0000049u32 as i32;
pub const STATUS_SUSPEND_COUNT_EXCEEDED: ::NTSTATUS = 0xC000004Au32 as i32;
pub const STATUS_THREAD_IS_TERMINATING: ::NTSTATUS = 0xC000004Bu32 as i32;
pub const STATUS_BAD_WORKING_SET_LIMIT: ::NTSTATUS = 0xC000004Cu32 as i32;
pub const STATUS_INCOMPATIBLE_FILE_MAP: ::NTSTATUS = 0xC000004Du32 as i32;
pub const STATUS_SECTION_PROTECTION: ::NTSTATUS = 0xC000004Eu32 as i32;
pub const STATUS_EAS_NOT_SUPPORTED: ::NTSTATUS = 0xC000004Fu32 as i32;
pub const STATUS_EA_TOO_LARGE: ::NTSTATUS = 0xC0000050u32 as i32;
pub const STATUS_NONEXISTENT_EA_ENTRY: ::NTSTATUS = 0xC0000051u32 as i32;
pub const STATUS_NO_EAS_ON_FILE: ::NTSTATUS = 0xC0000052u32 as i32;
pub const STATUS_EA_CORRUPT_ERROR: ::NTSTATUS = 0xC0000053u32 as i32;
pub const STATUS_FILE_LOCK_CONFLICT: ::NTSTATUS = 0xC0000054u32 as i32;
pub const STATUS_LOCK_NOT_GRANTED: ::NTSTATUS = 0xC0000055u32 as i32;
pub const STATUS_DELETE_PENDING: ::NTSTATUS = 0xC0000056u32 as i32;
pub const STATUS_CTL_FILE_NOT_SUPPORTED: ::NTSTATUS = 0xC0000057u32 as i32;
pub const STATUS_UNKNOWN_REVISION: ::NTSTATUS = 0xC0000058u32 as i32;
pub const STATUS_REVISION_MISMATCH: ::NTSTATUS = 0xC0000059u32 as i32;
pub const STATUS_INVALID_OWNER: ::NTSTATUS = 0xC000005Au32 as i32;
pub const STATUS_INVALID_PRIMARY_GROUP: ::NTSTATUS = 0xC000005Bu32 as i32;
pub const STATUS_NO_IMPERSONATION_TOKEN: ::NTSTATUS = 0xC000005Cu32 as i32;
pub const STATUS_CANT_DISABLE_MANDATORY: ::NTSTATUS = 0xC000005Du32 as i32;
pub const STATUS_NO_LOGON_SERVERS: ::NTSTATUS = 0xC000005Eu32 as i32;
pub const STATUS_NO_SUCH_LOGON_SESSION: ::NTSTATUS = 0xC000005Fu32 as i32;
pub const STATUS_NO_SUCH_PRIVILEGE: ::NTSTATUS = 0xC0000060u32 as i32;
pub const STATUS_PRIVILEGE_NOT_HELD: ::NTSTATUS = 0xC0000061u32 as i32;
pub const STATUS_INVALID_ACCOUNT_NAME: ::NTSTATUS = 0xC0000062u32 as i32;
pub const STATUS_USER_EXISTS: ::NTSTATUS = 0xC0000063u32 as i32;
pub const STATUS_NO_SUCH_USER: ::NTSTATUS = 0xC0000064u32 as i32;
pub const STATUS_GROUP_EXISTS: ::NTSTATUS = 0xC0000065u32 as i32;
pub const STATUS_NO_SUCH_GROUP: ::NTSTATUS = 0xC0000066u32 as i32;
pub const STATUS_MEMBER_IN_GROUP: ::NTSTATUS = 0xC0000067u32 as i32;
pub const STATUS_MEMBER_NOT_IN_GROUP: ::NTSTATUS = 0xC0000068u32 as i32;
pub const STATUS_LAST_ADMIN: ::NTSTATUS = 0xC0000069u32 as i32;
pub const STATUS_WRONG_PASSWORD: ::NTSTATUS = 0xC000006Au32 as i32;
pub const STATUS_ILL_FORMED_PASSWORD: ::NTSTATUS = 0xC000006Bu32 as i32;
pub const STATUS_PASSWORD_RESTRICTION: ::NTSTATUS = 0xC000006Cu32 as i32;
pub const STATUS_LOGON_FAILURE: ::NTSTATUS = 0xC000006Du32 as i32;
pub const STATUS_ACCOUNT_RESTRICTION: ::NTSTATUS = 0xC000006Eu32 as i32;
pub const STATUS_INVALID_LOGON_HOURS: ::NTSTATUS = 0xC000006Fu32 as i32;
pub const STATUS_INVALID_WORKSTATION: ::NTSTATUS = 0xC0000070u32 as i32;
pub const STATUS_PASSWORD_EXPIRED: ::NTSTATUS = 0xC0000071u32 as i32;
pub const STATUS_ACCOUNT_DISABLED: ::NTSTATUS = 0xC0000072u32 as i32;
pub const STATUS_NONE_MAPPED: ::NTSTATUS = 0xC0000073u32 as i32;
pub const STATUS_TOO_MANY_LUIDS_REQUESTED: ::NTSTATUS = 0xC0000074u32 as i32;
pub const STATUS_LUIDS_EXHAUSTED: ::NTSTATUS = 0xC0000075u32 as i32;
pub const STATUS_INVALID_SUB_AUTHORITY: ::NTSTATUS = 0xC0000076u32 as i32;
pub const STATUS_INVALID_ACL: ::NTSTATUS = 0xC0000077u32 as i32;
pub const STATUS_INVALID_SID: ::NTSTATUS = 0xC0000078u32 as i32;
pub const STATUS_INVALID_SECURITY_DESCR: ::NTSTATUS = 0xC0000079u32 as i32;
pub const STATUS_PROCEDURE_NOT_FOUND: ::NTSTATUS = 0xC000007Au32 as i32;
pub const STATUS_INVALID_IMAGE_FORMAT: ::NTSTATUS = 0xC000007Bu32 as i32;
pub const STATUS_NO_TOKEN: ::NTSTATUS = 0xC000007Cu32 as i32;
pub const STATUS_BAD_INHERITANCE_ACL: ::NTSTATUS = 0xC000007Du32 as i32;
pub const STATUS_RANGE_NOT_LOCKED: ::NTSTATUS = 0xC000007Eu32 as i32;
pub const STATUS_DISK_FULL: ::NTSTATUS = 0xC000007Fu32 as i32;
pub const STATUS_SERVER_DISABLED: ::NTSTATUS = 0xC0000080u32 as i32;
pub const STATUS_SERVER_NOT_DISABLED: ::NTSTATUS = 0xC0000081u32 as i32;
pub const STATUS_TOO_MANY_GUIDS_REQUESTED: ::NTSTATUS = 0xC0000082u32 as i32;
pub const STATUS_GUIDS_EXHAUSTED: ::NTSTATUS = 0xC0000083u32 as i32;
pub const STATUS_INVALID_ID_AUTHORITY: ::NTSTATUS = 0xC0000084u32 as i32;
pub const STATUS_AGENTS_EXHAUSTED: ::NTSTATUS = 0xC0000085u32 as i32;
pub const STATUS_INVALID_VOLUME_LABEL: ::NTSTATUS = 0xC0000086u32 as i32;
pub const STATUS_SECTION_NOT_EXTENDED: ::NTSTATUS = 0xC0000087u32 as i32;
pub const STATUS_NOT_MAPPED_DATA: ::NTSTATUS = 0xC0000088u32 as i32;
pub const STATUS_RESOURCE_DATA_NOT_FOUND: ::NTSTATUS = 0xC0000089u32 as i32;
pub const STATUS_RESOURCE_TYPE_NOT_FOUND: ::NTSTATUS = 0xC000008Au32 as i32;
pub const STATUS_RESOURCE_NAME_NOT_FOUND: ::NTSTATUS = 0xC000008Bu32 as i32;
pub const STATUS_ARRAY_BOUNDS_EXCEEDED: ::NTSTATUS = 0xC000008Cu32 as i32;
pub const STATUS_FLOAT_DENORMAL_OPERAND: ::NTSTATUS = 0xC000008Du32 as i32;
pub const STATUS_FLOAT_DIVIDE_BY_ZERO: ::NTSTATUS = 0xC000008Eu32 as i32;
pub const STATUS_FLOAT_INEXACT_RESULT: ::NTSTATUS = 0xC000008Fu32 as i32;
pub const STATUS_FLOAT_INVALID_OPERATION: ::NTSTATUS = 0xC0000090u32 as i32;
pub const STATUS_FLOAT_OVERFLOW: ::NTSTATUS = 0xC0000091u32 as i32;
pub const STATUS_FLOAT_STACK_CHECK: ::NTSTATUS = 0xC0000092u32 as i32;
pub const STATUS_FLOAT_UNDERFLOW: ::NTSTATUS = 0xC0000093u32 as i32;
pub const STATUS_INTEGER_DIVIDE_BY_ZERO: ::NTSTATUS = 0xC0000094u32 as i32;
pub const STATUS_INTEGER_OVERFLOW: ::NTSTATUS = 0xC0000095u32 as i32;
pub const STATUS_PRIVILEGED_INSTRUCTION: ::NTSTATUS = 0xC0000096u32 as i32;
pub const STATUS_TOO_MANY_PAGING_FILES: ::NTSTATUS = 0xC0000097u32 as i32;
pub const STATUS_FILE_INVALID: ::NTSTATUS = 0xC0000098u32 as i32;
pub const STATUS_ALLOTTED_SPACE_EXCEEDED: ::NTSTATUS = 0xC0000099u32 as i32;
pub const STATUS_INSUFFICIENT_RESOURCES: ::NTSTATUS = 0xC000009Au32 as i32;
pub const STATUS_DFS_EXIT_PATH_FOUND: ::NTSTATUS = 0xC000009Bu32 as i32;
pub const STATUS_DEVICE_DATA_ERROR: ::NTSTATUS = 0xC000009Cu32 as i32;
pub const STATUS_DEVICE_NOT_CONNECTED: ::NTSTATUS = 0xC000009Du32 as i32;
pub const STATUS_DEVICE_POWER_FAILURE: ::NTSTATUS = 0xC000009Eu32 as i32;
pub const STATUS_FREE_VM_NOT_AT_BASE: ::NTSTATUS = 0xC000009Fu32 as i32;
pub const STATUS_MEMORY_NOT_ALLOCATED: ::NTSTATUS = 0xC00000A0u32 as i32;
pub const STATUS_WORKING_SET_QUOTA: ::NTSTATUS = 0xC00000A1u32 as i32;
pub const STATUS_MEDIA_WRITE_PROTECTED: ::NTSTATUS = 0xC00000A2u32 as i32;
pub const STATUS_DEVICE_NOT_READY: ::NTSTATUS = 0xC00000A3u32 as i32;
pub const STATUS_INVALID_GROUP_ATTRIBUTES: ::NTSTATUS = 0xC00000A4u32 as i32;
pub const STATUS_BAD_IMPERSONATION_LEVEL: ::NTSTATUS = 0xC00000A5u32 as i32;
pub const STATUS_CANT_OPEN_ANONYMOUS: ::NTSTATUS = 0xC00000A6u32 as i32;
pub const STATUS_BAD_VALIDATION_CLASS: ::NTSTATUS = 0xC00000A7u32 as i32;
pub const STATUS_BAD_TOKEN_TYPE: ::NTSTATUS = 0xC00000A8u32 as i32;
pub const STATUS_BAD_MASTER_BOOT_RECORD: ::NTSTATUS = 0xC00000A9u32 as i32;
pub const STATUS_INSTRUCTION_MISALIGNMENT: ::NTSTATUS = 0xC00000AAu32 as i32;
pub const STATUS_INSTANCE_NOT_AVAILABLE: ::NTSTATUS = 0xC00000ABu32 as i32;
pub const STATUS_PIPE_NOT_AVAILABLE: ::NTSTATUS = 0xC00000ACu32 as i32;
pub const STATUS_INVALID_PIPE_STATE: ::NTSTATUS = 0xC00000ADu32 as i32;
pub const STATUS_PIPE_BUSY: ::NTSTATUS = 0xC00000AEu32 as i32;
pub const STATUS_ILLEGAL_FUNCTION: ::NTSTATUS = 0xC00000AFu32 as i32;
pub const STATUS_PIPE_DISCONNECTED: ::NTSTATUS = 0xC00000B0u32 as i32;
pub const STATUS_PIPE_CLOSING: ::NTSTATUS = 0xC00000B1u32 as i32;
pub const STATUS_PIPE_CONNECTED: ::NTSTATUS = 0xC00000B2u32 as i32;
pub const STATUS_PIPE_LISTENING: ::NTSTATUS = 0xC00000B3u32 as i32;
pub const STATUS_INVALID_READ_MODE: ::NTSTATUS = 0xC00000B4u32 as i32;
pub const STATUS_IO_TIMEOUT: ::NTSTATUS = 0xC00000B5u32 as i32;
pub const STATUS_FILE_FORCED_CLOSED: ::NTSTATUS = 0xC00000B6u32 as i32;
pub const STATUS_PROFILING_NOT_STARTED: ::NTSTATUS = 0xC00000B7u32 as i32;
pub const STATUS_PROFILING_NOT_STOPPED: ::NTSTATUS = 0xC00000B8u32 as i32;
pub const STATUS_COULD_NOT_INTERPRET: ::NTSTATUS = 0xC00000B9u32 as i32;
pub const STATUS_FILE_IS_A_DIRECTORY: ::NTSTATUS = 0xC00000BAu32 as i32;
pub const STATUS_NOT_SUPPORTED: ::NTSTATUS = 0xC00000BBu32 as i32;
pub const STATUS_REMOTE_NOT_LISTENING: ::NTSTATUS = 0xC00000BCu32 as i32;
pub const STATUS_DUPLICATE_NAME: ::NTSTATUS = 0xC00000BDu32 as i32;
pub const STATUS_BAD_NETWORK_PATH: ::NTSTATUS = 0xC00000BEu32 as i32;
pub const STATUS_NETWORK_BUSY: ::NTSTATUS = 0xC00000BFu32 as i32;
pub const STATUS_DEVICE_DOES_NOT_EXIST: ::NTSTATUS = 0xC00000C0u32 as i32;
pub const STATUS_TOO_MANY_COMMANDS: ::NTSTATUS = 0xC00000C1u32 as i32;
pub const STATUS_ADAPTER_HARDWARE_ERROR: ::NTSTATUS = 0xC00000C2u32 as i32;
pub const STATUS_INVALID_NETWORK_RESPONSE: ::NTSTATUS = 0xC00000C3u32 as i32;
pub const STATUS_UNEXPECTED_NETWORK_ERROR: ::NTSTATUS = 0xC00000C4u32 as i32;
pub const STATUS_BAD_REMOTE_ADAPTER: ::NTSTATUS = 0xC00000C5u32 as i32;
pub const STATUS_PRINT_QUEUE_FULL: ::NTSTATUS = 0xC00000C6u32 as i32;
pub const STATUS_NO_SPOOL_SPACE: ::NTSTATUS = 0xC00000C7u32 as i32;
pub const STATUS_PRINT_CANCELLED: ::NTSTATUS = 0xC00000C8u32 as i32;
pub const STATUS_NETWORK_NAME_DELETED: ::NTSTATUS = 0xC00000C9u32 as i32;
pub const STATUS_NETWORK_ACCESS_DENIED: ::NTSTATUS = 0xC00000CAu32 as i32;
pub const STATUS_BAD_DEVICE_TYPE: ::NTSTATUS = 0xC00000CBu32 as i32;
pub const STATUS_BAD_NETWORK_NAME: ::NTSTATUS = 0xC00000CCu32 as i32;
pub const STATUS_TOO_MANY_NAMES: ::NTSTATUS = 0xC00000CDu32 as i32;
pub const STATUS_TOO_MANY_SESSIONS: ::NTSTATUS = 0xC00000CEu32 as i32;
pub const STATUS_SHARING_PAUSED: ::NTSTATUS = 0xC00000CFu32 as i32;
pub const STATUS_REQUEST_NOT_ACCEPTED: ::NTSTATUS = 0xC00000D0u32 as i32;
pub const STATUS_REDIRECTOR_PAUSED: ::NTSTATUS = 0xC00000D1u32 as i32;
pub const STATUS_NET_WRITE_FAULT: ::NTSTATUS = 0xC00000D2u32 as i32;
pub const STATUS_PROFILING_AT_LIMIT: ::NTSTATUS = 0xC00000D3u32 as i32;
pub const STATUS_NOT_SAME_DEVICE: ::NTSTATUS = 0xC00000D4u32 as i32;
pub const STATUS_FILE_RENAMED: ::NTSTATUS = 0xC00000D5u32 as i32;
pub const STATUS_VIRTUAL_CIRCUIT_CLOSED: ::NTSTATUS = 0xC00000D6u32 as i32;
pub const STATUS_NO_SECURITY_ON_OBJECT: ::NTSTATUS = 0xC00000D7u32 as i32;
pub const STATUS_CANT_WAIT: ::NTSTATUS = 0xC00000D8u32 as i32;
pub const STATUS_PIPE_EMPTY: ::NTSTATUS = 0xC00000D9u32 as i32;
pub const STATUS_CANT_ACCESS_DOMAIN_INFO: ::NTSTATUS = 0xC00000DAu32 as i32;
pub const STATUS_CANT_TERMINATE_SELF: ::NTSTATUS = 0xC00000DBu32 as i32;
pub const STATUS_INVALID_SERVER_STATE: ::NTSTATUS = 0xC00000DCu32 as i32;
pub const STATUS_INVALID_DOMAIN_STATE: ::NTSTATUS = 0xC00000DDu32 as i32;
pub const STATUS_INVALID_DOMAIN_ROLE: ::NTSTATUS = 0xC00000DEu32 as i32;
pub const STATUS_NO_SUCH_DOMAIN: ::NTSTATUS = 0xC00000DFu32 as i32;
pub const STATUS_DOMAIN_EXISTS: ::NTSTATUS = 0xC00000E0u32 as i32;
pub const STATUS_DOMAIN_LIMIT_EXCEEDED: ::NTSTATUS = 0xC00000E1u32 as i32;
pub const STATUS_OPLOCK_NOT_GRANTED: ::NTSTATUS = 0xC00000E2u32 as i32;
pub const STATUS_INVALID_OPLOCK_PROTOCOL: ::NTSTATUS = 0xC00000E3u32 as i32;
pub const STATUS_INTERNAL_DB_CORRUPTION: ::NTSTATUS = 0xC00000E4u32 as i32;
pub const STATUS_INTERNAL_ERROR: ::NTSTATUS = 0xC00000E5u32 as i32;
pub const STATUS_GENERIC_NOT_MAPPED: ::NTSTATUS = 0xC00000E6u32 as i32;
pub const STATUS_BAD_DESCRIPTOR_FORMAT: ::NTSTATUS = 0xC00000E7u32 as i32;
pub const STATUS_INVALID_USER_BUFFER: ::NTSTATUS = 0xC00000E8u32 as i32;
pub const STATUS_UNEXPECTED_IO_ERROR: ::NTSTATUS = 0xC00000E9u32 as i32;
pub const STATUS_UNEXPECTED_MM_CREATE_ERR: ::NTSTATUS = 0xC00000EAu32 as i32;
pub const STATUS_UNEXPECTED_MM_MAP_ERROR: ::NTSTATUS = 0xC00000EBu32 as i32;
pub const STATUS_UNEXPECTED_MM_EXTEND_ERR: ::NTSTATUS = 0xC00000ECu32 as i32;
pub const STATUS_NOT_LOGON_PROCESS: ::NTSTATUS = 0xC00000EDu32 as i32;
pub const STATUS_LOGON_SESSION_EXISTS: ::NTSTATUS = 0xC00000EEu32 as i32;
pub const STATUS_INVALID_PARAMETER_1: ::NTSTATUS = 0xC00000EFu32 as i32;
pub const STATUS_INVALID_PARAMETER_2: ::NTSTATUS = 0xC00000F0u32 as i32;
pub const STATUS_INVALID_PARAMETER_3: ::NTSTATUS = 0xC00000F1u32 as i32;
pub const STATUS_INVALID_PARAMETER_4: ::NTSTATUS = 0xC00000F2u32 as i32;
pub const STATUS_INVALID_PARAMETER_5: ::NTSTATUS = 0xC00000F3u32 as i32;
pub const STATUS_INVALID_PARAMETER_6: ::NTSTATUS = 0xC00000F4u32 as i32;
pub const STATUS_INVALID_PARAMETER_7: ::NTSTATUS = 0xC00000F5u32 as i32;
pub const STATUS_INVALID_PARAMETER_8: ::NTSTATUS = 0xC00000F6u32 as i32;
pub const STATUS_INVALID_PARAMETER_9: ::NTSTATUS = 0xC00000F7u32 as i32;
pub const STATUS_INVALID_PARAMETER_10: ::NTSTATUS = 0xC00000F8u32 as i32;
pub const STATUS_INVALID_PARAMETER_11: ::NTSTATUS = 0xC00000F9u32 as i32;
pub const STATUS_INVALID_PARAMETER_12: ::NTSTATUS = 0xC00000FAu32 as i32;
pub const STATUS_REDIRECTOR_NOT_STARTED: ::NTSTATUS = 0xC00000FBu32 as i32;
pub const STATUS_REDIRECTOR_STARTED: ::NTSTATUS = 0xC00000FCu32 as i32;
pub const STATUS_STACK_OVERFLOW: ::NTSTATUS = 0xC00000FDu32 as i32;
pub const STATUS_NO_SUCH_PACKAGE: ::NTSTATUS = 0xC00000FEu32 as i32;
pub const STATUS_BAD_FUNCTION_TABLE: ::NTSTATUS = 0xC00000FFu32 as i32;
pub const STATUS_VARIABLE_NOT_FOUND: ::NTSTATUS = 0xC0000100u32 as i32;
pub const STATUS_DIRECTORY_NOT_EMPTY: ::NTSTATUS = 0xC0000101u32 as i32;
pub const STATUS_FILE_CORRUPT_ERROR: ::NTSTATUS = 0xC0000102u32 as i32;
pub const STATUS_NOT_A_DIRECTORY: ::NTSTATUS = 0xC0000103u32 as i32;
pub const STATUS_BAD_LOGON_SESSION_STATE: ::NTSTATUS = 0xC0000104u32 as i32;
pub const STATUS_LOGON_SESSION_COLLISION: ::NTSTATUS = 0xC0000105u32 as i32;
pub const STATUS_NAME_TOO_LONG: ::NTSTATUS = 0xC0000106u32 as i32;
pub const STATUS_FILES_OPEN: ::NTSTATUS = 0xC0000107u32 as i32;
pub const STATUS_CONNECTION_IN_USE: ::NTSTATUS = 0xC0000108u32 as i32;
pub const STATUS_MESSAGE_NOT_FOUND: ::NTSTATUS = 0xC0000109u32 as i32;
pub const STATUS_PROCESS_IS_TERMINATING: ::NTSTATUS = 0xC000010Au32 as i32;
pub const STATUS_INVALID_LOGON_TYPE: ::NTSTATUS = 0xC000010Bu32 as i32;
pub const STATUS_NO_GUID_TRANSLATION: ::NTSTATUS = 0xC000010Cu32 as i32;
pub const STATUS_CANNOT_IMPERSONATE: ::NTSTATUS = 0xC000010Du32 as i32;
pub const STATUS_IMAGE_ALREADY_LOADED: ::NTSTATUS = 0xC000010Eu32 as i32;
pub const STATUS_ABIOS_NOT_PRESENT: ::NTSTATUS = 0xC000010Fu32 as i32;
pub const STATUS_ABIOS_LID_NOT_EXIST: ::NTSTATUS = 0xC0000110u32 as i32;
pub const STATUS_ABIOS_LID_ALREADY_OWNED: ::NTSTATUS = 0xC0000111u32 as i32;
pub const STATUS_ABIOS_NOT_LID_OWNER: ::NTSTATUS = 0xC0000112u32 as i32;
pub const STATUS_ABIOS_INVALID_COMMAND: ::NTSTATUS = 0xC0000113u32 as i32;
pub const STATUS_ABIOS_INVALID_LID: ::NTSTATUS = 0xC0000114u32 as i32;
pub const STATUS_ABIOS_SELECTOR_NOT_AVAILABLE: ::NTSTATUS = 0xC0000115u32 as i32;
pub const STATUS_ABIOS_INVALID_SELECTOR: ::NTSTATUS = 0xC0000116u32 as i32;
pub const STATUS_NO_LDT: ::NTSTATUS = 0xC0000117u32 as i32;
pub const STATUS_INVALID_LDT_SIZE: ::NTSTATUS = 0xC0000118u32 as i32;
pub const STATUS_INVALID_LDT_OFFSET: ::NTSTATUS = 0xC0000119u32 as i32;
pub const STATUS_INVALID_LDT_DESCRIPTOR: ::NTSTATUS = 0xC000011Au32 as i32;
pub const STATUS_INVALID_IMAGE_NE_FORMAT: ::NTSTATUS = 0xC000011Bu32 as i32;
pub const STATUS_RXACT_INVALID_STATE: ::NTSTATUS = 0xC000011Cu32 as i32;
pub const STATUS_RXACT_COMMIT_FAILURE: ::NTSTATUS = 0xC000011Du32 as i32;
pub const STATUS_MAPPED_FILE_SIZE_ZERO: ::NTSTATUS = 0xC000011Eu32 as i32;
pub const STATUS_TOO_MANY_OPENED_FILES: ::NTSTATUS = 0xC000011Fu32 as i32;
pub const STATUS_CANCELLED: ::NTSTATUS = 0xC0000120u32 as i32;
pub const STATUS_CANNOT_DELETE: ::NTSTATUS = 0xC0000121u32 as i32;
pub const STATUS_INVALID_COMPUTER_NAME: ::NTSTATUS = 0xC0000122u32 as i32;
pub const STATUS_FILE_DELETED: ::NTSTATUS = 0xC0000123u32 as i32;
pub const STATUS_SPECIAL_ACCOUNT: ::NTSTATUS = 0xC0000124u32 as i32;
pub const STATUS_SPECIAL_GROUP: ::NTSTATUS = 0xC0000125u32 as i32;
pub const STATUS_SPECIAL_USER: ::NTSTATUS = 0xC0000126u32 as i32;
pub const STATUS_MEMBERS_PRIMARY_GROUP: ::NTSTATUS = 0xC0000127u32 as i32;
pub const STATUS_FILE_CLOSED: ::NTSTATUS = 0xC0000128u32 as i32;
pub const STATUS_TOO_MANY_THREADS: ::NTSTATUS = 0xC0000129u32 as i32;
pub const STATUS_THREAD_NOT_IN_PROCESS: ::NTSTATUS = 0xC000012Au32 as i32;
pub const STATUS_TOKEN_ALREADY_IN_USE: ::NTSTATUS = 0xC000012Bu32 as i32;
pub const STATUS_PAGEFILE_QUOTA_EXCEEDED: ::NTSTATUS = 0xC000012Cu32 as i32;
pub const STATUS_COMMITMENT_LIMIT: ::NTSTATUS = 0xC000012Du32 as i32;
pub const STATUS_INVALID_IMAGE_LE_FORMAT: ::NTSTATUS = 0xC000012Eu32 as i32;
pub const STATUS_INVALID_IMAGE_NOT_MZ: ::NTSTATUS = 0xC000012Fu32 as i32;
pub const STATUS_INVALID_IMAGE_PROTECT: ::NTSTATUS = 0xC0000130u32 as i32;
pub const STATUS_INVALID_IMAGE_WIN_16: ::NTSTATUS = 0xC0000131u32 as i32;
pub const STATUS_LOGON_SERVER_CONFLICT: ::NTSTATUS = 0xC0000132u32 as i32;
pub const STATUS_TIME_DIFFERENCE_AT_DC: ::NTSTATUS = 0xC0000133u32 as i32;
pub const STATUS_SYNCHRONIZATION_REQUIRED: ::NTSTATUS = 0xC0000134u32 as i32;
pub const STATUS_DLL_NOT_FOUND: ::NTSTATUS = 0xC0000135u32 as i32;
pub const STATUS_OPEN_FAILED: ::NTSTATUS = 0xC0000136u32 as i32;
pub const STATUS_IO_PRIVILEGE_FAILED: ::NTSTATUS = 0xC0000137u32 as i32;
pub const STATUS_ORDINAL_NOT_FOUND: ::NTSTATUS = 0xC0000138u32 as i32;
pub const STATUS_ENTRYPOINT_NOT_FOUND: ::NTSTATUS = 0xC0000139u32 as i32;
pub const STATUS_CONTROL_C_EXIT: ::NTSTATUS = 0xC000013Au32 as i32;
pub const STATUS_LOCAL_DISCONNECT: ::NTSTATUS = 0xC000013Bu32 as i32;
pub const STATUS_REMOTE_DISCONNECT: ::NTSTATUS = 0xC000013Cu32 as i32;
pub const STATUS_REMOTE_RESOURCES: ::NTSTATUS = 0xC000013Du32 as i32;
pub const STATUS_LINK_FAILED: ::NTSTATUS = 0xC000013Eu32 as i32;
pub const STATUS_LINK_TIMEOUT: ::NTSTATUS = 0xC000013Fu32 as i32;
pub const STATUS_INVALID_CONNECTION: ::NTSTATUS = 0xC0000140u32 as i32;
pub const STATUS_INVALID_ADDRESS: ::NTSTATUS = 0xC0000141u32 as i32;
pub const STATUS_DLL_INIT_FAILED: ::NTSTATUS = 0xC0000142u32 as i32;
pub const STATUS_MISSING_SYSTEMFILE: ::NTSTATUS = 0xC0000143u32 as i32;
pub const STATUS_UNHANDLED_EXCEPTION: ::NTSTATUS = 0xC0000144u32 as i32;
pub const STATUS_APP_INIT_FAILURE: ::NTSTATUS = 0xC0000145u32 as i32;
pub const STATUS_PAGEFILE_CREATE_FAILED: ::NTSTATUS = 0xC0000146u32 as i32;
pub const STATUS_NO_PAGEFILE: ::NTSTATUS = 0xC0000147u32 as i32;
pub const STATUS_INVALID_LEVEL: ::NTSTATUS = 0xC0000148u32 as i32;
pub const STATUS_WRONG_PASSWORD_CORE: ::NTSTATUS = 0xC0000149u32 as i32;
pub const STATUS_ILLEGAL_FLOAT_CONTEXT: ::NTSTATUS = 0xC000014Au32 as i32;
pub const STATUS_PIPE_BROKEN: ::NTSTATUS = 0xC000014Bu32 as i32;
pub const STATUS_REGISTRY_CORRUPT: ::NTSTATUS = 0xC000014Cu32 as i32;
pub const STATUS_REGISTRY_IO_FAILED: ::NTSTATUS = 0xC000014Du32 as i32;
pub const STATUS_NO_EVENT_PAIR: ::NTSTATUS = 0xC000014Eu32 as i32;
pub const STATUS_UNRECOGNIZED_VOLUME: ::NTSTATUS = 0xC000014Fu32 as i32;
pub const STATUS_SERIAL_NO_DEVICE_INITED: ::NTSTATUS = 0xC0000150u32 as i32;
pub const STATUS_NO_SUCH_ALIAS: ::NTSTATUS = 0xC0000151u32 as i32;
pub const STATUS_MEMBER_NOT_IN_ALIAS: ::NTSTATUS = 0xC0000152u32 as i32;
pub const STATUS_MEMBER_IN_ALIAS: ::NTSTATUS = 0xC0000153u32 as i32;
pub const STATUS_ALIAS_EXISTS: ::NTSTATUS = 0xC0000154u32 as i32;
pub const STATUS_LOGON_NOT_GRANTED: ::NTSTATUS = 0xC0000155u32 as i32;
pub const STATUS_TOO_MANY_SECRETS: ::NTSTATUS = 0xC0000156u32 as i32;
pub const STATUS_SECRET_TOO_LONG: ::NTSTATUS = 0xC0000157u32 as i32;
pub const STATUS_INTERNAL_DB_ERROR: ::NTSTATUS = 0xC0000158u32 as i32;
pub const STATUS_FULLSCREEN_MODE: ::NTSTATUS = 0xC0000159u32 as i32;
pub const STATUS_TOO_MANY_CONTEXT_IDS: ::NTSTATUS = 0xC000015Au32 as i32;
pub const STATUS_LOGON_TYPE_NOT_GRANTED: ::NTSTATUS = 0xC000015Bu32 as i32;
pub const STATUS_NOT_REGISTRY_FILE: ::NTSTATUS = 0xC000015Cu32 as i32;
pub const STATUS_NT_CROSS_ENCRYPTION_REQUIRED: ::NTSTATUS = 0xC000015Du32 as i32;
pub const STATUS_DOMAIN_CTRLR_CONFIG_ERROR: ::NTSTATUS = 0xC000015Eu32 as i32;
pub const STATUS_FT_MISSING_MEMBER: ::NTSTATUS = 0xC000015Fu32 as i32;
pub const STATUS_ILL_FORMED_SERVICE_ENTRY: ::NTSTATUS = 0xC0000160u32 as i32;
pub const STATUS_ILLEGAL_CHARACTER: ::NTSTATUS = 0xC0000161u32 as i32;
pub const STATUS_UNMAPPABLE_CHARACTER: ::NTSTATUS = 0xC0000162u32 as i32;
pub const STATUS_UNDEFINED_CHARACTER: ::NTSTATUS = 0xC0000163u32 as i32;
pub const STATUS_FLOPPY_VOLUME: ::NTSTATUS = 0xC0000164u32 as i32;
pub const STATUS_FLOPPY_ID_MARK_NOT_FOUND: ::NTSTATUS = 0xC0000165u32 as i32;
pub const STATUS_FLOPPY_WRONG_CYLINDER: ::NTSTATUS = 0xC0000166u32 as i32;
pub const STATUS_FLOPPY_UNKNOWN_ERROR: ::NTSTATUS = 0xC0000167u32 as i32;
pub const STATUS_FLOPPY_BAD_REGISTERS: ::NTSTATUS = 0xC0000168u32 as i32;
pub const STATUS_DISK_RECALIBRATE_FAILED: ::NTSTATUS = 0xC0000169u32 as i32;
pub const STATUS_DISK_OPERATION_FAILED: ::NTSTATUS = 0xC000016Au32 as i32;
pub const STATUS_DISK_RESET_FAILED: ::NTSTATUS = 0xC000016Bu32 as i32;
pub const STATUS_SHARED_IRQ_BUSY: ::NTSTATUS = 0xC000016Cu32 as i32;
pub const STATUS_FT_ORPHANING: ::NTSTATUS = 0xC000016Du32 as i32;
pub const STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT: ::NTSTATUS = 0xC000016Eu32 as i32;
pub const STATUS_PARTITION_FAILURE: ::NTSTATUS = 0xC0000172u32 as i32;
pub const STATUS_INVALID_BLOCK_LENGTH: ::NTSTATUS = 0xC0000173u32 as i32;
pub const STATUS_DEVICE_NOT_PARTITIONED: ::NTSTATUS = 0xC0000174u32 as i32;
pub const STATUS_UNABLE_TO_LOCK_MEDIA: ::NTSTATUS = 0xC0000175u32 as i32;
pub const STATUS_UNABLE_TO_UNLOAD_MEDIA: ::NTSTATUS = 0xC0000176u32 as i32;
pub const STATUS_EOM_OVERFLOW: ::NTSTATUS = 0xC0000177u32 as i32;
pub const STATUS_NO_MEDIA: ::NTSTATUS = 0xC0000178u32 as i32;
pub const STATUS_NO_SUCH_MEMBER: ::NTSTATUS = 0xC000017Au32 as i32;
pub const STATUS_INVALID_MEMBER: ::NTSTATUS = 0xC000017Bu32 as i32;
pub const STATUS_KEY_DELETED: ::NTSTATUS = 0xC000017Cu32 as i32;
pub const STATUS_NO_LOG_SPACE: ::NTSTATUS = 0xC000017Du32 as i32;
pub const STATUS_TOO_MANY_SIDS: ::NTSTATUS = 0xC000017Eu32 as i32;
pub const STATUS_LM_CROSS_ENCRYPTION_REQUIRED: ::NTSTATUS = 0xC000017Fu32 as i32;
pub const STATUS_KEY_HAS_CHILDREN: ::NTSTATUS = 0xC0000180u32 as i32;
pub const STATUS_CHILD_MUST_BE_VOLATILE: ::NTSTATUS = 0xC0000181u32 as i32;
pub const STATUS_DEVICE_CONFIGURATION_ERROR: ::NTSTATUS = 0xC0000182u32 as i32;
pub const STATUS_DRIVER_INTERNAL_ERROR: ::NTSTATUS = 0xC0000183u32 as i32;
pub const STATUS_INVALID_DEVICE_STATE: ::NTSTATUS = 0xC0000184u32 as i32;
pub const STATUS_IO_DEVICE_ERROR: ::NTSTATUS = 0xC0000185u32 as i32;
pub const STATUS_DEVICE_PROTOCOL_ERROR: ::NTSTATUS = 0xC0000186u32 as i32;
pub const STATUS_BACKUP_CONTROLLER: ::NTSTATUS = 0xC0000187u32 as i32;
pub const STATUS_LOG_FILE_FULL: ::NTSTATUS = 0xC0000188u32 as i32;
pub const STATUS_TOO_LATE: ::NTSTATUS = 0xC0000189u32 as i32;
pub const STATUS_NO_TRUST_LSA_SECRET: ::NTSTATUS = 0xC000018Au32 as i32;
pub const STATUS_NO_TRUST_SAM_ACCOUNT: ::NTSTATUS = 0xC000018Bu32 as i32;
pub const STATUS_TRUSTED_DOMAIN_FAILURE: ::NTSTATUS = 0xC000018Cu32 as i32;
pub const STATUS_TRUSTED_RELATIONSHIP_FAILURE: ::NTSTATUS = 0xC000018Du32 as i32;
pub const STATUS_EVENTLOG_FILE_CORRUPT: ::NTSTATUS = 0xC000018Eu32 as i32;
pub const STATUS_EVENTLOG_CANT_START: ::NTSTATUS = 0xC000018Fu32 as i32;
pub const STATUS_TRUST_FAILURE: ::NTSTATUS = 0xC0000190u32 as i32;
pub const STATUS_MUTANT_LIMIT_EXCEEDED: ::NTSTATUS = 0xC0000191u32 as i32;
pub const STATUS_NETLOGON_NOT_STARTED: ::NTSTATUS = 0xC0000192u32 as i32;
pub const STATUS_ACCOUNT_EXPIRED: ::NTSTATUS = 0xC0000193u32 as i32;
pub const STATUS_POSSIBLE_DEADLOCK: ::NTSTATUS = 0xC0000194u32 as i32;
pub const STATUS_NETWORK_CREDENTIAL_CONFLICT: ::NTSTATUS = 0xC0000195u32 as i32;
pub const STATUS_REMOTE_SESSION_LIMIT: ::NTSTATUS = 0xC0000196u32 as i32;
pub const STATUS_EVENTLOG_FILE_CHANGED: ::NTSTATUS = 0xC0000197u32 as i32;
pub const STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: ::NTSTATUS = 0xC0000198u32 as i32;
pub const STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT: ::NTSTATUS = 0xC0000199u32 as i32;
pub const STATUS_NOLOGON_SERVER_TRUST_ACCOUNT: ::NTSTATUS = 0xC000019Au32 as i32;
pub const STATUS_DOMAIN_TRUST_INCONSISTENT: ::NTSTATUS = 0xC000019Bu32 as i32;
pub const STATUS_FS_DRIVER_REQUIRED: ::NTSTATUS = 0xC000019Cu32 as i32;
pub const STATUS_IMAGE_ALREADY_LOADED_AS_DLL: ::NTSTATUS = 0xC000019Du32 as i32;
pub const STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING: ::NTSTATUS = 0xC000019Eu32 as i32;
pub const STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME: ::NTSTATUS = 0xC000019Fu32 as i32;
pub const STATUS_SECURITY_STREAM_IS_INCONSISTENT: ::NTSTATUS = 0xC00001A0u32 as i32;
pub const STATUS_INVALID_LOCK_RANGE: ::NTSTATUS = 0xC00001A1u32 as i32;
pub const STATUS_INVALID_ACE_CONDITION: ::NTSTATUS = 0xC00001A2u32 as i32;
pub const STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT: ::NTSTATUS = 0xC00001A3u32 as i32;
pub const STATUS_NOTIFICATION_GUID_ALREADY_DEFINED: ::NTSTATUS = 0xC00001A4u32 as i32;
pub const STATUS_INVALID_EXCEPTION_HANDLER: ::NTSTATUS = 0xC00001A5u32 as i32;
pub const STATUS_DUPLICATE_PRIVILEGES: ::NTSTATUS = 0xC00001A6u32 as i32;
pub const STATUS_NOT_ALLOWED_ON_SYSTEM_FILE: ::NTSTATUS = 0xC00001A7u32 as i32;
pub const STATUS_REPAIR_NEEDED: ::NTSTATUS = 0xC00001A8u32 as i32;
pub const STATUS_QUOTA_NOT_ENABLED: ::NTSTATUS = 0xC00001A9u32 as i32;
pub const STATUS_NO_APPLICATION_PACKAGE: ::NTSTATUS = 0xC00001AAu32 as i32;
pub const STATUS_FILE_METADATA_OPTIMIZATION_IN_PROGRESS: ::NTSTATUS = 0xC00001ABu32 as i32;
pub const STATUS_NOT_SAME_OBJECT: ::NTSTATUS = 0xC00001ACu32 as i32;
pub const STATUS_FATAL_MEMORY_EXHAUSTION: ::NTSTATUS = 0xC00001ADu32 as i32;
pub const STATUS_ERROR_PROCESS_NOT_IN_JOB: ::NTSTATUS = 0xC00001AEu32 as i32;
pub const STATUS_NETWORK_OPEN_RESTRICTION: ::NTSTATUS = 0xC0000201u32 as i32;
pub const STATUS_NO_USER_SESSION_KEY: ::NTSTATUS = 0xC0000202u32 as i32;
pub const STATUS_USER_SESSION_DELETED: ::NTSTATUS = 0xC0000203u32 as i32;
pub const STATUS_RESOURCE_LANG_NOT_FOUND: ::NTSTATUS = 0xC0000204u32 as i32;
pub const STATUS_INSUFF_SERVER_RESOURCES: ::NTSTATUS = 0xC0000205u32 as i32;
pub const STATUS_INVALID_BUFFER_SIZE: ::NTSTATUS = 0xC0000206u32 as i32;
pub const STATUS_INVALID_ADDRESS_COMPONENT: ::NTSTATUS = 0xC0000207u32 as i32;
pub const STATUS_INVALID_ADDRESS_WILDCARD: ::NTSTATUS = 0xC0000208u32 as i32;
pub const STATUS_TOO_MANY_ADDRESSES: ::NTSTATUS = 0xC0000209u32 as i32;
pub const STATUS_ADDRESS_ALREADY_EXISTS: ::NTSTATUS = 0xC000020Au32 as i32;
pub const STATUS_ADDRESS_CLOSED: ::NTSTATUS = 0xC000020Bu32 as i32;
pub const STATUS_CONNECTION_DISCONNECTED: ::NTSTATUS = 0xC000020Cu32 as i32;
pub const STATUS_CONNECTION_RESET: ::NTSTATUS = 0xC000020Du32 as i32;
pub const STATUS_TOO_MANY_NODES: ::NTSTATUS = 0xC000020Eu32 as i32;
pub const STATUS_TRANSACTION_ABORTED: ::NTSTATUS = 0xC000020Fu32 as i32;
pub const STATUS_TRANSACTION_TIMED_OUT: ::NTSTATUS = 0xC0000210u32 as i32;
pub const STATUS_TRANSACTION_NO_RELEASE: ::NTSTATUS = 0xC0000211u32 as i32;
pub const STATUS_TRANSACTION_NO_MATCH: ::NTSTATUS = 0xC0000212u32 as i32;
pub const STATUS_TRANSACTION_RESPONDED: ::NTSTATUS = 0xC0000213u32 as i32;
pub const STATUS_TRANSACTION_INVALID_ID: ::NTSTATUS = 0xC0000214u32 as i32;
pub const STATUS_TRANSACTION_INVALID_TYPE: ::NTSTATUS = 0xC0000215u32 as i32;
pub const STATUS_NOT_SERVER_SESSION: ::NTSTATUS = 0xC0000216u32 as i32;
pub const STATUS_NOT_CLIENT_SESSION: ::NTSTATUS = 0xC0000217u32 as i32;
pub const STATUS_CANNOT_LOAD_REGISTRY_FILE: ::NTSTATUS = 0xC0000218u32 as i32;
pub const STATUS_DEBUG_ATTACH_FAILED: ::NTSTATUS = 0xC0000219u32 as i32;
pub const STATUS_SYSTEM_PROCESS_TERMINATED: ::NTSTATUS = 0xC000021Au32 as i32;
pub const STATUS_DATA_NOT_ACCEPTED: ::NTSTATUS = 0xC000021Bu32 as i32;
pub const STATUS_NO_BROWSER_SERVERS_FOUND: ::NTSTATUS = 0xC000021Cu32 as i32;
pub const STATUS_VDM_HARD_ERROR: ::NTSTATUS = 0xC000021Du32 as i32;
pub const STATUS_DRIVER_CANCEL_TIMEOUT: ::NTSTATUS = 0xC000021Eu32 as i32;
pub const STATUS_REPLY_MESSAGE_MISMATCH: ::NTSTATUS = 0xC000021Fu32 as i32;
pub const STATUS_MAPPED_ALIGNMENT: ::NTSTATUS = 0xC0000220u32 as i32;
pub const STATUS_IMAGE_CHECKSUM_MISMATCH: ::NTSTATUS = 0xC0000221u32 as i32;
pub const STATUS_LOST_WRITEBEHIND_DATA: ::NTSTATUS = 0xC0000222u32 as i32;
pub const STATUS_CLIENT_SERVER_PARAMETERS_INVALID: ::NTSTATUS = 0xC0000223u32 as i32;
pub const STATUS_PASSWORD_MUST_CHANGE: ::NTSTATUS = 0xC0000224u32 as i32;
pub const STATUS_NOT_FOUND: ::NTSTATUS = 0xC0000225u32 as i32;
pub const STATUS_NOT_TINY_STREAM: ::NTSTATUS = 0xC0000226u32 as i32;
pub const STATUS_RECOVERY_FAILURE: ::NTSTATUS = 0xC0000227u32 as i32;
pub const STATUS_STACK_OVERFLOW_READ: ::NTSTATUS = 0xC0000228u32 as i32;
pub const STATUS_FAIL_CHECK: ::NTSTATUS = 0xC0000229u32 as i32;
pub const STATUS_DUPLICATE_OBJECTID: ::NTSTATUS = 0xC000022Au32 as i32;
pub const STATUS_OBJECTID_EXISTS: ::NTSTATUS = 0xC000022Bu32 as i32;
pub const STATUS_CONVERT_TO_LARGE: ::NTSTATUS = 0xC000022Cu32 as i32;
pub const STATUS_RETRY: ::NTSTATUS = 0xC000022Du32 as i32;
pub const STATUS_FOUND_OUT_OF_SCOPE: ::NTSTATUS = 0xC000022Eu32 as i32;
pub const STATUS_ALLOCATE_BUCKET: ::NTSTATUS = 0xC000022Fu32 as i32;
pub const STATUS_PROPSET_NOT_FOUND: ::NTSTATUS = 0xC0000230u32 as i32;
pub const STATUS_MARSHALL_OVERFLOW: ::NTSTATUS = 0xC0000231u32 as i32;
pub const STATUS_INVALID_VARIANT: ::NTSTATUS = 0xC0000232u32 as i32;
pub const STATUS_DOMAIN_CONTROLLER_NOT_FOUND: ::NTSTATUS = 0xC0000233u32 as i32;
pub const STATUS_ACCOUNT_LOCKED_OUT: ::NTSTATUS = 0xC0000234u32 as i32;
pub const STATUS_HANDLE_NOT_CLOSABLE: ::NTSTATUS = 0xC0000235u32 as i32;
pub const STATUS_CONNECTION_REFUSED: ::NTSTATUS = 0xC0000236u32 as i32;
pub const STATUS_GRACEFUL_DISCONNECT: ::NTSTATUS = 0xC0000237u32 as i32;
pub const STATUS_ADDRESS_ALREADY_ASSOCIATED: ::NTSTATUS = 0xC0000238u32 as i32;
pub const STATUS_ADDRESS_NOT_ASSOCIATED: ::NTSTATUS = 0xC0000239u32 as i32;
pub const STATUS_CONNECTION_INVALID: ::NTSTATUS = 0xC000023Au32 as i32;
pub const STATUS_CONNECTION_ACTIVE: ::NTSTATUS = 0xC000023Bu32 as i32;
pub const STATUS_NETWORK_UNREACHABLE: ::NTSTATUS = 0xC000023Cu32 as i32;
pub const STATUS_HOST_UNREACHABLE: ::NTSTATUS = 0xC000023Du32 as i32;
pub const STATUS_PROTOCOL_UNREACHABLE: ::NTSTATUS = 0xC000023Eu32 as i32;
pub const STATUS_PORT_UNREACHABLE: ::NTSTATUS = 0xC000023Fu32 as i32;
pub const STATUS_REQUEST_ABORTED: ::NTSTATUS = 0xC0000240u32 as i32;
pub const STATUS_CONNECTION_ABORTED: ::NTSTATUS = 0xC0000241u32 as i32;
pub const STATUS_BAD_COMPRESSION_BUFFER: ::NTSTATUS = 0xC0000242u32 as i32;
pub const STATUS_USER_MAPPED_FILE: ::NTSTATUS = 0xC0000243u32 as i32;
pub const STATUS_AUDIT_FAILED: ::NTSTATUS = 0xC0000244u32 as i32;
pub const STATUS_TIMER_RESOLUTION_NOT_SET: ::NTSTATUS = 0xC0000245u32 as i32;
pub const STATUS_CONNECTION_COUNT_LIMIT: ::NTSTATUS = 0xC0000246u32 as i32;
pub const STATUS_LOGIN_TIME_RESTRICTION: ::NTSTATUS = 0xC0000247u32 as i32;
pub const STATUS_LOGIN_WKSTA_RESTRICTION: ::NTSTATUS = 0xC0000248u32 as i32;
pub const STATUS_IMAGE_MP_UP_MISMATCH: ::NTSTATUS = 0xC0000249u32 as i32;
pub const STATUS_INSUFFICIENT_LOGON_INFO: ::NTSTATUS = 0xC0000250u32 as i32;
pub const STATUS_BAD_DLL_ENTRYPOINT: ::NTSTATUS = 0xC0000251u32 as i32;
pub const STATUS_BAD_SERVICE_ENTRYPOINT: ::NTSTATUS = 0xC0000252u32 as i32;
pub const STATUS_LPC_REPLY_LOST: ::NTSTATUS = 0xC0000253u32 as i32;
pub const STATUS_IP_ADDRESS_CONFLICT1: ::NTSTATUS = 0xC0000254u32 as i32;
pub const STATUS_IP_ADDRESS_CONFLICT2: ::NTSTATUS = 0xC0000255u32 as i32;
pub const STATUS_REGISTRY_QUOTA_LIMIT: ::NTSTATUS = 0xC0000256u32 as i32;
pub const STATUS_PATH_NOT_COVERED: ::NTSTATUS = 0xC0000257u32 as i32;
pub const STATUS_NO_CALLBACK_ACTIVE: ::NTSTATUS = 0xC0000258u32 as i32;
pub const STATUS_LICENSE_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000259u32 as i32;
pub const STATUS_PWD_TOO_SHORT: ::NTSTATUS = 0xC000025Au32 as i32;
pub const STATUS_PWD_TOO_RECENT: ::NTSTATUS = 0xC000025Bu32 as i32;
pub const STATUS_PWD_HISTORY_CONFLICT: ::NTSTATUS = 0xC000025Cu32 as i32;
pub const STATUS_PLUGPLAY_NO_DEVICE: ::NTSTATUS = 0xC000025Eu32 as i32;
pub const STATUS_UNSUPPORTED_COMPRESSION: ::NTSTATUS = 0xC000025Fu32 as i32;
pub const STATUS_INVALID_HW_PROFILE: ::NTSTATUS = 0xC0000260u32 as i32;
pub const STATUS_INVALID_PLUGPLAY_DEVICE_PATH: ::NTSTATUS = 0xC0000261u32 as i32;
pub const STATUS_DRIVER_ORDINAL_NOT_FOUND: ::NTSTATUS = 0xC0000262u32 as i32;
pub const STATUS_DRIVER_ENTRYPOINT_NOT_FOUND: ::NTSTATUS = 0xC0000263u32 as i32;
pub const STATUS_RESOURCE_NOT_OWNED: ::NTSTATUS = 0xC0000264u32 as i32;
pub const STATUS_TOO_MANY_LINKS: ::NTSTATUS = 0xC0000265u32 as i32;
pub const STATUS_QUOTA_LIST_INCONSISTENT: ::NTSTATUS = 0xC0000266u32 as i32;
pub const STATUS_FILE_IS_OFFLINE: ::NTSTATUS = 0xC0000267u32 as i32;
pub const STATUS_EVALUATION_EXPIRATION: ::NTSTATUS = 0xC0000268u32 as i32;
pub const STATUS_ILLEGAL_DLL_RELOCATION: ::NTSTATUS = 0xC0000269u32 as i32;
pub const STATUS_LICENSE_VIOLATION: ::NTSTATUS = 0xC000026Au32 as i32;
pub const STATUS_DLL_INIT_FAILED_LOGOFF: ::NTSTATUS = 0xC000026Bu32 as i32;
pub const STATUS_DRIVER_UNABLE_TO_LOAD: ::NTSTATUS = 0xC000026Cu32 as i32;
pub const STATUS_DFS_UNAVAILABLE: ::NTSTATUS = 0xC000026Du32 as i32;
pub const STATUS_VOLUME_DISMOUNTED: ::NTSTATUS = 0xC000026Eu32 as i32;
pub const STATUS_WX86_INTERNAL_ERROR: ::NTSTATUS = 0xC000026Fu32 as i32;
pub const STATUS_WX86_FLOAT_STACK_CHECK: ::NTSTATUS = 0xC0000270u32 as i32;
pub const STATUS_VALIDATE_CONTINUE: ::NTSTATUS = 0xC0000271u32 as i32;
pub const STATUS_NO_MATCH: ::NTSTATUS = 0xC0000272u32 as i32;
pub const STATUS_NO_MORE_MATCHES: ::NTSTATUS = 0xC0000273u32 as i32;
pub const STATUS_NOT_A_REPARSE_POINT: ::NTSTATUS = 0xC0000275u32 as i32;
pub const STATUS_IO_REPARSE_TAG_INVALID: ::NTSTATUS = 0xC0000276u32 as i32;
pub const STATUS_IO_REPARSE_TAG_MISMATCH: ::NTSTATUS = 0xC0000277u32 as i32;
pub const STATUS_IO_REPARSE_DATA_INVALID: ::NTSTATUS = 0xC0000278u32 as i32;
pub const STATUS_IO_REPARSE_TAG_NOT_HANDLED: ::NTSTATUS = 0xC0000279u32 as i32;
pub const STATUS_PWD_TOO_LONG: ::NTSTATUS = 0xC000027Au32 as i32;
pub const STATUS_STOWED_EXCEPTION: ::NTSTATUS = 0xC000027Bu32 as i32;
pub const STATUS_REPARSE_POINT_NOT_RESOLVED: ::NTSTATUS = 0xC0000280u32 as i32;
pub const STATUS_DIRECTORY_IS_A_REPARSE_POINT: ::NTSTATUS = 0xC0000281u32 as i32;
pub const STATUS_RANGE_LIST_CONFLICT: ::NTSTATUS = 0xC0000282u32 as i32;
pub const STATUS_SOURCE_ELEMENT_EMPTY: ::NTSTATUS = 0xC0000283u32 as i32;
pub const STATUS_DESTINATION_ELEMENT_FULL: ::NTSTATUS = 0xC0000284u32 as i32;
pub const STATUS_ILLEGAL_ELEMENT_ADDRESS: ::NTSTATUS = 0xC0000285u32 as i32;
pub const STATUS_MAGAZINE_NOT_PRESENT: ::NTSTATUS = 0xC0000286u32 as i32;
pub const STATUS_REINITIALIZATION_NEEDED: ::NTSTATUS = 0xC0000287u32 as i32;
pub const STATUS_DEVICE_REQUIRES_CLEANING: ::NTSTATUS = 0x80000288u32 as i32;
pub const STATUS_DEVICE_DOOR_OPEN: ::NTSTATUS = 0x80000289u32 as i32;
pub const STATUS_ENCRYPTION_FAILED: ::NTSTATUS = 0xC000028Au32 as i32;
pub const STATUS_DECRYPTION_FAILED: ::NTSTATUS = 0xC000028Bu32 as i32;
pub const STATUS_RANGE_NOT_FOUND: ::NTSTATUS = 0xC000028Cu32 as i32;
pub const STATUS_NO_RECOVERY_POLICY: ::NTSTATUS = 0xC000028Du32 as i32;
pub const STATUS_NO_EFS: ::NTSTATUS = 0xC000028Eu32 as i32;
pub const STATUS_WRONG_EFS: ::NTSTATUS = 0xC000028Fu32 as i32;
pub const STATUS_NO_USER_KEYS: ::NTSTATUS = 0xC0000290u32 as i32;
pub const STATUS_FILE_NOT_ENCRYPTED: ::NTSTATUS = 0xC0000291u32 as i32;
pub const STATUS_NOT_EXPORT_FORMAT: ::NTSTATUS = 0xC0000292u32 as i32;
pub const STATUS_FILE_ENCRYPTED: ::NTSTATUS = 0xC0000293u32 as i32;
pub const STATUS_WAKE_SYSTEM: ::NTSTATUS = 0x40000294;
pub const STATUS_WMI_GUID_NOT_FOUND: ::NTSTATUS = 0xC0000295u32 as i32;
pub const STATUS_WMI_INSTANCE_NOT_FOUND: ::NTSTATUS = 0xC0000296u32 as i32;
pub const STATUS_WMI_ITEMID_NOT_FOUND: ::NTSTATUS = 0xC0000297u32 as i32;
pub const STATUS_WMI_TRY_AGAIN: ::NTSTATUS = 0xC0000298u32 as i32;
pub const STATUS_SHARED_POLICY: ::NTSTATUS = 0xC0000299u32 as i32;
pub const STATUS_POLICY_OBJECT_NOT_FOUND: ::NTSTATUS = 0xC000029Au32 as i32;
pub const STATUS_POLICY_ONLY_IN_DS: ::NTSTATUS = 0xC000029Bu32 as i32;
pub const STATUS_VOLUME_NOT_UPGRADED: ::NTSTATUS = 0xC000029Cu32 as i32;
pub const STATUS_REMOTE_STORAGE_NOT_ACTIVE: ::NTSTATUS = 0xC000029Du32 as i32;
pub const STATUS_REMOTE_STORAGE_MEDIA_ERROR: ::NTSTATUS = 0xC000029Eu32 as i32;
pub const STATUS_NO_TRACKING_SERVICE: ::NTSTATUS = 0xC000029Fu32 as i32;
pub const STATUS_SERVER_SID_MISMATCH: ::NTSTATUS = 0xC00002A0u32 as i32;
pub const STATUS_DS_NO_ATTRIBUTE_OR_VALUE: ::NTSTATUS = 0xC00002A1u32 as i32;
pub const STATUS_DS_INVALID_ATTRIBUTE_SYNTAX: ::NTSTATUS = 0xC00002A2u32 as i32;
pub const STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED: ::NTSTATUS = 0xC00002A3u32 as i32;
pub const STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS: ::NTSTATUS = 0xC00002A4u32 as i32;
pub const STATUS_DS_BUSY: ::NTSTATUS = 0xC00002A5u32 as i32;
pub const STATUS_DS_UNAVAILABLE: ::NTSTATUS = 0xC00002A6u32 as i32;
pub const STATUS_DS_NO_RIDS_ALLOCATED: ::NTSTATUS = 0xC00002A7u32 as i32;
pub const STATUS_DS_NO_MORE_RIDS: ::NTSTATUS = 0xC00002A8u32 as i32;
pub const STATUS_DS_INCORRECT_ROLE_OWNER: ::NTSTATUS = 0xC00002A9u32 as i32;
pub const STATUS_DS_RIDMGR_INIT_ERROR: ::NTSTATUS = 0xC00002AAu32 as i32;
pub const STATUS_DS_OBJ_CLASS_VIOLATION: ::NTSTATUS = 0xC00002ABu32 as i32;
pub const STATUS_DS_CANT_ON_NON_LEAF: ::NTSTATUS = 0xC00002ACu32 as i32;
pub const STATUS_DS_CANT_ON_RDN: ::NTSTATUS = 0xC00002ADu32 as i32;
pub const STATUS_DS_CANT_MOD_OBJ_CLASS: ::NTSTATUS = 0xC00002AEu32 as i32;
pub const STATUS_DS_CROSS_DOM_MOVE_FAILED: ::NTSTATUS = 0xC00002AFu32 as i32;
pub const STATUS_DS_GC_NOT_AVAILABLE: ::NTSTATUS = 0xC00002B0u32 as i32;
pub const STATUS_DIRECTORY_SERVICE_REQUIRED: ::NTSTATUS = 0xC00002B1u32 as i32;
pub const STATUS_REPARSE_ATTRIBUTE_CONFLICT: ::NTSTATUS = 0xC00002B2u32 as i32;
pub const STATUS_CANT_ENABLE_DENY_ONLY: ::NTSTATUS = 0xC00002B3u32 as i32;
pub const STATUS_FLOAT_MULTIPLE_FAULTS: ::NTSTATUS = 0xC00002B4u32 as i32;
pub const STATUS_FLOAT_MULTIPLE_TRAPS: ::NTSTATUS = 0xC00002B5u32 as i32;
pub const STATUS_DEVICE_REMOVED: ::NTSTATUS = 0xC00002B6u32 as i32;
pub const STATUS_JOURNAL_DELETE_IN_PROGRESS: ::NTSTATUS = 0xC00002B7u32 as i32;
pub const STATUS_JOURNAL_NOT_ACTIVE: ::NTSTATUS = 0xC00002B8u32 as i32;
pub const STATUS_NOINTERFACE: ::NTSTATUS = 0xC00002B9u32 as i32;
pub const STATUS_DS_RIDMGR_DISABLED: ::NTSTATUS = 0xC00002BAu32 as i32;
pub const STATUS_DS_ADMIN_LIMIT_EXCEEDED: ::NTSTATUS = 0xC00002C1u32 as i32;
pub const STATUS_DRIVER_FAILED_SLEEP: ::NTSTATUS = 0xC00002C2u32 as i32;
pub const STATUS_MUTUAL_AUTHENTICATION_FAILED: ::NTSTATUS = 0xC00002C3u32 as i32;
pub const STATUS_CORRUPT_SYSTEM_FILE: ::NTSTATUS = 0xC00002C4u32 as i32;
pub const STATUS_DATATYPE_MISALIGNMENT_ERROR: ::NTSTATUS = 0xC00002C5u32 as i32;
pub const STATUS_WMI_READ_ONLY: ::NTSTATUS = 0xC00002C6u32 as i32;
pub const STATUS_WMI_SET_FAILURE: ::NTSTATUS = 0xC00002C7u32 as i32;
pub const STATUS_COMMITMENT_MINIMUM: ::NTSTATUS = 0xC00002C8u32 as i32;
pub const STATUS_REG_NAT_CONSUMPTION: ::NTSTATUS = 0xC00002C9u32 as i32;
pub const STATUS_TRANSPORT_FULL: ::NTSTATUS = 0xC00002CAu32 as i32;
pub const STATUS_DS_SAM_INIT_FAILURE: ::NTSTATUS = 0xC00002CBu32 as i32;
pub const STATUS_ONLY_IF_CONNECTED: ::NTSTATUS = 0xC00002CCu32 as i32;
pub const STATUS_DS_SENSITIVE_GROUP_VIOLATION: ::NTSTATUS = 0xC00002CDu32 as i32;
pub const STATUS_PNP_RESTART_ENUMERATION: ::NTSTATUS = 0xC00002CEu32 as i32;
pub const STATUS_JOURNAL_ENTRY_DELETED: ::NTSTATUS = 0xC00002CFu32 as i32;
pub const STATUS_DS_CANT_MOD_PRIMARYGROUPID: ::NTSTATUS = 0xC00002D0u32 as i32;
pub const STATUS_SYSTEM_IMAGE_BAD_SIGNATURE: ::NTSTATUS = 0xC00002D1u32 as i32;
pub const STATUS_PNP_REBOOT_REQUIRED: ::NTSTATUS = 0xC00002D2u32 as i32;
pub const STATUS_POWER_STATE_INVALID: ::NTSTATUS = 0xC00002D3u32 as i32;
pub const STATUS_DS_INVALID_GROUP_TYPE: ::NTSTATUS = 0xC00002D4u32 as i32;
pub const STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: ::NTSTATUS = 0xC00002D5u32 as i32;
pub const STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: ::NTSTATUS = 0xC00002D6u32 as i32;
pub const STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: ::NTSTATUS = 0xC00002D7u32 as i32;
pub const STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: ::NTSTATUS = 0xC00002D8u32 as i32;
pub const STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: ::NTSTATUS = 0xC00002D9u32 as i32;
pub const STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: ::NTSTATUS = 0xC00002DAu32 as i32;
pub const STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: ::NTSTATUS = 0xC00002DBu32 as i32;
pub const STATUS_DS_HAVE_PRIMARY_MEMBERS: ::NTSTATUS = 0xC00002DCu32 as i32;
pub const STATUS_WMI_NOT_SUPPORTED: ::NTSTATUS = 0xC00002DDu32 as i32;
pub const STATUS_INSUFFICIENT_POWER: ::NTSTATUS = 0xC00002DEu32 as i32;
pub const STATUS_SAM_NEED_BOOTKEY_PASSWORD: ::NTSTATUS = 0xC00002DFu32 as i32;
pub const STATUS_SAM_NEED_BOOTKEY_FLOPPY: ::NTSTATUS = 0xC00002E0u32 as i32;
pub const STATUS_DS_CANT_START: ::NTSTATUS = 0xC00002E1u32 as i32;
pub const STATUS_DS_INIT_FAILURE: ::NTSTATUS = 0xC00002E2u32 as i32;
pub const STATUS_SAM_INIT_FAILURE: ::NTSTATUS = 0xC00002E3u32 as i32;
pub const STATUS_DS_GC_REQUIRED: ::NTSTATUS = 0xC00002E4u32 as i32;
pub const STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: ::NTSTATUS = 0xC00002E5u32 as i32;
pub const STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS: ::NTSTATUS = 0xC00002E6u32 as i32;
pub const STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: ::NTSTATUS = 0xC00002E7u32 as i32;
pub const STATUS_MULTIPLE_FAULT_VIOLATION: ::NTSTATUS = 0xC00002E8u32 as i32;
pub const STATUS_CURRENT_DOMAIN_NOT_ALLOWED: ::NTSTATUS = 0xC00002E9u32 as i32;
pub const STATUS_CANNOT_MAKE: ::NTSTATUS = 0xC00002EAu32 as i32;
pub const STATUS_SYSTEM_SHUTDOWN: ::NTSTATUS = 0xC00002EBu32 as i32;
pub const STATUS_DS_INIT_FAILURE_CONSOLE: ::NTSTATUS = 0xC00002ECu32 as i32;
pub const STATUS_DS_SAM_INIT_FAILURE_CONSOLE: ::NTSTATUS = 0xC00002EDu32 as i32;
pub const STATUS_UNFINISHED_CONTEXT_DELETED: ::NTSTATUS = 0xC00002EEu32 as i32;
pub const STATUS_NO_TGT_REPLY: ::NTSTATUS = 0xC00002EFu32 as i32;
pub const STATUS_OBJECTID_NOT_FOUND: ::NTSTATUS = 0xC00002F0u32 as i32;
pub const STATUS_NO_IP_ADDRESSES: ::NTSTATUS = 0xC00002F1u32 as i32;
pub const STATUS_WRONG_CREDENTIAL_HANDLE: ::NTSTATUS = 0xC00002F2u32 as i32;
pub const STATUS_CRYPTO_SYSTEM_INVALID: ::NTSTATUS = 0xC00002F3u32 as i32;
pub const STATUS_MAX_REFERRALS_EXCEEDED: ::NTSTATUS = 0xC00002F4u32 as i32;
pub const STATUS_MUST_BE_KDC: ::NTSTATUS = 0xC00002F5u32 as i32;
pub const STATUS_STRONG_CRYPTO_NOT_SUPPORTED: ::NTSTATUS = 0xC00002F6u32 as i32;
pub const STATUS_TOO_MANY_PRINCIPALS: ::NTSTATUS = 0xC00002F7u32 as i32;
pub const STATUS_NO_PA_DATA: ::NTSTATUS = 0xC00002F8u32 as i32;
pub const STATUS_PKINIT_NAME_MISMATCH: ::NTSTATUS = 0xC00002F9u32 as i32;
pub const STATUS_SMARTCARD_LOGON_REQUIRED: ::NTSTATUS = 0xC00002FAu32 as i32;
pub const STATUS_KDC_INVALID_REQUEST: ::NTSTATUS = 0xC00002FBu32 as i32;
pub const STATUS_KDC_UNABLE_TO_REFER: ::NTSTATUS = 0xC00002FCu32 as i32;
pub const STATUS_KDC_UNKNOWN_ETYPE: ::NTSTATUS = 0xC00002FDu32 as i32;
pub const STATUS_SHUTDOWN_IN_PROGRESS: ::NTSTATUS = 0xC00002FEu32 as i32;
pub const STATUS_SERVER_SHUTDOWN_IN_PROGRESS: ::NTSTATUS = 0xC00002FFu32 as i32;
pub const STATUS_NOT_SUPPORTED_ON_SBS: ::NTSTATUS = 0xC0000300u32 as i32;
pub const STATUS_WMI_GUID_DISCONNECTED: ::NTSTATUS = 0xC0000301u32 as i32;
pub const STATUS_WMI_ALREADY_DISABLED: ::NTSTATUS = 0xC0000302u32 as i32;
pub const STATUS_WMI_ALREADY_ENABLED: ::NTSTATUS = 0xC0000303u32 as i32;
pub const STATUS_MFT_TOO_FRAGMENTED: ::NTSTATUS = 0xC0000304u32 as i32;
pub const STATUS_COPY_PROTECTION_FAILURE: ::NTSTATUS = 0xC0000305u32 as i32;
pub const STATUS_CSS_AUTHENTICATION_FAILURE: ::NTSTATUS = 0xC0000306u32 as i32;
pub const STATUS_CSS_KEY_NOT_PRESENT: ::NTSTATUS = 0xC0000307u32 as i32;
pub const STATUS_CSS_KEY_NOT_ESTABLISHED: ::NTSTATUS = 0xC0000308u32 as i32;
pub const STATUS_CSS_SCRAMBLED_SECTOR: ::NTSTATUS = 0xC0000309u32 as i32;
pub const STATUS_CSS_REGION_MISMATCH: ::NTSTATUS = 0xC000030Au32 as i32;
pub const STATUS_CSS_RESETS_EXHAUSTED: ::NTSTATUS = 0xC000030Bu32 as i32;
pub const STATUS_PASSWORD_CHANGE_REQUIRED: ::NTSTATUS = 0xC000030Cu32 as i32;
pub const STATUS_PKINIT_FAILURE: ::NTSTATUS = 0xC0000320u32 as i32;
pub const STATUS_SMARTCARD_SUBSYSTEM_FAILURE: ::NTSTATUS = 0xC0000321u32 as i32;
pub const STATUS_NO_KERB_KEY: ::NTSTATUS = 0xC0000322u32 as i32;
pub const STATUS_HOST_DOWN: ::NTSTATUS = 0xC0000350u32 as i32;
pub const STATUS_UNSUPPORTED_PREAUTH: ::NTSTATUS = 0xC0000351u32 as i32;
pub const STATUS_EFS_ALG_BLOB_TOO_BIG: ::NTSTATUS = 0xC0000352u32 as i32;
pub const STATUS_PORT_NOT_SET: ::NTSTATUS = 0xC0000353u32 as i32;
pub const STATUS_DEBUGGER_INACTIVE: ::NTSTATUS = 0xC0000354u32 as i32;
pub const STATUS_DS_VERSION_CHECK_FAILURE: ::NTSTATUS = 0xC0000355u32 as i32;
pub const STATUS_AUDITING_DISABLED: ::NTSTATUS = 0xC0000356u32 as i32;
pub const STATUS_PRENT4_MACHINE_ACCOUNT: ::NTSTATUS = 0xC0000357u32 as i32;
pub const STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: ::NTSTATUS = 0xC0000358u32 as i32;
pub const STATUS_INVALID_IMAGE_WIN_32: ::NTSTATUS = 0xC0000359u32 as i32;
pub const STATUS_INVALID_IMAGE_WIN_64: ::NTSTATUS = 0xC000035Au32 as i32;
pub const STATUS_BAD_BINDINGS: ::NTSTATUS = 0xC000035Bu32 as i32;
pub const STATUS_NETWORK_SESSION_EXPIRED: ::NTSTATUS = 0xC000035Cu32 as i32;
pub const STATUS_APPHELP_BLOCK: ::NTSTATUS = 0xC000035Du32 as i32;
pub const STATUS_ALL_SIDS_FILTERED: ::NTSTATUS = 0xC000035Eu32 as i32;
pub const STATUS_NOT_SAFE_MODE_DRIVER: ::NTSTATUS = 0xC000035Fu32 as i32;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT: ::NTSTATUS = 0xC0000361u32 as i32;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PATH: ::NTSTATUS = 0xC0000362u32 as i32;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER: ::NTSTATUS = 0xC0000363u32 as i32;
pub const STATUS_ACCESS_DISABLED_BY_POLICY_OTHER: ::NTSTATUS = 0xC0000364u32 as i32;
pub const STATUS_FAILED_DRIVER_ENTRY: ::NTSTATUS = 0xC0000365u32 as i32;
pub const STATUS_DEVICE_ENUMERATION_ERROR: ::NTSTATUS = 0xC0000366u32 as i32;
pub const STATUS_MOUNT_POINT_NOT_RESOLVED: ::NTSTATUS = 0xC0000368u32 as i32;
pub const STATUS_INVALID_DEVICE_OBJECT_PARAMETER: ::NTSTATUS = 0xC0000369u32 as i32;
pub const STATUS_MCA_OCCURED: ::NTSTATUS = 0xC000036Au32 as i32;
pub const STATUS_DRIVER_BLOCKED_CRITICAL: ::NTSTATUS = 0xC000036Bu32 as i32;
pub const STATUS_DRIVER_BLOCKED: ::NTSTATUS = 0xC000036Cu32 as i32;
pub const STATUS_DRIVER_DATABASE_ERROR: ::NTSTATUS = 0xC000036Du32 as i32;
pub const STATUS_SYSTEM_HIVE_TOO_LARGE: ::NTSTATUS = 0xC000036Eu32 as i32;
pub const STATUS_INVALID_IMPORT_OF_NON_DLL: ::NTSTATUS = 0xC000036Fu32 as i32;
pub const STATUS_DS_SHUTTING_DOWN: ::NTSTATUS = 0x40000370;
pub const STATUS_NO_SECRETS: ::NTSTATUS = 0xC0000371u32 as i32;
pub const STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY: ::NTSTATUS = 0xC0000372u32 as i32;
pub const STATUS_FAILED_STACK_SWITCH: ::NTSTATUS = 0xC0000373u32 as i32;
pub const STATUS_HEAP_CORRUPTION: ::NTSTATUS = 0xC0000374u32 as i32;
pub const STATUS_SMARTCARD_WRONG_PIN: ::NTSTATUS = 0xC0000380u32 as i32;
pub const STATUS_SMARTCARD_CARD_BLOCKED: ::NTSTATUS = 0xC0000381u32 as i32;
pub const STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED: ::NTSTATUS = 0xC0000382u32 as i32;
pub const STATUS_SMARTCARD_NO_CARD: ::NTSTATUS = 0xC0000383u32 as i32;
pub const STATUS_SMARTCARD_NO_KEY_CONTAINER: ::NTSTATUS = 0xC0000384u32 as i32;
pub const STATUS_SMARTCARD_NO_CERTIFICATE: ::NTSTATUS = 0xC0000385u32 as i32;
pub const STATUS_SMARTCARD_NO_KEYSET: ::NTSTATUS = 0xC0000386u32 as i32;
pub const STATUS_SMARTCARD_IO_ERROR: ::NTSTATUS = 0xC0000387u32 as i32;
pub const STATUS_DOWNGRADE_DETECTED: ::NTSTATUS = 0xC0000388u32 as i32;
pub const STATUS_SMARTCARD_CERT_REVOKED: ::NTSTATUS = 0xC0000389u32 as i32;
pub const STATUS_ISSUING_CA_UNTRUSTED: ::NTSTATUS = 0xC000038Au32 as i32;
pub const STATUS_REVOCATION_OFFLINE_C: ::NTSTATUS = 0xC000038Bu32 as i32;
pub const STATUS_PKINIT_CLIENT_FAILURE: ::NTSTATUS = 0xC000038Cu32 as i32;
pub const STATUS_SMARTCARD_CERT_EXPIRED: ::NTSTATUS = 0xC000038Du32 as i32;
pub const STATUS_DRIVER_FAILED_PRIOR_UNLOAD: ::NTSTATUS = 0xC000038Eu32 as i32;
pub const STATUS_SMARTCARD_SILENT_CONTEXT: ::NTSTATUS = 0xC000038Fu32 as i32;
pub const STATUS_PER_USER_TRUST_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000401u32 as i32;
pub const STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000402u32 as i32;
pub const STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000403u32 as i32;
pub const STATUS_DS_NAME_NOT_UNIQUE: ::NTSTATUS = 0xC0000404u32 as i32;
pub const STATUS_DS_DUPLICATE_ID_FOUND: ::NTSTATUS = 0xC0000405u32 as i32;
pub const STATUS_DS_GROUP_CONVERSION_ERROR: ::NTSTATUS = 0xC0000406u32 as i32;
pub const STATUS_VOLSNAP_PREPARE_HIBERNATE: ::NTSTATUS = 0xC0000407u32 as i32;
pub const STATUS_USER2USER_REQUIRED: ::NTSTATUS = 0xC0000408u32 as i32;
pub const STATUS_STACK_BUFFER_OVERRUN: ::NTSTATUS = 0xC0000409u32 as i32;
pub const STATUS_NO_S4U_PROT_SUPPORT: ::NTSTATUS = 0xC000040Au32 as i32;
pub const STATUS_CROSSREALM_DELEGATION_FAILURE: ::NTSTATUS = 0xC000040Bu32 as i32;
pub const STATUS_REVOCATION_OFFLINE_KDC: ::NTSTATUS = 0xC000040Cu32 as i32;
pub const STATUS_ISSUING_CA_UNTRUSTED_KDC: ::NTSTATUS = 0xC000040Du32 as i32;
pub const STATUS_KDC_CERT_EXPIRED: ::NTSTATUS = 0xC000040Eu32 as i32;
pub const STATUS_KDC_CERT_REVOKED: ::NTSTATUS = 0xC000040Fu32 as i32;
pub const STATUS_PARAMETER_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000410u32 as i32;
pub const STATUS_HIBERNATION_FAILURE: ::NTSTATUS = 0xC0000411u32 as i32;
pub const STATUS_DELAY_LOAD_FAILED: ::NTSTATUS = 0xC0000412u32 as i32;
pub const STATUS_AUTHENTICATION_FIREWALL_FAILED: ::NTSTATUS = 0xC0000413u32 as i32;
pub const STATUS_VDM_DISALLOWED: ::NTSTATUS = 0xC0000414u32 as i32;
pub const STATUS_HUNG_DISPLAY_DRIVER_THREAD: ::NTSTATUS = 0xC0000415u32 as i32;
pub const STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE: ::NTSTATUS = 0xC0000416u32 as i32;
pub const STATUS_INVALID_CRUNTIME_PARAMETER: ::NTSTATUS = 0xC0000417u32 as i32;
pub const STATUS_NTLM_BLOCKED: ::NTSTATUS = 0xC0000418u32 as i32;
pub const STATUS_DS_SRC_SID_EXISTS_IN_FOREST: ::NTSTATUS = 0xC0000419u32 as i32;
pub const STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST: ::NTSTATUS = 0xC000041Au32 as i32;
pub const STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST: ::NTSTATUS = 0xC000041Bu32 as i32;
pub const STATUS_INVALID_USER_PRINCIPAL_NAME: ::NTSTATUS = 0xC000041Cu32 as i32;
pub const STATUS_FATAL_USER_CALLBACK_EXCEPTION: ::NTSTATUS = 0xC000041Du32 as i32;
pub const STATUS_ASSERTION_FAILURE: ::NTSTATUS = 0xC0000420u32 as i32;
pub const STATUS_VERIFIER_STOP: ::NTSTATUS = 0xC0000421u32 as i32;
pub const STATUS_CALLBACK_POP_STACK: ::NTSTATUS = 0xC0000423u32 as i32;
pub const STATUS_INCOMPATIBLE_DRIVER_BLOCKED: ::NTSTATUS = 0xC0000424u32 as i32;
pub const STATUS_HIVE_UNLOADED: ::NTSTATUS = 0xC0000425u32 as i32;
pub const STATUS_COMPRESSION_DISABLED: ::NTSTATUS = 0xC0000426u32 as i32;
pub const STATUS_FILE_SYSTEM_LIMITATION: ::NTSTATUS = 0xC0000427u32 as i32;
pub const STATUS_INVALID_IMAGE_HASH: ::NTSTATUS = 0xC0000428u32 as i32;
pub const STATUS_NOT_CAPABLE: ::NTSTATUS = 0xC0000429u32 as i32;
pub const STATUS_REQUEST_OUT_OF_SEQUENCE: ::NTSTATUS = 0xC000042Au32 as i32;
pub const STATUS_IMPLEMENTATION_LIMIT: ::NTSTATUS = 0xC000042Bu32 as i32;
pub const STATUS_ELEVATION_REQUIRED: ::NTSTATUS = 0xC000042Cu32 as i32;
pub const STATUS_NO_SECURITY_CONTEXT: ::NTSTATUS = 0xC000042Du32 as i32;
pub const STATUS_PKU2U_CERT_FAILURE: ::NTSTATUS = 0xC000042Fu32 as i32;
pub const STATUS_BEYOND_VDL: ::NTSTATUS = 0xC0000432u32 as i32;
pub const STATUS_ENCOUNTERED_WRITE_IN_PROGRESS: ::NTSTATUS = 0xC0000433u32 as i32;
pub const STATUS_PTE_CHANGED: ::NTSTATUS = 0xC0000434u32 as i32;
pub const STATUS_PURGE_FAILED: ::NTSTATUS = 0xC0000435u32 as i32;
pub const STATUS_CRED_REQUIRES_CONFIRMATION: ::NTSTATUS = 0xC0000440u32 as i32;
pub const STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE: ::NTSTATUS = 0xC0000441u32 as i32;
pub const STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER: ::NTSTATUS = 0xC0000442u32 as i32;
pub const STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE: ::NTSTATUS = 0xC0000443u32 as i32;
pub const STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE: ::NTSTATUS = 0xC0000444u32 as i32;
pub const STATUS_CS_ENCRYPTION_FILE_NOT_CSE: ::NTSTATUS = 0xC0000445u32 as i32;
pub const STATUS_INVALID_LABEL: ::NTSTATUS = 0xC0000446u32 as i32;
pub const STATUS_DRIVER_PROCESS_TERMINATED: ::NTSTATUS = 0xC0000450u32 as i32;
pub const STATUS_AMBIGUOUS_SYSTEM_DEVICE: ::NTSTATUS = 0xC0000451u32 as i32;
pub const STATUS_SYSTEM_DEVICE_NOT_FOUND: ::NTSTATUS = 0xC0000452u32 as i32;
pub const STATUS_RESTART_BOOT_APPLICATION: ::NTSTATUS = 0xC0000453u32 as i32;
pub const STATUS_INSUFFICIENT_NVRAM_RESOURCES: ::NTSTATUS = 0xC0000454u32 as i32;
pub const STATUS_INVALID_SESSION: ::NTSTATUS = 0xC0000455u32 as i32;
pub const STATUS_THREAD_ALREADY_IN_SESSION: ::NTSTATUS = 0xC0000456u32 as i32;
pub const STATUS_THREAD_NOT_IN_SESSION: ::NTSTATUS = 0xC0000457u32 as i32;
pub const STATUS_INVALID_WEIGHT: ::NTSTATUS = 0xC0000458u32 as i32;
pub const STATUS_REQUEST_PAUSED: ::NTSTATUS = 0xC0000459u32 as i32;
pub const STATUS_NO_RANGES_PROCESSED: ::NTSTATUS = 0xC0000460u32 as i32;
pub const STATUS_DISK_RESOURCES_EXHAUSTED: ::NTSTATUS = 0xC0000461u32 as i32;
pub const STATUS_NEEDS_REMEDIATION: ::NTSTATUS = 0xC0000462u32 as i32;
pub const STATUS_DEVICE_FEATURE_NOT_SUPPORTED: ::NTSTATUS = 0xC0000463u32 as i32;
pub const STATUS_DEVICE_UNREACHABLE: ::NTSTATUS = 0xC0000464u32 as i32;
pub const STATUS_INVALID_TOKEN: ::NTSTATUS = 0xC0000465u32 as i32;
pub const STATUS_SERVER_UNAVAILABLE: ::NTSTATUS = 0xC0000466u32 as i32;
pub const STATUS_FILE_NOT_AVAILABLE: ::NTSTATUS = 0xC0000467u32 as i32;
pub const STATUS_DEVICE_INSUFFICIENT_RESOURCES: ::NTSTATUS = 0xC0000468u32 as i32;
pub const STATUS_PACKAGE_UPDATING: ::NTSTATUS = 0xC0000469u32 as i32;
pub const STATUS_NOT_READ_FROM_COPY: ::NTSTATUS = 0xC000046Au32 as i32;
pub const STATUS_FT_WRITE_FAILURE: ::NTSTATUS = 0xC000046Bu32 as i32;
pub const STATUS_FT_DI_SCAN_REQUIRED: ::NTSTATUS = 0xC000046Cu32 as i32;
pub const STATUS_OBJECT_NOT_EXTERNALLY_BACKED: ::NTSTATUS = 0xC000046Du32 as i32;
pub const STATUS_EXTERNAL_BACKING_PROVIDER_UNKNOWN: ::NTSTATUS = 0xC000046Eu32 as i32;
pub const STATUS_COMPRESSION_NOT_BENEFICIAL: ::NTSTATUS = 0xC000046Fu32 as i32;
pub const STATUS_DATA_CHECKSUM_ERROR: ::NTSTATUS = 0xC0000470u32 as i32;
pub const STATUS_INTERMIXED_KERNEL_EA_OPERATION: ::NTSTATUS = 0xC0000471u32 as i32;
pub const STATUS_TRIM_READ_ZERO_NOT_SUPPORTED: ::NTSTATUS = 0xC0000472u32 as i32;
pub const STATUS_TOO_MANY_SEGMENT_DESCRIPTORS: ::NTSTATUS = 0xC0000473u32 as i32;
pub const STATUS_INVALID_OFFSET_ALIGNMENT: ::NTSTATUS = 0xC0000474u32 as i32;
pub const STATUS_INVALID_FIELD_IN_PARAMETER_LIST: ::NTSTATUS = 0xC0000475u32 as i32;
pub const STATUS_OPERATION_IN_PROGRESS: ::NTSTATUS = 0xC0000476u32 as i32;
pub const STATUS_INVALID_INITIATOR_TARGET_PATH: ::NTSTATUS = 0xC0000477u32 as i32;
pub const STATUS_SCRUB_DATA_DISABLED: ::NTSTATUS = 0xC0000478u32 as i32;
pub const STATUS_NOT_REDUNDANT_STORAGE: ::NTSTATUS = 0xC0000479u32 as i32;
pub const STATUS_RESIDENT_FILE_NOT_SUPPORTED: ::NTSTATUS = 0xC000047Au32 as i32;
pub const STATUS_COMPRESSED_FILE_NOT_SUPPORTED: ::NTSTATUS = 0xC000047Bu32 as i32;
pub const STATUS_DIRECTORY_NOT_SUPPORTED: ::NTSTATUS = 0xC000047Cu32 as i32;
pub const STATUS_IO_OPERATION_TIMEOUT: ::NTSTATUS = 0xC000047Du32 as i32;
pub const STATUS_SYSTEM_NEEDS_REMEDIATION: ::NTSTATUS = 0xC000047Eu32 as i32;
pub const STATUS_APPX_INTEGRITY_FAILURE_CLR_NGEN: ::NTSTATUS = 0xC000047Fu32 as i32;
pub const STATUS_SHARE_UNAVAILABLE: ::NTSTATUS = 0xC0000480u32 as i32;
pub const STATUS_APISET_NOT_HOSTED: ::NTSTATUS = 0xC0000481u32 as i32;
pub const STATUS_APISET_NOT_PRESENT: ::NTSTATUS = 0xC0000482u32 as i32;
pub const STATUS_DEVICE_HARDWARE_ERROR: ::NTSTATUS = 0xC0000483u32 as i32;
pub const STATUS_FIRMWARE_SLOT_INVALID: ::NTSTATUS = 0xC0000484u32 as i32;
pub const STATUS_FIRMWARE_IMAGE_INVALID: ::NTSTATUS = 0xC0000485u32 as i32;
pub const STATUS_STORAGE_TOPOLOGY_ID_MISMATCH: ::NTSTATUS = 0xC0000486u32 as i32;
pub const STATUS_WIM_NOT_BOOTABLE: ::NTSTATUS = 0xC0000487u32 as i32;
pub const STATUS_BLOCKED_BY_PARENTAL_CONTROLS: ::NTSTATUS = 0xC0000488u32 as i32;
pub const STATUS_NEEDS_REGISTRATION: ::NTSTATUS = 0xC0000489u32 as i32;
pub const STATUS_QUOTA_ACTIVITY: ::NTSTATUS = 0xC000048Au32 as i32;
pub const STATUS_INVALID_TASK_NAME: ::NTSTATUS = 0xC0000500u32 as i32;
pub const STATUS_INVALID_TASK_INDEX: ::NTSTATUS = 0xC0000501u32 as i32;
pub const STATUS_THREAD_ALREADY_IN_TASK: ::NTSTATUS = 0xC0000502u32 as i32;
pub const STATUS_CALLBACK_BYPASS: ::NTSTATUS = 0xC0000503u32 as i32;
pub const STATUS_UNDEFINED_SCOPE: ::NTSTATUS = 0xC0000504u32 as i32;
pub const STATUS_INVALID_CAP: ::NTSTATUS = 0xC0000505u32 as i32;
pub const STATUS_NOT_GUI_PROCESS: ::NTSTATUS = 0xC0000506u32 as i32;
pub const STATUS_DEVICE_HUNG: ::NTSTATUS = 0xC0000507u32 as i32;
pub const STATUS_FAIL_FAST_EXCEPTION: ::NTSTATUS = 0xC0000602u32 as i32;
pub const STATUS_IMAGE_CERT_REVOKED: ::NTSTATUS = 0xC0000603u32 as i32;
pub const STATUS_DYNAMIC_CODE_BLOCKED: ::NTSTATUS = 0xC0000604u32 as i32;
pub const STATUS_IMAGE_CERT_EXPIRED: ::NTSTATUS = 0xC0000605u32 as i32;
pub const STATUS_PORT_CLOSED: ::NTSTATUS = 0xC0000700u32 as i32;
pub const STATUS_MESSAGE_LOST: ::NTSTATUS = 0xC0000701u32 as i32;
pub const STATUS_INVALID_MESSAGE: ::NTSTATUS = 0xC0000702u32 as i32;
pub const STATUS_REQUEST_CANCELED: ::NTSTATUS = 0xC0000703u32 as i32;
pub const STATUS_RECURSIVE_DISPATCH: ::NTSTATUS = 0xC0000704u32 as i32;
pub const STATUS_LPC_RECEIVE_BUFFER_EXPECTED: ::NTSTATUS = 0xC0000705u32 as i32;
pub const STATUS_LPC_INVALID_CONNECTION_USAGE: ::NTSTATUS = 0xC0000706u32 as i32;
pub const STATUS_LPC_REQUESTS_NOT_ALLOWED: ::NTSTATUS = 0xC0000707u32 as i32;
pub const STATUS_RESOURCE_IN_USE: ::NTSTATUS = 0xC0000708u32 as i32;
pub const STATUS_HARDWARE_MEMORY_ERROR: ::NTSTATUS = 0xC0000709u32 as i32;
pub const STATUS_THREADPOOL_HANDLE_EXCEPTION: ::NTSTATUS = 0xC000070Au32 as i32;
pub const STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED: ::NTSTATUS = 0xC000070Bu32 as i32;
pub const STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED: ::NTSTATUS = 0xC000070Cu32 as i32;
pub const STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED: ::NTSTATUS = 0xC000070Du32 as i32;
pub const STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED: ::NTSTATUS = 0xC000070Eu32 as i32;
pub const STATUS_THREADPOOL_RELEASED_DURING_OPERATION: ::NTSTATUS = 0xC000070Fu32 as i32;
pub const STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING: ::NTSTATUS = 0xC0000710u32 as i32;
pub const STATUS_APC_RETURNED_WHILE_IMPERSONATING: ::NTSTATUS = 0xC0000711u32 as i32;
pub const STATUS_PROCESS_IS_PROTECTED: ::NTSTATUS = 0xC0000712u32 as i32;
pub const STATUS_MCA_EXCEPTION: ::NTSTATUS = 0xC0000713u32 as i32;
pub const STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE: ::NTSTATUS = 0xC0000714u32 as i32;
pub const STATUS_SYMLINK_CLASS_DISABLED: ::NTSTATUS = 0xC0000715u32 as i32;
pub const STATUS_INVALID_IDN_NORMALIZATION: ::NTSTATUS = 0xC0000716u32 as i32;
pub const STATUS_NO_UNICODE_TRANSLATION: ::NTSTATUS = 0xC0000717u32 as i32;
pub const STATUS_ALREADY_REGISTERED: ::NTSTATUS = 0xC0000718u32 as i32;
pub const STATUS_CONTEXT_MISMATCH: ::NTSTATUS = 0xC0000719u32 as i32;
pub const STATUS_PORT_ALREADY_HAS_COMPLETION_LIST: ::NTSTATUS = 0xC000071Au32 as i32;
pub const STATUS_CALLBACK_RETURNED_THREAD_PRIORITY: ::NTSTATUS = 0xC000071Bu32 as i32;
pub const STATUS_INVALID_THREAD: ::NTSTATUS = 0xC000071Cu32 as i32;
pub const STATUS_CALLBACK_RETURNED_TRANSACTION: ::NTSTATUS = 0xC000071Du32 as i32;
pub const STATUS_CALLBACK_RETURNED_LDR_LOCK: ::NTSTATUS = 0xC000071Eu32 as i32;
pub const STATUS_CALLBACK_RETURNED_LANG: ::NTSTATUS = 0xC000071Fu32 as i32;
pub const STATUS_CALLBACK_RETURNED_PRI_BACK: ::NTSTATUS = 0xC0000720u32 as i32;
pub const STATUS_CALLBACK_RETURNED_THREAD_AFFINITY: ::NTSTATUS = 0xC0000721u32 as i32;
pub const STATUS_DISK_REPAIR_DISABLED: ::NTSTATUS = 0xC0000800u32 as i32;
pub const STATUS_DS_DOMAIN_RENAME_IN_PROGRESS: ::NTSTATUS = 0xC0000801u32 as i32;
pub const STATUS_DISK_QUOTA_EXCEEDED: ::NTSTATUS = 0xC0000802u32 as i32;
pub const STATUS_DATA_LOST_REPAIR: ::NTSTATUS = 0x80000803u32 as i32;
pub const STATUS_CONTENT_BLOCKED: ::NTSTATUS = 0xC0000804u32 as i32;
pub const STATUS_BAD_CLUSTERS: ::NTSTATUS = 0xC0000805u32 as i32;
pub const STATUS_VOLUME_DIRTY: ::NTSTATUS = 0xC0000806u32 as i32;
pub const STATUS_DISK_REPAIR_REDIRECTED: ::NTSTATUS = 0x40000807;
pub const STATUS_DISK_REPAIR_UNSUCCESSFUL: ::NTSTATUS = 0xC0000808u32 as i32;
pub const STATUS_CORRUPT_LOG_OVERFULL: ::NTSTATUS = 0xC0000809u32 as i32;
pub const STATUS_CORRUPT_LOG_CORRUPTED: ::NTSTATUS = 0xC000080Au32 as i32;
pub const STATUS_CORRUPT_LOG_UNAVAILABLE: ::NTSTATUS = 0xC000080Bu32 as i32;
pub const STATUS_CORRUPT_LOG_DELETED_FULL: ::NTSTATUS = 0xC000080Cu32 as i32;
pub const STATUS_CORRUPT_LOG_CLEARED: ::NTSTATUS = 0xC000080Du32 as i32;
pub const STATUS_ORPHAN_NAME_EXHAUSTED: ::NTSTATUS = 0xC000080Eu32 as i32;
pub const STATUS_PROACTIVE_SCAN_IN_PROGRESS: ::NTSTATUS = 0xC000080Fu32 as i32;
pub const STATUS_ENCRYPTED_IO_NOT_POSSIBLE: ::NTSTATUS = 0xC0000810u32 as i32;
pub const STATUS_CORRUPT_LOG_UPLEVEL_RECORDS: ::NTSTATUS = 0xC0000811u32 as i32;
pub const STATUS_FILE_CHECKED_OUT: ::NTSTATUS = 0xC0000901u32 as i32;
pub const STATUS_CHECKOUT_REQUIRED: ::NTSTATUS = 0xC0000902u32 as i32;
pub const STATUS_BAD_FILE_TYPE: ::NTSTATUS = 0xC0000903u32 as i32;
pub const STATUS_FILE_TOO_LARGE: ::NTSTATUS = 0xC0000904u32 as i32;
pub const STATUS_FORMS_AUTH_REQUIRED: ::NTSTATUS = 0xC0000905u32 as i32;
pub const STATUS_VIRUS_INFECTED: ::NTSTATUS = 0xC0000906u32 as i32;
pub const STATUS_VIRUS_DELETED: ::NTSTATUS = 0xC0000907u32 as i32;
pub const STATUS_BAD_MCFG_TABLE: ::NTSTATUS = 0xC0000908u32 as i32;
pub const STATUS_CANNOT_BREAK_OPLOCK: ::NTSTATUS = 0xC0000909u32 as i32;
pub const STATUS_BAD_KEY: ::NTSTATUS = 0xC000090Au32 as i32;
pub const STATUS_BAD_DATA: ::NTSTATUS = 0xC000090Bu32 as i32;
pub const STATUS_NO_KEY: ::NTSTATUS = 0xC000090Cu32 as i32;
pub const STATUS_FILE_HANDLE_REVOKED: ::NTSTATUS = 0xC0000910u32 as i32;
pub const STATUS_WOW_ASSERTION: ::NTSTATUS = 0xC0009898u32 as i32;
pub const STATUS_INVALID_SIGNATURE: ::NTSTATUS = 0xC000A000u32 as i32;
pub const STATUS_HMAC_NOT_SUPPORTED: ::NTSTATUS = 0xC000A001u32 as i32;
pub const STATUS_AUTH_TAG_MISMATCH: ::NTSTATUS = 0xC000A002u32 as i32;
pub const STATUS_INVALID_STATE_TRANSITION: ::NTSTATUS = 0xC000A003u32 as i32;
pub const STATUS_INVALID_KERNEL_INFO_VERSION: ::NTSTATUS = 0xC000A004u32 as i32;
pub const STATUS_INVALID_PEP_INFO_VERSION: ::NTSTATUS = 0xC000A005u32 as i32;
pub const STATUS_HANDLE_REVOKED: ::NTSTATUS = 0xC000A006u32 as i32;
pub const STATUS_IPSEC_QUEUE_OVERFLOW: ::NTSTATUS = 0xC000A010u32 as i32;
pub const STATUS_ND_QUEUE_OVERFLOW: ::NTSTATUS = 0xC000A011u32 as i32;
pub const STATUS_HOPLIMIT_EXCEEDED: ::NTSTATUS = 0xC000A012u32 as i32;
pub const STATUS_PROTOCOL_NOT_SUPPORTED: ::NTSTATUS = 0xC000A013u32 as i32;
pub const STATUS_FASTPATH_REJECTED: ::NTSTATUS = 0xC000A014u32 as i32;
pub const STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED: ::NTSTATUS = 0xC000A080u32 as i32;
pub const STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR: ::NTSTATUS = 0xC000A081u32 as i32;
pub const STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR: ::NTSTATUS = 0xC000A082u32 as i32;
pub const STATUS_XML_PARSE_ERROR: ::NTSTATUS = 0xC000A083u32 as i32;
pub const STATUS_XMLDSIG_ERROR: ::NTSTATUS = 0xC000A084u32 as i32;
pub const STATUS_WRONG_COMPARTMENT: ::NTSTATUS = 0xC000A085u32 as i32;
pub const STATUS_AUTHIP_FAILURE: ::NTSTATUS = 0xC000A086u32 as i32;
pub const STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS: ::NTSTATUS = 0xC000A087u32 as i32;
pub const STATUS_DS_OID_NOT_FOUND: ::NTSTATUS = 0xC000A088u32 as i32;
pub const STATUS_INCORRECT_ACCOUNT_TYPE: ::NTSTATUS = 0xC000A089u32 as i32;
pub const STATUS_HASH_NOT_SUPPORTED: ::NTSTATUS = 0xC000A100u32 as i32;
pub const STATUS_HASH_NOT_PRESENT: ::NTSTATUS = 0xC000A101u32 as i32;
pub const STATUS_SECONDARY_IC_PROVIDER_NOT_REGISTERED: ::NTSTATUS = 0xC000A121u32 as i32;
pub const STATUS_GPIO_CLIENT_INFORMATION_INVALID: ::NTSTATUS = 0xC000A122u32 as i32;
pub const STATUS_GPIO_VERSION_NOT_SUPPORTED: ::NTSTATUS = 0xC000A123u32 as i32;
pub const STATUS_GPIO_INVALID_REGISTRATION_PACKET: ::NTSTATUS = 0xC000A124u32 as i32;
pub const STATUS_GPIO_OPERATION_DENIED: ::NTSTATUS = 0xC000A125u32 as i32;
pub const STATUS_GPIO_INCOMPATIBLE_CONNECT_MODE: ::NTSTATUS = 0xC000A126u32 as i32;
pub const STATUS_GPIO_INTERRUPT_ALREADY_UNMASKED: ::NTSTATUS = 0x8000A127u32 as i32;
pub const STATUS_CANNOT_SWITCH_RUNLEVEL: ::NTSTATUS = 0xC000A141u32 as i32;
pub const STATUS_INVALID_RUNLEVEL_SETTING: ::NTSTATUS = 0xC000A142u32 as i32;
pub const STATUS_RUNLEVEL_SWITCH_TIMEOUT: ::NTSTATUS = 0xC000A143u32 as i32;
pub const STATUS_SERVICES_FAILED_AUTOSTART: ::NTSTATUS = 0x4000A144;
pub const STATUS_RUNLEVEL_SWITCH_AGENT_TIMEOUT: ::NTSTATUS = 0xC000A145u32 as i32;
pub const STATUS_RUNLEVEL_SWITCH_IN_PROGRESS: ::NTSTATUS = 0xC000A146u32 as i32;
pub const STATUS_NOT_APPCONTAINER: ::NTSTATUS = 0xC000A200u32 as i32;
pub const STATUS_NOT_SUPPORTED_IN_APPCONTAINER: ::NTSTATUS = 0xC000A201u32 as i32;
pub const STATUS_INVALID_PACKAGE_SID_LENGTH: ::NTSTATUS = 0xC000A202u32 as i32;
pub const STATUS_APP_DATA_NOT_FOUND: ::NTSTATUS = 0xC000A281u32 as i32;
pub const STATUS_APP_DATA_EXPIRED: ::NTSTATUS = 0xC000A282u32 as i32;
pub const STATUS_APP_DATA_CORRUPT: ::NTSTATUS = 0xC000A283u32 as i32;
pub const STATUS_APP_DATA_LIMIT_EXCEEDED: ::NTSTATUS = 0xC000A284u32 as i32;
pub const STATUS_APP_DATA_REBOOT_REQUIRED: ::NTSTATUS = 0xC000A285u32 as i32;
pub const STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED: ::NTSTATUS = 0xC000A2A1u32 as i32;
pub const STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED: ::NTSTATUS = 0xC000A2A2u32 as i32;
pub const STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED: ::NTSTATUS = 0xC000A2A3u32 as i32;
pub const STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED: ::NTSTATUS = 0xC000A2A4u32 as i32;
pub const DBG_NO_STATE_CHANGE: ::NTSTATUS = 0xC0010001u32 as i32;
pub const DBG_APP_NOT_IDLE: ::NTSTATUS = 0xC0010002u32 as i32;
pub const RPC_NT_INVALID_STRING_BINDING: ::NTSTATUS = 0xC0020001u32 as i32;
pub const RPC_NT_WRONG_KIND_OF_BINDING: ::NTSTATUS = 0xC0020002u32 as i32;
pub const RPC_NT_INVALID_BINDING: ::NTSTATUS = 0xC0020003u32 as i32;
pub const RPC_NT_PROTSEQ_NOT_SUPPORTED: ::NTSTATUS = 0xC0020004u32 as i32;
pub const RPC_NT_INVALID_RPC_PROTSEQ: ::NTSTATUS = 0xC0020005u32 as i32;
pub const RPC_NT_INVALID_STRING_UUID: ::NTSTATUS = 0xC0020006u32 as i32;
pub const RPC_NT_INVALID_ENDPOINT_FORMAT: ::NTSTATUS = 0xC0020007u32 as i32;
pub const RPC_NT_INVALID_NET_ADDR: ::NTSTATUS = 0xC0020008u32 as i32;
pub const RPC_NT_NO_ENDPOINT_FOUND: ::NTSTATUS = 0xC0020009u32 as i32;
pub const RPC_NT_INVALID_TIMEOUT: ::NTSTATUS = 0xC002000Au32 as i32;
pub const RPC_NT_OBJECT_NOT_FOUND: ::NTSTATUS = 0xC002000Bu32 as i32;
pub const RPC_NT_ALREADY_REGISTERED: ::NTSTATUS = 0xC002000Cu32 as i32;
pub const RPC_NT_TYPE_ALREADY_REGISTERED: ::NTSTATUS = 0xC002000Du32 as i32;
pub const RPC_NT_ALREADY_LISTENING: ::NTSTATUS = 0xC002000Eu32 as i32;
pub const RPC_NT_NO_PROTSEQS_REGISTERED: ::NTSTATUS = 0xC002000Fu32 as i32;
pub const RPC_NT_NOT_LISTENING: ::NTSTATUS = 0xC0020010u32 as i32;
pub const RPC_NT_UNKNOWN_MGR_TYPE: ::NTSTATUS = 0xC0020011u32 as i32;
pub const RPC_NT_UNKNOWN_IF: ::NTSTATUS = 0xC0020012u32 as i32;
pub const RPC_NT_NO_BINDINGS: ::NTSTATUS = 0xC0020013u32 as i32;
pub const RPC_NT_NO_PROTSEQS: ::NTSTATUS = 0xC0020014u32 as i32;
pub const RPC_NT_CANT_CREATE_ENDPOINT: ::NTSTATUS = 0xC0020015u32 as i32;
pub const RPC_NT_OUT_OF_RESOURCES: ::NTSTATUS = 0xC0020016u32 as i32;
pub const RPC_NT_SERVER_UNAVAILABLE: ::NTSTATUS = 0xC0020017u32 as i32;
pub const RPC_NT_SERVER_TOO_BUSY: ::NTSTATUS = 0xC0020018u32 as i32;
pub const RPC_NT_INVALID_NETWORK_OPTIONS: ::NTSTATUS = 0xC0020019u32 as i32;
pub const RPC_NT_NO_CALL_ACTIVE: ::NTSTATUS = 0xC002001Au32 as i32;
pub const RPC_NT_CALL_FAILED: ::NTSTATUS = 0xC002001Bu32 as i32;
pub const RPC_NT_CALL_FAILED_DNE: ::NTSTATUS = 0xC002001Cu32 as i32;
pub const RPC_NT_PROTOCOL_ERROR: ::NTSTATUS = 0xC002001Du32 as i32;
pub const RPC_NT_UNSUPPORTED_TRANS_SYN: ::NTSTATUS = 0xC002001Fu32 as i32;
pub const RPC_NT_UNSUPPORTED_TYPE: ::NTSTATUS = 0xC0020021u32 as i32;
pub const RPC_NT_INVALID_TAG: ::NTSTATUS = 0xC0020022u32 as i32;
pub const RPC_NT_INVALID_BOUND: ::NTSTATUS = 0xC0020023u32 as i32;
pub const RPC_NT_NO_ENTRY_NAME: ::NTSTATUS = 0xC0020024u32 as i32;
pub const RPC_NT_INVALID_NAME_SYNTAX: ::NTSTATUS = 0xC0020025u32 as i32;
pub const RPC_NT_UNSUPPORTED_NAME_SYNTAX: ::NTSTATUS = 0xC0020026u32 as i32;
pub const RPC_NT_UUID_NO_ADDRESS: ::NTSTATUS = 0xC0020028u32 as i32;
pub const RPC_NT_DUPLICATE_ENDPOINT: ::NTSTATUS = 0xC0020029u32 as i32;
pub const RPC_NT_UNKNOWN_AUTHN_TYPE: ::NTSTATUS = 0xC002002Au32 as i32;
pub const RPC_NT_MAX_CALLS_TOO_SMALL: ::NTSTATUS = 0xC002002Bu32 as i32;
pub const RPC_NT_STRING_TOO_LONG: ::NTSTATUS = 0xC002002Cu32 as i32;
pub const RPC_NT_PROTSEQ_NOT_FOUND: ::NTSTATUS = 0xC002002Du32 as i32;
pub const RPC_NT_PROCNUM_OUT_OF_RANGE: ::NTSTATUS = 0xC002002Eu32 as i32;
pub const RPC_NT_BINDING_HAS_NO_AUTH: ::NTSTATUS = 0xC002002Fu32 as i32;
pub const RPC_NT_UNKNOWN_AUTHN_SERVICE: ::NTSTATUS = 0xC0020030u32 as i32;
pub const RPC_NT_UNKNOWN_AUTHN_LEVEL: ::NTSTATUS = 0xC0020031u32 as i32;
pub const RPC_NT_INVALID_AUTH_IDENTITY: ::NTSTATUS = 0xC0020032u32 as i32;
pub const RPC_NT_UNKNOWN_AUTHZ_SERVICE: ::NTSTATUS = 0xC0020033u32 as i32;
pub const EPT_NT_INVALID_ENTRY: ::NTSTATUS = 0xC0020034u32 as i32;
pub const EPT_NT_CANT_PERFORM_OP: ::NTSTATUS = 0xC0020035u32 as i32;
pub const EPT_NT_NOT_REGISTERED: ::NTSTATUS = 0xC0020036u32 as i32;
pub const RPC_NT_NOTHING_TO_EXPORT: ::NTSTATUS = 0xC0020037u32 as i32;
pub const RPC_NT_INCOMPLETE_NAME: ::NTSTATUS = 0xC0020038u32 as i32;
pub const RPC_NT_INVALID_VERS_OPTION: ::NTSTATUS = 0xC0020039u32 as i32;
pub const RPC_NT_NO_MORE_MEMBERS: ::NTSTATUS = 0xC002003Au32 as i32;
pub const RPC_NT_NOT_ALL_OBJS_UNEXPORTED: ::NTSTATUS = 0xC002003Bu32 as i32;
pub const RPC_NT_INTERFACE_NOT_FOUND: ::NTSTATUS = 0xC002003Cu32 as i32;
pub const RPC_NT_ENTRY_ALREADY_EXISTS: ::NTSTATUS = 0xC002003Du32 as i32;
pub const RPC_NT_ENTRY_NOT_FOUND: ::NTSTATUS = 0xC002003Eu32 as i32;
pub const RPC_NT_NAME_SERVICE_UNAVAILABLE: ::NTSTATUS = 0xC002003Fu32 as i32;
pub const RPC_NT_INVALID_NAF_ID: ::NTSTATUS = 0xC0020040u32 as i32;
pub const RPC_NT_CANNOT_SUPPORT: ::NTSTATUS = 0xC0020041u32 as i32;
pub const RPC_NT_NO_CONTEXT_AVAILABLE: ::NTSTATUS = 0xC0020042u32 as i32;
pub const RPC_NT_INTERNAL_ERROR: ::NTSTATUS = 0xC0020043u32 as i32;
pub const RPC_NT_ZERO_DIVIDE: ::NTSTATUS = 0xC0020044u32 as i32;
pub const RPC_NT_ADDRESS_ERROR: ::NTSTATUS = 0xC0020045u32 as i32;
pub const RPC_NT_FP_DIV_ZERO: ::NTSTATUS = 0xC0020046u32 as i32;
pub const RPC_NT_FP_UNDERFLOW: ::NTSTATUS = 0xC0020047u32 as i32;
pub const RPC_NT_FP_OVERFLOW: ::NTSTATUS = 0xC0020048u32 as i32;
pub const RPC_NT_NO_MORE_ENTRIES: ::NTSTATUS = 0xC0030001u32 as i32;
pub const RPC_NT_SS_CHAR_TRANS_OPEN_FAIL: ::NTSTATUS = 0xC0030002u32 as i32;
pub const RPC_NT_SS_CHAR_TRANS_SHORT_FILE: ::NTSTATUS = 0xC0030003u32 as i32;
pub const RPC_NT_SS_IN_NULL_CONTEXT: ::NTSTATUS = 0xC0030004u32 as i32;
pub const RPC_NT_SS_CONTEXT_MISMATCH: ::NTSTATUS = 0xC0030005u32 as i32;
pub const RPC_NT_SS_CONTEXT_DAMAGED: ::NTSTATUS = 0xC0030006u32 as i32;
pub const RPC_NT_SS_HANDLES_MISMATCH: ::NTSTATUS = 0xC0030007u32 as i32;
pub const RPC_NT_SS_CANNOT_GET_CALL_HANDLE: ::NTSTATUS = 0xC0030008u32 as i32;
pub const RPC_NT_NULL_REF_POINTER: ::NTSTATUS = 0xC0030009u32 as i32;
pub const RPC_NT_ENUM_VALUE_OUT_OF_RANGE: ::NTSTATUS = 0xC003000Au32 as i32;
pub const RPC_NT_BYTE_COUNT_TOO_SMALL: ::NTSTATUS = 0xC003000Bu32 as i32;
pub const RPC_NT_BAD_STUB_DATA: ::NTSTATUS = 0xC003000Cu32 as i32;
pub const RPC_NT_CALL_IN_PROGRESS: ::NTSTATUS = 0xC0020049u32 as i32;
pub const RPC_NT_NO_MORE_BINDINGS: ::NTSTATUS = 0xC002004Au32 as i32;
pub const RPC_NT_GROUP_MEMBER_NOT_FOUND: ::NTSTATUS = 0xC002004Bu32 as i32;
pub const EPT_NT_CANT_CREATE: ::NTSTATUS = 0xC002004Cu32 as i32;
pub const RPC_NT_INVALID_OBJECT: ::NTSTATUS = 0xC002004Du32 as i32;
pub const RPC_NT_NO_INTERFACES: ::NTSTATUS = 0xC002004Fu32 as i32;
pub const RPC_NT_CALL_CANCELLED: ::NTSTATUS = 0xC0020050u32 as i32;
pub const RPC_NT_BINDING_INCOMPLETE: ::NTSTATUS = 0xC0020051u32 as i32;
pub const RPC_NT_COMM_FAILURE: ::NTSTATUS = 0xC0020052u32 as i32;
pub const RPC_NT_UNSUPPORTED_AUTHN_LEVEL: ::NTSTATUS = 0xC0020053u32 as i32;
pub const RPC_NT_NO_PRINC_NAME: ::NTSTATUS = 0xC0020054u32 as i32;
pub const RPC_NT_NOT_RPC_ERROR: ::NTSTATUS = 0xC0020055u32 as i32;
pub const RPC_NT_UUID_LOCAL_ONLY: ::NTSTATUS = 0x40020056;
pub const RPC_NT_SEC_PKG_ERROR: ::NTSTATUS = 0xC0020057u32 as i32;
pub const RPC_NT_NOT_CANCELLED: ::NTSTATUS = 0xC0020058u32 as i32;
pub const RPC_NT_INVALID_ES_ACTION: ::NTSTATUS = 0xC0030059u32 as i32;
pub const RPC_NT_WRONG_ES_VERSION: ::NTSTATUS = 0xC003005Au32 as i32;
pub const RPC_NT_WRONG_STUB_VERSION: ::NTSTATUS = 0xC003005Bu32 as i32;
pub const RPC_NT_INVALID_PIPE_OBJECT: ::NTSTATUS = 0xC003005Cu32 as i32;
pub const RPC_NT_INVALID_PIPE_OPERATION: ::NTSTATUS = 0xC003005Du32 as i32;
pub const RPC_NT_WRONG_PIPE_VERSION: ::NTSTATUS = 0xC003005Eu32 as i32;
pub const RPC_NT_PIPE_CLOSED: ::NTSTATUS = 0xC003005Fu32 as i32;
pub const RPC_NT_PIPE_DISCIPLINE_ERROR: ::NTSTATUS = 0xC0030060u32 as i32;
pub const RPC_NT_PIPE_EMPTY: ::NTSTATUS = 0xC0030061u32 as i32;
pub const RPC_NT_INVALID_ASYNC_HANDLE: ::NTSTATUS = 0xC0020062u32 as i32;
pub const RPC_NT_INVALID_ASYNC_CALL: ::NTSTATUS = 0xC0020063u32 as i32;
pub const RPC_NT_PROXY_ACCESS_DENIED: ::NTSTATUS = 0xC0020064u32 as i32;
pub const RPC_NT_COOKIE_AUTH_FAILED: ::NTSTATUS = 0xC0020065u32 as i32;
pub const RPC_NT_SEND_INCOMPLETE: ::NTSTATUS = 0x400200AF;
pub const STATUS_ACPI_INVALID_OPCODE: ::NTSTATUS = 0xC0140001u32 as i32;
pub const STATUS_ACPI_STACK_OVERFLOW: ::NTSTATUS = 0xC0140002u32 as i32;
pub const STATUS_ACPI_ASSERT_FAILED: ::NTSTATUS = 0xC0140003u32 as i32;
pub const STATUS_ACPI_INVALID_INDEX: ::NTSTATUS = 0xC0140004u32 as i32;
pub const STATUS_ACPI_INVALID_ARGUMENT: ::NTSTATUS = 0xC0140005u32 as i32;
pub const STATUS_ACPI_FATAL: ::NTSTATUS = 0xC0140006u32 as i32;
pub const STATUS_ACPI_INVALID_SUPERNAME: ::NTSTATUS = 0xC0140007u32 as i32;
pub const STATUS_ACPI_INVALID_ARGTYPE: ::NTSTATUS = 0xC0140008u32 as i32;
pub const STATUS_ACPI_INVALID_OBJTYPE: ::NTSTATUS = 0xC0140009u32 as i32;
pub const STATUS_ACPI_INVALID_TARGETTYPE: ::NTSTATUS = 0xC014000Au32 as i32;
pub const STATUS_ACPI_INCORRECT_ARGUMENT_COUNT: ::NTSTATUS = 0xC014000Bu32 as i32;
pub const STATUS_ACPI_ADDRESS_NOT_MAPPED: ::NTSTATUS = 0xC014000Cu32 as i32;
pub const STATUS_ACPI_INVALID_EVENTTYPE: ::NTSTATUS = 0xC014000Du32 as i32;
pub const STATUS_ACPI_HANDLER_COLLISION: ::NTSTATUS = 0xC014000Eu32 as i32;
pub const STATUS_ACPI_INVALID_DATA: ::NTSTATUS = 0xC014000Fu32 as i32;
pub const STATUS_ACPI_INVALID_REGION: ::NTSTATUS = 0xC0140010u32 as i32;
pub const STATUS_ACPI_INVALID_ACCESS_SIZE: ::NTSTATUS = 0xC0140011u32 as i32;
pub const STATUS_ACPI_ACQUIRE_GLOBAL_LOCK: ::NTSTATUS = 0xC0140012u32 as i32;
pub const STATUS_ACPI_ALREADY_INITIALIZED: ::NTSTATUS = 0xC0140013u32 as i32;
pub const STATUS_ACPI_NOT_INITIALIZED: ::NTSTATUS = 0xC0140014u32 as i32;
pub const STATUS_ACPI_INVALID_MUTEX_LEVEL: ::NTSTATUS = 0xC0140015u32 as i32;
pub const STATUS_ACPI_MUTEX_NOT_OWNED: ::NTSTATUS = 0xC0140016u32 as i32;
pub const STATUS_ACPI_MUTEX_NOT_OWNER: ::NTSTATUS = 0xC0140017u32 as i32;
pub const STATUS_ACPI_RS_ACCESS: ::NTSTATUS = 0xC0140018u32 as i32;
pub const STATUS_ACPI_INVALID_TABLE: ::NTSTATUS = 0xC0140019u32 as i32;
pub const STATUS_ACPI_REG_HANDLER_FAILED: ::NTSTATUS = 0xC0140020u32 as i32;
pub const STATUS_ACPI_POWER_REQUEST_FAILED: ::NTSTATUS = 0xC0140021u32 as i32;
pub const STATUS_CTX_WINSTATION_NAME_INVALID: ::NTSTATUS = 0xC00A0001u32 as i32;
pub const STATUS_CTX_INVALID_PD: ::NTSTATUS = 0xC00A0002u32 as i32;
pub const STATUS_CTX_PD_NOT_FOUND: ::NTSTATUS = 0xC00A0003u32 as i32;
pub const STATUS_CTX_CDM_CONNECT: ::NTSTATUS = 0x400A0004;
pub const STATUS_CTX_CDM_DISCONNECT: ::NTSTATUS = 0x400A0005;
pub const STATUS_CTX_CLOSE_PENDING: ::NTSTATUS = 0xC00A0006u32 as i32;
pub const STATUS_CTX_NO_OUTBUF: ::NTSTATUS = 0xC00A0007u32 as i32;
pub const STATUS_CTX_MODEM_INF_NOT_FOUND: ::NTSTATUS = 0xC00A0008u32 as i32;
pub const STATUS_CTX_INVALID_MODEMNAME: ::NTSTATUS = 0xC00A0009u32 as i32;
pub const STATUS_CTX_RESPONSE_ERROR: ::NTSTATUS = 0xC00A000Au32 as i32;
pub const STATUS_CTX_MODEM_RESPONSE_TIMEOUT: ::NTSTATUS = 0xC00A000Bu32 as i32;
pub const STATUS_CTX_MODEM_RESPONSE_NO_CARRIER: ::NTSTATUS = 0xC00A000Cu32 as i32;
pub const STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE: ::NTSTATUS = 0xC00A000Du32 as i32;
pub const STATUS_CTX_MODEM_RESPONSE_BUSY: ::NTSTATUS = 0xC00A000Eu32 as i32;
pub const STATUS_CTX_MODEM_RESPONSE_VOICE: ::NTSTATUS = 0xC00A000Fu32 as i32;
pub const STATUS_CTX_TD_ERROR: ::NTSTATUS = 0xC00A0010u32 as i32;
pub const STATUS_CTX_LICENSE_CLIENT_INVALID: ::NTSTATUS = 0xC00A0012u32 as i32;
pub const STATUS_CTX_LICENSE_NOT_AVAILABLE: ::NTSTATUS = 0xC00A0013u32 as i32;
pub const STATUS_CTX_LICENSE_EXPIRED: ::NTSTATUS = 0xC00A0014u32 as i32;
pub const STATUS_CTX_WINSTATION_NOT_FOUND: ::NTSTATUS = 0xC00A0015u32 as i32;
pub const STATUS_CTX_WINSTATION_NAME_COLLISION: ::NTSTATUS = 0xC00A0016u32 as i32;
pub const STATUS_CTX_WINSTATION_BUSY: ::NTSTATUS = 0xC00A0017u32 as i32;
pub const STATUS_CTX_BAD_VIDEO_MODE: ::NTSTATUS = 0xC00A0018u32 as i32;
pub const STATUS_CTX_GRAPHICS_INVALID: ::NTSTATUS = 0xC00A0022u32 as i32;
pub const STATUS_CTX_NOT_CONSOLE: ::NTSTATUS = 0xC00A0024u32 as i32;
pub const STATUS_CTX_CLIENT_QUERY_TIMEOUT: ::NTSTATUS = 0xC00A0026u32 as i32;
pub const STATUS_CTX_CONSOLE_DISCONNECT: ::NTSTATUS = 0xC00A0027u32 as i32;
pub const STATUS_CTX_CONSOLE_CONNECT: ::NTSTATUS = 0xC00A0028u32 as i32;
pub const STATUS_CTX_SHADOW_DENIED: ::NTSTATUS = 0xC00A002Au32 as i32;
pub const STATUS_CTX_WINSTATION_ACCESS_DENIED: ::NTSTATUS = 0xC00A002Bu32 as i32;
pub const STATUS_CTX_INVALID_WD: ::NTSTATUS = 0xC00A002Eu32 as i32;
pub const STATUS_CTX_WD_NOT_FOUND: ::NTSTATUS = 0xC00A002Fu32 as i32;
pub const STATUS_CTX_SHADOW_INVALID: ::NTSTATUS = 0xC00A0030u32 as i32;
pub const STATUS_CTX_SHADOW_DISABLED: ::NTSTATUS = 0xC00A0031u32 as i32;
pub const STATUS_RDP_PROTOCOL_ERROR: ::NTSTATUS = 0xC00A0032u32 as i32;
pub const STATUS_CTX_CLIENT_LICENSE_NOT_SET: ::NTSTATUS = 0xC00A0033u32 as i32;
pub const STATUS_CTX_CLIENT_LICENSE_IN_USE: ::NTSTATUS = 0xC00A0034u32 as i32;
pub const STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE: ::NTSTATUS = 0xC00A0035u32 as i32;
pub const STATUS_CTX_SHADOW_NOT_RUNNING: ::NTSTATUS = 0xC00A0036u32 as i32;
pub const STATUS_CTX_LOGON_DISABLED: ::NTSTATUS = 0xC00A0037u32 as i32;
pub const STATUS_CTX_SECURITY_LAYER_ERROR: ::NTSTATUS = 0xC00A0038u32 as i32;
pub const STATUS_TS_INCOMPATIBLE_SESSIONS: ::NTSTATUS = 0xC00A0039u32 as i32;
pub const STATUS_TS_VIDEO_SUBSYSTEM_ERROR: ::NTSTATUS = 0xC00A003Au32 as i32;
pub const STATUS_PNP_BAD_MPS_TABLE: ::NTSTATUS = 0xC0040035u32 as i32;
pub const STATUS_PNP_TRANSLATION_FAILED: ::NTSTATUS = 0xC0040036u32 as i32;
pub const STATUS_PNP_IRQ_TRANSLATION_FAILED: ::NTSTATUS = 0xC0040037u32 as i32;
pub const STATUS_PNP_INVALID_ID: ::NTSTATUS = 0xC0040038u32 as i32;
pub const STATUS_IO_REISSUE_AS_CACHED: ::NTSTATUS = 0xC0040039u32 as i32;
pub const STATUS_MUI_FILE_NOT_FOUND: ::NTSTATUS = 0xC00B0001u32 as i32;
pub const STATUS_MUI_INVALID_FILE: ::NTSTATUS = 0xC00B0002u32 as i32;
pub const STATUS_MUI_INVALID_RC_CONFIG: ::NTSTATUS = 0xC00B0003u32 as i32;
pub const STATUS_MUI_INVALID_LOCALE_NAME: ::NTSTATUS = 0xC00B0004u32 as i32;
pub const STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME: ::NTSTATUS = 0xC00B0005u32 as i32;
pub const STATUS_MUI_FILE_NOT_LOADED: ::NTSTATUS = 0xC00B0006u32 as i32;
pub const STATUS_RESOURCE_ENUM_USER_STOP: ::NTSTATUS = 0xC00B0007u32 as i32;
pub const STATUS_FLT_NO_HANDLER_DEFINED: ::NTSTATUS = 0xC01C0001u32 as i32;
pub const STATUS_FLT_CONTEXT_ALREADY_DEFINED: ::NTSTATUS = 0xC01C0002u32 as i32;
pub const STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST: ::NTSTATUS = 0xC01C0003u32 as i32;
pub const STATUS_FLT_DISALLOW_FAST_IO: ::NTSTATUS = 0xC01C0004u32 as i32;
pub const STATUS_FLT_INVALID_NAME_REQUEST: ::NTSTATUS = 0xC01C0005u32 as i32;
pub const STATUS_FLT_NOT_SAFE_TO_POST_OPERATION: ::NTSTATUS = 0xC01C0006u32 as i32;
pub const STATUS_FLT_NOT_INITIALIZED: ::NTSTATUS = 0xC01C0007u32 as i32;
pub const STATUS_FLT_FILTER_NOT_READY: ::NTSTATUS = 0xC01C0008u32 as i32;
pub const STATUS_FLT_POST_OPERATION_CLEANUP: ::NTSTATUS = 0xC01C0009u32 as i32;
pub const STATUS_FLT_INTERNAL_ERROR: ::NTSTATUS = 0xC01C000Au32 as i32;
pub const STATUS_FLT_DELETING_OBJECT: ::NTSTATUS = 0xC01C000Bu32 as i32;
pub const STATUS_FLT_MUST_BE_NONPAGED_POOL: ::NTSTATUS = 0xC01C000Cu32 as i32;
pub const STATUS_FLT_DUPLICATE_ENTRY: ::NTSTATUS = 0xC01C000Du32 as i32;
pub const STATUS_FLT_CBDQ_DISABLED: ::NTSTATUS = 0xC01C000Eu32 as i32;
pub const STATUS_FLT_DO_NOT_ATTACH: ::NTSTATUS = 0xC01C000Fu32 as i32;
pub const STATUS_FLT_DO_NOT_DETACH: ::NTSTATUS = 0xC01C0010u32 as i32;
pub const STATUS_FLT_INSTANCE_ALTITUDE_COLLISION: ::NTSTATUS = 0xC01C0011u32 as i32;
pub const STATUS_FLT_INSTANCE_NAME_COLLISION: ::NTSTATUS = 0xC01C0012u32 as i32;
pub const STATUS_FLT_FILTER_NOT_FOUND: ::NTSTATUS = 0xC01C0013u32 as i32;
pub const STATUS_FLT_VOLUME_NOT_FOUND: ::NTSTATUS = 0xC01C0014u32 as i32;
pub const STATUS_FLT_INSTANCE_NOT_FOUND: ::NTSTATUS = 0xC01C0015u32 as i32;
pub const STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND: ::NTSTATUS = 0xC01C0016u32 as i32;
pub const STATUS_FLT_INVALID_CONTEXT_REGISTRATION: ::NTSTATUS = 0xC01C0017u32 as i32;
pub const STATUS_FLT_NAME_CACHE_MISS: ::NTSTATUS = 0xC01C0018u32 as i32;
pub const STATUS_FLT_NO_DEVICE_OBJECT: ::NTSTATUS = 0xC01C0019u32 as i32;
pub const STATUS_FLT_VOLUME_ALREADY_MOUNTED: ::NTSTATUS = 0xC01C001Au32 as i32;
pub const STATUS_FLT_ALREADY_ENLISTED: ::NTSTATUS = 0xC01C001Bu32 as i32;
pub const STATUS_FLT_CONTEXT_ALREADY_LINKED: ::NTSTATUS = 0xC01C001Cu32 as i32;
pub const STATUS_FLT_NO_WAITER_FOR_REPLY: ::NTSTATUS = 0xC01C0020u32 as i32;
pub const STATUS_FLT_REGISTRATION_BUSY: ::NTSTATUS = 0xC01C0023u32 as i32;
pub const STATUS_SXS_SECTION_NOT_FOUND: ::NTSTATUS = 0xC0150001u32 as i32;
pub const STATUS_SXS_CANT_GEN_ACTCTX: ::NTSTATUS = 0xC0150002u32 as i32;
pub const STATUS_SXS_INVALID_ACTCTXDATA_FORMAT: ::NTSTATUS = 0xC0150003u32 as i32;
pub const STATUS_SXS_ASSEMBLY_NOT_FOUND: ::NTSTATUS = 0xC0150004u32 as i32;
pub const STATUS_SXS_MANIFEST_FORMAT_ERROR: ::NTSTATUS = 0xC0150005u32 as i32;
pub const STATUS_SXS_MANIFEST_PARSE_ERROR: ::NTSTATUS = 0xC0150006u32 as i32;
pub const STATUS_SXS_ACTIVATION_CONTEXT_DISABLED: ::NTSTATUS = 0xC0150007u32 as i32;
pub const STATUS_SXS_KEY_NOT_FOUND: ::NTSTATUS = 0xC0150008u32 as i32;
pub const STATUS_SXS_VERSION_CONFLICT: ::NTSTATUS = 0xC0150009u32 as i32;
pub const STATUS_SXS_WRONG_SECTION_TYPE: ::NTSTATUS = 0xC015000Au32 as i32;
pub const STATUS_SXS_THREAD_QUERIES_DISABLED: ::NTSTATUS = 0xC015000Bu32 as i32;
pub const STATUS_SXS_ASSEMBLY_MISSING: ::NTSTATUS = 0xC015000Cu32 as i32;
pub const STATUS_SXS_RELEASE_ACTIVATION_CONTEXT: ::NTSTATUS = 0x4015000D;
pub const STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET: ::NTSTATUS = 0xC015000Eu32 as i32;
pub const STATUS_SXS_EARLY_DEACTIVATION: ::NTSTATUS = 0xC015000Fu32 as i32;
pub const STATUS_SXS_INVALID_DEACTIVATION: ::NTSTATUS = 0xC0150010u32 as i32;
pub const STATUS_SXS_MULTIPLE_DEACTIVATION: ::NTSTATUS = 0xC0150011u32 as i32;
pub const STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: ::NTSTATUS = 0xC0150012u32 as i32;
pub const STATUS_SXS_PROCESS_TERMINATION_REQUESTED: ::NTSTATUS = 0xC0150013u32 as i32;
pub const STATUS_SXS_CORRUPT_ACTIVATION_STACK: ::NTSTATUS = 0xC0150014u32 as i32;
pub const STATUS_SXS_CORRUPTION: ::NTSTATUS = 0xC0150015u32 as i32;
pub const STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: ::NTSTATUS = 0xC0150016u32 as i32;
pub const STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: ::NTSTATUS = 0xC0150017u32 as i32;
pub const STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: ::NTSTATUS = 0xC0150018u32 as i32;
pub const STATUS_SXS_IDENTITY_PARSE_ERROR: ::NTSTATUS = 0xC0150019u32 as i32;
pub const STATUS_SXS_COMPONENT_STORE_CORRUPT: ::NTSTATUS = 0xC015001Au32 as i32;
pub const STATUS_SXS_FILE_HASH_MISMATCH: ::NTSTATUS = 0xC015001Bu32 as i32;
pub const STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: ::NTSTATUS = 0xC015001Cu32 as i32;
pub const STATUS_SXS_IDENTITIES_DIFFERENT: ::NTSTATUS = 0xC015001Du32 as i32;
pub const STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: ::NTSTATUS = 0xC015001Eu32 as i32;
pub const STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY: ::NTSTATUS = 0xC015001Fu32 as i32;
pub const STATUS_ADVANCED_INSTALLER_FAILED: ::NTSTATUS = 0xC0150020u32 as i32;
pub const STATUS_XML_ENCODING_MISMATCH: ::NTSTATUS = 0xC0150021u32 as i32;
pub const STATUS_SXS_MANIFEST_TOO_BIG: ::NTSTATUS = 0xC0150022u32 as i32;
pub const STATUS_SXS_SETTING_NOT_REGISTERED: ::NTSTATUS = 0xC0150023u32 as i32;
pub const STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE: ::NTSTATUS = 0xC0150024u32 as i32;
pub const STATUS_SMI_PRIMITIVE_INSTALLER_FAILED: ::NTSTATUS = 0xC0150025u32 as i32;
pub const STATUS_GENERIC_COMMAND_FAILED: ::NTSTATUS = 0xC0150026u32 as i32;
pub const STATUS_SXS_FILE_HASH_MISSING: ::NTSTATUS = 0xC0150027u32 as i32;
pub const STATUS_CLUSTER_INVALID_NODE: ::NTSTATUS = 0xC0130001u32 as i32;
pub const STATUS_CLUSTER_NODE_EXISTS: ::NTSTATUS = 0xC0130002u32 as i32;
pub const STATUS_CLUSTER_JOIN_IN_PROGRESS: ::NTSTATUS = 0xC0130003u32 as i32;
pub const STATUS_CLUSTER_NODE_NOT_FOUND: ::NTSTATUS = 0xC0130004u32 as i32;
pub const STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND: ::NTSTATUS = 0xC0130005u32 as i32;
pub const STATUS_CLUSTER_NETWORK_EXISTS: ::NTSTATUS = 0xC0130006u32 as i32;
pub const STATUS_CLUSTER_NETWORK_NOT_FOUND: ::NTSTATUS = 0xC0130007u32 as i32;
pub const STATUS_CLUSTER_NETINTERFACE_EXISTS: ::NTSTATUS = 0xC0130008u32 as i32;
pub const STATUS_CLUSTER_NETINTERFACE_NOT_FOUND: ::NTSTATUS = 0xC0130009u32 as i32;
pub const STATUS_CLUSTER_INVALID_REQUEST: ::NTSTATUS = 0xC013000Au32 as i32;
pub const STATUS_CLUSTER_INVALID_NETWORK_PROVIDER: ::NTSTATUS = 0xC013000Bu32 as i32;
pub const STATUS_CLUSTER_NODE_DOWN: ::NTSTATUS = 0xC013000Cu32 as i32;
pub const STATUS_CLUSTER_NODE_UNREACHABLE: ::NTSTATUS = 0xC013000Du32 as i32;
pub const STATUS_CLUSTER_NODE_NOT_MEMBER: ::NTSTATUS = 0xC013000Eu32 as i32;
pub const STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS: ::NTSTATUS = 0xC013000Fu32 as i32;
pub const STATUS_CLUSTER_INVALID_NETWORK: ::NTSTATUS = 0xC0130010u32 as i32;
pub const STATUS_CLUSTER_NO_NET_ADAPTERS: ::NTSTATUS = 0xC0130011u32 as i32;
pub const STATUS_CLUSTER_NODE_UP: ::NTSTATUS = 0xC0130012u32 as i32;
pub const STATUS_CLUSTER_NODE_PAUSED: ::NTSTATUS = 0xC0130013u32 as i32;
pub const STATUS_CLUSTER_NODE_NOT_PAUSED: ::NTSTATUS = 0xC0130014u32 as i32;
pub const STATUS_CLUSTER_NO_SECURITY_CONTEXT: ::NTSTATUS = 0xC0130015u32 as i32;
pub const STATUS_CLUSTER_NETWORK_NOT_INTERNAL: ::NTSTATUS = 0xC0130016u32 as i32;
pub const STATUS_CLUSTER_POISONED: ::NTSTATUS = 0xC0130017u32 as i32;
pub const STATUS_CLUSTER_NON_CSV_PATH: ::NTSTATUS = 0xC0130018u32 as i32;
pub const STATUS_CLUSTER_CSV_VOLUME_NOT_LOCAL: ::NTSTATUS = 0xC0130019u32 as i32;
pub const STATUS_CLUSTER_CSV_READ_OPLOCK_BREAK_IN_PROGRESS: ::NTSTATUS = 0xC0130020u32 as i32;
pub const STATUS_CLUSTER_CSV_AUTO_PAUSE_ERROR: ::NTSTATUS = 0xC0130021u32 as i32;
pub const STATUS_CLUSTER_CSV_REDIRECTED: ::NTSTATUS = 0xC0130022u32 as i32;
pub const STATUS_CLUSTER_CSV_NOT_REDIRECTED: ::NTSTATUS = 0xC0130023u32 as i32;
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING: ::NTSTATUS = 0xC0130024u32 as i32;
pub const STATUS_CLUSTER_CSV_SNAPSHOT_CREATION_IN_PROGRESS: ::NTSTATUS = 0xC0130025u32 as i32;
pub const STATUS_CLUSTER_CSV_VOLUME_DRAINING_SUCCEEDED_DOWNLEVEL: ::NTSTATUS = 0xC0130026u32 as i32;
pub const STATUS_CLUSTER_CSV_NO_SNAPSHOTS: ::NTSTATUS = 0xC0130027u32 as i32;
pub const STATUS_CSV_IO_PAUSE_TIMEOUT: ::NTSTATUS = 0xC0130028u32 as i32;
pub const STATUS_TRANSACTIONAL_CONFLICT: ::NTSTATUS = 0xC0190001u32 as i32;
pub const STATUS_INVALID_TRANSACTION: ::NTSTATUS = 0xC0190002u32 as i32;
pub const STATUS_TRANSACTION_NOT_ACTIVE: ::NTSTATUS = 0xC0190003u32 as i32;
pub const STATUS_TM_INITIALIZATION_FAILED: ::NTSTATUS = 0xC0190004u32 as i32;
pub const STATUS_RM_NOT_ACTIVE: ::NTSTATUS = 0xC0190005u32 as i32;
pub const STATUS_RM_METADATA_CORRUPT: ::NTSTATUS = 0xC0190006u32 as i32;
pub const STATUS_TRANSACTION_NOT_JOINED: ::NTSTATUS = 0xC0190007u32 as i32;
pub const STATUS_DIRECTORY_NOT_RM: ::NTSTATUS = 0xC0190008u32 as i32;
pub const STATUS_COULD_NOT_RESIZE_LOG: ::NTSTATUS = 0x80190009u32 as i32;
pub const STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE: ::NTSTATUS = 0xC019000Au32 as i32;
pub const STATUS_LOG_RESIZE_INVALID_SIZE: ::NTSTATUS = 0xC019000Bu32 as i32;
pub const STATUS_REMOTE_FILE_VERSION_MISMATCH: ::NTSTATUS = 0xC019000Cu32 as i32;
pub const STATUS_CRM_PROTOCOL_ALREADY_EXISTS: ::NTSTATUS = 0xC019000Fu32 as i32;
pub const STATUS_TRANSACTION_PROPAGATION_FAILED: ::NTSTATUS = 0xC0190010u32 as i32;
pub const STATUS_CRM_PROTOCOL_NOT_FOUND: ::NTSTATUS = 0xC0190011u32 as i32;
pub const STATUS_TRANSACTION_SUPERIOR_EXISTS: ::NTSTATUS = 0xC0190012u32 as i32;
pub const STATUS_TRANSACTION_REQUEST_NOT_VALID: ::NTSTATUS = 0xC0190013u32 as i32;
pub const STATUS_TRANSACTION_NOT_REQUESTED: ::NTSTATUS = 0xC0190014u32 as i32;
pub const STATUS_TRANSACTION_ALREADY_ABORTED: ::NTSTATUS = 0xC0190015u32 as i32;
pub const STATUS_TRANSACTION_ALREADY_COMMITTED: ::NTSTATUS = 0xC0190016u32 as i32;
pub const STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER: ::NTSTATUS = 0xC0190017u32 as i32;
pub const STATUS_CURRENT_TRANSACTION_NOT_VALID: ::NTSTATUS = 0xC0190018u32 as i32;
pub const STATUS_LOG_GROWTH_FAILED: ::NTSTATUS = 0xC0190019u32 as i32;
pub const STATUS_OBJECT_NO_LONGER_EXISTS: ::NTSTATUS = 0xC0190021u32 as i32;
pub const STATUS_STREAM_MINIVERSION_NOT_FOUND: ::NTSTATUS = 0xC0190022u32 as i32;
pub const STATUS_STREAM_MINIVERSION_NOT_VALID: ::NTSTATUS = 0xC0190023u32 as i32;
pub const STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION: ::NTSTATUS = 0xC0190024u32 as i32;
pub const STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT: ::NTSTATUS = 0xC0190025u32 as i32;
pub const STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS: ::NTSTATUS = 0xC0190026u32 as i32;
pub const STATUS_HANDLE_NO_LONGER_VALID: ::NTSTATUS = 0xC0190028u32 as i32;
pub const STATUS_NO_TXF_METADATA: ::NTSTATUS = 0x80190029u32 as i32;
pub const STATUS_LOG_CORRUPTION_DETECTED: ::NTSTATUS = 0xC0190030u32 as i32;
pub const STATUS_CANT_RECOVER_WITH_HANDLE_OPEN: ::NTSTATUS = 0x80190031u32 as i32;
pub const STATUS_RM_DISCONNECTED: ::NTSTATUS = 0xC0190032u32 as i32;
pub const STATUS_ENLISTMENT_NOT_SUPERIOR: ::NTSTATUS = 0xC0190033u32 as i32;
pub const STATUS_RECOVERY_NOT_NEEDED: ::NTSTATUS = 0x40190034;
pub const STATUS_RM_ALREADY_STARTED: ::NTSTATUS = 0x40190035;
pub const STATUS_FILE_IDENTITY_NOT_PERSISTENT: ::NTSTATUS = 0xC0190036u32 as i32;
pub const STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY: ::NTSTATUS = 0xC0190037u32 as i32;
pub const STATUS_CANT_CROSS_RM_BOUNDARY: ::NTSTATUS = 0xC0190038u32 as i32;
pub const STATUS_TXF_DIR_NOT_EMPTY: ::NTSTATUS = 0xC0190039u32 as i32;
pub const STATUS_INDOUBT_TRANSACTIONS_EXIST: ::NTSTATUS = 0xC019003Au32 as i32;
pub const STATUS_TM_VOLATILE: ::NTSTATUS = 0xC019003Bu32 as i32;
pub const STATUS_ROLLBACK_TIMER_EXPIRED: ::NTSTATUS = 0xC019003Cu32 as i32;
pub const STATUS_TXF_ATTRIBUTE_CORRUPT: ::NTSTATUS = 0xC019003Du32 as i32;
pub const STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION: ::NTSTATUS = 0xC019003Eu32 as i32;
pub const STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED: ::NTSTATUS = 0xC019003Fu32 as i32;
pub const STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE: ::NTSTATUS = 0xC0190040u32 as i32;
pub const STATUS_TXF_METADATA_ALREADY_PRESENT: ::NTSTATUS = 0x80190041u32 as i32;
pub const STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET: ::NTSTATUS = 0x80190042u32 as i32;
pub const STATUS_TRANSACTION_REQUIRED_PROMOTION: ::NTSTATUS = 0xC0190043u32 as i32;
pub const STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION: ::NTSTATUS = 0xC0190044u32 as i32;
pub const STATUS_TRANSACTIONS_NOT_FROZEN: ::NTSTATUS = 0xC0190045u32 as i32;
pub const STATUS_TRANSACTION_FREEZE_IN_PROGRESS: ::NTSTATUS = 0xC0190046u32 as i32;
pub const STATUS_NOT_SNAPSHOT_VOLUME: ::NTSTATUS = 0xC0190047u32 as i32;
pub const STATUS_NO_SAVEPOINT_WITH_OPEN_FILES: ::NTSTATUS = 0xC0190048u32 as i32;
pub const STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION: ::NTSTATUS = 0xC0190049u32 as i32;
pub const STATUS_TM_IDENTITY_MISMATCH: ::NTSTATUS = 0xC019004Au32 as i32;
pub const STATUS_FLOATED_SECTION: ::NTSTATUS = 0xC019004Bu32 as i32;
pub const STATUS_CANNOT_ACCEPT_TRANSACTED_WORK: ::NTSTATUS = 0xC019004Cu32 as i32;
pub const STATUS_CANNOT_ABORT_TRANSACTIONS: ::NTSTATUS = 0xC019004Du32 as i32;
pub const STATUS_TRANSACTION_NOT_FOUND: ::NTSTATUS = 0xC019004Eu32 as i32;
pub const STATUS_RESOURCEMANAGER_NOT_FOUND: ::NTSTATUS = 0xC019004Fu32 as i32;
pub const STATUS_ENLISTMENT_NOT_FOUND: ::NTSTATUS = 0xC0190050u32 as i32;
pub const STATUS_TRANSACTIONMANAGER_NOT_FOUND: ::NTSTATUS = 0xC0190051u32 as i32;
pub const STATUS_TRANSACTIONMANAGER_NOT_ONLINE: ::NTSTATUS = 0xC0190052u32 as i32;
pub const STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION: ::NTSTATUS = 0xC0190053u32 as i32;
pub const STATUS_TRANSACTION_NOT_ROOT: ::NTSTATUS = 0xC0190054u32 as i32;
pub const STATUS_TRANSACTION_OBJECT_EXPIRED: ::NTSTATUS = 0xC0190055u32 as i32;
pub const STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION: ::NTSTATUS = 0xC0190056u32 as i32;
pub const STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED: ::NTSTATUS = 0xC0190057u32 as i32;
pub const STATUS_TRANSACTION_RECORD_TOO_LONG: ::NTSTATUS = 0xC0190058u32 as i32;
pub const STATUS_NO_LINK_TRACKING_IN_TRANSACTION: ::NTSTATUS = 0xC0190059u32 as i32;
pub const STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION: ::NTSTATUS = 0xC019005Au32 as i32;
pub const STATUS_TRANSACTION_INTEGRITY_VIOLATED: ::NTSTATUS = 0xC019005Bu32 as i32;
pub const STATUS_TRANSACTIONMANAGER_IDENTITY_MISMATCH: ::NTSTATUS = 0xC019005Cu32 as i32;
pub const STATUS_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT: ::NTSTATUS = 0xC019005Du32 as i32;
pub const STATUS_TRANSACTION_MUST_WRITETHROUGH: ::NTSTATUS = 0xC019005Eu32 as i32;
pub const STATUS_TRANSACTION_NO_SUPERIOR: ::NTSTATUS = 0xC019005Fu32 as i32;
pub const STATUS_EXPIRED_HANDLE: ::NTSTATUS = 0xC0190060u32 as i32;
pub const STATUS_TRANSACTION_NOT_ENLISTED: ::NTSTATUS = 0xC0190061u32 as i32;
pub const STATUS_LOG_SECTOR_INVALID: ::NTSTATUS = 0xC01A0001u32 as i32;
pub const STATUS_LOG_SECTOR_PARITY_INVALID: ::NTSTATUS = 0xC01A0002u32 as i32;
pub const STATUS_LOG_SECTOR_REMAPPED: ::NTSTATUS = 0xC01A0003u32 as i32;
pub const STATUS_LOG_BLOCK_INCOMPLETE: ::NTSTATUS = 0xC01A0004u32 as i32;
pub const STATUS_LOG_INVALID_RANGE: ::NTSTATUS = 0xC01A0005u32 as i32;
pub const STATUS_LOG_BLOCKS_EXHAUSTED: ::NTSTATUS = 0xC01A0006u32 as i32;
pub const STATUS_LOG_READ_CONTEXT_INVALID: ::NTSTATUS = 0xC01A0007u32 as i32;
pub const STATUS_LOG_RESTART_INVALID: ::NTSTATUS = 0xC01A0008u32 as i32;
pub const STATUS_LOG_BLOCK_VERSION: ::NTSTATUS = 0xC01A0009u32 as i32;
pub const STATUS_LOG_BLOCK_INVALID: ::NTSTATUS = 0xC01A000Au32 as i32;
pub const STATUS_LOG_READ_MODE_INVALID: ::NTSTATUS = 0xC01A000Bu32 as i32;
pub const STATUS_LOG_NO_RESTART: ::NTSTATUS = 0x401A000C;
pub const STATUS_LOG_METADATA_CORRUPT: ::NTSTATUS = 0xC01A000Du32 as i32;
pub const STATUS_LOG_METADATA_INVALID: ::NTSTATUS = 0xC01A000Eu32 as i32;
pub const STATUS_LOG_METADATA_INCONSISTENT: ::NTSTATUS = 0xC01A000Fu32 as i32;
pub const STATUS_LOG_RESERVATION_INVALID: ::NTSTATUS = 0xC01A0010u32 as i32;
pub const STATUS_LOG_CANT_DELETE: ::NTSTATUS = 0xC01A0011u32 as i32;
pub const STATUS_LOG_CONTAINER_LIMIT_EXCEEDED: ::NTSTATUS = 0xC01A0012u32 as i32;
pub const STATUS_LOG_START_OF_LOG: ::NTSTATUS = 0xC01A0013u32 as i32;
pub const STATUS_LOG_POLICY_ALREADY_INSTALLED: ::NTSTATUS = 0xC01A0014u32 as i32;
pub const STATUS_LOG_POLICY_NOT_INSTALLED: ::NTSTATUS = 0xC01A0015u32 as i32;
pub const STATUS_LOG_POLICY_INVALID: ::NTSTATUS = 0xC01A0016u32 as i32;
pub const STATUS_LOG_POLICY_CONFLICT: ::NTSTATUS = 0xC01A0017u32 as i32;
pub const STATUS_LOG_PINNED_ARCHIVE_TAIL: ::NTSTATUS = 0xC01A0018u32 as i32;
pub const STATUS_LOG_RECORD_NONEXISTENT: ::NTSTATUS = 0xC01A0019u32 as i32;
pub const STATUS_LOG_RECORDS_RESERVED_INVALID: ::NTSTATUS = 0xC01A001Au32 as i32;
pub const STATUS_LOG_SPACE_RESERVED_INVALID: ::NTSTATUS = 0xC01A001Bu32 as i32;
pub const STATUS_LOG_TAIL_INVALID: ::NTSTATUS = 0xC01A001Cu32 as i32;
pub const STATUS_LOG_FULL: ::NTSTATUS = 0xC01A001Du32 as i32;
pub const STATUS_LOG_MULTIPLEXED: ::NTSTATUS = 0xC01A001Eu32 as i32;
pub const STATUS_LOG_DEDICATED: ::NTSTATUS = 0xC01A001Fu32 as i32;
pub const STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS: ::NTSTATUS = 0xC01A0020u32 as i32;
pub const STATUS_LOG_ARCHIVE_IN_PROGRESS: ::NTSTATUS = 0xC01A0021u32 as i32;
pub const STATUS_LOG_EPHEMERAL: ::NTSTATUS = 0xC01A0022u32 as i32;
pub const STATUS_LOG_NOT_ENOUGH_CONTAINERS: ::NTSTATUS = 0xC01A0023u32 as i32;
pub const STATUS_LOG_CLIENT_ALREADY_REGISTERED: ::NTSTATUS = 0xC01A0024u32 as i32;
pub const STATUS_LOG_CLIENT_NOT_REGISTERED: ::NTSTATUS = 0xC01A0025u32 as i32;
pub const STATUS_LOG_FULL_HANDLER_IN_PROGRESS: ::NTSTATUS = 0xC01A0026u32 as i32;
pub const STATUS_LOG_CONTAINER_READ_FAILED: ::NTSTATUS = 0xC01A0027u32 as i32;
pub const STATUS_LOG_CONTAINER_WRITE_FAILED: ::NTSTATUS = 0xC01A0028u32 as i32;
pub const STATUS_LOG_CONTAINER_OPEN_FAILED: ::NTSTATUS = 0xC01A0029u32 as i32;
pub const STATUS_LOG_CONTAINER_STATE_INVALID: ::NTSTATUS = 0xC01A002Au32 as i32;
pub const STATUS_LOG_STATE_INVALID: ::NTSTATUS = 0xC01A002Bu32 as i32;
pub const STATUS_LOG_PINNED: ::NTSTATUS = 0xC01A002Cu32 as i32;
pub const STATUS_LOG_METADATA_FLUSH_FAILED: ::NTSTATUS = 0xC01A002Du32 as i32;
pub const STATUS_LOG_INCONSISTENT_SECURITY: ::NTSTATUS = 0xC01A002Eu32 as i32;
pub const STATUS_LOG_APPENDED_FLUSH_FAILED: ::NTSTATUS = 0xC01A002Fu32 as i32;
pub const STATUS_LOG_PINNED_RESERVATION: ::NTSTATUS = 0xC01A0030u32 as i32;
pub const STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD: ::NTSTATUS = 0xC01B00EAu32 as i32;
pub const STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED: ::NTSTATUS = 0x801B00EBu32 as i32;
pub const STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST: ::NTSTATUS = 0x401B00EC;
pub const STATUS_MONITOR_NO_DESCRIPTOR: ::NTSTATUS = 0xC01D0001u32 as i32;
pub const STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT: ::NTSTATUS = 0xC01D0002u32 as i32;
pub const STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM: ::NTSTATUS = 0xC01D0003u32 as i32;
pub const STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK: ::NTSTATUS = 0xC01D0004u32 as i32;
pub const STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED: ::NTSTATUS = 0xC01D0005u32 as i32;
pub const STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK: ::NTSTATUS = 0xC01D0006u32 as i32;
pub const STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK: ::NTSTATUS = 0xC01D0007u32 as i32;
pub const STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA: ::NTSTATUS = 0xC01D0008u32 as i32;
pub const STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK: ::NTSTATUS = 0xC01D0009u32 as i32;
pub const STATUS_MONITOR_INVALID_MANUFACTURE_DATE: ::NTSTATUS = 0xC01D000Au32 as i32;
pub const STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER: ::NTSTATUS = 0xC01E0000u32 as i32;
pub const STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER: ::NTSTATUS = 0xC01E0001u32 as i32;
pub const STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER: ::NTSTATUS = 0xC01E0002u32 as i32;
pub const STATUS_GRAPHICS_ADAPTER_WAS_RESET: ::NTSTATUS = 0xC01E0003u32 as i32;
pub const STATUS_GRAPHICS_INVALID_DRIVER_MODEL: ::NTSTATUS = 0xC01E0004u32 as i32;
pub const STATUS_GRAPHICS_PRESENT_MODE_CHANGED: ::NTSTATUS = 0xC01E0005u32 as i32;
pub const STATUS_GRAPHICS_PRESENT_OCCLUDED: ::NTSTATUS = 0xC01E0006u32 as i32;
pub const STATUS_GRAPHICS_PRESENT_DENIED: ::NTSTATUS = 0xC01E0007u32 as i32;
pub const STATUS_GRAPHICS_CANNOTCOLORCONVERT: ::NTSTATUS = 0xC01E0008u32 as i32;
pub const STATUS_GRAPHICS_DRIVER_MISMATCH: ::NTSTATUS = 0xC01E0009u32 as i32;
pub const STATUS_GRAPHICS_PARTIAL_DATA_POPULATED: ::NTSTATUS = 0x401E000A;
pub const STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED: ::NTSTATUS = 0xC01E000Bu32 as i32;
pub const STATUS_GRAPHICS_PRESENT_UNOCCLUDED: ::NTSTATUS = 0xC01E000Cu32 as i32;
pub const STATUS_GRAPHICS_WINDOWDC_NOT_AVAILABLE: ::NTSTATUS = 0xC01E000Du32 as i32;
pub const STATUS_GRAPHICS_WINDOWLESS_PRESENT_DISABLED: ::NTSTATUS = 0xC01E000Eu32 as i32;
pub const STATUS_GRAPHICS_NO_VIDEO_MEMORY: ::NTSTATUS = 0xC01E0100u32 as i32;
pub const STATUS_GRAPHICS_CANT_LOCK_MEMORY: ::NTSTATUS = 0xC01E0101u32 as i32;
pub const STATUS_GRAPHICS_ALLOCATION_BUSY: ::NTSTATUS = 0xC01E0102u32 as i32;
pub const STATUS_GRAPHICS_TOO_MANY_REFERENCES: ::NTSTATUS = 0xC01E0103u32 as i32;
pub const STATUS_GRAPHICS_TRY_AGAIN_LATER: ::NTSTATUS = 0xC01E0104u32 as i32;
pub const STATUS_GRAPHICS_TRY_AGAIN_NOW: ::NTSTATUS = 0xC01E0105u32 as i32;
pub const STATUS_GRAPHICS_ALLOCATION_INVALID: ::NTSTATUS = 0xC01E0106u32 as i32;
pub const STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE: ::NTSTATUS = 0xC01E0107u32 as i32;
pub const STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED: ::NTSTATUS = 0xC01E0108u32 as i32;
pub const STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION: ::NTSTATUS = 0xC01E0109u32 as i32;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE: ::NTSTATUS = 0xC01E0110u32 as i32;
pub const STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION: ::NTSTATUS = 0xC01E0111u32 as i32;
pub const STATUS_GRAPHICS_ALLOCATION_CLOSED: ::NTSTATUS = 0xC01E0112u32 as i32;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE: ::NTSTATUS = 0xC01E0113u32 as i32;
pub const STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE: ::NTSTATUS = 0xC01E0114u32 as i32;
pub const STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE: ::NTSTATUS = 0xC01E0115u32 as i32;
pub const STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST: ::NTSTATUS = 0xC01E0116u32 as i32;
pub const STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE: ::NTSTATUS = 0xC01E0200u32 as i32;
pub const STATUS_GRAPHICS_SKIP_ALLOCATION_PREPARATION: ::NTSTATUS = 0x401E0201;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY: ::NTSTATUS = 0xC01E0300u32 as i32;
pub const STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0301u32 as i32;
pub const STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0302u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDPN: ::NTSTATUS = 0xC01E0303u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE: ::NTSTATUS = 0xC01E0304u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET: ::NTSTATUS = 0xC01E0305u32 as i32;
pub const STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0306u32 as i32;
pub const STATUS_GRAPHICS_MODE_NOT_PINNED: ::NTSTATUS = 0x401E0307;
pub const STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET: ::NTSTATUS = 0xC01E0308u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET: ::NTSTATUS = 0xC01E0309u32 as i32;
pub const STATUS_GRAPHICS_INVALID_FREQUENCY: ::NTSTATUS = 0xC01E030Au32 as i32;
pub const STATUS_GRAPHICS_INVALID_ACTIVE_REGION: ::NTSTATUS = 0xC01E030Bu32 as i32;
pub const STATUS_GRAPHICS_INVALID_TOTAL_REGION: ::NTSTATUS = 0xC01E030Cu32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE: ::NTSTATUS = 0xC01E0310u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE: ::NTSTATUS = 0xC01E0311u32 as i32;
pub const STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET: ::NTSTATUS = 0xC01E0312u32 as i32;
pub const STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY: ::NTSTATUS = 0xC01E0313u32 as i32;
pub const STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET: ::NTSTATUS = 0xC01E0314u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET: ::NTSTATUS = 0xC01E0315u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET: ::NTSTATUS = 0xC01E0316u32 as i32;
pub const STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET: ::NTSTATUS = 0xC01E0317u32 as i32;
pub const STATUS_GRAPHICS_TARGET_ALREADY_IN_SET: ::NTSTATUS = 0xC01E0318u32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH: ::NTSTATUS = 0xC01E0319u32 as i32;
pub const STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY: ::NTSTATUS = 0xC01E031Au32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET: ::NTSTATUS = 0xC01E031Bu32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE: ::NTSTATUS = 0xC01E031Cu32 as i32;
pub const STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET: ::NTSTATUS = 0xC01E031Du32 as i32;
pub const STATUS_GRAPHICS_NO_PREFERRED_MODE: ::NTSTATUS = 0x401E031E;
pub const STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET: ::NTSTATUS = 0xC01E031Fu32 as i32;
pub const STATUS_GRAPHICS_STALE_MODESET: ::NTSTATUS = 0xC01E0320u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET: ::NTSTATUS = 0xC01E0321u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE: ::NTSTATUS = 0xC01E0322u32 as i32;
pub const STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN: ::NTSTATUS = 0xC01E0323u32 as i32;
pub const STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE: ::NTSTATUS = 0xC01E0324u32 as i32;
pub const STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION: ::NTSTATUS = 0xC01E0325u32 as i32;
pub const STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES: ::NTSTATUS = 0xC01E0326u32 as i32;
pub const STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY: ::NTSTATUS = 0xC01E0327u32 as i32;
pub const STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE: ::NTSTATUS = 0xC01E0328u32 as i32;
pub const STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET: ::NTSTATUS = 0xC01E0329u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET: ::NTSTATUS = 0xC01E032Au32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR: ::NTSTATUS = 0xC01E032Bu32 as i32;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET: ::NTSTATUS = 0xC01E032Cu32 as i32;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET: ::NTSTATUS = 0xC01E032Du32 as i32;
pub const STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE: ::NTSTATUS = 0xC01E032Eu32 as i32;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE: ::NTSTATUS = 0xC01E032Fu32 as i32;
pub const STATUS_GRAPHICS_RESOURCES_NOT_RELATED: ::NTSTATUS = 0xC01E0330u32 as i32;
pub const STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE: ::NTSTATUS = 0xC01E0331u32 as i32;
pub const STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE: ::NTSTATUS = 0xC01E0332u32 as i32;
pub const STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET: ::NTSTATUS = 0xC01E0333u32 as i32;
pub const STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER: ::NTSTATUS = 0xC01E0334u32 as i32;
pub const STATUS_GRAPHICS_NO_VIDPNMGR: ::NTSTATUS = 0xC01E0335u32 as i32;
pub const STATUS_GRAPHICS_NO_ACTIVE_VIDPN: ::NTSTATUS = 0xC01E0336u32 as i32;
pub const STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY: ::NTSTATUS = 0xC01E0337u32 as i32;
pub const STATUS_GRAPHICS_MONITOR_NOT_CONNECTED: ::NTSTATUS = 0xC01E0338u32 as i32;
pub const STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY: ::NTSTATUS = 0xC01E0339u32 as i32;
pub const STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE: ::NTSTATUS = 0xC01E033Au32 as i32;
pub const STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE: ::NTSTATUS = 0xC01E033Bu32 as i32;
pub const STATUS_GRAPHICS_INVALID_STRIDE: ::NTSTATUS = 0xC01E033Cu32 as i32;
pub const STATUS_GRAPHICS_INVALID_PIXELFORMAT: ::NTSTATUS = 0xC01E033Du32 as i32;
pub const STATUS_GRAPHICS_INVALID_COLORBASIS: ::NTSTATUS = 0xC01E033Eu32 as i32;
pub const STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE: ::NTSTATUS = 0xC01E033Fu32 as i32;
pub const STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY: ::NTSTATUS = 0xC01E0340u32 as i32;
pub const STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT: ::NTSTATUS = 0xC01E0341u32 as i32;
pub const STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE: ::NTSTATUS = 0xC01E0342u32 as i32;
pub const STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN: ::NTSTATUS = 0xC01E0343u32 as i32;
pub const STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL: ::NTSTATUS = 0xC01E0344u32 as i32;
pub const STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION: ::NTSTATUS = 0xC01E0345u32 as i32;
pub const STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0346u32 as i32;
pub const STATUS_GRAPHICS_INVALID_GAMMA_RAMP: ::NTSTATUS = 0xC01E0347u32 as i32;
pub const STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0348u32 as i32;
pub const STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0349u32 as i32;
pub const STATUS_GRAPHICS_MODE_NOT_IN_MODESET: ::NTSTATUS = 0xC01E034Au32 as i32;
pub const STATUS_GRAPHICS_DATASET_IS_EMPTY: ::NTSTATUS = 0x401E034B;
pub const STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET: ::NTSTATUS = 0x401E034C;
pub const STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON: ::NTSTATUS = 0xC01E034Du32 as i32;
pub const STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE: ::NTSTATUS = 0xC01E034Eu32 as i32;
pub const STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE: ::NTSTATUS = 0xC01E034Fu32 as i32;
pub const STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS: ::NTSTATUS = 0xC01E0350u32 as i32;
pub const STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED: ::NTSTATUS = 0x401E0351;
pub const STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING: ::NTSTATUS = 0xC01E0352u32 as i32;
pub const STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED: ::NTSTATUS = 0xC01E0353u32 as i32;
pub const STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS: ::NTSTATUS = 0xC01E0354u32 as i32;
pub const STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT: ::NTSTATUS = 0xC01E0355u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM: ::NTSTATUS = 0xC01E0356u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN: ::NTSTATUS = 0xC01E0357u32 as i32;
pub const STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT: ::NTSTATUS = 0xC01E0358u32 as i32;
pub const STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED: ::NTSTATUS = 0xC01E0359u32 as i32;
pub const STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION: ::NTSTATUS = 0xC01E035Au32 as i32;
pub const STATUS_GRAPHICS_INVALID_CLIENT_TYPE: ::NTSTATUS = 0xC01E035Bu32 as i32;
pub const STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET: ::NTSTATUS = 0xC01E035Cu32 as i32;
pub const STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED: ::NTSTATUS = 0xC01E0400u32 as i32;
pub const STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0401u32 as i32;
pub const STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS: ::NTSTATUS = 0x401E042F;
pub const STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER: ::NTSTATUS = 0xC01E0430u32 as i32;
pub const STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED: ::NTSTATUS = 0xC01E0431u32 as i32;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED: ::NTSTATUS = 0xC01E0432u32 as i32;
pub const STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY: ::NTSTATUS = 0xC01E0433u32 as i32;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED: ::NTSTATUS = 0xC01E0434u32 as i32;
pub const STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON: ::NTSTATUS = 0xC01E0435u32 as i32;
pub const STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE: ::NTSTATUS = 0xC01E0436u32 as i32;
pub const STATUS_GRAPHICS_LEADLINK_START_DEFERRED: ::NTSTATUS = 0x401E0437;
pub const STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER: ::NTSTATUS = 0xC01E0438u32 as i32;
pub const STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY: ::NTSTATUS = 0x401E0439;
pub const STATUS_GRAPHICS_START_DEFERRED: ::NTSTATUS = 0x401E043A;
pub const STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED: ::NTSTATUS = 0xC01E043Bu32 as i32;
pub const STATUS_GRAPHICS_DEPENDABLE_CHILD_STATUS: ::NTSTATUS = 0x401E043C;
pub const STATUS_GRAPHICS_OPM_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0500u32 as i32;
pub const STATUS_GRAPHICS_COPP_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0501u32 as i32;
pub const STATUS_GRAPHICS_UAB_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0502u32 as i32;
pub const STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS: ::NTSTATUS = 0xC01E0503u32 as i32;
pub const STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST: ::NTSTATUS = 0xC01E0505u32 as i32;
pub const STATUS_GRAPHICS_OPM_INTERNAL_ERROR: ::NTSTATUS = 0xC01E050Bu32 as i32;
pub const STATUS_GRAPHICS_OPM_INVALID_HANDLE: ::NTSTATUS = 0xC01E050Cu32 as i32;
pub const STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH: ::NTSTATUS = 0xC01E050Eu32 as i32;
pub const STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED: ::NTSTATUS = 0xC01E050Fu32 as i32;
pub const STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED: ::NTSTATUS = 0xC01E0510u32 as i32;
pub const STATUS_GRAPHICS_PVP_HFS_FAILED: ::NTSTATUS = 0xC01E0511u32 as i32;
pub const STATUS_GRAPHICS_OPM_INVALID_SRM: ::NTSTATUS = 0xC01E0512u32 as i32;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP: ::NTSTATUS = 0xC01E0513u32 as i32;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP: ::NTSTATUS = 0xC01E0514u32 as i32;
pub const STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA: ::NTSTATUS = 0xC01E0515u32 as i32;
pub const STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET: ::NTSTATUS = 0xC01E0516u32 as i32;
pub const STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH: ::NTSTATUS = 0xC01E0517u32 as i32;
pub const STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE: ::NTSTATUS = 0xC01E0518u32 as i32;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS: ::NTSTATUS = 0xC01E051Au32 as i32;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS: ::NTSTATUS = 0xC01E051Cu32 as i32;
pub const STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST: ::NTSTATUS = 0xC01E051Du32 as i32;
pub const STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR: ::NTSTATUS = 0xC01E051Eu32 as i32;
pub const STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS: ::NTSTATUS = 0xC01E051Fu32 as i32;
pub const STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0520u32 as i32;
pub const STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST: ::NTSTATUS = 0xC01E0521u32 as i32;
pub const STATUS_GRAPHICS_I2C_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0580u32 as i32;
pub const STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST: ::NTSTATUS = 0xC01E0581u32 as i32;
pub const STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA: ::NTSTATUS = 0xC01E0582u32 as i32;
pub const STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA: ::NTSTATUS = 0xC01E0583u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED: ::NTSTATUS = 0xC01E0584u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_INVALID_DATA: ::NTSTATUS = 0xC01E0585u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE: ::NTSTATUS = 0xC01E0586u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING: ::NTSTATUS = 0xC01E0587u32 as i32;
pub const STATUS_GRAPHICS_MCA_INTERNAL_ERROR: ::NTSTATUS = 0xC01E0588u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND: ::NTSTATUS = 0xC01E0589u32 as i32;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH: ::NTSTATUS = 0xC01E058Au32 as i32;
pub const STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM: ::NTSTATUS = 0xC01E058Bu32 as i32;
pub const STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE: ::NTSTATUS = 0xC01E058Cu32 as i32;
pub const STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS: ::NTSTATUS = 0xC01E058Du32 as i32;
pub const STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED: ::NTSTATUS = 0xC01E05E0u32 as i32;
pub const STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME: ::NTSTATUS = 0xC01E05E1u32 as i32;
pub const STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP: ::NTSTATUS = 0xC01E05E2u32 as i32;
pub const STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED: ::NTSTATUS = 0xC01E05E3u32 as i32;
pub const STATUS_GRAPHICS_INVALID_POINTER: ::NTSTATUS = 0xC01E05E4u32 as i32;
pub const STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE: ::NTSTATUS = 0xC01E05E5u32 as i32;
pub const STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL: ::NTSTATUS = 0xC01E05E6u32 as i32;
pub const STATUS_GRAPHICS_INTERNAL_ERROR: ::NTSTATUS = 0xC01E05E7u32 as i32;
pub const STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS: ::NTSTATUS = 0xC01E05E8u32 as i32;
pub const STATUS_FVE_LOCKED_VOLUME: ::NTSTATUS = 0xC0210000u32 as i32;
pub const STATUS_FVE_NOT_ENCRYPTED: ::NTSTATUS = 0xC0210001u32 as i32;
pub const STATUS_FVE_BAD_INFORMATION: ::NTSTATUS = 0xC0210002u32 as i32;
pub const STATUS_FVE_TOO_SMALL: ::NTSTATUS = 0xC0210003u32 as i32;
pub const STATUS_FVE_FAILED_WRONG_FS: ::NTSTATUS = 0xC0210004u32 as i32;
pub const STATUS_FVE_BAD_PARTITION_SIZE: ::NTSTATUS = 0xC0210005u32 as i32;
pub const STATUS_FVE_FS_NOT_EXTENDED: ::NTSTATUS = 0xC0210006u32 as i32;
pub const STATUS_FVE_FS_MOUNTED: ::NTSTATUS = 0xC0210007u32 as i32;
pub const STATUS_FVE_NO_LICENSE: ::NTSTATUS = 0xC0210008u32 as i32;
pub const STATUS_FVE_ACTION_NOT_ALLOWED: ::NTSTATUS = 0xC0210009u32 as i32;
pub const STATUS_FVE_BAD_DATA: ::NTSTATUS = 0xC021000Au32 as i32;
pub const STATUS_FVE_VOLUME_NOT_BOUND: ::NTSTATUS = 0xC021000Bu32 as i32;
pub const STATUS_FVE_NOT_DATA_VOLUME: ::NTSTATUS = 0xC021000Cu32 as i32;
pub const STATUS_FVE_CONV_READ_ERROR: ::NTSTATUS = 0xC021000Du32 as i32;
pub const STATUS_FVE_CONV_WRITE_ERROR: ::NTSTATUS = 0xC021000Eu32 as i32;
pub const STATUS_FVE_OVERLAPPED_UPDATE: ::NTSTATUS = 0xC021000Fu32 as i32;
pub const STATUS_FVE_FAILED_SECTOR_SIZE: ::NTSTATUS = 0xC0210010u32 as i32;
pub const STATUS_FVE_FAILED_AUTHENTICATION: ::NTSTATUS = 0xC0210011u32 as i32;
pub const STATUS_FVE_NOT_OS_VOLUME: ::NTSTATUS = 0xC0210012u32 as i32;
pub const STATUS_FVE_KEYFILE_NOT_FOUND: ::NTSTATUS = 0xC0210013u32 as i32;
pub const STATUS_FVE_KEYFILE_INVALID: ::NTSTATUS = 0xC0210014u32 as i32;
pub const STATUS_FVE_KEYFILE_NO_VMK: ::NTSTATUS = 0xC0210015u32 as i32;
pub const STATUS_FVE_TPM_DISABLED: ::NTSTATUS = 0xC0210016u32 as i32;
pub const STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO: ::NTSTATUS = 0xC0210017u32 as i32;
pub const STATUS_FVE_TPM_INVALID_PCR: ::NTSTATUS = 0xC0210018u32 as i32;
pub const STATUS_FVE_TPM_NO_VMK: ::NTSTATUS = 0xC0210019u32 as i32;
pub const STATUS_FVE_PIN_INVALID: ::NTSTATUS = 0xC021001Au32 as i32;
pub const STATUS_FVE_AUTH_INVALID_APPLICATION: ::NTSTATUS = 0xC021001Bu32 as i32;
pub const STATUS_FVE_AUTH_INVALID_CONFIG: ::NTSTATUS = 0xC021001Cu32 as i32;
pub const STATUS_FVE_DEBUGGER_ENABLED: ::NTSTATUS = 0xC021001Du32 as i32;
pub const STATUS_FVE_DRY_RUN_FAILED: ::NTSTATUS = 0xC021001Eu32 as i32;
pub const STATUS_FVE_BAD_METADATA_POINTER: ::NTSTATUS = 0xC021001Fu32 as i32;
pub const STATUS_FVE_OLD_METADATA_COPY: ::NTSTATUS = 0xC0210020u32 as i32;
pub const STATUS_FVE_REBOOT_REQUIRED: ::NTSTATUS = 0xC0210021u32 as i32;
pub const STATUS_FVE_RAW_ACCESS: ::NTSTATUS = 0xC0210022u32 as i32;
pub const STATUS_FVE_RAW_BLOCKED: ::NTSTATUS = 0xC0210023u32 as i32;
pub const STATUS_FVE_NO_AUTOUNLOCK_MASTER_KEY: ::NTSTATUS = 0xC0210024u32 as i32;
pub const STATUS_FVE_MOR_FAILED: ::NTSTATUS = 0xC0210025u32 as i32;
pub const STATUS_FVE_NO_FEATURE_LICENSE: ::NTSTATUS = 0xC0210026u32 as i32;
pub const STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED: ::NTSTATUS = 0xC0210027u32 as i32;
pub const STATUS_FVE_CONV_RECOVERY_FAILED: ::NTSTATUS = 0xC0210028u32 as i32;
pub const STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG: ::NTSTATUS = 0xC0210029u32 as i32;
pub const STATUS_FVE_INVALID_DATUM_TYPE: ::NTSTATUS = 0xC021002Au32 as i32;
pub const STATUS_FVE_VOLUME_TOO_SMALL: ::NTSTATUS = 0xC0210030u32 as i32;
pub const STATUS_FVE_ENH_PIN_INVALID: ::NTSTATUS = 0xC0210031u32 as i32;
pub const STATUS_FVE_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE: ::NTSTATUS = 0xC0210032u32 as i32;
pub const STATUS_FVE_WIPE_NOT_ALLOWED_ON_TP_STORAGE: ::NTSTATUS = 0xC0210033u32 as i32;
pub const STATUS_FVE_NOT_ALLOWED_ON_CSV_STACK: ::NTSTATUS = 0xC0210034u32 as i32;
pub const STATUS_FVE_NOT_ALLOWED_ON_CLUSTER: ::NTSTATUS = 0xC0210035u32 as i32;
pub const STATUS_FVE_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING: ::NTSTATUS = 0xC0210036u32 as i32;
pub const STATUS_FVE_WIPE_CANCEL_NOT_APPLICABLE: ::NTSTATUS = 0xC0210037u32 as i32;
pub const STATUS_FVE_EDRIVE_DRY_RUN_FAILED: ::NTSTATUS = 0xC0210038u32 as i32;
pub const STATUS_FVE_SECUREBOOT_DISABLED: ::NTSTATUS = 0xC0210039u32 as i32;
pub const STATUS_FVE_SECUREBOOT_CONFIG_CHANGE: ::NTSTATUS = 0xC021003Au32 as i32;
pub const STATUS_FVE_DEVICE_LOCKEDOUT: ::NTSTATUS = 0xC021003Bu32 as i32;
pub const STATUS_FVE_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT: ::NTSTATUS = 0xC021003Cu32 as i32;
pub const STATUS_FVE_NOT_DE_VOLUME: ::NTSTATUS = 0xC021003Du32 as i32;
pub const STATUS_FVE_PROTECTION_DISABLED: ::NTSTATUS = 0xC021003Eu32 as i32;
pub const STATUS_FVE_PROTECTION_CANNOT_BE_DISABLED: ::NTSTATUS = 0xC021003Fu32 as i32;
pub const STATUS_FWP_CALLOUT_NOT_FOUND: ::NTSTATUS = 0xC0220001u32 as i32;
pub const STATUS_FWP_CONDITION_NOT_FOUND: ::NTSTATUS = 0xC0220002u32 as i32;
pub const STATUS_FWP_FILTER_NOT_FOUND: ::NTSTATUS = 0xC0220003u32 as i32;
pub const STATUS_FWP_LAYER_NOT_FOUND: ::NTSTATUS = 0xC0220004u32 as i32;
pub const STATUS_FWP_PROVIDER_NOT_FOUND: ::NTSTATUS = 0xC0220005u32 as i32;
pub const STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND: ::NTSTATUS = 0xC0220006u32 as i32;
pub const STATUS_FWP_SUBLAYER_NOT_FOUND: ::NTSTATUS = 0xC0220007u32 as i32;
pub const STATUS_FWP_NOT_FOUND: ::NTSTATUS = 0xC0220008u32 as i32;
pub const STATUS_FWP_ALREADY_EXISTS: ::NTSTATUS = 0xC0220009u32 as i32;
pub const STATUS_FWP_IN_USE: ::NTSTATUS = 0xC022000Au32 as i32;
pub const STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS: ::NTSTATUS = 0xC022000Bu32 as i32;
pub const STATUS_FWP_WRONG_SESSION: ::NTSTATUS = 0xC022000Cu32 as i32;
pub const STATUS_FWP_NO_TXN_IN_PROGRESS: ::NTSTATUS = 0xC022000Du32 as i32;
pub const STATUS_FWP_TXN_IN_PROGRESS: ::NTSTATUS = 0xC022000Eu32 as i32;
pub const STATUS_FWP_TXN_ABORTED: ::NTSTATUS = 0xC022000Fu32 as i32;
pub const STATUS_FWP_SESSION_ABORTED: ::NTSTATUS = 0xC0220010u32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_TXN: ::NTSTATUS = 0xC0220011u32 as i32;
pub const STATUS_FWP_TIMEOUT: ::NTSTATUS = 0xC0220012u32 as i32;
pub const STATUS_FWP_NET_EVENTS_DISABLED: ::NTSTATUS = 0xC0220013u32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_LAYER: ::NTSTATUS = 0xC0220014u32 as i32;
pub const STATUS_FWP_KM_CLIENTS_ONLY: ::NTSTATUS = 0xC0220015u32 as i32;
pub const STATUS_FWP_LIFETIME_MISMATCH: ::NTSTATUS = 0xC0220016u32 as i32;
pub const STATUS_FWP_BUILTIN_OBJECT: ::NTSTATUS = 0xC0220017u32 as i32;
pub const STATUS_FWP_TOO_MANY_CALLOUTS: ::NTSTATUS = 0xC0220018u32 as i32;
pub const STATUS_FWP_NOTIFICATION_DROPPED: ::NTSTATUS = 0xC0220019u32 as i32;
pub const STATUS_FWP_TRAFFIC_MISMATCH: ::NTSTATUS = 0xC022001Au32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_SA_STATE: ::NTSTATUS = 0xC022001Bu32 as i32;
pub const STATUS_FWP_NULL_POINTER: ::NTSTATUS = 0xC022001Cu32 as i32;
pub const STATUS_FWP_INVALID_ENUMERATOR: ::NTSTATUS = 0xC022001Du32 as i32;
pub const STATUS_FWP_INVALID_FLAGS: ::NTSTATUS = 0xC022001Eu32 as i32;
pub const STATUS_FWP_INVALID_NET_MASK: ::NTSTATUS = 0xC022001Fu32 as i32;
pub const STATUS_FWP_INVALID_RANGE: ::NTSTATUS = 0xC0220020u32 as i32;
pub const STATUS_FWP_INVALID_INTERVAL: ::NTSTATUS = 0xC0220021u32 as i32;
pub const STATUS_FWP_ZERO_LENGTH_ARRAY: ::NTSTATUS = 0xC0220022u32 as i32;
pub const STATUS_FWP_NULL_DISPLAY_NAME: ::NTSTATUS = 0xC0220023u32 as i32;
pub const STATUS_FWP_INVALID_ACTION_TYPE: ::NTSTATUS = 0xC0220024u32 as i32;
pub const STATUS_FWP_INVALID_WEIGHT: ::NTSTATUS = 0xC0220025u32 as i32;
pub const STATUS_FWP_MATCH_TYPE_MISMATCH: ::NTSTATUS = 0xC0220026u32 as i32;
pub const STATUS_FWP_TYPE_MISMATCH: ::NTSTATUS = 0xC0220027u32 as i32;
pub const STATUS_FWP_OUT_OF_BOUNDS: ::NTSTATUS = 0xC0220028u32 as i32;
pub const STATUS_FWP_RESERVED: ::NTSTATUS = 0xC0220029u32 as i32;
pub const STATUS_FWP_DUPLICATE_CONDITION: ::NTSTATUS = 0xC022002Au32 as i32;
pub const STATUS_FWP_DUPLICATE_KEYMOD: ::NTSTATUS = 0xC022002Bu32 as i32;
pub const STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER: ::NTSTATUS = 0xC022002Cu32 as i32;
pub const STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER: ::NTSTATUS = 0xC022002Du32 as i32;
pub const STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER: ::NTSTATUS = 0xC022002Eu32 as i32;
pub const STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT: ::NTSTATUS = 0xC022002Fu32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_AUTH_METHOD: ::NTSTATUS = 0xC0220030u32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_DH_GROUP: ::NTSTATUS = 0xC0220031u32 as i32;
pub const STATUS_FWP_EM_NOT_SUPPORTED: ::NTSTATUS = 0xC0220032u32 as i32;
pub const STATUS_FWP_NEVER_MATCH: ::NTSTATUS = 0xC0220033u32 as i32;
pub const STATUS_FWP_PROVIDER_CONTEXT_MISMATCH: ::NTSTATUS = 0xC0220034u32 as i32;
pub const STATUS_FWP_INVALID_PARAMETER: ::NTSTATUS = 0xC0220035u32 as i32;
pub const STATUS_FWP_TOO_MANY_SUBLAYERS: ::NTSTATUS = 0xC0220036u32 as i32;
pub const STATUS_FWP_CALLOUT_NOTIFICATION_FAILED: ::NTSTATUS = 0xC0220037u32 as i32;
pub const STATUS_FWP_INVALID_AUTH_TRANSFORM: ::NTSTATUS = 0xC0220038u32 as i32;
pub const STATUS_FWP_INVALID_CIPHER_TRANSFORM: ::NTSTATUS = 0xC0220039u32 as i32;
pub const STATUS_FWP_INCOMPATIBLE_CIPHER_TRANSFORM: ::NTSTATUS = 0xC022003Au32 as i32;
pub const STATUS_FWP_INVALID_TRANSFORM_COMBINATION: ::NTSTATUS = 0xC022003Bu32 as i32;
pub const STATUS_FWP_DUPLICATE_AUTH_METHOD: ::NTSTATUS = 0xC022003Cu32 as i32;
pub const STATUS_FWP_INVALID_TUNNEL_ENDPOINT: ::NTSTATUS = 0xC022003Du32 as i32;
pub const STATUS_FWP_L2_DRIVER_NOT_READY: ::NTSTATUS = 0xC022003Eu32 as i32;
pub const STATUS_FWP_KEY_DICTATOR_ALREADY_REGISTERED: ::NTSTATUS = 0xC022003Fu32 as i32;
pub const STATUS_FWP_KEY_DICTATION_INVALID_KEYING_MATERIAL: ::NTSTATUS = 0xC0220040u32 as i32;
pub const STATUS_FWP_CONNECTIONS_DISABLED: ::NTSTATUS = 0xC0220041u32 as i32;
pub const STATUS_FWP_INVALID_DNS_NAME: ::NTSTATUS = 0xC0220042u32 as i32;
pub const STATUS_FWP_STILL_ON: ::NTSTATUS = 0xC0220043u32 as i32;
pub const STATUS_FWP_IKEEXT_NOT_RUNNING: ::NTSTATUS = 0xC0220044u32 as i32;
pub const STATUS_FWP_TCPIP_NOT_READY: ::NTSTATUS = 0xC0220100u32 as i32;
pub const STATUS_FWP_INJECT_HANDLE_CLOSING: ::NTSTATUS = 0xC0220101u32 as i32;
pub const STATUS_FWP_INJECT_HANDLE_STALE: ::NTSTATUS = 0xC0220102u32 as i32;
pub const STATUS_FWP_CANNOT_PEND: ::NTSTATUS = 0xC0220103u32 as i32;
pub const STATUS_FWP_DROP_NOICMP: ::NTSTATUS = 0xC0220104u32 as i32;
pub const STATUS_NDIS_CLOSING: ::NTSTATUS = 0xC0230002u32 as i32;
pub const STATUS_NDIS_BAD_VERSION: ::NTSTATUS = 0xC0230004u32 as i32;
pub const STATUS_NDIS_BAD_CHARACTERISTICS: ::NTSTATUS = 0xC0230005u32 as i32;
pub const STATUS_NDIS_ADAPTER_NOT_FOUND: ::NTSTATUS = 0xC0230006u32 as i32;
pub const STATUS_NDIS_OPEN_FAILED: ::NTSTATUS = 0xC0230007u32 as i32;
pub const STATUS_NDIS_DEVICE_FAILED: ::NTSTATUS = 0xC0230008u32 as i32;
pub const STATUS_NDIS_MULTICAST_FULL: ::NTSTATUS = 0xC0230009u32 as i32;
pub const STATUS_NDIS_MULTICAST_EXISTS: ::NTSTATUS = 0xC023000Au32 as i32;
pub const STATUS_NDIS_MULTICAST_NOT_FOUND: ::NTSTATUS = 0xC023000Bu32 as i32;
pub const STATUS_NDIS_REQUEST_ABORTED: ::NTSTATUS = 0xC023000Cu32 as i32;
pub const STATUS_NDIS_RESET_IN_PROGRESS: ::NTSTATUS = 0xC023000Du32 as i32;
pub const STATUS_NDIS_NOT_SUPPORTED: ::NTSTATUS = 0xC02300BBu32 as i32;
pub const STATUS_NDIS_INVALID_PACKET: ::NTSTATUS = 0xC023000Fu32 as i32;
pub const STATUS_NDIS_ADAPTER_NOT_READY: ::NTSTATUS = 0xC0230011u32 as i32;
pub const STATUS_NDIS_INVALID_LENGTH: ::NTSTATUS = 0xC0230014u32 as i32;
pub const STATUS_NDIS_INVALID_DATA: ::NTSTATUS = 0xC0230015u32 as i32;
pub const STATUS_NDIS_BUFFER_TOO_SHORT: ::NTSTATUS = 0xC0230016u32 as i32;
pub const STATUS_NDIS_INVALID_OID: ::NTSTATUS = 0xC0230017u32 as i32;
pub const STATUS_NDIS_ADAPTER_REMOVED: ::NTSTATUS = 0xC0230018u32 as i32;
pub const STATUS_NDIS_UNSUPPORTED_MEDIA: ::NTSTATUS = 0xC0230019u32 as i32;
pub const STATUS_NDIS_GROUP_ADDRESS_IN_USE: ::NTSTATUS = 0xC023001Au32 as i32;
pub const STATUS_NDIS_FILE_NOT_FOUND: ::NTSTATUS = 0xC023001Bu32 as i32;
pub const STATUS_NDIS_ERROR_READING_FILE: ::NTSTATUS = 0xC023001Cu32 as i32;
pub const STATUS_NDIS_ALREADY_MAPPED: ::NTSTATUS = 0xC023001Du32 as i32;
pub const STATUS_NDIS_RESOURCE_CONFLICT: ::NTSTATUS = 0xC023001Eu32 as i32;
pub const STATUS_NDIS_MEDIA_DISCONNECTED: ::NTSTATUS = 0xC023001Fu32 as i32;
pub const STATUS_NDIS_INVALID_ADDRESS: ::NTSTATUS = 0xC0230022u32 as i32;
pub const STATUS_NDIS_INVALID_DEVICE_REQUEST: ::NTSTATUS = 0xC0230010u32 as i32;
pub const STATUS_NDIS_PAUSED: ::NTSTATUS = 0xC023002Au32 as i32;
pub const STATUS_NDIS_INTERFACE_NOT_FOUND: ::NTSTATUS = 0xC023002Bu32 as i32;
pub const STATUS_NDIS_UNSUPPORTED_REVISION: ::NTSTATUS = 0xC023002Cu32 as i32;
pub const STATUS_NDIS_INVALID_PORT: ::NTSTATUS = 0xC023002Du32 as i32;
pub const STATUS_NDIS_INVALID_PORT_STATE: ::NTSTATUS = 0xC023002Eu32 as i32;
pub const STATUS_NDIS_LOW_POWER_STATE: ::NTSTATUS = 0xC023002Fu32 as i32;
pub const STATUS_NDIS_REINIT_REQUIRED: ::NTSTATUS = 0xC0230030u32 as i32;
pub const STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED: ::NTSTATUS = 0xC0232000u32 as i32;
pub const STATUS_NDIS_DOT11_MEDIA_IN_USE: ::NTSTATUS = 0xC0232001u32 as i32;
pub const STATUS_NDIS_DOT11_POWER_STATE_INVALID: ::NTSTATUS = 0xC0232002u32 as i32;
pub const STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL: ::NTSTATUS = 0xC0232003u32 as i32;
pub const STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL: ::NTSTATUS = 0xC0232004u32 as i32;
pub const STATUS_NDIS_INDICATION_REQUIRED: ::NTSTATUS = 0x40230001;
pub const STATUS_NDIS_OFFLOAD_POLICY: ::NTSTATUS = 0xC023100Fu32 as i32;
pub const STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED: ::NTSTATUS = 0xC0231012u32 as i32;
pub const STATUS_NDIS_OFFLOAD_PATH_REJECTED: ::NTSTATUS = 0xC0231013u32 as i32;
pub const STATUS_TPM_ERROR_MASK: ::NTSTATUS = 0xC0290000u32 as i32;
pub const STATUS_TPM_AUTHFAIL: ::NTSTATUS = 0xC0290001u32 as i32;
pub const STATUS_TPM_BADINDEX: ::NTSTATUS = 0xC0290002u32 as i32;
pub const STATUS_TPM_BAD_PARAMETER: ::NTSTATUS = 0xC0290003u32 as i32;
pub const STATUS_TPM_AUDITFAILURE: ::NTSTATUS = 0xC0290004u32 as i32;
pub const STATUS_TPM_CLEAR_DISABLED: ::NTSTATUS = 0xC0290005u32 as i32;
pub const STATUS_TPM_DEACTIVATED: ::NTSTATUS = 0xC0290006u32 as i32;
pub const STATUS_TPM_DISABLED: ::NTSTATUS = 0xC0290007u32 as i32;
pub const STATUS_TPM_DISABLED_CMD: ::NTSTATUS = 0xC0290008u32 as i32;
pub const STATUS_TPM_FAIL: ::NTSTATUS = 0xC0290009u32 as i32;
pub const STATUS_TPM_BAD_ORDINAL: ::NTSTATUS = 0xC029000Au32 as i32;
pub const STATUS_TPM_INSTALL_DISABLED: ::NTSTATUS = 0xC029000Bu32 as i32;
pub const STATUS_TPM_INVALID_KEYHANDLE: ::NTSTATUS = 0xC029000Cu32 as i32;
pub const STATUS_TPM_KEYNOTFOUND: ::NTSTATUS = 0xC029000Du32 as i32;
pub const STATUS_TPM_INAPPROPRIATE_ENC: ::NTSTATUS = 0xC029000Eu32 as i32;
pub const STATUS_TPM_MIGRATEFAIL: ::NTSTATUS = 0xC029000Fu32 as i32;
pub const STATUS_TPM_INVALID_PCR_INFO: ::NTSTATUS = 0xC0290010u32 as i32;
pub const STATUS_TPM_NOSPACE: ::NTSTATUS = 0xC0290011u32 as i32;
pub const STATUS_TPM_NOSRK: ::NTSTATUS = 0xC0290012u32 as i32;
pub const STATUS_TPM_NOTSEALED_BLOB: ::NTSTATUS = 0xC0290013u32 as i32;
pub const STATUS_TPM_OWNER_SET: ::NTSTATUS = 0xC0290014u32 as i32;
pub const STATUS_TPM_RESOURCES: ::NTSTATUS = 0xC0290015u32 as i32;
pub const STATUS_TPM_SHORTRANDOM: ::NTSTATUS = 0xC0290016u32 as i32;
pub const STATUS_TPM_SIZE: ::NTSTATUS = 0xC0290017u32 as i32;
pub const STATUS_TPM_WRONGPCRVAL: ::NTSTATUS = 0xC0290018u32 as i32;
pub const STATUS_TPM_BAD_PARAM_SIZE: ::NTSTATUS = 0xC0290019u32 as i32;
pub const STATUS_TPM_SHA_THREAD: ::NTSTATUS = 0xC029001Au32 as i32;
pub const STATUS_TPM_SHA_ERROR: ::NTSTATUS = 0xC029001Bu32 as i32;
pub const STATUS_TPM_FAILEDSELFTEST: ::NTSTATUS = 0xC029001Cu32 as i32;
pub const STATUS_TPM_AUTH2FAIL: ::NTSTATUS = 0xC029001Du32 as i32;
pub const STATUS_TPM_BADTAG: ::NTSTATUS = 0xC029001Eu32 as i32;
pub const STATUS_TPM_IOERROR: ::NTSTATUS = 0xC029001Fu32 as i32;
pub const STATUS_TPM_ENCRYPT_ERROR: ::NTSTATUS = 0xC0290020u32 as i32;
pub const STATUS_TPM_DECRYPT_ERROR: ::NTSTATUS = 0xC0290021u32 as i32;
pub const STATUS_TPM_INVALID_AUTHHANDLE: ::NTSTATUS = 0xC0290022u32 as i32;
pub const STATUS_TPM_NO_ENDORSEMENT: ::NTSTATUS = 0xC0290023u32 as i32;
pub const STATUS_TPM_INVALID_KEYUSAGE: ::NTSTATUS = 0xC0290024u32 as i32;
pub const STATUS_TPM_WRONG_ENTITYTYPE: ::NTSTATUS = 0xC0290025u32 as i32;
pub const STATUS_TPM_INVALID_POSTINIT: ::NTSTATUS = 0xC0290026u32 as i32;
pub const STATUS_TPM_INAPPROPRIATE_SIG: ::NTSTATUS = 0xC0290027u32 as i32;
pub const STATUS_TPM_BAD_KEY_PROPERTY: ::NTSTATUS = 0xC0290028u32 as i32;
pub const STATUS_TPM_BAD_MIGRATION: ::NTSTATUS = 0xC0290029u32 as i32;
pub const STATUS_TPM_BAD_SCHEME: ::NTSTATUS = 0xC029002Au32 as i32;
pub const STATUS_TPM_BAD_DATASIZE: ::NTSTATUS = 0xC029002Bu32 as i32;
pub const STATUS_TPM_BAD_MODE: ::NTSTATUS = 0xC029002Cu32 as i32;
pub const STATUS_TPM_BAD_PRESENCE: ::NTSTATUS = 0xC029002Du32 as i32;
pub const STATUS_TPM_BAD_VERSION: ::NTSTATUS = 0xC029002Eu32 as i32;
pub const STATUS_TPM_NO_WRAP_TRANSPORT: ::NTSTATUS = 0xC029002Fu32 as i32;
pub const STATUS_TPM_AUDITFAIL_UNSUCCESSFUL: ::NTSTATUS = 0xC0290030u32 as i32;
pub const STATUS_TPM_AUDITFAIL_SUCCESSFUL: ::NTSTATUS = 0xC0290031u32 as i32;
pub const STATUS_TPM_NOTRESETABLE: ::NTSTATUS = 0xC0290032u32 as i32;
pub const STATUS_TPM_NOTLOCAL: ::NTSTATUS = 0xC0290033u32 as i32;
pub const STATUS_TPM_BAD_TYPE: ::NTSTATUS = 0xC0290034u32 as i32;
pub const STATUS_TPM_INVALID_RESOURCE: ::NTSTATUS = 0xC0290035u32 as i32;
pub const STATUS_TPM_NOTFIPS: ::NTSTATUS = 0xC0290036u32 as i32;
pub const STATUS_TPM_INVALID_FAMILY: ::NTSTATUS = 0xC0290037u32 as i32;
pub const STATUS_TPM_NO_NV_PERMISSION: ::NTSTATUS = 0xC0290038u32 as i32;
pub const STATUS_TPM_REQUIRES_SIGN: ::NTSTATUS = 0xC0290039u32 as i32;
pub const STATUS_TPM_KEY_NOTSUPPORTED: ::NTSTATUS = 0xC029003Au32 as i32;
pub const STATUS_TPM_AUTH_CONFLICT: ::NTSTATUS = 0xC029003Bu32 as i32;
pub const STATUS_TPM_AREA_LOCKED: ::NTSTATUS = 0xC029003Cu32 as i32;
pub const STATUS_TPM_BAD_LOCALITY: ::NTSTATUS = 0xC029003Du32 as i32;
pub const STATUS_TPM_READ_ONLY: ::NTSTATUS = 0xC029003Eu32 as i32;
pub const STATUS_TPM_PER_NOWRITE: ::NTSTATUS = 0xC029003Fu32 as i32;
pub const STATUS_TPM_FAMILYCOUNT: ::NTSTATUS = 0xC0290040u32 as i32;
pub const STATUS_TPM_WRITE_LOCKED: ::NTSTATUS = 0xC0290041u32 as i32;
pub const STATUS_TPM_BAD_ATTRIBUTES: ::NTSTATUS = 0xC0290042u32 as i32;
pub const STATUS_TPM_INVALID_STRUCTURE: ::NTSTATUS = 0xC0290043u32 as i32;
pub const STATUS_TPM_KEY_OWNER_CONTROL: ::NTSTATUS = 0xC0290044u32 as i32;
pub const STATUS_TPM_BAD_COUNTER: ::NTSTATUS = 0xC0290045u32 as i32;
pub const STATUS_TPM_NOT_FULLWRITE: ::NTSTATUS = 0xC0290046u32 as i32;
pub const STATUS_TPM_CONTEXT_GAP: ::NTSTATUS = 0xC0290047u32 as i32;
pub const STATUS_TPM_MAXNVWRITES: ::NTSTATUS = 0xC0290048u32 as i32;
pub const STATUS_TPM_NOOPERATOR: ::NTSTATUS = 0xC0290049u32 as i32;
pub const STATUS_TPM_RESOURCEMISSING: ::NTSTATUS = 0xC029004Au32 as i32;
pub const STATUS_TPM_DELEGATE_LOCK: ::NTSTATUS = 0xC029004Bu32 as i32;
pub const STATUS_TPM_DELEGATE_FAMILY: ::NTSTATUS = 0xC029004Cu32 as i32;
pub const STATUS_TPM_DELEGATE_ADMIN: ::NTSTATUS = 0xC029004Du32 as i32;
pub const STATUS_TPM_TRANSPORT_NOTEXCLUSIVE: ::NTSTATUS = 0xC029004Eu32 as i32;
pub const STATUS_TPM_OWNER_CONTROL: ::NTSTATUS = 0xC029004Fu32 as i32;
pub const STATUS_TPM_DAA_RESOURCES: ::NTSTATUS = 0xC0290050u32 as i32;
pub const STATUS_TPM_DAA_INPUT_DATA0: ::NTSTATUS = 0xC0290051u32 as i32;
pub const STATUS_TPM_DAA_INPUT_DATA1: ::NTSTATUS = 0xC0290052u32 as i32;
pub const STATUS_TPM_DAA_ISSUER_SETTINGS: ::NTSTATUS = 0xC0290053u32 as i32;
pub const STATUS_TPM_DAA_TPM_SETTINGS: ::NTSTATUS = 0xC0290054u32 as i32;
pub const STATUS_TPM_DAA_STAGE: ::NTSTATUS = 0xC0290055u32 as i32;
pub const STATUS_TPM_DAA_ISSUER_VALIDITY: ::NTSTATUS = 0xC0290056u32 as i32;
pub const STATUS_TPM_DAA_WRONG_W: ::NTSTATUS = 0xC0290057u32 as i32;
pub const STATUS_TPM_BAD_HANDLE: ::NTSTATUS = 0xC0290058u32 as i32;
pub const STATUS_TPM_BAD_DELEGATE: ::NTSTATUS = 0xC0290059u32 as i32;
pub const STATUS_TPM_BADCONTEXT: ::NTSTATUS = 0xC029005Au32 as i32;
pub const STATUS_TPM_TOOMANYCONTEXTS: ::NTSTATUS = 0xC029005Bu32 as i32;
pub const STATUS_TPM_MA_TICKET_SIGNATURE: ::NTSTATUS = 0xC029005Cu32 as i32;
pub const STATUS_TPM_MA_DESTINATION: ::NTSTATUS = 0xC029005Du32 as i32;
pub const STATUS_TPM_MA_SOURCE: ::NTSTATUS = 0xC029005Eu32 as i32;
pub const STATUS_TPM_MA_AUTHORITY: ::NTSTATUS = 0xC029005Fu32 as i32;
pub const STATUS_TPM_PERMANENTEK: ::NTSTATUS = 0xC0290061u32 as i32;
pub const STATUS_TPM_BAD_SIGNATURE: ::NTSTATUS = 0xC0290062u32 as i32;
pub const STATUS_TPM_NOCONTEXTSPACE: ::NTSTATUS = 0xC0290063u32 as i32;
pub const STATUS_TPM_COMMAND_BLOCKED: ::NTSTATUS = 0xC0290400u32 as i32;
pub const STATUS_TPM_INVALID_HANDLE: ::NTSTATUS = 0xC0290401u32 as i32;
pub const STATUS_TPM_DUPLICATE_VHANDLE: ::NTSTATUS = 0xC0290402u32 as i32;
pub const STATUS_TPM_EMBEDDED_COMMAND_BLOCKED: ::NTSTATUS = 0xC0290403u32 as i32;
pub const STATUS_TPM_EMBEDDED_COMMAND_UNSUPPORTED: ::NTSTATUS = 0xC0290404u32 as i32;
pub const STATUS_TPM_RETRY: ::NTSTATUS = 0xC0290800u32 as i32;
pub const STATUS_TPM_NEEDS_SELFTEST: ::NTSTATUS = 0xC0290801u32 as i32;
pub const STATUS_TPM_DOING_SELFTEST: ::NTSTATUS = 0xC0290802u32 as i32;
pub const STATUS_TPM_DEFEND_LOCK_RUNNING: ::NTSTATUS = 0xC0290803u32 as i32;
pub const STATUS_TPM_COMMAND_CANCELED: ::NTSTATUS = 0xC0291001u32 as i32;
pub const STATUS_TPM_TOO_MANY_CONTEXTS: ::NTSTATUS = 0xC0291002u32 as i32;
pub const STATUS_TPM_NOT_FOUND: ::NTSTATUS = 0xC0291003u32 as i32;
pub const STATUS_TPM_ACCESS_DENIED: ::NTSTATUS = 0xC0291004u32 as i32;
pub const STATUS_TPM_INSUFFICIENT_BUFFER: ::NTSTATUS = 0xC0291005u32 as i32;
pub const STATUS_TPM_PPI_FUNCTION_UNSUPPORTED: ::NTSTATUS = 0xC0291006u32 as i32;
pub const STATUS_PCP_ERROR_MASK: ::NTSTATUS = 0xC0292000u32 as i32;
pub const STATUS_PCP_DEVICE_NOT_READY: ::NTSTATUS = 0xC0292001u32 as i32;
pub const STATUS_PCP_INVALID_HANDLE: ::NTSTATUS = 0xC0292002u32 as i32;
pub const STATUS_PCP_INVALID_PARAMETER: ::NTSTATUS = 0xC0292003u32 as i32;
pub const STATUS_PCP_FLAG_NOT_SUPPORTED: ::NTSTATUS = 0xC0292004u32 as i32;
pub const STATUS_PCP_NOT_SUPPORTED: ::NTSTATUS = 0xC0292005u32 as i32;
pub const STATUS_PCP_BUFFER_TOO_SMALL: ::NTSTATUS = 0xC0292006u32 as i32;
pub const STATUS_PCP_INTERNAL_ERROR: ::NTSTATUS = 0xC0292007u32 as i32;
pub const STATUS_PCP_AUTHENTICATION_FAILED: ::NTSTATUS = 0xC0292008u32 as i32;
pub const STATUS_PCP_AUTHENTICATION_IGNORED: ::NTSTATUS = 0xC0292009u32 as i32;
pub const STATUS_PCP_POLICY_NOT_FOUND: ::NTSTATUS = 0xC029200Au32 as i32;
pub const STATUS_PCP_PROFILE_NOT_FOUND: ::NTSTATUS = 0xC029200Bu32 as i32;
pub const STATUS_PCP_VALIDATION_FAILED: ::NTSTATUS = 0xC029200Cu32 as i32;
pub const STATUS_PCP_DEVICE_NOT_FOUND: ::NTSTATUS = 0xC029200Du32 as i32;
pub const STATUS_RTPM_CONTEXT_CONTINUE: ::NTSTATUS = 0x00293000;
pub const STATUS_RTPM_CONTEXT_COMPLETE: ::NTSTATUS = 0x00293001;
pub const STATUS_RTPM_NO_RESULT: ::NTSTATUS = 0xC0293002u32 as i32;
pub const STATUS_RTPM_PCR_READ_INCOMPLETE: ::NTSTATUS = 0xC0293003u32 as i32;
pub const STATUS_RTPM_INVALID_CONTEXT: ::NTSTATUS = 0xC0293004u32 as i32;
pub const STATUS_RTPM_UNSUPPORTED_CMD: ::NTSTATUS = 0xC0293005u32 as i32;
pub const STATUS_HV_INVALID_HYPERCALL_CODE: ::NTSTATUS = 0xC0350002u32 as i32;
pub const STATUS_HV_INVALID_HYPERCALL_INPUT: ::NTSTATUS = 0xC0350003u32 as i32;
pub const STATUS_HV_INVALID_ALIGNMENT: ::NTSTATUS = 0xC0350004u32 as i32;
pub const STATUS_HV_INVALID_PARAMETER: ::NTSTATUS = 0xC0350005u32 as i32;
pub const STATUS_HV_ACCESS_DENIED: ::NTSTATUS = 0xC0350006u32 as i32;
pub const STATUS_HV_INVALID_PARTITION_STATE: ::NTSTATUS = 0xC0350007u32 as i32;
pub const STATUS_HV_OPERATION_DENIED: ::NTSTATUS = 0xC0350008u32 as i32;
pub const STATUS_HV_UNKNOWN_PROPERTY: ::NTSTATUS = 0xC0350009u32 as i32;
pub const STATUS_HV_PROPERTY_VALUE_OUT_OF_RANGE: ::NTSTATUS = 0xC035000Au32 as i32;
pub const STATUS_HV_INSUFFICIENT_MEMORY: ::NTSTATUS = 0xC035000Bu32 as i32;
pub const STATUS_HV_PARTITION_TOO_DEEP: ::NTSTATUS = 0xC035000Cu32 as i32;
pub const STATUS_HV_INVALID_PARTITION_ID: ::NTSTATUS = 0xC035000Du32 as i32;
pub const STATUS_HV_INVALID_VP_INDEX: ::NTSTATUS = 0xC035000Eu32 as i32;
pub const STATUS_HV_INVALID_PORT_ID: ::NTSTATUS = 0xC0350011u32 as i32;
pub const STATUS_HV_INVALID_CONNECTION_ID: ::NTSTATUS = 0xC0350012u32 as i32;
pub const STATUS_HV_INSUFFICIENT_BUFFERS: ::NTSTATUS = 0xC0350013u32 as i32;
pub const STATUS_HV_NOT_ACKNOWLEDGED: ::NTSTATUS = 0xC0350014u32 as i32;
pub const STATUS_HV_ACKNOWLEDGED: ::NTSTATUS = 0xC0350016u32 as i32;
pub const STATUS_HV_INVALID_SAVE_RESTORE_STATE: ::NTSTATUS = 0xC0350017u32 as i32;
pub const STATUS_HV_INVALID_SYNIC_STATE: ::NTSTATUS = 0xC0350018u32 as i32;
pub const STATUS_HV_OBJECT_IN_USE: ::NTSTATUS = 0xC0350019u32 as i32;
pub const STATUS_HV_INVALID_PROXIMITY_DOMAIN_INFO: ::NTSTATUS = 0xC035001Au32 as i32;
pub const STATUS_HV_NO_DATA: ::NTSTATUS = 0xC035001Bu32 as i32;
pub const STATUS_HV_INACTIVE: ::NTSTATUS = 0xC035001Cu32 as i32;
pub const STATUS_HV_NO_RESOURCES: ::NTSTATUS = 0xC035001Du32 as i32;
pub const STATUS_HV_FEATURE_UNAVAILABLE: ::NTSTATUS = 0xC035001Eu32 as i32;
pub const STATUS_HV_INSUFFICIENT_BUFFER: ::NTSTATUS = 0xC0350033u32 as i32;
pub const STATUS_HV_INSUFFICIENT_DEVICE_DOMAINS: ::NTSTATUS = 0xC0350038u32 as i32;
pub const STATUS_HV_CPUID_FEATURE_VALIDATION_ERROR: ::NTSTATUS = 0xC035003Cu32 as i32;
pub const STATUS_HV_CPUID_XSAVE_FEATURE_VALIDATION_ERROR: ::NTSTATUS = 0xC035003Du32 as i32;
pub const STATUS_HV_PROCESSOR_STARTUP_TIMEOUT: ::NTSTATUS = 0xC035003Eu32 as i32;
pub const STATUS_HV_SMX_ENABLED: ::NTSTATUS = 0xC035003Fu32 as i32;
pub const STATUS_HV_INVALID_LP_INDEX: ::NTSTATUS = 0xC0350041u32 as i32;
pub const STATUS_HV_INVALID_REGISTER_VALUE: ::NTSTATUS = 0xC0350050u32 as i32;
pub const STATUS_HV_INVALID_VTL_STATE: ::NTSTATUS = 0xC0350051u32 as i32;
pub const STATUS_HV_NX_NOT_DETECTED: ::NTSTATUS = 0xC0350055u32 as i32;
pub const STATUS_HV_INVALID_DEVICE_ID: ::NTSTATUS = 0xC0350057u32 as i32;
pub const STATUS_HV_INVALID_DEVICE_STATE: ::NTSTATUS = 0xC0350058u32 as i32;
pub const STATUS_HV_PENDING_PAGE_REQUESTS: ::NTSTATUS = 0x00350059;
pub const STATUS_HV_PAGE_REQUEST_INVALID: ::NTSTATUS = 0xC0350060u32 as i32;
pub const STATUS_HV_NOT_PRESENT: ::NTSTATUS = 0xC0351000u32 as i32;
pub const STATUS_VID_DUPLICATE_HANDLER: ::NTSTATUS = 0xC0370001u32 as i32;
pub const STATUS_VID_TOO_MANY_HANDLERS: ::NTSTATUS = 0xC0370002u32 as i32;
pub const STATUS_VID_QUEUE_FULL: ::NTSTATUS = 0xC0370003u32 as i32;
pub const STATUS_VID_HANDLER_NOT_PRESENT: ::NTSTATUS = 0xC0370004u32 as i32;
pub const STATUS_VID_INVALID_OBJECT_NAME: ::NTSTATUS = 0xC0370005u32 as i32;
pub const STATUS_VID_PARTITION_NAME_TOO_LONG: ::NTSTATUS = 0xC0370006u32 as i32;
pub const STATUS_VID_MESSAGE_QUEUE_NAME_TOO_LONG: ::NTSTATUS = 0xC0370007u32 as i32;
pub const STATUS_VID_PARTITION_ALREADY_EXISTS: ::NTSTATUS = 0xC0370008u32 as i32;
pub const STATUS_VID_PARTITION_DOES_NOT_EXIST: ::NTSTATUS = 0xC0370009u32 as i32;
pub const STATUS_VID_PARTITION_NAME_NOT_FOUND: ::NTSTATUS = 0xC037000Au32 as i32;
pub const STATUS_VID_MESSAGE_QUEUE_ALREADY_EXISTS: ::NTSTATUS = 0xC037000Bu32 as i32;
pub const STATUS_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT: ::NTSTATUS = 0xC037000Cu32 as i32;
pub const STATUS_VID_MB_STILL_REFERENCED: ::NTSTATUS = 0xC037000Du32 as i32;
pub const STATUS_VID_CHILD_GPA_PAGE_SET_CORRUPTED: ::NTSTATUS = 0xC037000Eu32 as i32;
pub const STATUS_VID_INVALID_NUMA_SETTINGS: ::NTSTATUS = 0xC037000Fu32 as i32;
pub const STATUS_VID_INVALID_NUMA_NODE_INDEX: ::NTSTATUS = 0xC0370010u32 as i32;
pub const STATUS_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED: ::NTSTATUS = 0xC0370011u32 as i32;
pub const STATUS_VID_INVALID_MEMORY_BLOCK_HANDLE: ::NTSTATUS = 0xC0370012u32 as i32;
pub const STATUS_VID_PAGE_RANGE_OVERFLOW: ::NTSTATUS = 0xC0370013u32 as i32;
pub const STATUS_VID_INVALID_MESSAGE_QUEUE_HANDLE: ::NTSTATUS = 0xC0370014u32 as i32;
pub const STATUS_VID_INVALID_GPA_RANGE_HANDLE: ::NTSTATUS = 0xC0370015u32 as i32;
pub const STATUS_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE: ::NTSTATUS = 0xC0370016u32 as i32;
pub const STATUS_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED: ::NTSTATUS = 0xC0370017u32 as i32;
pub const STATUS_VID_INVALID_PPM_HANDLE: ::NTSTATUS = 0xC0370018u32 as i32;
pub const STATUS_VID_MBPS_ARE_LOCKED: ::NTSTATUS = 0xC0370019u32 as i32;
pub const STATUS_VID_MESSAGE_QUEUE_CLOSED: ::NTSTATUS = 0xC037001Au32 as i32;
pub const STATUS_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED: ::NTSTATUS = 0xC037001Bu32 as i32;
pub const STATUS_VID_STOP_PENDING: ::NTSTATUS = 0xC037001Cu32 as i32;
pub const STATUS_VID_INVALID_PROCESSOR_STATE: ::NTSTATUS = 0xC037001Du32 as i32;
pub const STATUS_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT: ::NTSTATUS = 0xC037001Eu32 as i32;
pub const STATUS_VID_KM_INTERFACE_ALREADY_INITIALIZED: ::NTSTATUS = 0xC037001Fu32 as i32;
pub const STATUS_VID_MB_PROPERTY_ALREADY_SET_RESET: ::NTSTATUS = 0xC0370020u32 as i32;
pub const STATUS_VID_MMIO_RANGE_DESTROYED: ::NTSTATUS = 0xC0370021u32 as i32;
pub const STATUS_VID_INVALID_CHILD_GPA_PAGE_SET: ::NTSTATUS = 0xC0370022u32 as i32;
pub const STATUS_VID_RESERVE_PAGE_SET_IS_BEING_USED: ::NTSTATUS = 0xC0370023u32 as i32;
pub const STATUS_VID_RESERVE_PAGE_SET_TOO_SMALL: ::NTSTATUS = 0xC0370024u32 as i32;
pub const STATUS_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE: ::NTSTATUS = 0xC0370025u32 as i32;
pub const STATUS_VID_MBP_COUNT_EXCEEDED_LIMIT: ::NTSTATUS = 0xC0370026u32 as i32;
pub const STATUS_VID_SAVED_STATE_CORRUPT: ::NTSTATUS = 0xC0370027u32 as i32;
pub const STATUS_VID_SAVED_STATE_UNRECOGNIZED_ITEM: ::NTSTATUS = 0xC0370028u32 as i32;
pub const STATUS_VID_SAVED_STATE_INCOMPATIBLE: ::NTSTATUS = 0xC0370029u32 as i32;
pub const STATUS_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED: ::NTSTATUS = 0x80370001u32 as i32;
pub const STATUS_IPSEC_BAD_SPI: ::NTSTATUS = 0xC0360001u32 as i32;
pub const STATUS_IPSEC_SA_LIFETIME_EXPIRED: ::NTSTATUS = 0xC0360002u32 as i32;
pub const STATUS_IPSEC_WRONG_SA: ::NTSTATUS = 0xC0360003u32 as i32;
pub const STATUS_IPSEC_REPLAY_CHECK_FAILED: ::NTSTATUS = 0xC0360004u32 as i32;
pub const STATUS_IPSEC_INVALID_PACKET: ::NTSTATUS = 0xC0360005u32 as i32;
pub const STATUS_IPSEC_INTEGRITY_CHECK_FAILED: ::NTSTATUS = 0xC0360006u32 as i32;
pub const STATUS_IPSEC_CLEAR_TEXT_DROP: ::NTSTATUS = 0xC0360007u32 as i32;
pub const STATUS_IPSEC_AUTH_FIREWALL_DROP: ::NTSTATUS = 0xC0360008u32 as i32;
pub const STATUS_IPSEC_THROTTLE_DROP: ::NTSTATUS = 0xC0360009u32 as i32;
pub const STATUS_IPSEC_DOSP_BLOCK: ::NTSTATUS = 0xC0368000u32 as i32;
pub const STATUS_IPSEC_DOSP_RECEIVED_MULTICAST: ::NTSTATUS = 0xC0368001u32 as i32;
pub const STATUS_IPSEC_DOSP_INVALID_PACKET: ::NTSTATUS = 0xC0368002u32 as i32;
pub const STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED: ::NTSTATUS = 0xC0368003u32 as i32;
pub const STATUS_IPSEC_DOSP_MAX_ENTRIES: ::NTSTATUS = 0xC0368004u32 as i32;
pub const STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: ::NTSTATUS = 0xC0368005u32 as i32;
pub const STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: ::NTSTATUS = 0xC0368006u32 as i32;
pub const STATUS_VOLMGR_INCOMPLETE_REGENERATION: ::NTSTATUS = 0x80380001u32 as i32;
pub const STATUS_VOLMGR_INCOMPLETE_DISK_MIGRATION: ::NTSTATUS = 0x80380002u32 as i32;
pub const STATUS_VOLMGR_DATABASE_FULL: ::NTSTATUS = 0xC0380001u32 as i32;
pub const STATUS_VOLMGR_DISK_CONFIGURATION_CORRUPTED: ::NTSTATUS = 0xC0380002u32 as i32;
pub const STATUS_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC: ::NTSTATUS = 0xC0380003u32 as i32;
pub const STATUS_VOLMGR_PACK_CONFIG_UPDATE_FAILED: ::NTSTATUS = 0xC0380004u32 as i32;
pub const STATUS_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME: ::NTSTATUS = 0xC0380005u32 as i32;
pub const STATUS_VOLMGR_DISK_DUPLICATE: ::NTSTATUS = 0xC0380006u32 as i32;
pub const STATUS_VOLMGR_DISK_DYNAMIC: ::NTSTATUS = 0xC0380007u32 as i32;
pub const STATUS_VOLMGR_DISK_ID_INVALID: ::NTSTATUS = 0xC0380008u32 as i32;
pub const STATUS_VOLMGR_DISK_INVALID: ::NTSTATUS = 0xC0380009u32 as i32;
pub const STATUS_VOLMGR_DISK_LAST_VOTER: ::NTSTATUS = 0xC038000Au32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_INVALID: ::NTSTATUS = 0xC038000Bu32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS: ::NTSTATUS = 0xC038000Cu32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED: ::NTSTATUS = 0xC038000Du32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL: ::NTSTATUS = 0xC038000Eu32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS: ::NTSTATUS = 0xC038000Fu32 as i32;
pub const STATUS_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS: ::NTSTATUS = 0xC0380010u32 as i32;
pub const STATUS_VOLMGR_DISK_MISSING: ::NTSTATUS = 0xC0380011u32 as i32;
pub const STATUS_VOLMGR_DISK_NOT_EMPTY: ::NTSTATUS = 0xC0380012u32 as i32;
pub const STATUS_VOLMGR_DISK_NOT_ENOUGH_SPACE: ::NTSTATUS = 0xC0380013u32 as i32;
pub const STATUS_VOLMGR_DISK_REVECTORING_FAILED: ::NTSTATUS = 0xC0380014u32 as i32;
pub const STATUS_VOLMGR_DISK_SECTOR_SIZE_INVALID: ::NTSTATUS = 0xC0380015u32 as i32;
pub const STATUS_VOLMGR_DISK_SET_NOT_CONTAINED: ::NTSTATUS = 0xC0380016u32 as i32;
pub const STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS: ::NTSTATUS = 0xC0380017u32 as i32;
pub const STATUS_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES: ::NTSTATUS = 0xC0380018u32 as i32;
pub const STATUS_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED: ::NTSTATUS = 0xC0380019u32 as i32;
pub const STATUS_VOLMGR_EXTENT_ALREADY_USED: ::NTSTATUS = 0xC038001Au32 as i32;
pub const STATUS_VOLMGR_EXTENT_NOT_CONTIGUOUS: ::NTSTATUS = 0xC038001Bu32 as i32;
pub const STATUS_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION: ::NTSTATUS = 0xC038001Cu32 as i32;
pub const STATUS_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED: ::NTSTATUS = 0xC038001Du32 as i32;
pub const STATUS_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION: ::NTSTATUS = 0xC038001Eu32 as i32;
pub const STATUS_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH: ::NTSTATUS = 0xC038001Fu32 as i32;
pub const STATUS_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED: ::NTSTATUS = 0xC0380020u32 as i32;
pub const STATUS_VOLMGR_INTERLEAVE_LENGTH_INVALID: ::NTSTATUS = 0xC0380021u32 as i32;
pub const STATUS_VOLMGR_MAXIMUM_REGISTERED_USERS: ::NTSTATUS = 0xC0380022u32 as i32;
pub const STATUS_VOLMGR_MEMBER_IN_SYNC: ::NTSTATUS = 0xC0380023u32 as i32;
pub const STATUS_VOLMGR_MEMBER_INDEX_DUPLICATE: ::NTSTATUS = 0xC0380024u32 as i32;
pub const STATUS_VOLMGR_MEMBER_INDEX_INVALID: ::NTSTATUS = 0xC0380025u32 as i32;
pub const STATUS_VOLMGR_MEMBER_MISSING: ::NTSTATUS = 0xC0380026u32 as i32;
pub const STATUS_VOLMGR_MEMBER_NOT_DETACHED: ::NTSTATUS = 0xC0380027u32 as i32;
pub const STATUS_VOLMGR_MEMBER_REGENERATING: ::NTSTATUS = 0xC0380028u32 as i32;
pub const STATUS_VOLMGR_ALL_DISKS_FAILED: ::NTSTATUS = 0xC0380029u32 as i32;
pub const STATUS_VOLMGR_NO_REGISTERED_USERS: ::NTSTATUS = 0xC038002Au32 as i32;
pub const STATUS_VOLMGR_NO_SUCH_USER: ::NTSTATUS = 0xC038002Bu32 as i32;
pub const STATUS_VOLMGR_NOTIFICATION_RESET: ::NTSTATUS = 0xC038002Cu32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_MEMBERS_INVALID: ::NTSTATUS = 0xC038002Du32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_PLEXES_INVALID: ::NTSTATUS = 0xC038002Eu32 as i32;
pub const STATUS_VOLMGR_PACK_DUPLICATE: ::NTSTATUS = 0xC038002Fu32 as i32;
pub const STATUS_VOLMGR_PACK_ID_INVALID: ::NTSTATUS = 0xC0380030u32 as i32;
pub const STATUS_VOLMGR_PACK_INVALID: ::NTSTATUS = 0xC0380031u32 as i32;
pub const STATUS_VOLMGR_PACK_NAME_INVALID: ::NTSTATUS = 0xC0380032u32 as i32;
pub const STATUS_VOLMGR_PACK_OFFLINE: ::NTSTATUS = 0xC0380033u32 as i32;
pub const STATUS_VOLMGR_PACK_HAS_QUORUM: ::NTSTATUS = 0xC0380034u32 as i32;
pub const STATUS_VOLMGR_PACK_WITHOUT_QUORUM: ::NTSTATUS = 0xC0380035u32 as i32;
pub const STATUS_VOLMGR_PARTITION_STYLE_INVALID: ::NTSTATUS = 0xC0380036u32 as i32;
pub const STATUS_VOLMGR_PARTITION_UPDATE_FAILED: ::NTSTATUS = 0xC0380037u32 as i32;
pub const STATUS_VOLMGR_PLEX_IN_SYNC: ::NTSTATUS = 0xC0380038u32 as i32;
pub const STATUS_VOLMGR_PLEX_INDEX_DUPLICATE: ::NTSTATUS = 0xC0380039u32 as i32;
pub const STATUS_VOLMGR_PLEX_INDEX_INVALID: ::NTSTATUS = 0xC038003Au32 as i32;
pub const STATUS_VOLMGR_PLEX_LAST_ACTIVE: ::NTSTATUS = 0xC038003Bu32 as i32;
pub const STATUS_VOLMGR_PLEX_MISSING: ::NTSTATUS = 0xC038003Cu32 as i32;
pub const STATUS_VOLMGR_PLEX_REGENERATING: ::NTSTATUS = 0xC038003Du32 as i32;
pub const STATUS_VOLMGR_PLEX_TYPE_INVALID: ::NTSTATUS = 0xC038003Eu32 as i32;
pub const STATUS_VOLMGR_PLEX_NOT_RAID5: ::NTSTATUS = 0xC038003Fu32 as i32;
pub const STATUS_VOLMGR_PLEX_NOT_SIMPLE: ::NTSTATUS = 0xC0380040u32 as i32;
pub const STATUS_VOLMGR_STRUCTURE_SIZE_INVALID: ::NTSTATUS = 0xC0380041u32 as i32;
pub const STATUS_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS: ::NTSTATUS = 0xC0380042u32 as i32;
pub const STATUS_VOLMGR_TRANSACTION_IN_PROGRESS: ::NTSTATUS = 0xC0380043u32 as i32;
pub const STATUS_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE: ::NTSTATUS = 0xC0380044u32 as i32;
pub const STATUS_VOLMGR_VOLUME_CONTAINS_MISSING_DISK: ::NTSTATUS = 0xC0380045u32 as i32;
pub const STATUS_VOLMGR_VOLUME_ID_INVALID: ::NTSTATUS = 0xC0380046u32 as i32;
pub const STATUS_VOLMGR_VOLUME_LENGTH_INVALID: ::NTSTATUS = 0xC0380047u32 as i32;
pub const STATUS_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE: ::NTSTATUS = 0xC0380048u32 as i32;
pub const STATUS_VOLMGR_VOLUME_NOT_MIRRORED: ::NTSTATUS = 0xC0380049u32 as i32;
pub const STATUS_VOLMGR_VOLUME_NOT_RETAINED: ::NTSTATUS = 0xC038004Au32 as i32;
pub const STATUS_VOLMGR_VOLUME_OFFLINE: ::NTSTATUS = 0xC038004Bu32 as i32;
pub const STATUS_VOLMGR_VOLUME_RETAINED: ::NTSTATUS = 0xC038004Cu32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_EXTENTS_INVALID: ::NTSTATUS = 0xC038004Du32 as i32;
pub const STATUS_VOLMGR_DIFFERENT_SECTOR_SIZE: ::NTSTATUS = 0xC038004Eu32 as i32;
pub const STATUS_VOLMGR_BAD_BOOT_DISK: ::NTSTATUS = 0xC038004Fu32 as i32;
pub const STATUS_VOLMGR_PACK_CONFIG_OFFLINE: ::NTSTATUS = 0xC0380050u32 as i32;
pub const STATUS_VOLMGR_PACK_CONFIG_ONLINE: ::NTSTATUS = 0xC0380051u32 as i32;
pub const STATUS_VOLMGR_NOT_PRIMARY_PACK: ::NTSTATUS = 0xC0380052u32 as i32;
pub const STATUS_VOLMGR_PACK_LOG_UPDATE_FAILED: ::NTSTATUS = 0xC0380053u32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID: ::NTSTATUS = 0xC0380054u32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID: ::NTSTATUS = 0xC0380055u32 as i32;
pub const STATUS_VOLMGR_VOLUME_MIRRORED: ::NTSTATUS = 0xC0380056u32 as i32;
pub const STATUS_VOLMGR_PLEX_NOT_SIMPLE_SPANNED: ::NTSTATUS = 0xC0380057u32 as i32;
pub const STATUS_VOLMGR_NO_VALID_LOG_COPIES: ::NTSTATUS = 0xC0380058u32 as i32;
pub const STATUS_VOLMGR_PRIMARY_PACK_PRESENT: ::NTSTATUS = 0xC0380059u32 as i32;
pub const STATUS_VOLMGR_NUMBER_OF_DISKS_INVALID: ::NTSTATUS = 0xC038005Au32 as i32;
pub const STATUS_VOLMGR_MIRROR_NOT_SUPPORTED: ::NTSTATUS = 0xC038005Bu32 as i32;
pub const STATUS_VOLMGR_RAID5_NOT_SUPPORTED: ::NTSTATUS = 0xC038005Cu32 as i32;
pub const STATUS_BCD_NOT_ALL_ENTRIES_IMPORTED: ::NTSTATUS = 0x80390001u32 as i32;
pub const STATUS_BCD_TOO_MANY_ELEMENTS: ::NTSTATUS = 0xC0390002u32 as i32;
pub const STATUS_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED: ::NTSTATUS = 0x80390003u32 as i32;
pub const STATUS_VHD_DRIVE_FOOTER_MISSING: ::NTSTATUS = 0xC03A0001u32 as i32;
pub const STATUS_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH: ::NTSTATUS = 0xC03A0002u32 as i32;
pub const STATUS_VHD_DRIVE_FOOTER_CORRUPT: ::NTSTATUS = 0xC03A0003u32 as i32;
pub const STATUS_VHD_FORMAT_UNKNOWN: ::NTSTATUS = 0xC03A0004u32 as i32;
pub const STATUS_VHD_FORMAT_UNSUPPORTED_VERSION: ::NTSTATUS = 0xC03A0005u32 as i32;
pub const STATUS_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH: ::NTSTATUS = 0xC03A0006u32 as i32;
pub const STATUS_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION: ::NTSTATUS = 0xC03A0007u32 as i32;
pub const STATUS_VHD_SPARSE_HEADER_CORRUPT: ::NTSTATUS = 0xC03A0008u32 as i32;
pub const STATUS_VHD_BLOCK_ALLOCATION_FAILURE: ::NTSTATUS = 0xC03A0009u32 as i32;
pub const STATUS_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT: ::NTSTATUS = 0xC03A000Au32 as i32;
pub const STATUS_VHD_INVALID_BLOCK_SIZE: ::NTSTATUS = 0xC03A000Bu32 as i32;
pub const STATUS_VHD_BITMAP_MISMATCH: ::NTSTATUS = 0xC03A000Cu32 as i32;
pub const STATUS_VHD_PARENT_VHD_NOT_FOUND: ::NTSTATUS = 0xC03A000Du32 as i32;
pub const STATUS_VHD_CHILD_PARENT_ID_MISMATCH: ::NTSTATUS = 0xC03A000Eu32 as i32;
pub const STATUS_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH: ::NTSTATUS = 0xC03A000Fu32 as i32;
pub const STATUS_VHD_METADATA_READ_FAILURE: ::NTSTATUS = 0xC03A0010u32 as i32;
pub const STATUS_VHD_METADATA_WRITE_FAILURE: ::NTSTATUS = 0xC03A0011u32 as i32;
pub const STATUS_VHD_INVALID_SIZE: ::NTSTATUS = 0xC03A0012u32 as i32;
pub const STATUS_VHD_INVALID_FILE_SIZE: ::NTSTATUS = 0xC03A0013u32 as i32;
pub const STATUS_VIRTDISK_PROVIDER_NOT_FOUND: ::NTSTATUS = 0xC03A0014u32 as i32;
pub const STATUS_VIRTDISK_NOT_VIRTUAL_DISK: ::NTSTATUS = 0xC03A0015u32 as i32;
pub const STATUS_VHD_PARENT_VHD_ACCESS_DENIED: ::NTSTATUS = 0xC03A0016u32 as i32;
pub const STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH: ::NTSTATUS = 0xC03A0017u32 as i32;
pub const STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED: ::NTSTATUS = 0xC03A0018u32 as i32;
pub const STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT: ::NTSTATUS = 0xC03A0019u32 as i32;
pub const STATUS_VIRTUAL_DISK_LIMITATION: ::NTSTATUS = 0xC03A001Au32 as i32;
pub const STATUS_VHD_INVALID_TYPE: ::NTSTATUS = 0xC03A001Bu32 as i32;
pub const STATUS_VHD_INVALID_STATE: ::NTSTATUS = 0xC03A001Cu32 as i32;
pub const STATUS_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE: ::NTSTATUS = 0xC03A001Du32 as i32;
pub const STATUS_VIRTDISK_DISK_ALREADY_OWNED: ::NTSTATUS = 0xC03A001Eu32 as i32;
pub const STATUS_VIRTDISK_DISK_ONLINE_AND_WRITABLE: ::NTSTATUS = 0xC03A001Fu32 as i32;
pub const STATUS_CTLOG_TRACKING_NOT_INITIALIZED: ::NTSTATUS = 0xC03A0020u32 as i32;
pub const STATUS_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE: ::NTSTATUS = 0xC03A0021u32 as i32;
pub const STATUS_CTLOG_VHD_CHANGED_OFFLINE: ::NTSTATUS = 0xC03A0022u32 as i32;
pub const STATUS_CTLOG_INVALID_TRACKING_STATE: ::NTSTATUS = 0xC03A0023u32 as i32;
pub const STATUS_CTLOG_INCONSISTENT_TRACKING_FILE: ::NTSTATUS = 0xC03A0024u32 as i32;
pub const STATUS_VHD_METADATA_FULL: ::NTSTATUS = 0xC03A0028u32 as i32;
pub const STATUS_VHD_INVALID_CHANGE_TRACKING_ID: ::NTSTATUS = 0xC03A0029u32 as i32;
pub const STATUS_VHD_CHANGE_TRACKING_DISABLED: ::NTSTATUS = 0xC03A002Au32 as i32;
pub const STATUS_VHD_MISSING_CHANGE_TRACKING_INFORMATION: ::NTSTATUS = 0xC03A0030u32 as i32;
pub const STATUS_VHD_RESIZE_WOULD_TRUNCATE_DATA: ::NTSTATUS = 0xC03A0031u32 as i32;
pub const STATUS_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE: ::NTSTATUS = 0xC03A0032u32 as i32;
pub const STATUS_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE: ::NTSTATUS = 0xC03A0033u32 as i32;
pub const STATUS_QUERY_STORAGE_ERROR: ::NTSTATUS = 0x803A0001u32 as i32;
pub const STATUS_RKF_KEY_NOT_FOUND: ::NTSTATUS = 0xC0400001u32 as i32;
pub const STATUS_RKF_DUPLICATE_KEY: ::NTSTATUS = 0xC0400002u32 as i32;
pub const STATUS_RKF_BLOB_FULL: ::NTSTATUS = 0xC0400003u32 as i32;
pub const STATUS_RKF_STORE_FULL: ::NTSTATUS = 0xC0400004u32 as i32;
pub const STATUS_RKF_FILE_BLOCKED: ::NTSTATUS = 0xC0400005u32 as i32;
pub const STATUS_RKF_ACTIVE_KEY: ::NTSTATUS = 0xC0400006u32 as i32;
pub const STATUS_RDBSS_RESTART_OPERATION: ::NTSTATUS = 0xC0410001u32 as i32;
pub const STATUS_RDBSS_CONTINUE_OPERATION: ::NTSTATUS = 0xC0410002u32 as i32;
pub const STATUS_RDBSS_POST_OPERATION: ::NTSTATUS = 0xC0410003u32 as i32;
pub const STATUS_BTH_ATT_INVALID_HANDLE: ::NTSTATUS = 0xC0420001u32 as i32;
pub const STATUS_BTH_ATT_READ_NOT_PERMITTED: ::NTSTATUS = 0xC0420002u32 as i32;
pub const STATUS_BTH_ATT_WRITE_NOT_PERMITTED: ::NTSTATUS = 0xC0420003u32 as i32;
pub const STATUS_BTH_ATT_INVALID_PDU: ::NTSTATUS = 0xC0420004u32 as i32;
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHENTICATION: ::NTSTATUS = 0xC0420005u32 as i32;
pub const STATUS_BTH_ATT_REQUEST_NOT_SUPPORTED: ::NTSTATUS = 0xC0420006u32 as i32;
pub const STATUS_BTH_ATT_INVALID_OFFSET: ::NTSTATUS = 0xC0420007u32 as i32;
pub const STATUS_BTH_ATT_INSUFFICIENT_AUTHORIZATION: ::NTSTATUS = 0xC0420008u32 as i32;
pub const STATUS_BTH_ATT_PREPARE_QUEUE_FULL: ::NTSTATUS = 0xC0420009u32 as i32;
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_FOUND: ::NTSTATUS = 0xC042000Au32 as i32;
pub const STATUS_BTH_ATT_ATTRIBUTE_NOT_LONG: ::NTSTATUS = 0xC042000Bu32 as i32;
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE: ::NTSTATUS = 0xC042000Cu32 as i32;
pub const STATUS_BTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH: ::NTSTATUS = 0xC042000Du32 as i32;
pub const STATUS_BTH_ATT_UNLIKELY: ::NTSTATUS = 0xC042000Eu32 as i32;
pub const STATUS_BTH_ATT_INSUFFICIENT_ENCRYPTION: ::NTSTATUS = 0xC042000Fu32 as i32;
pub const STATUS_BTH_ATT_UNSUPPORTED_GROUP_TYPE: ::NTSTATUS = 0xC0420010u32 as i32;
pub const STATUS_BTH_ATT_INSUFFICIENT_RESOURCES: ::NTSTATUS = 0xC0420011u32 as i32;
pub const STATUS_BTH_ATT_UNKNOWN_ERROR: ::NTSTATUS = 0xC0421000u32 as i32;
pub const STATUS_SECUREBOOT_ROLLBACK_DETECTED: ::NTSTATUS = 0xC0430001u32 as i32;
pub const STATUS_SECUREBOOT_POLICY_VIOLATION: ::NTSTATUS = 0xC0430002u32 as i32;
pub const STATUS_SECUREBOOT_INVALID_POLICY: ::NTSTATUS = 0xC0430003u32 as i32;
pub const STATUS_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND: ::NTSTATUS = 0xC0430004u32 as i32;
pub const STATUS_SECUREBOOT_POLICY_NOT_SIGNED: ::NTSTATUS = 0xC0430005u32 as i32;
pub const STATUS_SECUREBOOT_NOT_ENABLED: ::NTSTATUS = 0x80430006u32 as i32;
pub const STATUS_SECUREBOOT_FILE_REPLACED: ::NTSTATUS = 0xC0430007u32 as i32;
pub const STATUS_SYSTEM_INTEGRITY_ROLLBACK_DETECTED: ::NTSTATUS = 0xC0E90001u32 as i32;
pub const STATUS_SYSTEM_INTEGRITY_POLICY_VIOLATION: ::NTSTATUS = 0xC0E90002u32 as i32;
pub const STATUS_SYSTEM_INTEGRITY_INVALID_POLICY: ::NTSTATUS = 0xC0E90003u32 as i32;
pub const STATUS_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED: ::NTSTATUS = 0xC0E90004u32 as i32;
pub const STATUS_NO_APPLICABLE_APP_LICENSES_FOUND: ::NTSTATUS = 0xC0EA0001u32 as i32;
pub const STATUS_AUDIO_ENGINE_NODE_NOT_FOUND: ::NTSTATUS = 0xC0440001u32 as i32;
pub const STATUS_HDAUDIO_EMPTY_CONNECTION_LIST: ::NTSTATUS = 0xC0440002u32 as i32;
pub const STATUS_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED: ::NTSTATUS = 0xC0440003u32 as i32;
pub const STATUS_HDAUDIO_NO_LOGICAL_DEVICES_CREATED: ::NTSTATUS = 0xC0440004u32 as i32;
pub const STATUS_HDAUDIO_NULL_LINKED_LIST_ENTRY: ::NTSTATUS = 0xC0440005u32 as i32;
pub const STATUS_SPACES_RESILIENCY_TYPE_INVALID: ::NTSTATUS = 0xC0E70003u32 as i32;
pub const STATUS_SPACES_DRIVE_SECTOR_SIZE_INVALID: ::NTSTATUS = 0xC0E70004u32 as i32;
pub const STATUS_SPACES_DRIVE_REDUNDANCY_INVALID: ::NTSTATUS = 0xC0E70006u32 as i32;
pub const STATUS_SPACES_NUMBER_OF_DATA_COPIES_INVALID: ::NTSTATUS = 0xC0E70007u32 as i32;
pub const STATUS_SPACES_INTERLEAVE_LENGTH_INVALID: ::NTSTATUS = 0xC0E70009u32 as i32;
pub const STATUS_SPACES_NUMBER_OF_COLUMNS_INVALID: ::NTSTATUS = 0xC0E7000Au32 as i32;
pub const STATUS_SPACES_NOT_ENOUGH_DRIVES: ::NTSTATUS = 0xC0E7000Bu32 as i32;
pub const STATUS_SPACES_EXTENDED_ERROR: ::NTSTATUS = 0xC0E7000Cu32 as i32;
pub const STATUS_SPACES_PROVISIONING_TYPE_INVALID: ::NTSTATUS = 0xC0E7000Du32 as i32;
pub const STATUS_SPACES_ALLOCATION_SIZE_INVALID: ::NTSTATUS = 0xC0E7000Eu32 as i32;
pub const STATUS_SPACES_ENCLOSURE_AWARE_INVALID: ::NTSTATUS = 0xC0E7000Fu32 as i32;
pub const STATUS_SPACES_WRITE_CACHE_SIZE_INVALID: ::NTSTATUS = 0xC0E70010u32 as i32;
pub const STATUS_SPACES_NUMBER_OF_GROUPS_INVALID: ::NTSTATUS = 0xC0E70011u32 as i32;
pub const STATUS_SPACES_DRIVE_OPERATIONAL_STATE_INVALID: ::NTSTATUS = 0xC0E70012u32 as i32;
pub const STATUS_SPACES_UPDATE_COLUMN_STATE: ::NTSTATUS = 0xC0E70013u32 as i32;
pub const STATUS_SPACES_MAP_REQUIRED: ::NTSTATUS = 0xC0E70014u32 as i32;
pub const STATUS_SPACES_UNSUPPORTED_VERSION: ::NTSTATUS = 0xC0E70015u32 as i32;
pub const STATUS_SPACES_CORRUPT_METADATA: ::NTSTATUS = 0xC0E70016u32 as i32;
pub const STATUS_SPACES_DRT_FULL: ::NTSTATUS = 0xC0E70017u32 as i32;
pub const STATUS_SPACES_INCONSISTENCY: ::NTSTATUS = 0xC0E70018u32 as i32;
pub const STATUS_SPACES_LOG_NOT_READY: ::NTSTATUS = 0xC0E70019u32 as i32;
pub const STATUS_SPACES_NO_REDUNDANCY: ::NTSTATUS = 0xC0E7001Au32 as i32;
pub const STATUS_SPACES_DRIVE_NOT_READY: ::NTSTATUS = 0xC0E7001Bu32 as i32;
pub const STATUS_SPACES_REPAIRED: ::NTSTATUS = 0x00E7001C;
pub const STATUS_SPACES_PAUSE: ::NTSTATUS = 0x00E7001D;
pub const STATUS_SPACES_COMPLETE: ::NTSTATUS = 0x00E7001E;
pub const STATUS_VOLSNAP_BOOTFILE_NOT_VALID: ::NTSTATUS = 0xC0500003u32 as i32;
pub const STATUS_IO_PREEMPTED: ::NTSTATUS = 0xC0510001u32 as i32;
pub const STATUS_SVHDX_ERROR_STORED: ::NTSTATUS = 0xC05C0000u32 as i32;
pub const STATUS_SVHDX_ERROR_NOT_AVAILABLE: ::NTSTATUS = 0xC05CFF00u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_AVAILABLE: ::NTSTATUS = 0xC05CFF01u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED: ::NTSTATUS = 0xC05CFF02u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED: ::NTSTATUS = 0xC05CFF03u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED: ::NTSTATUS = 0xC05CFF04u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED: ::NTSTATUS = 0xC05CFF05u32 as i32;
pub const STATUS_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED: ::NTSTATUS = 0xC05CFF06u32 as i32;
pub const STATUS_SVHDX_RESERVATION_CONFLICT: ::NTSTATUS = 0xC05CFF07u32 as i32;
pub const STATUS_SVHDX_WRONG_FILE_TYPE: ::NTSTATUS = 0xC05CFF08u32 as i32;
pub const STATUS_SVHDX_VERSION_MISMATCH: ::NTSTATUS = 0xC05CFF09u32 as i32;
pub const STATUS_VHD_SHARED: ::NTSTATUS = 0xC05CFF0Au32 as i32;
pub const STATUS_SVHDX_NO_INITIATOR: ::NTSTATUS = 0xC05CFF0Bu32 as i32;
pub const STATUS_VHDSET_BACKING_STORAGE_NOT_FOUND: ::NTSTATUS = 0xC05CFF0Cu32 as i32;
pub const STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP: ::NTSTATUS = 0xC05D0000u32 as i32;
pub const STATUS_SMB_BAD_CLUSTER_DIALECT: ::NTSTATUS = 0xC05D0001u32 as i32;
pub const STATUS_SMB_GUEST_LOGON_BLOCKED: ::NTSTATUS = 0xC05D0002u32 as i32;
pub const STATUS_SECCORE_INVALID_COMMAND: ::NTSTATUS = 0xC0E80000u32 as i32;
pub const STATUS_VSM_NOT_INITIALIZED: ::NTSTATUS = 0xC0450000u32 as i32;
pub const STATUS_VSM_DMA_PROTECTION_NOT_IN_USE: ::NTSTATUS = 0xC0450001u32 as i32;
