# Literal expressions

> **<sup>Syntax</sup>**  
> _LiteralExpression_ :  
> &nbsp;&nbsp; &nbsp;&nbsp; [CHAR_LITERAL]  
> &nbsp;&nbsp; | [STRING_LITERAL]  
> &nbsp;&nbsp; | [RAW_STRING_LITERAL]  
> &nbsp;&nbsp; | [BYTE_LITERAL]  
> &nbsp;&nbsp; | [BYTE_STRING_LITERAL]  
> &nbsp;&nbsp; | [RAW_BYTE_STRING_LITERAL]  
> &nbsp;&nbsp; | [INTEGER_LITERAL]  
> &nbsp;&nbsp; | [FLOAT_LITERAL]  
> &nbsp;&nbsp; | [BOOLEAN_LITERAL]  

A _literal expression_ consists of one of the [literal](tokens.html#literals)
forms described earlier. It directly describes a number, character, string,
or boolean value.

```rust
"hello";   // string type
'5';       // character type
5;         // integer type
```

[CHAR_LITERAL]: tokens.html#character-literals
[STRING_LITERAL]: tokens.html#string-literals
[RAW_STRING_LITERAL]: tokens.html#raw-string-literals
[BYTE_LITERAL]: tokens.html#byte-literals
[BYTE_STRING_LITERAL]: tokens.html#byte-string-literals
[RAW_BYTE_STRING_LITERAL]: tokens.html#raw-byte-string-literals
[INTEGER_LITERAL]: tokens.html#integer-literals
[FLOAT_LITERAL]: tokens.html#floating-point-literals
[BOOLEAN_LITERAL]: tokens.html#boolean-literals
