// Copyright 2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// DO NOT EDIT: autogenerated by etc/platform-intrinsics/generator.py
// ignore-tidy-linelength

#![allow(unused_imports)]

use {Intrinsic, Type};
use IntrinsicDef::Named;

pub fn find(name: &str) -> Option<Intrinsic> {
    if !name.starts_with("Q6_") { return None }
    Some(match &name["Q6_".len()..] {
        "R_vextract64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x16, &::U32]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.hexagon.V6.extractw")
        },
        "R_vextract128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x32, &::U32]; &INPUTS },
            output: &::U32,
            definition: Named("llvm.hexagon.V6.extractw.128B")
        },
        "V_lo64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.lo")
        },
        "V_lo128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x64]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.lo.128B")
        },
        "V_hi64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.hi")
        },
        "V_hi128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x64]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.hi.128B")
        },
        "V_vsplat_R64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.lvsplatuw")
        },
        "V_vsplat_R128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.lvsplatuw.128B")
        },
        "Q_and_QQ64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.pred.and")
        },
        "Q_and_QQ128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.pred.and.128B")
        },
        "Q_not_Q64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.pred.not")
        },
        "Q_not_Q128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.pred.not.128B")
        },
        "Q_or_QQ64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.pred.or")
        },
        "Q_or_QQ128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.pred.or.128B")
        },
        "Q_xor_QQ64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.pred.xor")
        },
        "Q_xor_QQ128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.pred.xor.128B")
        },
        "Vub_vabsdiff_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vabsdiffub")
        },
        "Vuh_vabsdiff_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vabsdiffuh")
        },
        "Vub_vabsdiff_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vabsdiffub.128B")
        },
        "Vuh_vabsdiff_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vabsdiffuh.128B")
        },
        "Vuh_vabsdiff_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vabsdiffh")
        },
        "Vuw_vabsdiff_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vabsdiffw")
        },
        "Vuh_vabsdiff_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vabsdiffh.128B")
        },
        "Vuw_vabsdiff_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vabsdiffw.128B")
        },
        "Vh_vabs_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vabsh")
        },
        "Vw_vabs_Vw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vabsw")
        },
        "Vh_vabs_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vabsh.128B")
        },
        "Vw_vabs_Vw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vabsw.128B")
        },
        "Vh_vabs_Vh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vabsh.sat")
        },
        "Vw_vabs_Vw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vabsw.sat")
        },
        "Vh_vabs_Vh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vabsh.sat.128B")
        },
        "Vw_vabs_Vw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vabsw.sat.128B")
        },
        "Vb_vadd_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vaddb")
        },
        "Vh_vadd_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaddh")
        },
        "Vw_vadd_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaddw")
        },
        "Vb_vadd_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vaddb.128B")
        },
        "Vh_vadd_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddh.128B")
        },
        "Vw_vadd_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddw.128B")
        },
        "Vh_vadd_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaddhsat")
        },
        "Vw_vadd_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaddwsat")
        },
        "Vh_vadd_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddhsat.128B")
        },
        "Vw_vadd_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddwsat.128B")
        },
        "Vub_vadd_VubVub_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vaddubsat")
        },
        "Vuh_vadd_VuhVuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vadduhsat")
        },
        "Vub_vadd_VubVub_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vaddubsat.128B")
        },
        "Vuh_vadd_VuhVuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vadduhsat.128B")
        },
        "Wb_vadd_WbWb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vaddb.dv")
        },
        "Wh_vadd_WhWh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddh.dv")
        },
        "Ww_vadd_WwWw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddw.dv")
        },
        "Wb_vadd_WbWb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x256, &::I8x256]; &INPUTS },
            output: &::I8x256,
            definition: Named("llvm.hexagon.V6.vaddb.dv.128B")
        },
        "Wh_vadd_WhWh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::I16x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vaddh.dv.128B")
        },
        "Ww_vadd_WwWw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::I32x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vaddw.dv.128B")
        },
        "Wh_vadd_WhWh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddhsat.dv")
        },
        "Ww_vadd_WwWw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddwsat.dv")
        },
        "Wh_vadd_WhWh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::I16x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vaddhsat.dv.128B")
        },
        "Ww_vadd_WwWw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::I32x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vaddwsat.dv.128B")
        },
        "Wub_vadd_WubWub_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vaddubsat.dv")
        },
        "Wuh_vadd_WuhWuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vadduhsat.dv")
        },
        "Wub_vadd_WubWub_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U8x256]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vaddubsat.dv.128B")
        },
        "Wuh_vadd_WuhWuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x128, &::U16x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vadduhsat.dv.128B")
        },
        "V_valign_VVR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.valignb")
        },
        "V_valign_VVR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.valignb.128B")
        },
        "V_valign_VVI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.valignbi")
        },
        "V_valign_VVI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.valignbi.128B")
        },
        "V_vlalign_VVR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vlalignb")
        },
        "V_vlalign_VVR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vlalignb.128B")
        },
        "V_vlalign_VVI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vlalignbi")
        },
        "V_vlalign_VVI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vlalignbi.128B")
        },
        "V_vand_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vand")
        },
        "V_vand_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vand.128B")
        },
        "V_vand_QR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vandqrt")
        },
        "V_vand_QR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vandqrt.128B")
        },
        "V_vandor_VQR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U32x2, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vandqrt.acc")
        },
        "V_vandor_VQR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U32x4, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vandqrt.acc.128B")
        },
        "Q_vand_VR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vandvrt")
        },
        "Q_vand_VR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vandvrt.128B")
        },
        "Q_vandor_QVR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U8x64, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vandvrt")
        },
        "Q_vandor_QVR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U8x128, &::U32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vandvrt.128B")
        },
        "Vh_vasl_VhR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaslh")
        },
        "Vw_vasl_VwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaslw")
        },
        "Vh_vasl_VhR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaslh.128B")
        },
        "Vw_vasl_VwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaslw.128B")
        },
        "Vh_vasl_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaslhv")
        },
        "Vw_vasl_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaslwv")
        },
        "Vh_vasl_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaslhv.128B")
        },
        "Vw_vasl_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaslwv.128B")
        },
        "Vw_vaslacc_VwVwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaslw.acc")
        },
        "Vw_vaslacc_VwVwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaslw.acc.128B")
        },
        "Vh_vasr_VhR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vasrh")
        },
        "Vw_vasr_VwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vasrw")
        },
        "Vh_vasr_VhR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vasrh.128B")
        },
        "Vw_vasr_VwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vasrw.128B")
        },
        "Vh_vasr_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vasrhv")
        },
        "Vw_vasr_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vasrwv")
        },
        "Vh_vasr_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vasrhv.128B")
        },
        "Vw_vasr_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vasrwv.128B")
        },
        "Vw_vasracc_VwVwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vasrw.acc")
        },
        "Vw_vasracc_VwVwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vasrw.acc.128B")
        },
        "Vh_vasr_VwVwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vasrhw")
        },
        "Vh_vasr_VwVwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vasrhw.128B")
        },
        "Vb_vasr_VhVhR_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::U32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vasrhbsat")
        },
        "Vub_vasr_VhVhR_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vasrhbsat")
        },
        "Vh_vasr_VwVwR_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vasrwhsat")
        },
        "Vuh_vasr_VwVwR_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vasrwhsat")
        },
        "Vb_vasr_VhVhR_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::U32]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vasrhbsat.128B")
        },
        "Vub_vasr_VhVhR_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vasrhbsat.128B")
        },
        "Vh_vasr_VwVwR_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vasrwhsat.128B")
        },
        "Vuh_vasr_VwVwR_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vasrwhsat.128B")
        },
        "Vb_vasr_VhVhR_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::U32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vasrhbrndsat")
        },
        "Vub_vasr_VhVhR_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vasrhbrndsat")
        },
        "Vh_vasr_VwVwR_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vasrwhrndsat")
        },
        "Vuh_vasr_VwVwR_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vasrwhrndsat")
        },
        "Vb_vasr_VhVhR_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::U32]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vasrhbrndsat.128B")
        },
        "Vub_vasr_VhVhR_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vasrhbrndsat.128B")
        },
        "Vh_vasr_VwVwR_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vasrwhrndsat.128B")
        },
        "Vuh_vasr_VwVwR_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vasrwhrndsat.128B")
        },
        "V_equals_V64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x16]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vassign")
        },
        "V_equals_V128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vassign.128B")
        },
        "W_equals_W64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vassignp")
        },
        "W_equals_W128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x64]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vassignp.128B")
        },
        "Vh_vavg_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vavgh")
        },
        "Vw_vavg_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vavgw")
        },
        "Vh_vavg_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vavgh.128B")
        },
        "Vw_vavg_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vavgw.128B")
        },
        "Vub_vavg_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vavgub")
        },
        "Vuh_vavg_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vavguh")
        },
        "Vub_vavg_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vavgub.128B")
        },
        "Vuh_vavg_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vavguh.128B")
        },
        "Vh_vavg_VhVh_rnd64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vavgrndh")
        },
        "Vw_vavg_VwVw_rnd64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vavgrndw")
        },
        "Vh_vavg_VhVh_rnd128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vavgrndh.128B")
        },
        "Vw_vavg_VwVw_rnd128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vavgrndw.128B")
        },
        "Vub_vavg_VubVub_rnd64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vavgrndub")
        },
        "Vuh_vavg_VuhVuh_rnd64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vavgrnduh")
        },
        "Vub_vavg_VubVub_rnd128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vavgrndub.128B")
        },
        "Vuh_vavg_VuhVuh_rnd128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vavgrnduh.128B")
        },
        "Vuh_vcl0_Vuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vcl0h")
        },
        "Vuw_vcl0_Vuw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x16]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vcl0w")
        },
        "Vuh_vcl0_Vuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vcl0h.128B")
        },
        "Vuw_vcl0_Vuw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vcl0w.128B")
        },
        "W_vcombine_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vcombine")
        },
        "W_vcombine_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vcombine.128B")
        },
        "V_vzero64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 0] = []; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vd0")
        },
        "V_vzero128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 0] = []; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vd0.128B")
        },
        "Vb_vdeal_Vb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vdealb")
        },
        "Vh_vdeal_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vdealh")
        },
        "Vb_vdeal_Vb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vdealb.128B")
        },
        "Vh_vdeal_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vdealh.128B")
        },
        "Vb_vdeale_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vdealb4w")
        },
        "Vb_vdeale_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vdealb4w.128B")
        },
        "W_vdeal_VVR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vdealvdd")
        },
        "W_vdeal_VVR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vdealvdd.128B")
        },
        "V_vdelta_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vdelta")
        },
        "V_vdelta_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vdelta.128B")
        },
        "Vh_vdmpy_VubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vdmpybus")
        },
        "Vh_vdmpy_VubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vdmpybus.128B")
        },
        "Vh_vdmpyacc_VhVubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::U8x64, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vdmpybus.acc")
        },
        "Vh_vdmpyacc_VhVubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vdmpybus.acc.128B")
        },
        "Wh_vdmpy_WubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vdmpybus.dv")
        },
        "Wh_vdmpy_WubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vdmpybus.dv.128B")
        },
        "Wh_vdmpyacc_WhWubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vdmpybus.dv.acc")
        },
        "Wh_vdmpyacc_WhWubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vdmpybus.dv.acc.128B")
        },
        "Vw_vdmpy_VhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhb")
        },
        "Vw_vdmpy_VhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhb.128B")
        },
        "Vw_vdmpyacc_VwVhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhb.acc")
        },
        "Vw_vdmpyacc_VwVhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhb.acc.128B")
        },
        "Ww_vdmpy_WhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhb.dv")
        },
        "Ww_vdmpy_WhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vdmpyhb.dv.128B")
        },
        "Ww_vdmpyacc_WwWhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhb.dv.acc")
        },
        "Ww_vdmpyacc_WwWhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vdmpyhb.dv.acc.128B")
        },
        "Vw_vdmpy_WwRh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhisat")
        },
        "Vw_vdmpy_WwRh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhisat.128B")
        },
        "Vw_vdmpy_VhRh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsat")
        },
        "Vw_vdmpy_VhRh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsat.128B")
        },
        "Vw_vdmpy_WhRuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsuisat")
        },
        "Vw_vdmpy_WhRuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsuisat.128B")
        },
        "Vw_vdmpy_VhRuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsusat")
        },
        "Vw_vdmpy_VhRuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsusat.128B")
        },
        "Vw_vdmpy_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhvsat")
        },
        "Vw_vdmpy_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhvsat.128B")
        },
        "Vw_vdmpyacc_VwWwRh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhisat_acc")
        },
        "Vw_vdmpyacc_VwWwRh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhisat_acc.128B")
        },
        "Wuw_vdsad_WuhRuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vdsaduh")
        },
        "Wuw_vdsad_WuhRuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x128, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vdsaduh.128B")
        },
        "Wuw_vdsadacc_WuwWuhRuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U16x64, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vdsaduh.acc")
        },
        "Wuw_vdsadacc_WuwWuhRuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x64, &::U16x128, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vdsaduh.acc.128B")
        },
        "Vw_vdmpyacc_VwVhRh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsat_acc")
        },
        "Vw_vdmpyacc_VwVhRh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsat_acc.128B")
        },
        "Vw_vdmpyacc_VwWhRuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsuisat_acc")
        },
        "Vw_vdmpyacc_VwWhRuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsuisat_acc.128B")
        },
        "Vw_vdmpyacc_VwVhRuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhsusat_acc")
        },
        "Vw_vdmpyacc_VwVhRuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhsusat_acc.128B")
        },
        "Vw_vdmpyacc_VwVhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vdmpyhvsat_acc")
        },
        "Vw_vdmpyacc_VwVhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vdmpyhvsat_acc.128B")
        },
        "Q_vcmp_eq_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqb")
        },
        "Q_vcmp_eq_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqh")
        },
        "Q_vcmp_eq_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqw")
        },
        "Q_vcmp_eq_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqb.128B")
        },
        "Q_vcmp_eq_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqh.128B")
        },
        "Q_vcmp_eq_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqw.128B")
        },
        "Q_vcmp_eqand_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqb.and")
        },
        "Q_vcmp_eqand_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqh.and")
        },
        "Q_vcmp_eqand_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqw.and")
        },
        "Q_vcmp_eqand_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqb.and.128B")
        },
        "Q_vcmp_eqand_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqh.and.128B")
        },
        "Q_vcmp_eqand_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqw.and.128B")
        },
        "Q_vcmp_eqor_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqb.or")
        },
        "Q_vcmp_eqor_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqh.or")
        },
        "Q_vcmp_eqor_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqw.or")
        },
        "Q_vcmp_eqor_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqb.or.128B")
        },
        "Q_vcmp_eqor_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqh.or.128B")
        },
        "Q_vcmp_eqor_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqw.or.128B")
        },
        "Q_vcmp_eqxacc_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqb.xor")
        },
        "Q_vcmp_eqxacc_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqh.xor")
        },
        "Q_vcmp_eqxacc_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.veqw.xor")
        },
        "Q_vcmp_eqxacc_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqb.xor.128B")
        },
        "Q_vcmp_eqxacc_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqh.xor.128B")
        },
        "Q_vcmp_eqxacc_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.veqw.xor.128B")
        },
        "Q_vcmp_gt_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtb")
        },
        "Q_vcmp_gt_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgth")
        },
        "Q_vcmp_gt_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtw")
        },
        "Q_vcmp_gt_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtb.128B")
        },
        "Q_vcmp_gt_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgth.128B")
        },
        "Q_vcmp_gt_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtw.128B")
        },
        "Q_vcmp_gt_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtub")
        },
        "Q_vcmp_gt_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtuh")
        },
        "Q_vcmp_gt_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtub.128B")
        },
        "Q_vcmp_gt_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtuh.128B")
        },
        "Q_vcmp_gtand_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtb.and")
        },
        "Q_vcmp_gtand_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgth.and")
        },
        "Q_vcmp_gtand_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtw.and")
        },
        "Q_vcmp_gtand_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtb.and.128B")
        },
        "Q_vcmp_gtand_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgth.and.128B")
        },
        "Q_vcmp_gtand_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtw.and.128B")
        },
        "Q_vcmp_gtand_QVubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtub.and")
        },
        "Q_vcmp_gtand_QVuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtuh.and")
        },
        "Q_vcmp_gtand_QVubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtub.and.128B")
        },
        "Q_vcmp_gtand_QVuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtuh.and.128B")
        },
        "Q_vcmp_gtor_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtb.or")
        },
        "Q_vcmp_gtor_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgth.or")
        },
        "Q_vcmp_gtor_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtw.or")
        },
        "Q_vcmp_gtor_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtb.or.128B")
        },
        "Q_vcmp_gtor_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgth.or.128B")
        },
        "Q_vcmp_gtor_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtw.or.128B")
        },
        "Q_vcmp_gtor_QVubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtub.or")
        },
        "Q_vcmp_gtor_QVuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtuh.or")
        },
        "Q_vcmp_gtor_QVubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtub.or.128B")
        },
        "Q_vcmp_gtor_QVuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtuh.or.128B")
        },
        "Q_vcmp_gtxacc_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtb.xor")
        },
        "Q_vcmp_gtxacc_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgth.xor")
        },
        "Q_vcmp_gtxacc_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtw.xor")
        },
        "Q_vcmp_gtxacc_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtb.xor.128B")
        },
        "Q_vcmp_gtxacc_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgth.xor.128B")
        },
        "Q_vcmp_gtxacc_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtw.xor.128B")
        },
        "Q_vcmp_gtxacc_QVubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtub.xor")
        },
        "Q_vcmp_gtxacc_QVuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.hexagon.V6.vgtuh.xor")
        },
        "Q_vcmp_gtxacc_QVubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtub.xor.128B")
        },
        "Q_vcmp_gtxacc_QVuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.hexagon.V6.vgtuh.xor.128B")
        },
        "Vw_vinsert_VwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vinsertwr")
        },
        "Vw_vinsert_VwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vinsertwr.128B")
        },
        "Vuh_vlsr_VuhR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vlsrh")
        },
        "Vuw_vlsr_VuwR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x16, &::U32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vlsrw")
        },
        "Vuh_vlsr_VuhR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vlsrh.128B")
        },
        "Vuw_vlsr_VuwR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x32, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vlsrw.128B")
        },
        "Vh_vlsr_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vlsrhv")
        },
        "Vw_vlsr_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vlsrwv")
        },
        "Vh_vlsr_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vlsrhv.128B")
        },
        "Vw_vlsr_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vlsrwv.128B")
        },
        "Vb_vlut32_VbVbR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x64, &::I8x64, &::U32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vlutvvb")
        },
        "Vb_vlut32_VbVbR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x128, &::I8x128, &::U32]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vlutvvb.128B")
        },
        "Wh_vlut16_VbVhR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x64, &::I16x32, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vlutvwh")
        },
        "Wh_vlut16_VbVhR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x128, &::I16x64, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vlutvwh.128B")
        },
        "Vb_vlut32or_VbVbVbR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 4] = [&::I8x64, &::I8x64, &::I8x64, &::U32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vlutvvb.oracc")
        },
        "Vb_vlut32or_VbVbVbR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 4] = [&::I8x128, &::I8x128, &::I8x128, &::U32]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vlutvvb.oracc.128B")
        },
        "Wh_vlut16or_WhVbVhR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 4] = [&::I16x64, &::I8x64, &::I16x32, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vlutvwh.oracc")
        },
        "Wh_vlut16or_WhVbVhR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 4] = [&::I16x128, &::I8x128, &::I16x64, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vlutvwh.oracc.128B")
        },
        "Vh_vmax_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmaxh")
        },
        "Vw_vmax_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmaxw")
        },
        "Vh_vmax_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmaxh.128B")
        },
        "Vw_vmax_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmaxw.128B")
        },
        "Vub_vmax_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vmaxub")
        },
        "Vuh_vmax_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vmaxuh")
        },
        "Vub_vmax_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vmaxub.128B")
        },
        "Vuh_vmax_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vmaxuh.128B")
        },
        "Vh_vmin_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vminh")
        },
        "Vw_vmin_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vminw")
        },
        "Vh_vmin_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vminh.128B")
        },
        "Vw_vmin_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vminw.128B")
        },
        "Vub_vmin_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vminub")
        },
        "Vuh_vmin_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vminuh")
        },
        "Vub_vmin_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vminub.128B")
        },
        "Vuh_vmin_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vminuh.128B")
        },
        "Wh_vmpa_WubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpabus")
        },
        "Wh_vmpa_WubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpabus.128B")
        },
        "Wh_vmpaacc_WhWubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpabus.acc")
        },
        "Wh_vmpaacc_WhWubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpabus.acc.128B")
        },
        "Wh_vmpa_WubWb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::I8x128]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpabusv")
        },
        "Wh_vmpa_WubWub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpabuuv")
        },
        "Wh_vmpa_WubWb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::I8x256]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpabusv.128B")
        },
        "Wh_vmpa_WubWub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U8x256]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpabuuv.128B")
        },
        "Ww_vmpa_WhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpahb")
        },
        "Ww_vmpa_WhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpahb.128B")
        },
        "Ww_vmpaacc_WwWhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpahb.acc")
        },
        "Ww_vmpaacc_WwWhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpahb.acc.128B")
        },
        "Wh_vmpy_VbVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::U8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybus")
        },
        "Ww_vmpy_VhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhus")
        },
        "Wh_vmpy_VbVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::U8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybus.128B")
        },
        "Ww_vmpy_VhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyhus.128B")
        },
        "Wh_vmpyacc_WhVbVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I8x64, &::U8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybus.acc")
        },
        "Ww_vmpyacc_WwVhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x32, &::U16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhus.acc")
        },
        "Wh_vmpyacc_WhVbVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::I8x128, &::U8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybus.acc.128B")
        },
        "Ww_vmpyacc_WwVhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x64, &::U16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyhus.acc.128B")
        },
        "Wh_vmpy_VubVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybusv")
        },
        "Wh_vmpy_VubVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybusv.128B")
        },
        "Wh_vmpyacc_WhVubVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::U8x64, &::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybusv.acc")
        },
        "Wh_vmpyacc_WhVubVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::U8x128, &::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybusv.acc.128B")
        },
        "Wh_vmpy_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybv")
        },
        "Wuh_vmpy_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vmpyubv")
        },
        "Ww_vmpy_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhv")
        },
        "Wuw_vmpy_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vmpyuhv")
        },
        "Wh_vmpy_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybv.128B")
        },
        "Wuh_vmpy_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vmpyubv.128B")
        },
        "Ww_vmpy_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyhv.128B")
        },
        "Wuw_vmpy_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vmpyuhv.128B")
        },
        "Wh_vmpyacc_WhVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpybv.acc")
        },
        "Wuh_vmpyacc_WuhVubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U16x64, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vmpyubv.acc")
        },
        "Ww_vmpyacc_WwVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhv.acc")
        },
        "Wuw_vmpyacc_WuwVuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U16x32, &::U16x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vmpyuhv.acc")
        },
        "Wh_vmpyacc_WhVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vmpybv.acc.128B")
        },
        "Wuh_vmpyacc_WuhVubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U16x128, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vmpyubv.acc.128B")
        },
        "Ww_vmpyacc_WwVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyhv.acc.128B")
        },
        "Wuw_vmpyacc_WuwVuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x64, &::U16x64, &::U16x64]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vmpyuhv.acc.128B")
        },
        "Vw_vmpye_VwVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyewuh")
        },
        "Vw_vmpye_VwVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyewuh.128B")
        },
        "Ww_vmpy_VhRh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyh")
        },
        "Wuw_vmpy_VuhRuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vmpyuh")
        },
        "Ww_vmpy_VhRh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyh.128B")
        },
        "Wuw_vmpy_VuhRuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vmpyuh.128B")
        },
        "Ww_vmpyacc_WwVhRh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhsat.acc")
        },
        "Ww_vmpyacc_WwVhRh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vmpyhsat.acc.128B")
        },
        "Vw_vmpy_VhRh_s1_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyhsrs")
        },
        "Vw_vmpy_VhRh_s1_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhsrs.128B")
        },
        "Vw_vmpy_VhRh_s1_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyhss")
        },
        "Vw_vmpy_VhRh_s1_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyhss.128B")
        },
        "Vh_vmpy_VhVh_s1_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmpyhvsrs")
        },
        "Vh_vmpy_VhVh_s1_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpyhvsrs.128B")
        },
        "Vw_vmpyieo_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyieoh")
        },
        "Vw_vmpyieo_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyieoh.128B")
        },
        "Vw_vmpyieacc_VwVwVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiewh.acc")
        },
        "Vw_vmpyieacc_VwVwVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiewuh.acc")
        },
        "Vw_vmpyieacc_VwVwVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiewh.acc.128B")
        },
        "Vw_vmpyieacc_VwVwVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiewuh.acc.128B")
        },
        "Vw_vmpyie_VwVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiewuh")
        },
        "Vw_vmpyie_VwVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiewuh.128B")
        },
        "Vh_vmpyi_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmpyih")
        },
        "Vh_vmpyi_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpyih.128B")
        },
        "Vh_vmpyiacc_VhVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmpyih.acc")
        },
        "Vh_vmpyiacc_VhVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpyih.acc.128B")
        },
        "Vh_vmpyi_VhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmpyihb")
        },
        "Vw_vmpyi_VwRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwb")
        },
        "Vh_vmpyi_VhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpyihb.128B")
        },
        "Vw_vmpyi_VwRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwb.128B")
        },
        "Vh_vmpyiacc_VhVhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x32, &::I16x32, &::U32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vmpyihb.acc")
        },
        "Vw_vmpyiacc_VwVwRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwb.acc")
        },
        "Vh_vmpyiacc_VhVhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I16x64, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vmpyihb.acc.128B")
        },
        "Vw_vmpyiacc_VwVwRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwb.acc.128B")
        },
        "Vw_vmpyi_VwRh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwh")
        },
        "Vw_vmpyi_VwRh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwh.128B")
        },
        "Vw_vmpyiacc_VwVwRh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwh.acc")
        },
        "Vw_vmpyiacc_VwVwRh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwh.acc.128B")
        },
        "Vw_vmpyi_VwRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwub")
        },
        "Vw_vmpyi_VwRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwub.128B")
        },
        "Vw_vmpyiacc_VwVwRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I32x16, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiwub.acc")
        },
        "Vw_vmpyiacc_VwVwRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I32x32, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiwub.acc.128B")
        },
        "Vw_vmpyo_VwVh_s1_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyowh")
        },
        "Vw_vmpyo_VwVh_s1_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyowh.128B")
        },
        "Vw_vmpyo_VwVh_s1_rnd_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyowh.rnd")
        },
        "Vw_vmpyo_VwVh_s1_rnd_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyowh.rnd.128B")
        },
        "Vw_vmpyo_VwVh_s1_rnd_sat_shift64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyowh.rnd.sacc")
        },
        "Vw_vmpyo_VwVh_s1_rnd_sat_shift128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyowh.rnd.sacc.128B")
        },
        "Vw_vmpyo_VwVh_s1_sat_shift64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyowh.sacc")
        },
        "Vw_vmpyo_VwVh_s1_sat_shift128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyowh.sacc.128B")
        },
        "Vw_vmpyio_VwVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I16x32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vmpyiowh")
        },
        "Vw_vmpyio_VwVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x64]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vmpyiowh.128B")
        },
        "Wuh_vmpy_VubRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vmpyub")
        },
        "Wuh_vmpy_VubRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vmpyub.128B")
        },
        "Wuh_vmpyacc_WuhVubRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U16x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vmpyub.acc")
        },
        "Wuw_vmpyacc_WuwVuhRuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U16x32, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vmpyuh.acc")
        },
        "Wuh_vmpyacc_WuhVubRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U16x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vmpyub.acc.128B")
        },
        "Wuw_vmpyacc_WuwVuhRuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x64, &::U16x64, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vmpyuh.acc.128B")
        },
        "Vuw_vmux_QVV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U32x16, &::U32x16]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vmux")
        },
        "Vuw_vmux_QVV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U32x32, &::U32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vmux.128B")
        },
        "Vh_vnavg_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vnavgh")
        },
        "Vuh_vnavg_VuhVuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vnavguh")
        },
        "Vw_vnavg_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vnavgw")
        },
        "Vuw_vnavg_VuwVuw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x16, &::U32x16]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vnavguw")
        },
        "Vh_vnavg_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vnavgh.128B")
        },
        "Vuh_vnavg_VuhVuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vnavguh.128B")
        },
        "Vw_vnavg_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vnavgw.128B")
        },
        "Vuw_vnavg_VuwVuw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x32, &::U32x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vnavguw.128B")
        },
        "Vub_vnavg_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vnavgub")
        },
        "Vub_vnavg_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vnavgub.128B")
        },
        "Vh_vnormamt_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vnormamth")
        },
        "Vw_vnormamt_Vw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vnormamtw")
        },
        "Vh_vnormamt_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vnormamth.128B")
        },
        "Vw_vnormamt_Vw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vnormamtw.128B")
        },
        "V_vnot_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vnot")
        },
        "V_vnot_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vnot.128B")
        },
        "V_vor_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vor")
        },
        "V_vor_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vor.128B")
        },
        "Vb_vpacke_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vpackhe")
        },
        "Vh_vpacke_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vpackwe")
        },
        "Vb_vpacke_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vpackhe.128B")
        },
        "Vh_vpacke_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vpackwe.128B")
        },
        "Vb_vpacko_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vpackho")
        },
        "Vh_vpacko_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vpackwo")
        },
        "Vb_vpacko_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vpackho.128B")
        },
        "Vh_vpacko_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vpackwo.128B")
        },
        "Vb_vpack_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vpackhb.sat")
        },
        "Vub_vpack_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vpackhub.sat")
        },
        "Vh_vpack_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vpackwh.sat")
        },
        "Vuh_vpack_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vpackwuh.sat")
        },
        "Vb_vpack_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vpackhb.sat.128B")
        },
        "Vub_vpack_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vpackhub.sat.128B")
        },
        "Vh_vpack_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vpackwh.sat.128B")
        },
        "Vuh_vpack_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vpackwuh.sat.128B")
        },
        "Vh_vpopcount_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vpopcounth")
        },
        "Vh_vpopcount_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vpopcounth.128B")
        },
        "V_vrdelta_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vrdelta")
        },
        "V_vrdelta_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vrdelta.128B")
        },
        "Vw_vrmpy_VubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpybus")
        },
        "Vw_vrmpy_VubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybus.128B")
        },
        "Vw_vrmpyacc_VwVubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::U8x64, &::U32]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpybus.acc")
        },
        "Vw_vrmpyacc_VwVubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::U8x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybus.acc.128B")
        },
        "Ww_vrmpy_WubRbI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybusi")
        },
        "Ww_vrmpy_WubRbI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vrmpybusi.128B")
        },
        "Ww_vrmpyacc_WwWubRbI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::U8x128, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybusi.acc")
        },
        "Ww_vrmpyacc_WwWubRbI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::U8x256, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vrmpybusi.acc.128B")
        },
        "Vw_vrmpy_VubVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::I8x64]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpybusv")
        },
        "Vw_vrmpy_VubVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::I8x128]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybusv.128B")
        },
        "Vw_vrmpyacc_VwVubVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::U8x64, &::I8x64]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpybusv.acc")
        },
        "Vw_vrmpyacc_VwVubVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::U8x128, &::I8x128]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybusv.acc.128B")
        },
        "Vw_vrmpy_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpybv")
        },
        "Vuw_vrmpy_VubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vrmpyubv")
        },
        "Vw_vrmpy_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpybv.128B")
        },
        "Vuw_vrmpy_VubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyubv.128B")
        },
        "Vw_vrmpyacc_VwVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x16, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vrmpywv.acc")
        },
        "Vuw_vrmpyacc_VuwVubVub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x16, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vrmpyuwv.acc")
        },
        "Vw_vrmpyacc_VwVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vrmpywv.acc.128B")
        },
        "Vuw_vrmpyacc_VuwVubVub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyuwv.acc.128B")
        },
        "Vuw_vrmpy_VubRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vrmpyub")
        },
        "Vuw_vrmpy_VubRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyub.128B")
        },
        "Vuw_vrmpyacc_VuwVubRub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x16, &::U8x64, &::U32]; &INPUTS },
            output: &::U32x16,
            definition: Named("llvm.hexagon.V6.vrmpyub.acc")
        },
        "Vuw_vrmpyacc_VuwVubRub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyub.acc.128B")
        },
        "Wuw_vrmpy_WubRubI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyubi")
        },
        "Wuw_vrmpy_WubRubI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vrmpyubi.128B")
        },
        "Wuw_vrmpyacc_WuwWubRubI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrmpyubi.acc")
        },
        "Wuw_vrmpyacc_WuwWubRubI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x64, &::U8x256, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vrmpyubi.acc.128B")
        },
        "V_vror_VR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vror")
        },
        "V_vror_VR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vror.128B")
        },
        "Vb_vround_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vroundhb")
        },
        "Vub_vround_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vroundhub")
        },
        "Vh_vround_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vroundwh")
        },
        "Vuh_vround_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vroundwuh")
        },
        "Vb_vround_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vroundhb.128B")
        },
        "Vub_vround_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vroundhub.128B")
        },
        "Vh_vround_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vroundwh.128B")
        },
        "Vuh_vround_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vroundwuh.128B")
        },
        "Wuw_vrsad_WubRubI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrsadubi")
        },
        "Wuw_vrsad_WubRubI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vrsadubi.128B")
        },
        "Wuw_vrsadacc_WuwWubRubI64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x32, &::U8x128, &::U32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vrsadubi.acc")
        },
        "Wuw_vrsadacc_WuwWubRubI128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x64, &::U8x256, &::U32]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vrsadubi.acc.128B")
        },
        "Vub_vsat_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vsathub")
        },
        "Vub_vsat_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vsathub.128B")
        },
        "Vh_vsat_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vsatwh")
        },
        "Vh_vsat_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsatwh.128B")
        },
        "Wh_vsxt_Vb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsb")
        },
        "Ww_vsxt_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsh")
        },
        "Wh_vsxt_Vb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vsb.128B")
        },
        "Ww_vsxt_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vsh.128B")
        },
        "Wuh_vzxt_Vub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vzb")
        },
        "Wuw_vzxt_Vuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vzh")
        },
        "Wuh_vzxt_Vub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vzb.128B")
        },
        "Wuw_vzxt_Vuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x64]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vzh.128B")
        },
        "Vb_condacc_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vaddbq")
        },
        "Vh_condacc_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaddhq")
        },
        "Vw_condacc_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaddwq")
        },
        "Vb_condacc_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vaddbq.128B")
        },
        "Vh_condacc_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddhq.128B")
        },
        "Vw_condacc_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddwq.128B")
        },
        "Vb_condacc_QnVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vaddbnq")
        },
        "Vh_condacc_QnVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vaddhnq")
        },
        "Vw_condacc_QnVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vaddwnq")
        },
        "Vb_condacc_QnVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vaddbnq.128B")
        },
        "Vh_condacc_QnVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vaddhnq.128B")
        },
        "Vw_condacc_QnVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vaddwnq.128B")
        },
        "Vb_condnac_QVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vsubbq")
        },
        "Vh_condnac_QVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vsubhq")
        },
        "Vw_condnac_QVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vsubwq")
        },
        "Vb_condnac_QVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vsubbq.128B")
        },
        "Vh_condnac_QVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubhq.128B")
        },
        "Vw_condnac_QVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubwq.128B")
        },
        "Vb_condnac_QnVbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vsubbnq")
        },
        "Vh_condnac_QnVhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vsubhnq")
        },
        "Vw_condnac_QnVwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vsubwnq")
        },
        "Vb_condnac_QnVbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vsubbnq.128B")
        },
        "Vh_condnac_QnVhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubhnq.128B")
        },
        "Vw_condnac_QnVwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubwnq.128B")
        },
        "Vh_vshuffe_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vshufeh")
        },
        "Vh_vshuffe_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vshufeh.128B")
        },
        "Vh_vshuffo_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vshufoh")
        },
        "Vh_vshuffo_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vshufoh.128B")
        },
        "Vb_vshuff_Vb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vshuffb")
        },
        "Vh_vshuff_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vshuffh")
        },
        "Vb_vshuff_Vb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vshuffb.128B")
        },
        "Vh_vshuff_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vshuffh.128B")
        },
        "Vb_vshuffe_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vshuffeb")
        },
        "Vb_vshuffe_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vshuffeb.128B")
        },
        "Vb_vshuffo_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vshuffob")
        },
        "Vb_vshuffo_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vshuffob.128B")
        },
        "Vb_vshuffoe_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vshuffoeb")
        },
        "Vh_vshuffoe_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vshuffoeh")
        },
        "Vb_vshuffoe_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vshuffoeb.128B")
        },
        "Vh_vshuffoe_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vshuffoeh.128B")
        },
        "W_vshuff_VVR64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x64, &::U8x64, &::U32]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vshufvvd")
        },
        "W_vshuff_VVR128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x128, &::U8x128, &::U32]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vshufvvd.128B")
        },
        "Vb_vsub_VbVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x64, &::I8x64]; &INPUTS },
            output: &::I8x64,
            definition: Named("llvm.hexagon.V6.vsubb")
        },
        "Vh_vsub_VhVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vsubh")
        },
        "Vw_vsub_VwVw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vsubw")
        },
        "Vb_vsub_VbVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vsubb.128B")
        },
        "Vh_vsub_VhVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubh.128B")
        },
        "Vw_vsub_VwVw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubw.128B")
        },
        "Vh_vsub_VhVh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x32, &::I16x32]; &INPUTS },
            output: &::I16x32,
            definition: Named("llvm.hexagon.V6.vsubhsat")
        },
        "Vw_vsub_VwVw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x16, &::I32x16]; &INPUTS },
            output: &::I32x16,
            definition: Named("llvm.hexagon.V6.vsubwsat")
        },
        "Vh_vsub_VhVh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubhsat.128B")
        },
        "Vw_vsub_VwVw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubwsat.128B")
        },
        "Vub_vsub_VubVub_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x64,
            definition: Named("llvm.hexagon.V6.vsububsat")
        },
        "Vuh_vsub_VuhVuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vsubuhsat")
        },
        "Vub_vsub_VubVub_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vsububsat.128B")
        },
        "Vuh_vsub_VuhVuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vsubuhsat.128B")
        },
        "Wb_vsub_WbWb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::I8x128]; &INPUTS },
            output: &::I8x128,
            definition: Named("llvm.hexagon.V6.vsubb.dv")
        },
        "Wh_vsub_WhWh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubh.dv")
        },
        "Ww_vsub_WwWw64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubw.dv")
        },
        "Wb_vsub_WbWb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x256, &::I8x256]; &INPUTS },
            output: &::I8x256,
            definition: Named("llvm.hexagon.V6.vsubb.dv.128B")
        },
        "Wh_vsub_WhWh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::I16x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vsubh.dv.128B")
        },
        "Ww_vsub_WwWw128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::I32x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vsubw.dv.128B")
        },
        "Wh_vsub_WhWh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I16x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vsubhsat.dv")
        },
        "Ww_vsub_WwWw_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I32x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vsubwsat.dv")
        },
        "Wh_vsub_WhWh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::I16x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vsubhsat.dv.128B")
        },
        "Ww_vsub_WwWw_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::I32x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vsubwsat.dv.128B")
        },
        "Wub_vsub_WubWub_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vsububsat.dv")
        },
        "Wuh_vsub_WuhWuh_sat64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vsubuhsat.dv")
        },
        "Wub_vsub_WubWub_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U8x256]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vsububsat.dv.128B")
        },
        "Wuh_vsub_WuhWuh_sat128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x128, &::U16x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vsubuhsat.dv.128B")
        },
        "W_vswap_QVV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x2, &::U8x64, &::U8x64]; &INPUTS },
            output: &::U8x128,
            definition: Named("llvm.hexagon.V6.vswap")
        },
        "W_vswap_QVV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U32x4, &::U8x128, &::U8x128]; &INPUTS },
            output: &::U8x256,
            definition: Named("llvm.hexagon.V6.vswap.128B")
        },
        "Wh_vtmpy_WbRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vtmpyb")
        },
        "Wh_vtmpy_WbRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vtmpyb.128B")
        },
        "Wh_vtmpyacc_WhWbRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::I8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vtmpyb.acc")
        },
        "Wh_vtmpyacc_WhWbRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::I8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vtmpyb.acc.128B")
        },
        "Wh_vtmpy_WubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vtmpybus")
        },
        "Wh_vtmpy_WubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vtmpybus.128B")
        },
        "Wh_vtmpyacc_WhWubRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x64, &::U8x128, &::U32]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vtmpybus.acc")
        },
        "Wh_vtmpyacc_WhWubRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I16x128, &::U8x256, &::U32]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vtmpybus.acc.128B")
        },
        "Ww_vtmpy_WhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vtmpyhb")
        },
        "Ww_vtmpy_WhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vtmpyhb.128B")
        },
        "Wh_vunpack_Vb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vunpackb")
        },
        "Wuh_vunpack_Vub64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vunpackub")
        },
        "Ww_vunpack_Vh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vunpackh")
        },
        "Wuw_vunpack_Vuh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x32]; &INPUTS },
            output: &::U32x32,
            definition: Named("llvm.hexagon.V6.vunpackuh")
        },
        "Wh_vunpack_Vb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vunpackb.128B")
        },
        "Wuh_vunpack_Vub128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x128]; &INPUTS },
            output: &::U16x128,
            definition: Named("llvm.hexagon.V6.vunpackub.128B")
        },
        "Ww_vunpack_Vh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vunpackh.128B")
        },
        "Wuw_vunpack_Vuh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x64]; &INPUTS },
            output: &::U32x64,
            definition: Named("llvm.hexagon.V6.vunpackuh.128B")
        },
        "Wh_vunpackoor_WhVb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x64, &::I8x64]; &INPUTS },
            output: &::I16x64,
            definition: Named("llvm.hexagon.V6.vunpackob")
        },
        "Ww_vunpackoor_WwVh64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x32, &::I16x32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vunpackoh")
        },
        "Wh_vunpackoor_WhVb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x128, &::I8x128]; &INPUTS },
            output: &::I16x128,
            definition: Named("llvm.hexagon.V6.vunpackob.128B")
        },
        "Ww_vunpackoor_WwVh128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x64, &::I16x64]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vunpackoh.128B")
        },
        "Ww_vtmpyacc_WwWhRb64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x32, &::I16x64, &::U32]; &INPUTS },
            output: &::I32x32,
            definition: Named("llvm.hexagon.V6.vtmpyhb.acc")
        },
        "Ww_vtmpyacc_WwWhRb128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I32x64, &::I16x128, &::U32]; &INPUTS },
            output: &::I32x64,
            definition: Named("llvm.hexagon.V6.vtmpyhb.acc.128B")
        },
        "V_vxor_VV64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x32, &::U16x32]; &INPUTS },
            output: &::U16x32,
            definition: Named("llvm.hexagon.V6.vxor")
        },
        "V_vxor_VV128" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x64, &::U16x64]; &INPUTS },
            output: &::U16x64,
            definition: Named("llvm.hexagon.V6.vxor.128B")
        },
        _ => return None,
    })
}
