An unsupported expression was used inside a const context.

Erroneous code example:

```compile_fail,E0744
const _: i32 = {
    let mut x = 0;

    for i in 0..4 { // error!
        x += i;
    }
};
```

At the moment, `for` loops, `.await`, and the `Try` operator (`?`) are forbidden
inside a `const`, `static`, or `const fn`.

This may be allowed at some point in the future, but the implementation is not
yet complete. See the tracking issues for [`async`] and [`?`] in `const fn`, and
(to support `for` loops in `const fn`) the tracking issues for [`impl const
Trait for Ty`] and [`&mut T`] in `const fn`.

[`async`]: https://github.com/rust-lang/rust/issues/69431
[`?`]: https://github.com/rust-lang/rust/issues/74935
[`impl const Trait for Ty`]: https://github.com/rust-lang/rust/issues/67792
[`&mut T`]: https://github.com/rust-lang/rust/issues/57349
