/* rygel-import-resource.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-import-resource.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
enum  {
	RYGEL_IMPORT_RESOURCE_0_PROPERTY,
	RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY,
	RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY,
	RYGEL_IMPORT_RESOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelImportResourceRunData RygelImportResourceRunData;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelImportResourceFetchItemData RygelImportResourceFetchItemData;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelImportResourcePrivate {
	RygelMediaFileItem* item;
	SoupSession* session;
	GCancellable* _cancellable;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GUPnPServiceAction* action;
	GSourceFunc run_callback;
	gpointer run_callback_target;
	GDestroyNotify run_callback_target_destroy_notify;
	GFileOutputStream* output_stream;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelImportResourceRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelImportResource* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	guint32 _tmp6_;
	RygelMediaFileItem* _tmp7_;
	RygelMediaFileItem* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	GError* _error_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	gint _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp18_;
	RygelObjectRemovalQueue* _tmp19_;
	RygelMediaFileItem* _tmp20_;
	GFile* source_file;
	RygelMediaFileItem* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFileOutputStream* _tmp26_;
	GFile* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GFileOutputStream* _tmp30_;
	GFileOutputStream* _tmp31_;
	SoupMessage* message;
	const gchar* _tmp32_;
	SoupMessage* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessage* _tmp35_;
	SoupMessage* _tmp36_;
	SoupMessage* _tmp37_;
	SoupMessage* _tmp38_;
	SoupMessageBody* _tmp39_;
	SoupSession* _tmp40_;
	SoupMessage* _tmp41_;
	SoupMessage* _tmp42_;
	const gchar* _tmp43_;
	RygelMediaFileItem* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	GError* err;
	GError* _tmp47_;
	const gchar* _tmp48_;
	RygelObjectRemovalQueue* _tmp49_;
	RygelMediaFileItem* _tmp50_;
	GCancellable* _tmp51_;
	GCancellable* _tmp52_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelImportResourceFetchItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelImportResource* self;
	RygelMediaFileItem* result;
	RygelHTTPItemURI* uri;
	RygelHTTPItemURI* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPItemURI* _tmp3_;
	RygelHTTPItemURI* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	gchar* msg;
	gboolean _tmp12_;
	gboolean _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaContainer* _tmp17_;
	RygelMediaContainer* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	RygelMediaObject* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	RygelMediaObject* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	RygelMediaObject* _tmp28_;
	GeeList* _tmp29_;
	GeeList* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	RygelMediaObject* _tmp37_;
	RygelMediaFileItem* _tmp38_;
	GError * _inner_error_;
};


static gpointer rygel_import_resource_parent_class = NULL;
static guint32 rygel_import_resource_last_transfer_id;
static guint32 rygel_import_resource_last_transfer_id = (guint32) 0;
static RygelStateMachineIface * rygel_import_resource_rygel_state_machine_parent_iface = NULL;

GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_IMPORT_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourcePrivate))
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir,
                                                GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type,
                                                      RygelContentDirectory* content_dir,
                                                      GUPnPServiceAction* action);
static void __lambda6_ (RygelImportResource* self);
static void ___lambda6__g_cancellable_cancelled (GCancellable* _sender,
                                          gpointer self);
static void rygel_import_resource_real_run_data_free (gpointer _data);
static void rygel_import_resource_real_run_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data);
static void rygel_import_resource_real_run (RygelStateMachine* base,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_import_resource_fetch_item (RygelImportResource* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static RygelMediaFileItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void rygel_import_resource_run_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self,
                                             RygelMediaObject* object);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
static void rygel_import_resource_got_chunk_cb (RygelImportResource* self,
                                         SoupMessage* message,
                                         SoupBuffer* buffer);
static void _rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender,
                                                                 SoupBuffer* chunk,
                                                                 gpointer self);
static void rygel_import_resource_got_body_cb (RygelImportResource* self,
                                        SoupMessage* message);
static void _rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender,
                                                               gpointer self);
static void rygel_import_resource_got_headers_cb (RygelImportResource* self,
                                           SoupMessage* message);
static void _rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender,
                                                                     gpointer self);
static void rygel_import_resource_finished_cb (RygelImportResource* self,
                                        SoupMessage* message);
static void _rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender,
                                                               gpointer self);
static gboolean _rygel_import_resource_real_run_co_gsource_func (gpointer self);
void rygel_object_removal_queue_remove_now (RygelObjectRemovalQueue* self,
                                            RygelMediaObject* object,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
void rygel_object_removal_queue_remove_now_finish (RygelObjectRemovalQueue* self,
                                                   GAsyncResult* _res_);
static void rygel_import_resource_fetch_item_data_free (gpointer _data);
static void rygel_import_resource_fetch_item_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data);
static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri,
                                                       RygelHTTPServer* http_server,
                                                       GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type,
                                                             const gchar* uri,
                                                             RygelHTTPServer* http_server,
                                                             GError** error);
void rygel_media_container_find_object (RygelMediaContainer* self,
                                        const gchar* id,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
static void rygel_import_resource_fetch_item_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
static void rygel_import_resource_handle_transfer_error (RygelImportResource* self,
                                                  SoupMessage* message);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
static void rygel_import_resource_finalize (GObject * obj);
static void _vala_rygel_import_resource_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_rygel_import_resource_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);


GType
rygel_transfer_status_get_type (void)
{
	static volatile gsize rygel_transfer_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transfer_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRANSFER_STATUS_COMPLETED, "RYGEL_TRANSFER_STATUS_COMPLETED", "completed"}, {RYGEL_TRANSFER_STATUS_ERROR, "RYGEL_TRANSFER_STATUS_ERROR", "error"}, {RYGEL_TRANSFER_STATUS_IN_PROGRESS, "RYGEL_TRANSFER_STATUS_IN_PROGRESS", "in-progress"}, {RYGEL_TRANSFER_STATUS_STOPPED, "RYGEL_TRANSFER_STATUS_STOPPED", "stopped"}, {0, NULL, NULL}};
		GType rygel_transfer_status_type_id;
		rygel_transfer_status_type_id = g_enum_register_static ("RygelTransferStatus", values);
		g_once_init_leave (&rygel_transfer_status_type_id__volatile, rygel_transfer_status_type_id);
	}
	return rygel_transfer_status_type_id__volatile;
}


static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda6_ (RygelImportResource* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	g_cancellable_cancel (_tmp1_);
}


static void
___lambda6__g_cancellable_cancelled (GCancellable* _sender,
                                     gpointer self)
{
	__lambda6_ ((RygelImportResource*) self);
}


RygelImportResource*
rygel_import_resource_construct (GType object_type,
                                 RygelContentDirectory* content_dir,
                                 GUPnPServiceAction* action)
{
	RygelImportResource * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPServer* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	guint32 _tmp7_;
	guint32 _tmp8_;
	SoupSession* _tmp9_;
	GCancellable* _tmp10_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelImportResource*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir->root_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->root_container);
	self->priv->root_container = _tmp1_;
	_tmp2_ = content_dir->http_server;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->http_server);
	self->priv->http_server = _tmp3_;
	_tmp4_ = g_cancellable_new ();
	_tmp5_ = _tmp4_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp6_;
	_tmp7_ = rygel_import_resource_last_transfer_id;
	rygel_import_resource_last_transfer_id = _tmp7_ + 1;
	_tmp8_ = rygel_import_resource_last_transfer_id;
	self->transfer_id = _tmp8_;
	self->bytes_copied = (gint64) 0;
	self->bytes_total = (gint64) 0;
	self->status = RYGEL_TRANSFER_STATUS_IN_PROGRESS;
	_tmp9_ = soup_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp9_;
	_tmp10_ = content_dir->cancellable;
	g_signal_connect_object (_tmp10_, "cancelled", (GCallback) ___lambda6__g_cancellable_cancelled, self, 0);
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


RygelImportResource*
rygel_import_resource_new (RygelContentDirectory* content_dir,
                           GUPnPServiceAction* action)
{
	return rygel_import_resource_construct (RYGEL_TYPE_IMPORT_RESOURCE, content_dir, action);
}


static void
rygel_import_resource_real_run_data_free (gpointer _data)
{
	RygelImportResourceRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelImportResourceRunData, _data_);
}


static void
rygel_import_resource_real_run_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data)
{
	RygelImportResourceRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_import_resource_real_run (RygelStateMachine* base,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	RygelImportResource * self;
	RygelImportResourceRunData* _data_;
	RygelImportResource* _tmp0_;
	self = (RygelImportResource*) base;
	_data_ = g_slice_new0 (RygelImportResourceRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_import_resource_real_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_import_resource_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_import_resource_real_run_co (_data_);
}


static void
rygel_import_resource_real_run_finish (RygelStateMachine* base,
                                       GAsyncResult* _res_)
{
	RygelImportResourceRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
rygel_import_resource_run_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	RygelImportResourceRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_import_resource_real_run_co (_data_);
}


static void
_rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender,
                                                            SoupBuffer* chunk,
                                                            gpointer self)
{
	rygel_import_resource_got_chunk_cb ((RygelImportResource*) self, _sender, chunk);
}


static void
_rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender,
                                                          gpointer self)
{
	rygel_import_resource_got_body_cb ((RygelImportResource*) self, _sender);
}


static void
_rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender,
                                                                gpointer self)
{
	rygel_import_resource_got_headers_cb ((RygelImportResource*) self, _sender);
}


static void
_rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender,
                                                          gpointer self)
{
	rygel_import_resource_finished_cb ((RygelImportResource*) self, _sender);
}


static gboolean
_rygel_import_resource_real_run_co_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_import_resource_real_run_co (self);
	return result;
}


static gboolean
rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->action;
	gupnp_service_action_get (_data_->_tmp0_, "SourceURI", G_TYPE_STRING, &_data_->self->source_uri, "DestinationURI", G_TYPE_STRING, &_data_->self->destination_uri, NULL);
	{
		_data_->_tmp1_ = _data_->self->source_uri;
		if (_data_->_tmp1_ == NULL) {
			_data_->_tmp2_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Must provide source URI");
			_data_->_inner_error_ = _data_->_tmp2_;
			goto __catch56_g_error;
		}
		_data_->_tmp3_ = _data_->self->destination_uri;
		if (_data_->_tmp3_ == NULL) {
			_data_->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, "Must provide destination URI");
			_data_->_inner_error_ = _data_->_tmp4_;
			goto __catch56_g_error;
		}
		_data_->_tmp5_ = _data_->self->priv->action;
		_data_->_tmp6_ = _data_->self->transfer_id;
		gupnp_service_action_set (_data_->_tmp5_, "TransferID", G_TYPE_UINT, _data_->_tmp6_, NULL);
		_data_->_state_ = 1;
		rygel_import_resource_fetch_item (_data_->self, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = rygel_import_resource_fetch_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch56_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_object_unref0 (_data_->self->priv->item);
		_data_->self->priv->item = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp7_);
	}
	goto __finally56;
	__catch56_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = _data_->self->destination_uri;
		_data_->_tmp11_ = _data_->_error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning (_ ("Failed to get original URI for “%s”: %s"), _data_->_tmp10_, _data_->_tmp12_);
		_data_->_tmp13_ = _data_->self->priv->action;
		_data_->_tmp14_ = _data_->_error_;
		_data_->_tmp15_ = _data_->_tmp14_->code;
		_data_->_tmp16_ = _data_->_error_;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		gupnp_service_action_return_error (_data_->_tmp13_, (guint) _data_->_tmp15_, _data_->_tmp17_);
		_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally56:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = rygel_object_removal_queue_get_default ();
	_data_->queue = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->queue;
	_data_->_tmp20_ = _data_->self->priv->item;
	rygel_object_removal_queue_dequeue (_data_->_tmp19_, (RygelMediaObject*) _data_->_tmp20_);
	{
		_data_->_tmp21_ = _data_->self->priv->item;
		_data_->_tmp22_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = g_file_new_for_uri (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_g_free0 (_data_->_tmp23_);
		_data_->source_file = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->source_file;
		_data_->_tmp28_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp27_, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, _data_->_tmp29_, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp30_ = g_file_replace_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp26_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->source_file);
			goto __catch57_g_error;
		}
		_data_->_tmp31_ = _data_->_tmp26_;
		_data_->_tmp26_ = NULL;
		_g_object_unref0 (_data_->self->priv->output_stream);
		_data_->self->priv->output_stream = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->self->source_uri;
		_data_->_tmp33_ = soup_message_new ("GET", _data_->_tmp32_);
		_data_->message = _data_->_tmp33_;
		_data_->_tmp34_ = _data_->message;
		g_signal_connect_object (_data_->_tmp34_, "got-chunk", (GCallback) _rygel_import_resource_got_chunk_cb_soup_message_got_chunk, _data_->self, 0);
		_data_->_tmp35_ = _data_->message;
		g_signal_connect_object (_data_->_tmp35_, "got-body", (GCallback) _rygel_import_resource_got_body_cb_soup_message_got_body, _data_->self, 0);
		_data_->_tmp36_ = _data_->message;
		g_signal_connect_object (_data_->_tmp36_, "got-headers", (GCallback) _rygel_import_resource_got_headers_cb_soup_message_got_headers, _data_->self, 0);
		_data_->_tmp37_ = _data_->message;
		g_signal_connect_object (_data_->_tmp37_, "finished", (GCallback) _rygel_import_resource_finished_cb_soup_message_finished, _data_->self, 0);
		_data_->_tmp38_ = _data_->message;
		_data_->_tmp39_ = _data_->_tmp38_->response_body;
		soup_message_body_set_accumulate (_data_->_tmp39_, FALSE);
		(_data_->self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->run_callback_target_destroy_notify (_data_->self->priv->run_callback_target), NULL);
		_data_->self->priv->run_callback = NULL;
		_data_->self->priv->run_callback_target = NULL;
		_data_->self->priv->run_callback_target_destroy_notify = NULL;
		_data_->self->priv->run_callback = _rygel_import_resource_real_run_co_gsource_func;
		_data_->self->priv->run_callback_target = _data_;
		_data_->self->priv->run_callback_target_destroy_notify = NULL;
		_data_->_tmp40_ = _data_->self->priv->session;
		_data_->_tmp41_ = _data_->message;
		_data_->_tmp42_ = _g_object_ref0 (_data_->_tmp41_);
		soup_session_queue_message (_data_->_tmp40_, _data_->_tmp42_, NULL, NULL);
		_data_->_tmp43_ = _data_->self->source_uri;
		_data_->_tmp44_ = _data_->self->priv->item;
		_data_->_tmp45_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp44_);
		_data_->_tmp46_ = _data_->_tmp45_;
		g_debug ("rygel-import-resource.vala:156: Importing resource from %s to %s", _data_->_tmp43_, _data_->_tmp46_);
		_g_free0 (_data_->_tmp46_);
		_data_->_state_ = 3;
		return FALSE;
		_state_3:
		;
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->_tmp26_);
		_g_object_unref0 (_data_->source_file);
	}
	goto __finally57;
	__catch57_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp47_ = _data_->err;
		_data_->_tmp48_ = _data_->_tmp47_->message;
		g_warning ("rygel-import-resource.vala:162: %s", _data_->_tmp48_);
		_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		_data_->_tmp49_ = _data_->queue;
		_data_->_tmp50_ = _data_->self->priv->item;
		_data_->_tmp51_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_state_ = 4;
		rygel_object_removal_queue_remove_now (_data_->_tmp49_, (RygelMediaObject*) _data_->_tmp50_, _data_->_tmp52_, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_4:
		rygel_object_removal_queue_remove_now_finish (_data_->_tmp49_, _data_->_res_);
		_g_error_free0 (_data_->err);
	}
	__finally57:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->queue);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	_g_object_unref0 (_data_->queue);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_import_resource_fetch_item_data_free (gpointer _data)
{
	RygelImportResourceFetchItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelImportResourceFetchItemData, _data_);
}


static void
rygel_import_resource_fetch_item_async_ready_wrapper (GObject *source_object,
                                                      GAsyncResult *res,
                                                      void *user_data)
{
	RygelImportResourceFetchItemData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_import_resource_fetch_item (RygelImportResource* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelImportResourceFetchItemData* _data_;
	RygelImportResource* _tmp0_;
	_data_ = g_slice_new0 (RygelImportResourceFetchItemData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_import_resource_fetch_item_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_import_resource_fetch_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_import_resource_fetch_item_co (_data_);
}


static RygelMediaFileItem*
rygel_import_resource_fetch_item_finish (RygelImportResource* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	RygelMediaFileItem* result;
	RygelImportResourceFetchItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
rygel_import_resource_fetch_item_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelImportResourceFetchItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_import_resource_fetch_item_co (_data_);
}


static gboolean
rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->destination_uri;
		_data_->_tmp2_ = _data_->self->priv->http_server;
		_data_->_tmp3_ = rygel_http_item_uri_new_from_string (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch58_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->uri);
		_data_->uri = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally58;
	__catch58_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp5_ = _data_->_error_;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, _data_->_tmp6_);
		_data_->_inner_error_ = _data_->_tmp7_;
		_g_error_free0 (_data_->_error_);
		goto __finally58;
	}
	__finally58:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->root_container;
	_data_->_tmp9_ = rygel_http_item_uri_get_item_id (_data_->uri);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp8_, _data_->_tmp10_, NULL, rygel_import_resource_fetch_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
	_data_->media_object = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->msg = NULL;
	_data_->_tmp14_ = _data_->media_object;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp13_ = TRUE;
	} else {
		_data_->_tmp15_ = _data_->media_object;
		_data_->_tmp13_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_MEDIA_FILE_ITEM);
	}
	if (_data_->_tmp13_) {
		_data_->_tmp12_ = TRUE;
	} else {
		_data_->_tmp16_ = _data_->media_object;
		_data_->_tmp17_ = rygel_media_object_get_parent (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp12_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, RYGEL_TYPE_WRITABLE_CONTAINER);
	}
	if (_data_->_tmp12_) {
		_data_->_tmp19_ = _data_->self->destination_uri;
		_data_->_tmp20_ = g_strdup_printf (_ ("URI “%s” invalid for importing contents to"), _data_->_tmp19_);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp20_;
	} else {
		_data_->_tmp21_ = _data_->media_object;
		_data_->_tmp22_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp21_) : NULL);
		_data_->_tmp23_ = _data_->_tmp22_;
		if (!_data_->_tmp23_) {
			_data_->_tmp24_ = _data_->media_object;
			_data_->_tmp25_ = rygel_media_object_get_id (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = g_strdup_printf (_ ("Pushing data to non-empty item “%s” not allowed"), _data_->_tmp26_);
			_g_free0 (_data_->msg);
			_data_->msg = _data_->_tmp27_;
		} else {
			_data_->_tmp28_ = _data_->media_object;
			_data_->_tmp29_ = rygel_media_object_get_uris (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp30_);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = _data_->_tmp32_;
			_g_object_unref0 (_data_->_tmp30_);
			if (_data_->_tmp33_) {
				g_assert_not_reached ();
			}
		}
	}
	_data_->_tmp34_ = _data_->msg;
	if (_data_->_tmp34_ != NULL) {
		_data_->_tmp35_ = _data_->msg;
		_data_->_tmp36_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp35_);
		_data_->_inner_error_ = _data_->_tmp36_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->msg);
		_g_object_unref0 (_data_->media_object);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = _data_->media_object;
	_data_->_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp37_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp37_) : NULL);
	_data_->result = _data_->_tmp38_;
	_g_free0 (_data_->msg);
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_import_resource_got_headers_cb (RygelImportResource* self,
                                      SoupMessage* message)
{
	SoupMessageHeaders* _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message->response_headers;
	self->bytes_total = soup_message_headers_get_content_length (_tmp0_);
	g_object_get (message, "status-code", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= ((guint) 200)) {
		guint _tmp4_;
		guint _tmp5_;
		g_object_get (message, "status-code", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ <= ((guint) 299);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GUPnPServiceAction* _tmp6_;
		_tmp6_ = self->priv->action;
		gupnp_service_action_return (_tmp6_);
	} else {
		rygel_import_resource_handle_transfer_error (self, message);
	}
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = NULL;
}


static void
rygel_import_resource_got_chunk_cb (RygelImportResource* self,
                                    SoupMessage* message,
                                    SoupBuffer* buffer)
{
	gint64 _tmp0_;
	gsize _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (buffer != NULL);
	_tmp0_ = self->bytes_copied;
	_tmp1_ = buffer->length;
	self->bytes_copied = _tmp0_ + _tmp1_;
	{
		gsize bytes_written = 0UL;
		GFileOutputStream* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		GCancellable* _tmp4_;
		GCancellable* _tmp5_;
		gsize _tmp6_ = 0UL;
		_tmp2_ = self->priv->output_stream;
		_tmp3_ = buffer->data;
		_tmp3__length1 = (gint) buffer->length;
		_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp5_ = _tmp4_;
		g_output_stream_write_all ((GOutputStream*) _tmp2_, _tmp3_, (gsize) _tmp3__length1, &_tmp6_, _tmp5_, &_inner_error_);
		bytes_written = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch59_g_error;
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		SoupSession* _tmp10_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("rygel-import-resource.vala:223: %s", _tmp8_);
		_tmp9_ = _error_;
		if (g_error_matches (_tmp9_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			self->status = RYGEL_TRANSFER_STATUS_STOPPED;
		} else {
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
		}
		_tmp10_ = self->priv->session;
		soup_session_cancel_message (_tmp10_, message, (guint) SOUP_STATUS_CANCELLED);
		_g_error_free0 (_error_);
	}
	__finally59:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
rygel_import_resource_got_body_cb (RygelImportResource* self,
                                   SoupMessage* message)
{
	gint64 _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->bytes_total;
	if (_tmp0_ == ((gint64) 0)) {
		gint64 _tmp1_;
		_tmp1_ = self->bytes_copied;
		self->bytes_total = _tmp1_;
	} else {
		gint64 _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = self->bytes_total;
		_tmp3_ = self->bytes_copied;
		if (_tmp2_ != _tmp3_) {
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
			return;
		}
	}
	{
		GFileOutputStream* _tmp4_;
		GCancellable* _tmp5_;
		GCancellable* _tmp6_;
		RygelTransferStatus _tmp7_;
		_tmp4_ = self->priv->output_stream;
		_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp6_ = _tmp5_;
		g_output_stream_close ((GOutputStream*) _tmp4_, _tmp6_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch60_g_error;
		}
		_tmp7_ = self->status;
		if (_tmp7_ == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
			self->status = RYGEL_TRANSFER_STATUS_COMPLETED;
		}
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("rygel-import-resource.vala:248: %s", _tmp9_);
		self->status = RYGEL_TRANSFER_STATUS_ERROR;
		_g_error_free0 (_error_);
	}
	__finally60:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
rygel_import_resource_finished_cb (RygelImportResource* self,
                                   SoupMessage* message)
{
	RygelTransferStatus _tmp0_;
	GSourceFunc _tmp6_;
	void* _tmp6__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->status;
	if (_tmp0_ == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
		gboolean _tmp1_ = FALSE;
		guint _tmp2_;
		guint _tmp3_;
		g_object_get (message, "status-code", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		if (_tmp3_ >= ((guint) 200)) {
			guint _tmp4_;
			guint _tmp5_;
			g_object_get (message, "status-code", &_tmp4_, NULL);
			_tmp5_ = _tmp4_;
			_tmp1_ = _tmp5_ <= ((guint) 299);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			rygel_import_resource_handle_transfer_error (self, message);
		}
	}
	_tmp6_ = self->priv->run_callback;
	_tmp6__target = self->priv->run_callback_target;
	_tmp6_ (_tmp6__target);
}


static void
rygel_import_resource_handle_transfer_error (RygelImportResource* self,
                                             SoupMessage* message)
{
	gchar* phrase = NULL;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GUPnPServiceAction* _tmp17_;
	gboolean _tmp18_ = FALSE;
	guint _tmp19_;
	guint _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	self->status = RYGEL_TRANSFER_STATUS_ERROR;
	{
		GFileOutputStream* _tmp0_;
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		GFile* file = NULL;
		RygelMediaFileItem* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GCancellable* _tmp9_;
		GCancellable* _tmp10_;
		_tmp0_ = self->priv->output_stream;
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp2_ = _tmp1_;
		g_output_stream_close ((GOutputStream*) _tmp0_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch61_g_error;
		}
		_tmp3_ = self->priv->item;
		_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		file = _tmp7_;
		_tmp8_ = file;
		_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp10_ = _tmp9_;
		g_file_delete (_tmp8_, _tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch61_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_get (message, "status-code", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = soup_status_get_phrase (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	phrase = _tmp14_;
	_tmp15_ = self->source_uri;
	_tmp16_ = phrase;
	g_warning (_ ("Failed to import file from %s: %s"), _tmp15_, _tmp16_);
	_tmp17_ = self->priv->action;
	if (_tmp17_ == NULL) {
		_g_free0 (phrase);
		return;
	}
	g_object_get (message, "status-code", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == ((guint) SOUP_STATUS_NOT_FOUND)) {
		_tmp18_ = TRUE;
	} else {
		guint _tmp21_;
		guint _tmp22_;
		g_object_get (message, "status-code", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ < ((guint) 100);
	}
	if (_tmp18_) {
		GUPnPServiceAction* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->action;
		_tmp24_ = phrase;
		gupnp_service_action_return_error (_tmp23_, (guint) 714, _tmp24_);
	} else {
		GUPnPServiceAction* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->action;
		_tmp26_ = phrase;
		gupnp_service_action_return_error (_tmp25_, (guint) 715, _tmp26_);
	}
	_g_free0 (phrase);
}


const gchar*
rygel_import_resource_get_status_as_string (RygelImportResource* self)
{
	const gchar* result;
	RygelTransferStatus _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->status;
	switch (_tmp0_) {
		case RYGEL_TRANSFER_STATUS_COMPLETED:
		{
			result = "COMPLETED";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_ERROR:
		{
			result = "ERROR";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_IN_PROGRESS:
		{
			result = "IN_PROGRESS";
			return result;
		}
		default:
		case RYGEL_TRANSFER_STATUS_STOPPED:
		{
			result = "STOPPED";
			return result;
		}
	}
}


static GCancellable*
rygel_import_resource_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelImportResource* self;
	GCancellable* _tmp0_;
	self = (RygelImportResource*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void
rygel_import_resource_real_set_cancellable (RygelStateMachine* base,
                                            GCancellable* value)
{
	RygelImportResource* self;
	self = (RygelImportResource*) base;
	if (rygel_import_resource_real_get_cancellable (base) != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY]);
	}
}


static void
rygel_import_resource_class_init (RygelImportResourceClass * klass)
{
	rygel_import_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelImportResourcePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_import_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_import_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_import_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY] = g_param_spec_string ("status-as-string", "status-as-string", "status-as-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
rygel_import_resource_rygel_state_machine_interface_init (RygelStateMachineIface * iface)
{
	rygel_import_resource_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine *, GAsyncReadyCallback, gpointer)) rygel_import_resource_real_run;
	iface->run_finish = (void (*) (RygelStateMachine *, GAsyncResult*)) rygel_import_resource_real_run_finish;
	iface->get_cancellable = rygel_import_resource_real_get_cancellable;
	iface->set_cancellable = rygel_import_resource_real_set_cancellable;
}


static void
rygel_import_resource_instance_init (RygelImportResource * self)
{
	self->priv = RYGEL_IMPORT_RESOURCE_GET_PRIVATE (self);
}


static void
rygel_import_resource_finalize (GObject * obj)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	_g_free0 (self->source_uri);
	_g_free0 (self->destination_uri);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->http_server);
	_g_object_unref0 (self->priv->root_container);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	(self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (self->priv->run_callback_target_destroy_notify (self->priv->run_callback_target), NULL);
	self->priv->run_callback = NULL;
	self->priv->run_callback_target = NULL;
	self->priv->run_callback_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->output_stream);
	G_OBJECT_CLASS (rygel_import_resource_parent_class)->finalize (obj);
}


/**
 * Responsible for handling ImportResource action.
 */
GType
rygel_import_resource_get_type (void)
{
	static volatile gsize rygel_import_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_import_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImportResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_import_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImportResource), 0, (GInstanceInitFunc) rygel_import_resource_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_import_resource_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_import_resource_type_id;
		rygel_import_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelImportResource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_import_resource_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_import_resource_type_id__volatile, rygel_import_resource_type_id);
	}
	return rygel_import_resource_type_id__volatile;
}


static void
_vala_rygel_import_resource_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY:
		g_value_set_string (value, rygel_import_resource_get_status_as_string (self));
		break;
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_rygel_import_resource_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



