// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include "mmapincr.h"

FitsMMapIncr::FitsMMapIncr(const char* fn)
{
  // parse the fn and options
  parse(fn);
  if (!valid_)
    return;

  // reset
  valid_ =0;

  if (!pName_)
    return;

  // Map the file.
  int fd = open(pName_, O_RDONLY);
  if (fd == -1)
    return;

  struct stat info;
  if (fstat(fd, &info) < 0)
    return;

  close(fd);

  // check to see if we have something, we may have a small array
  if (info.st_size <= 0)
    return;

  filesize_ = info.st_size;

  // so far, so good
  valid_ = 1;
}
